/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox;

import endorh.simpleconfig.ui.gui.widget.combobox.AbstractComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleComboBoxModel<T>
extends AbstractComboBoxModel<T> {
    @NotNull
    protected Supplier<List<T>> suggestions;
    protected long lastUpdate = 0L;
    protected long updateCooldown = 250L;
    @Nullable
    protected Function<String, Component> placeholder = null;

    public SimpleComboBoxModel() {
        this(Collections.emptyList());
    }

    public SimpleComboBoxModel(@NotNull List<T> suggestions) {
        this(() -> suggestions);
    }

    public SimpleComboBoxModel(@NotNull Supplier<List<T>> suggestionSupplier) {
        this.suggestions = suggestionSupplier;
    }

    @Override
    public Optional<List<T>> updateSuggestions(TypeWrapper<T> typeWrapper, String query) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < this.updateCooldown) {
            return Optional.empty();
        }
        this.lastUpdate = time;
        return Optional.of(new ArrayList(this.suggestions.get()));
    }

    @Override
    public Optional<Component> getPlaceHolder(TypeWrapper<T> typeWrapper, String query) {
        return this.placeholder != null ? Optional.of(this.placeholder.apply(query)) : super.getPlaceHolder(typeWrapper, query);
    }

    public void setUpdateCooldown(long cooldownMs) {
        this.updateCooldown = cooldownMs;
    }

    public void setPlaceholder(@Nullable Function<String, Component> getter) {
        this.placeholder = getter;
    }

    public void setPlaceholder(Component placeholder) {
        this.setPlaceholder((String s) -> placeholder);
    }
}

