/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.api.ScrollingHandler;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.api.TooltipRenderer;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.gui.widget.combobox.IComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ComboBoxWidget<T>
extends AbstractWidget
implements IOverlayCapableContainer.IOverlayRenderer {
    @ApiStatus.Internal
    protected IOverlayCapableContainer screen = null;
    protected Supplier<IOverlayCapableContainer> screenSupplier;
    @NotNull
    protected final TypeWrapper<T> typeWrapper;
    protected int focusedBorderColor = -1;
    protected int borderColor = -6250336;
    protected int backgroundColor = -16777216;
    protected boolean dropDownShown = false;
    protected boolean pendingDropDownShownChange = false;
    protected boolean draggingDropDownScrollBar = false;
    protected boolean restrictToSuggestions = false;
    protected boolean autoDropDown = true;
    protected int arrowWidth = 10;
    protected int dropDownHeight = 120;
    protected double dropDownScroll = 0.0;
    protected double dropDownScrollTarget = 0.0;
    protected int suggestionHeight = 20;
    protected long scrollAnimationStart;
    protected long scrollAnimationDuration = 150L;
    protected long lastSuggestionCursorNavigation = 0L;
    protected ToggleAnimator expandAnimator = new ToggleAnimator(250L);
    protected boolean showHelpTooltips = true;
    @Nullable
    protected TooltipRenderer tooltipConsumer = null;
    @Nullable
    protected Component hint = null;
    @NotNull
    protected IComboBoxModel<T> suggestionProvider;
    protected final Font font;
    protected String text = "";
    protected T autoCompleteValue = null;
    @Nullable
    protected T value = null;
    @Nullable
    protected Component parseError = null;
    private boolean isEnabled = true;
    protected int maxLength = 32;
    protected long lastInteraction;
    protected long lastClick;
    protected boolean shouldDrawBackground = true;
    protected boolean canLoseFocus = true;
    protected boolean canShowDropDown = true;
    protected int hScroll;
    protected int caretPos;
    protected int anchorPos;
    protected int lastClickWordPos = -1;
    protected boolean draggingText = false;
    protected int enabledColor = 0xE0E0E0;
    protected int disabledColor = 0x707070;
    protected Consumer<String> textListener;
    protected Consumer<T> valueListener;
    protected List<T> lastSuggestions = Lists.newArrayList();
    protected List<T> lastSortedSuggestions = Lists.newArrayList();
    protected String lastQuery = "";
    protected List<Component> decoratedSuggestions = Lists.newArrayList();
    protected Predicate<String> filter = Objects::nonNull;
    protected TextFormatter formatter = TextFormatter.DEFAULT;
    protected Rectangle area = new Rectangle();
    protected Rectangle dropDownRectangle = new Rectangle();
    protected Rectangle reportedDropDownRectangle = new Rectangle();
    protected long lastDropDownScroll = 0L;
    protected int suggestionCursor = -1;
    private static final Pattern WORD_BREAK_RIGHT_PATTERN = Pattern.compile("(?<=\\p{Alnum})(?=\\P{Alnum})|(?<=\\p{Alnum})(?=\\p{Lu}[\\p{Ll}\\d])|(?<=[\\p{Ll}\\d])(?=\\p{Lu})|(?<=[^\\p{Alnum}\\s_])(?=[\\p{Alnum}\\s_])");
    private static final Pattern WORD_BREAK_LEFT_PATTERN = Pattern.compile("(?<=\\p{Alnum})(?=\\P{Alnum})|(?<=[\\p{Ll}\\d]\\p{Lu})(?=\\p{Lu})|(?<=\\p{Lu})(?=[\\p{Ll}\\d])|(?<=[^\\p{Alnum}\\s_])(?=[\\p{Alnum}\\s_])");

    public ComboBoxWidget(@NotNull TypeWrapper<T> typeWrapper, @NotNull Supplier<IOverlayCapableContainer> screen, int x, int y, int width, int height) {
        this(typeWrapper, screen, x, y, width, height, GameNarrator.f_93310_);
    }

    public ComboBoxWidget(@NotNull TypeWrapper<T> typeWrapper, @NotNull Supplier<IOverlayCapableContainer> screen, int x, int y, int width, int height, @NotNull Component title) {
        this(typeWrapper, screen, Minecraft.m_91087_().f_91062_, x, y, width, height, title);
    }

    public ComboBoxWidget(@NotNull TypeWrapper<T> typeWrapper, @NotNull Supplier<IOverlayCapableContainer> screen, @NotNull Font font, int x, int y, int width, int height, @NotNull Component title) {
        super(x, y, width, height, title);
        this.typeWrapper = typeWrapper;
        TextFormatter formatter = typeWrapper.getTextFormatter();
        if (formatter != null) {
            this.formatter = formatter;
        }
        this.screenSupplier = screen;
        this.font = font;
        this.suggestionProvider = new SimpleComboBoxModel(Lists.newArrayList());
    }

    @NotNull
    protected IOverlayCapableContainer getScreen() {
        IOverlayCapableContainer screen = this.screen;
        if (screen == null) {
            if (this.screenSupplier != null) {
                this.screen = screen = this.screenSupplier.get();
                this.screenSupplier = null;
                return screen;
            }
            throw new IllegalStateException("Missing screen for combo box widget");
        }
        return screen;
    }

    public void setSuggestionProvider(@NotNull IComboBoxModel<T> provider) {
        this.suggestionProvider = provider;
        this.updateSuggestions();
    }

    public void setSuggestions(List<T> suggestions) {
        this.setSuggestionProvider(new SimpleComboBoxModel<T>(suggestions));
    }

    @Nullable
    public Component getHint() {
        return this.hint;
    }

    public ComboBoxWidget<T> setHint(@Nullable Component hint) {
        this.hint = hint;
        return this;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public boolean isShowHelpTooltips() {
        return this.showHelpTooltips;
    }

    public void setShowHelpTooltips(boolean show) {
        this.showHelpTooltips = show;
    }

    public void setTooltipRenderer(@Nullable TooltipRenderer consumer) {
        this.tooltipConsumer = consumer;
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        boolean showScrollbar;
        if (!this.isDropDownShown()) {
            return false;
        }
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        int maxScroll = this.getMaxDropDownScroll();
        double prev = this.dropDownScroll;
        this.dropDownScroll = ScrollingHandler.handleScrollingPosition(new double[]{this.dropDownScrollTarget}, this.dropDownScroll, Double.POSITIVE_INFINITY, 0.0f, this.scrollAnimationStart, this.scrollAnimationDuration);
        if (this.dropDownScroll > (double)maxScroll && this.dropDownScroll > prev) {
            this.dropDownScroll = maxScroll;
        }
        if (this.dropDownScroll < 0.0 && prev > this.dropDownScroll) {
            this.dropDownScroll = 0.0;
        }
        area = this.dropDownRectangle;
        int borderColor = this.m_93696_() ? this.focusedBorderColor : this.borderColor;
        gg.m_280509_(area.x, area.y, area.getMaxX(), area.getMaxY(), borderColor);
        gg.m_280509_(area.x + 1, area.y, area.getMaxX() - 1, area.getMaxY() - 1, this.backgroundColor);
        gg.m_280509_(area.x + 1, area.y, area.getMaxX() - 1, area.y + 1, borderColor & 0xFFFFFF | borderColor / 2 & 0xFF000000);
        int suggestionWidth = area.width - 2;
        boolean bl = showScrollbar = maxScroll > 0;
        if (showScrollbar) {
            suggestionWidth -= 5;
        }
        if (!this.lastSortedSuggestions.isEmpty()) {
            int suggestionHeight = this.getSuggestionHeight();
            int firstIdx = (int)Mth.m_14008_((double)(this.dropDownScroll / (double)suggestionHeight), (double)0.0, (double)(this.lastSortedSuggestions.size() - 1));
            int lastIdx = (int)Mth.m_14008_((double)((this.dropDownScroll + (double)this.dropDownHeight + (double)suggestionHeight - 1.0) / (double)suggestionHeight), (double)0.0, (double)(this.lastSortedSuggestions.size() - 1));
            int yy = area.y + 1 - (int)this.dropDownScroll % suggestionHeight;
            for (int i = firstIdx; i <= lastIdx; ++i) {
                this.renderSuggestion(i, this.lastSortedSuggestions.get(i), gg, area.x + 1, yy, suggestionWidth, suggestionHeight, mouseX, mouseY, delta, i == this.suggestionCursor);
                yy += suggestionHeight;
            }
            if (showScrollbar) {
                int scrollBarX = area.getMaxX() - 6;
                gg.m_280509_(scrollBarX, area.y + 1, scrollBarX + 5, area.getMaxY(), -2140904348);
                int thumbHeight = Math.max(20, (area.height - 2) / (this.lastSortedSuggestions.size() * suggestionHeight));
                int thumbY = area.y + 1 + (int)Math.round((double)(area.height - 2 - thumbHeight) * (this.dropDownScroll / (double)maxScroll));
                int thumbColor = this.draggingDropDownScrollBar || mouseX >= scrollBarX && mouseX < scrollBarX + 5 && mouseY >= thumbY && mouseY < thumbY + thumbHeight ? -1765950019 : -1769963392;
                gg.m_280509_(scrollBarX, thumbY, area.getMaxX() - 1, thumbY + thumbHeight, thumbColor);
            }
        } else {
            Optional<Component> opt = this.suggestionProvider.getPlaceHolder(this.typeWrapper, this.text);
            if (opt.isPresent()) {
                this.drawTextComponent(opt.get(), gg, area.x + 4, area.y + 2, area.width - 2, 10, -2039584);
            } else {
                this.setDropDownShown(false);
            }
        }
        gg.m_280509_(area.x + 1, area.y, area.getMaxX() - 1, area.y + 1, borderColor);
        gg.m_280509_(area.x + 1, area.getMaxY() - 1, area.getMaxX() - 1, area.getMaxY(), borderColor);
        mStack.m_85849_();
        return true;
    }

    protected void renderSuggestion(int i, T suggestion, GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta, boolean selected) {
        boolean hovered;
        boolean bl = hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
        if (selected) {
            gg.m_280509_(x, y, x + w, y + 1, -1595875104);
            gg.m_280509_(x, y + h - 1, x + w, y + h, -1595875104);
            gg.m_280509_(x, y + 1, x + 1, y + h - 1, -1595875104);
            gg.m_280509_(x + w - 1, y + 1, x + w, y + h - 1, -1595875104);
            gg.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, hovered ? -2140904348 : -2142746552);
        } else {
            gg.m_280509_(x, y, x + w, y + h, hovered ? -2140904348 : -2145115100);
        }
        int textX = x + 2;
        int textY = y;
        int iconHeight = this.getIconHeight();
        int iconWidth = this.getIconWidth();
        if (this.typeWrapper.hasIcon()) {
            this.typeWrapper.renderIcon(suggestion, this.typeWrapper.getName(suggestion), gg, x, y, iconWidth, Math.min(iconHeight, h), 200, mouseX, mouseY, delta);
            textX += iconWidth;
            textY += (iconHeight - 10) / 2;
        }
        Component name = i >= 0 && i < this.decoratedSuggestions.size() ? this.decoratedSuggestions.get(i) : this.typeWrapper.getDisplayName(suggestion);
        int textW = w - 4;
        if (this.hasIcon()) {
            textW -= iconWidth;
        }
        this.drawTextComponent(name, gg, textX, textY + 1, textW, 10, -1);
    }

    protected void drawTextComponent(Component component, GuiGraphics gg, int x, int y, int w, int h, int color) {
        List processors = this.font.m_92923_((FormattedText)component, w);
        if (!processors.isEmpty()) {
            gg.m_280648_(this.font, (FormattedCharSequence)processors.get(0), x, y, color);
        }
    }

    @Override
    public boolean overlayMouseScrolled(Rectangle area, double mouseX, double mouseY, double amount) {
        double lastScroll = this.dropDownScroll;
        double lastTarget = this.dropDownScrollTarget;
        long current = System.currentTimeMillis();
        this.scrollBy(-amount * (double)Math.min(24, this.getSuggestionHeight()), Math.abs(amount) >= 1.0);
        if (lastTarget != this.dropDownScrollTarget || lastScroll != this.dropDownScroll || current - this.lastDropDownScroll <= 100L) {
            this.lastDropDownScroll = current;
            return true;
        }
        return false;
    }

    public int getMaxDropDownScroll() {
        return this.getSuggestionHeight() * this.lastSortedSuggestions.size() + 2 - this.getDropDownHeight();
    }

    public boolean isScrollbarHovered(double mouseX, double mouseY) {
        Rectangle area = this.dropDownRectangle;
        return mouseX >= (double)(area.getMaxX() - 6) && mouseX < (double)(area.getMaxX() - 1) && mouseY >= (double)(area.y + 1) && mouseY < (double)(area.getMaxY() - 1);
    }

    public boolean isScrollThumbHovered(double mouseX, double mouseY) {
        Rectangle area = this.dropDownRectangle;
        int thumbHeight = Math.max(20, (area.height - 2) / (this.lastSortedSuggestions.size() * this.suggestionHeight));
        int thumbY = area.y + 1 + (int)Math.round((double)(area.height - 2 - thumbHeight) * (this.dropDownScroll / (double)this.getMaxDropDownScroll()));
        return mouseX >= (double)(area.getMaxX() - 6) && mouseX < (double)(area.getMaxX() - 1) && mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight);
    }

    @Override
    public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
        Rectangle rect = this.dropDownRectangle;
        if (!rect.contains(mouseX, mouseY)) {
            return false;
        }
        if (this.isScrollbarHovered(mouseX, mouseY)) {
            int thumbHeight = Math.max(20, (rect.height - 2) / (this.lastSortedSuggestions.size() * this.suggestionHeight));
            double scrollRange = rect.height - 2 - thumbHeight;
            this.setDropDownScroll((int)Math.round((mouseY - (double)rect.y - (double)thumbHeight / 2.0) / scrollRange * (double)this.getMaxDropDownScroll()));
            this.draggingDropDownScrollBar = true;
            return true;
        }
        int relY = (int)(mouseY - (double)rect.y - 1.0 + this.dropDownScroll);
        int suggestionHeight = this.getSuggestionHeight();
        int hoveredIndex = relY / suggestionHeight;
        if (hoveredIndex >= 0 && hoveredIndex < this.lastSortedSuggestions.size()) {
            this.setValue(this.lastSortedSuggestions.get(hoveredIndex));
        }
        this.setDropDownShown(false);
        return true;
    }

    @Override
    public boolean overlayMouseDragged(Rectangle area, double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingDropDownScrollBar) {
            Rectangle rect = this.dropDownRectangle;
            int thumbHeight = Math.max(20, (rect.height - 2) / (this.lastSortedSuggestions.size() * this.suggestionHeight));
            double scrollRange = rect.height - 2 - thumbHeight;
            this.setDropDownScroll((int)Math.round((mouseY - (double)rect.y - (double)thumbHeight / 2.0) / scrollRange * (double)this.getMaxDropDownScroll()));
            return true;
        }
        return false;
    }

    @Override
    public boolean isOverlayDragging() {
        return this.draggingDropDownScrollBar;
    }

    @Override
    public void overlayMouseDragEnd(Rectangle area, double mouseX, double mouseY, int button) {
        this.draggingDropDownScrollBar = false;
    }

    @Override
    public boolean overlayEscape() {
        if (this.isDropDownShown()) {
            this.setDropDownShown(false);
            this.playFeedbackTap(1.0f);
            return true;
        }
        return false;
    }

    public boolean isRestrictedToSuggestions() {
        return this.restrictToSuggestions;
    }

    public void setRestrictedToSuggestions(boolean restrict) {
        this.restrictToSuggestions = restrict;
    }

    public boolean isAutoDropDown() {
        return this.autoDropDown;
    }

    public void setAutoDropDown(boolean autoDropDown) {
        this.autoDropDown = autoDropDown;
    }

    public boolean isDropDownShown() {
        return this.dropDownShown;
    }

    public void setDropDownShown(boolean expanded) {
        this.setDropDownShown(expanded, false);
    }

    public void setDropDownShown(boolean expanded, boolean lease) {
        if (!this.canShowDropDown()) {
            expanded = false;
        }
        if (lease) {
            this.pendingDropDownShownChange = this.dropDownShown != expanded;
        } else {
            this.dropDownShown = expanded;
            this.pendingDropDownShownChange = false;
            this.expandAnimator.setEaseOutTarget(expanded);
            this.suggestionCursor = -1;
            if (expanded) {
                this.getScreen().addOverlay(this.reportedDropDownRectangle, this, 100);
            } else {
                this.setDropDownScroll(0);
                this.draggingDropDownScrollBar = false;
            }
        }
    }

    public List<T> getShownSuggestions() {
        return Collections.unmodifiableList(this.lastSortedSuggestions);
    }

    public int getDropDownHeight() {
        return (int)(this.expandAnimator.getEaseOut() * (float)(this.lastSortedSuggestions.isEmpty() ? 12 : Math.min(this.dropDownHeight, this.getSuggestionHeight() * this.lastSortedSuggestions.size() + 2)));
    }

    public int getIconHeight() {
        return this.typeWrapper.getIconHeight();
    }

    public int getIconWidth() {
        return this.typeWrapper.getIconWidth();
    }

    public int getSuggestionHeight() {
        return this.hasIcon() ? this.getIconHeight() : 10;
    }

    public void setDropDownScroll(int scroll) {
        this.dropDownScrollTarget = this.dropDownScroll = (double)Mth.m_14045_((int)scroll, (int)0, (int)this.getMaxDropDownScroll());
        this.scrollAnimationStart = 0L;
    }

    public void scrollBy(double amount, boolean animated) {
        int maxScroll = this.getMaxDropDownScroll();
        if (amount < 0.0 && this.dropDownScrollTarget > (double)maxScroll) {
            this.scrollTo((double)maxScroll + amount, animated);
        }
        if (amount > 0.0 && this.dropDownScrollTarget < 0.0) {
            this.scrollTo(amount, animated);
        } else {
            this.scrollTo(this.dropDownScrollTarget + amount, animated);
        }
    }

    public void scrollTo(double scroll, boolean animated) {
        if (animated) {
            this.dropDownScrollTarget = Mth.m_14008_((double)scroll, (double)-32.0, (double)(this.getMaxDropDownScroll() + 32));
            this.scrollAnimationStart = System.currentTimeMillis();
        } else {
            this.dropDownScroll = this.dropDownScrollTarget = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxDropDownScroll());
            this.scrollAnimationStart = 0L;
        }
    }

    public void setDropDownHeight(int height) {
        this.dropDownHeight = height;
    }

    public void setTextListener(Consumer<String> listener) {
        this.textListener = listener;
    }

    public void setValueListener(Consumer<T> listener) {
        this.valueListener = listener;
    }

    public void setTextFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public void tick() {
    }

    @NotNull
    protected MutableComponent m_5646_() {
        Component msg = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{msg, this.text});
    }

    public void setText(String textIn) {
        if (this.filter.test(textIn)) {
            this.text = textIn.length() > this.maxLength ? textIn.substring(0, this.maxLength) : textIn;
            this.moveCaretToEnd();
            this.setAnchorPos(this.caretPos);
            this.onTextChanged(textIn);
        }
    }

    public void setValue(T value) {
        if (value != null) {
            this.setText(this.typeWrapper.getName(value));
        } else {
            this.setText("");
        }
        this.value = value;
    }

    public boolean hasIcon() {
        return this.typeWrapper.hasIcon();
    }

    public String getText() {
        return this.text;
    }

    public boolean hasSelection() {
        return this.anchorPos != this.caretPos;
    }

    public String getSelectedText() {
        return this.caretPos < this.anchorPos ? this.text.substring(this.caretPos, this.anchorPos) : this.text.substring(this.anchorPos, this.caretPos);
    }

    public void setFilter(Predicate<String> validator) {
        this.filter = validator;
    }

    public void insertText(String inserted) {
        String result;
        String txt;
        int length;
        if (this.formatter != null) {
            inserted = this.formatter.stripInsertText(inserted);
        }
        int start = Math.min(this.caretPos, this.anchorPos);
        int end = Math.max(this.caretPos, this.anchorPos);
        int allowed = this.maxLength - this.text.length() + (end - start);
        if (allowed < (length = (txt = SharedConstants.m_136190_((String)inserted)).length())) {
            txt = txt.substring(0, allowed);
            length = allowed;
        }
        if (this.filter.test(result = new StringBuilder(this.text).replace(start, end, txt).toString())) {
            this.text = result;
            this.setCaretPosition(start + length);
            this.setAnchorPos(this.caretPos);
            this.onTextChanged(this.text);
            if (this.isAutoDropDown() && !this.isDropDownShown() && !this.lastSortedSuggestions.isEmpty()) {
                this.setDropDownShown(true);
            }
        }
    }

    protected void onTextChanged(String newText) {
        if (this.textListener != null) {
            this.textListener.accept(newText);
        }
        if (this.isRestrictedToSuggestions() && this.isAutoDropDown()) {
            this.setDropDownShown(true);
        }
        this.updateValue();
    }

    protected void updateValue() {
        if (!this.isRestrictedToSuggestions()) {
            Pair<Optional<T>, Optional<Component>> parsed = this.typeWrapper.parseElement(this.text);
            this.value = ((Optional)parsed.getLeft()).orElse(null);
            this.parseError = ((Optional)parsed.getRight()).orElse(null);
            this.onValueChanged(this.value);
        }
        this.updateSuggestions();
    }

    protected void updateSuggestions() {
        String query = this.text;
        Optional<List<T>> opt = this.suggestionProvider.updateSuggestions(this.typeWrapper, query);
        if (opt.isPresent()) {
            boolean changed;
            List<T> suggestions = opt.get();
            boolean bl = changed = !suggestions.equals(this.lastSuggestions);
            if (changed) {
                this.lastSuggestions = suggestions;
            }
            if (!query.equals(this.lastQuery) || changed) {
                Pair<List<T>, List<Component>> pair = this.suggestionProvider.pickAndDecorateSuggestions(this.typeWrapper, query, this.lastSuggestions);
                this.lastSortedSuggestions = (List)pair.getLeft();
                this.decoratedSuggestions = (List)pair.getRight();
                this.lastQuery = query;
                this.setDropDownScroll(0);
            }
        }
    }

    protected void onValueChanged(T newValue) {
        if (this.valueListener != null) {
            this.valueListener.accept(newValue);
        }
    }

    protected void delete(int num) {
        if (this.hasSelection()) {
            this.insertText("");
        } else if (Screen.m_96637_()) {
            this.deleteWords(num);
        } else {
            this.deleteFromCaret(num);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.hasSelection()) {
                this.insertText("");
            } else {
                this.deleteFromCaret(this.getWordPosFromCaret(num) - this.caretPos);
            }
        }
    }

    public void deleteFromCaret(int chars) {
        if (!this.text.isEmpty()) {
            if (this.hasSelection()) {
                this.insertText("");
            } else {
                int stop;
                int i = this.expandLigaturesFromCaret(chars);
                int start = Math.min(i, this.caretPos);
                if (start != (stop = Math.max(i, this.caretPos))) {
                    String s;
                    String text = this.getText();
                    if (this.formatter != null && chars == -1 && stop - start == 1 && stop < text.length()) {
                        String context = new StringBuilder(text).delete(start, stop + 1).toString();
                        String closingPair = this.formatter.closingPair(text.charAt(start), context, start);
                        if (closingPair != null && text.substring(stop).startsWith(closingPair)) {
                            stop += closingPair.length();
                        }
                    }
                    if (this.filter.test(s = new StringBuilder(text).delete(start, stop).toString())) {
                        this.text = s;
                        this.moveCaretWithAnchor(start);
                    }
                }
            }
        }
    }

    public int getWordPosFromCaret(int numWords) {
        return this.getWordPosFromPos(numWords, this.getCaret());
    }

    public int getWordPosFromPos(int wordStep, int pos) {
        boolean reverse;
        if (wordStep == 0) {
            return pos;
        }
        String text = this.getText();
        int length = text.length();
        boolean bl = reverse = wordStep < 0;
        if (reverse) {
            text = new StringBuilder(text).reverse().toString();
            wordStep = -wordStep;
            pos = length - pos;
        }
        Matcher m = (reverse ? WORD_BREAK_LEFT_PATTERN : WORD_BREAK_RIGHT_PATTERN).matcher(text);
        int r = -1;
        while (wordStep > 0 && m.find()) {
            if (m.end() <= pos) continue;
            --wordStep;
            r = m.end();
        }
        if (wordStep > 0) {
            r = length;
        }
        if (reverse) {
            r = length - r;
        }
        return r;
    }

    public void moveCaretBy(int num) {
        this.moveCaret(this.expandLigaturesFromCaret(num));
    }

    protected int expandLigaturesFromCaret(int chars) {
        return Util.m_137479_((String)this.text, (int)this.caretPos, (int)chars);
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void setSelection(int anchor, int caret) {
        this.moveCaret(caret);
        this.setAnchorPos(anchor);
    }

    public void moveCaret(int pos) {
        this.setCaretPosition(pos);
        if (!Screen.m_96638_()) {
            this.setAnchorPos(this.caretPos);
        }
        this.onTextChanged(this.text);
    }

    public void moveCaretWithAnchor(int pos) {
        this.moveCaret(pos);
        this.setAnchorPos(pos);
    }

    public void setCaretPosition(int pos) {
        this.caretPos = Mth.m_14045_((int)pos, (int)0, (int)this.text.length());
    }

    public void moveCaretToStart() {
        this.moveCaret(0);
    }

    public void moveCaretToEnd() {
        this.moveCaret(this.text.length());
    }

    public void autoComplete() {
        this.suggestionCursor = -1;
        if (!this.isDropDownShown()) {
            this.setDropDownShown(true);
        } else if (this.autoCompleteValue != null) {
            this.setValue(this.autoCompleteValue);
            this.setDropDownShown(false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.lastInteraction = System.currentTimeMillis();
        if (Screen.m_96634_((int)keyCode)) {
            this.moveCaretToEnd();
            this.setAnchorPos(0);
            return true;
        }
        KeyboardHandler kl = Minecraft.m_91087_().f_91068_;
        if (Screen.m_96632_((int)keyCode)) {
            kl.m_90911_(this.getSelectedText());
            this.playFeedbackTap(1.0f);
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable()) {
                this.insertText(kl.m_90876_());
            }
            this.playFeedbackTap(1.0f);
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            kl.m_90911_(this.getSelectedText());
            if (this.isEditable()) {
                this.insertText("");
            }
            this.playFeedbackTap(1.0f);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable()) {
                    this.delete(-1);
                }
                return true;
            }
            case 261: {
                if (this.isEditable()) {
                    this.delete(1);
                }
                return true;
            }
            case 264: {
                this.moveSuggestionCursor(1);
                return true;
            }
            case 265: {
                this.moveSuggestionCursor(-1);
                return true;
            }
            case 257: {
                this.autoComplete();
                this.playFeedbackTap(1.0f);
                return true;
            }
            case 266: {
                this.moveSuggestionCursor(-Math.max(1, this.dropDownHeight / this.getSuggestionHeight() - 1));
                return true;
            }
            case 267: {
                this.moveSuggestionCursor(Math.max(1, this.dropDownHeight / this.getSuggestionHeight() - 1));
                return true;
            }
            case 262: {
                if (this.hasSelection() && !Screen.m_96638_()) {
                    this.moveCaretWithAnchor(Math.max(this.anchorPos, this.caretPos));
                } else if (Screen.m_96637_()) {
                    this.moveCaret(this.getWordPosFromCaret(1));
                } else {
                    this.moveCaretBy(1);
                }
                return true;
            }
            case 263: {
                if (this.hasSelection() && !Screen.m_96638_()) {
                    this.moveCaretWithAnchor(Math.min(this.anchorPos, this.caretPos));
                } else if (Screen.m_96637_()) {
                    this.moveCaret(this.getWordPosFromCaret(-1));
                } else {
                    this.moveCaretBy(-1);
                }
                return true;
            }
            case 268: {
                this.moveCaretToStart();
                return true;
            }
            case 269: {
                this.moveCaretToEnd();
                return true;
            }
        }
        return false;
    }

    private void playFeedbackTap(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)volume));
    }

    private void playFeedbackClick(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)volume));
    }

    public void moveSuggestionCursor(int step) {
        boolean animated;
        if (!this.isDropDownShown()) {
            this.setDropDownShown(true);
        }
        int prev = this.suggestionCursor;
        this.suggestionCursor = Mth.m_14045_((int)(this.suggestionCursor + step), (int)0, (int)(this.lastSortedSuggestions.size() - 1));
        int suggestionHeight = this.getSuggestionHeight();
        int firstIdx = (int)Mth.m_14008_((double)(this.dropDownScroll / (double)suggestionHeight), (double)0.0, (double)(this.lastSortedSuggestions.size() - 1));
        int lastIdx = (int)Mth.m_14008_((double)((this.dropDownScroll + (double)this.dropDownHeight + (double)suggestionHeight - 1.0) / (double)suggestionHeight), (double)0.0, (double)(this.lastSortedSuggestions.size() - 1));
        long t = System.currentTimeMillis();
        boolean bl = animated = t - this.lastSuggestionCursorNavigation >= 60L;
        if (this.suggestionCursor <= firstIdx) {
            this.scrollTo((double)suggestionHeight * ((double)this.suggestionCursor - 0.5), animated);
        } else if (this.suggestionCursor >= lastIdx - 1) {
            this.scrollTo((double)suggestionHeight * ((double)this.suggestionCursor + 1.8) - (double)this.dropDownHeight, animated);
        }
        this.lastSuggestionCursorNavigation = t;
        if (prev != this.suggestionCursor) {
            this.playFeedbackTap(1.0f);
        }
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEnabled();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (codePoint == ' ' && (modifiers & 2) != 0) {
            this.autoComplete();
            this.playFeedbackTap(1.0f);
            return true;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            if (this.isEditable()) {
                int caret;
                String closingPair = null;
                if (this.formatter != null) {
                    String text;
                    caret = this.getCaret();
                    if (caret < (text = this.getText()).length() && text.charAt(caret) == codePoint && this.formatter.shouldSkipClosingPair(codePoint, text, caret)) {
                        this.moveCaretWithAnchor(caret + 1);
                        return true;
                    }
                    closingPair = this.formatter.closingPair(codePoint, text, caret);
                }
                this.insertText(Character.toString(codePoint));
                if (closingPair != null && !closingPair.isEmpty()) {
                    caret = this.getCaret();
                    this.insertText(closingPair);
                    this.moveCaretWithAnchor(caret);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93623_) {
            return false;
        }
        if (this.isVisible()) {
            this.lastInteraction = System.currentTimeMillis();
            this.lastClickWordPos = -1;
            this.draggingText = false;
            if (this.isMouseOverArrow((int)Math.round(mouseX), (int)Math.round(mouseY)) || this.isMouseOverIcon((int)Math.round(mouseX), (int)Math.round(mouseY))) {
                if (!this.m_93696_()) {
                    this.m_93692_(true);
                }
                this.setDropDownShown(!this.isDropDownShown());
                this.playFeedbackClick(1.0f);
                return true;
            }
            boolean hovered = this.m_5953_(mouseX, mouseY);
            if (this.isRestrictedToSuggestions() && hovered) {
                if (!this.m_93696_()) {
                    this.m_93692_(true);
                }
                if (this.isEnabled()) {
                    boolean wasShown = this.isDropDownShown();
                    this.setDropDownShown(!wasShown);
                    if (!wasShown) {
                        this.setText("");
                    }
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                }
                return true;
            }
            if (!this.canLoseFocus || !this.m_93696_()) {
                this.m_93692_(hovered);
            }
            if (this.m_93696_() && hovered && button == 0) {
                this.draggingText = true;
                double relX = mouseX - (double)this.m_252754_();
                if (this.hasIcon()) {
                    relX -= (double)(this.getIconWidth() + 1);
                } else if (this.shouldDrawBackground()) {
                    relX -= 4.0;
                }
                int clickedPos = this.getClickedCaretPos(SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll), relX) + this.hScroll;
                if (this.lastInteraction - this.lastClick < 250L) {
                    int left = this.getWordPosFromPos(-1, clickedPos);
                    int right = this.getWordPosFromPos(1, clickedPos);
                    if (this.anchorPos == left && this.caretPos == right) {
                        this.moveCaretToEnd();
                        this.setAnchorPos(0);
                        this.draggingText = false;
                    } else {
                        this.moveCaret(right);
                        this.setAnchorPos(left);
                        this.lastClickWordPos = clickedPos;
                    }
                } else {
                    this.moveCaret(clickedPos);
                    this.setAnchorPos(this.caretPos);
                }
                this.lastClick = this.lastInteraction;
                return true;
            }
            if (this.isEnabled() && this.m_93696_() && hovered && button == 1 && !this.isRestrictedToSuggestions()) {
                this.setText("");
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isVisible() && this.m_93696_() && button == 0 && this.draggingText) {
            this.lastInteraction = System.currentTimeMillis();
            double relX = mouseX - (double)this.m_252754_();
            if (this.hasIcon()) {
                relX -= (double)(this.getIconWidth() + 1);
            } else if (this.shouldDrawBackground()) {
                relX -= 4.0;
            }
            int prevAnchor = this.anchorPos;
            int draggedPos = this.getClickedCaretPos(SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll), relX) + this.hScroll;
            if (this.lastClickWordPos != -1) {
                int left = this.getWordPosFromPos(-1, this.lastClickWordPos);
                int right = this.getWordPosFromPos(1, this.lastClickWordPos);
                if (draggedPos < left) {
                    this.moveCaret(this.getWordPosFromPos(-1, draggedPos));
                    this.setAnchorPos(right);
                } else if (draggedPos > right) {
                    this.moveCaret(this.getWordPosFromPos(1, draggedPos));
                    this.setAnchorPos(left);
                } else {
                    boolean r = draggedPos > (left + right) / 2;
                    this.moveCaret(r ? right : left);
                    this.setAnchorPos(r ? left : right);
                }
            } else {
                this.moveCaret(draggedPos);
                this.setAnchorPos(prevAnchor);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected int getClickedCaretPos(MutableComponent line, double relX) {
        int right;
        int lineLength = line.getString().length();
        int floor = this.font.m_92854_((FormattedText)line, (int)relX).getString().length();
        if (floor >= lineLength) {
            return lineLength;
        }
        int left = this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)line, 0, floor));
        return relX < (double)(left + (right = this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)line, 0, floor + 1)))) * 0.5 ? floor : floor + 1;
    }

    public void m_93692_(boolean focused) {
        boolean prev = this.m_93696_();
        super.m_93692_(focused);
        boolean actual = this.m_93696_();
        if (prev != actual) {
            this.onFocusedChanged(actual);
        }
    }

    protected void updateDropDownRectangle() {
        this.dropDownRectangle.x = this.m_252754_() - 1;
        this.dropDownRectangle.y = this.m_252907_() + this.f_93619_;
        this.dropDownRectangle.width = this.f_93618_ + 2;
        this.dropDownRectangle.height = this.getDropDownHeight();
        this.reportedDropDownRectangle.setBounds(ScissorsHandler.INSTANCE.getScissorsAreas().stream().reduce(this.dropDownRectangle, Rectangle::intersection));
        if (this.reportedDropDownRectangle.isEmpty()) {
            this.reportedDropDownRectangle.setBounds(0, 0, 0, 0);
        }
    }

    public MutableComponent getDisplayedText() {
        return this.formatter.formatText(this.getText());
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        List<Component> tooltip;
        int color;
        if (this.pendingDropDownShownChange) {
            this.setDropDownShown(!this.dropDownShown);
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        this.area.setBounds(x, y, this.f_93618_, this.f_93619_);
        if (!this.isVisible()) {
            return;
        }
        this.updateSuggestions();
        if (this.shouldDrawBackground()) {
            int color2 = this.m_198029_() ? this.focusedBorderColor : this.borderColor;
            gg.m_280509_(x - 1, y - 1, x + this.f_93618_ + 1, y + this.f_93619_ + 1, color2);
            gg.m_280509_(x, y, x + this.f_93618_, y + this.f_93619_, this.backgroundColor);
            if (!this.isRestrictedToSuggestions()) {
                gg.m_280509_(x + this.f_93618_ - this.arrowWidth - 1, y, x + this.f_93618_ - this.arrowWidth, y + this.f_93619_, color2);
            }
        }
        if (!this.m_93696_() || !this.canShowDropDown()) {
            this.setDropDownShown(false);
        }
        this.updateDropDownRectangle();
        this.autoCompleteValue = this.lastSortedSuggestions.isEmpty() ? null : (this.suggestionCursor >= 0 && this.suggestionCursor < this.lastSortedSuggestions.size() ? this.lastSortedSuggestions.get(this.suggestionCursor) : (this.text.isEmpty() && !"".equals(this.value) ? this.value : this.lastSortedSuggestions.get(0)));
        boolean hasIcon = this.hasIcon();
        int iconHeight = this.getIconHeight();
        int iconWidth = this.getIconWidth();
        int textX = hasIcon ? x + iconWidth + 1 : (this.shouldDrawBackground ? x + 4 : x);
        int textY = this.shouldDrawBackground ? y + (this.f_93619_ - 8) / 2 : y;
        int iconX = x;
        int iconY = this.shouldDrawBackground ? textY + 4 - iconHeight / 2 : (hasIcon ? y + iconHeight / 2 - 4 : y);
        int innerWidth = this.getInnerWidth();
        Component hint = this.getHint();
        int n = color = this.isEnabled() ? this.enabledColor : this.disabledColor;
        if (this.m_93696_() || this.value == null && hint == null) {
            boolean showCaret;
            int relCaret = this.caretPos - this.hScroll;
            int relAnchor = this.anchorPos - this.hScroll;
            MutableComponent displayedText = SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll);
            String shown = this.font.m_92854_((FormattedText)displayedText, innerWidth).getString();
            int fitLength = shown.length();
            displayedText = SimpleConfigTextUtil.subText((Component)displayedText, 0, fitLength);
            boolean fitCaret = relCaret >= 0 && relCaret <= fitLength;
            boolean bl = showCaret = this.m_93696_() && fitCaret && (System.currentTimeMillis() - this.lastInteraction) % 1000L < 500L;
            int caretX = fitCaret ? textX + this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)displayedText, 0, relCaret)) - 1 : (relCaret > 0 ? textX + innerWidth - 1 : textX);
            int endTextX = textX;
            if (!shown.isEmpty()) {
                endTextX += gg.m_280430_(this.font, (Component)displayedText, textX, textY, color);
            }
            if (this.isDropDownShown() && this.autoCompleteValue != null) {
                String autoComplete = this.typeWrapper.getName(this.autoCompleteValue);
                Object shownAutocomplete = autoComplete.startsWith(this.text) ? autoComplete.substring(this.text.length()) : "\u2192" + autoComplete;
                shownAutocomplete = this.font.m_92834_((String)shownAutocomplete, innerWidth - endTextX + textX);
                gg.m_280488_(this.font, (String)shownAutocomplete, endTextX, textY, -1769963392);
            }
            if (showCaret) {
                this.renderCaret(gg, caretX, textY - 2, 1, 12);
            }
            if (relAnchor != relCaret) {
                if (relAnchor > fitLength) {
                    relAnchor = fitLength;
                }
                int anchorX = textX + this.font.m_92895_(shown.substring(0, relAnchor));
                this.renderSelection(gg, caretX, textY - 3, anchorX - 1, textY + 2 + 9);
            }
        } else if (this.text.isEmpty() && this.value == null) {
            this.drawTextComponent((Component)hint.m_6881_().m_130940_(ChatFormatting.GRAY), gg, textX, textY, innerWidth, 10, -1761607681);
        } else if (this.value != null) {
            Component display = this.typeWrapper.getDisplayName(this.value);
            if (!this.isEnabled()) {
                display = display.m_6881_().m_130940_(ChatFormatting.GRAY);
            }
            this.drawTextComponent(display, gg, textX, textY, innerWidth, 10, -2039584);
        } else {
            MutableComponent displayedText = SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll);
            displayedText = SimpleConfigTextUtil.subText((Component)displayedText, 0, this.font.m_92854_((FormattedText)displayedText, innerWidth).getString().length());
            gg.m_280430_(this.font, (Component)displayedText, textX, textY, color);
        }
        if (hasIcon) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.isEnabled() ? 1.0f : 0.7f));
            this.typeWrapper.renderIcon(this.autoCompleteValue != null && this.isDropDownShown() ? this.autoCompleteValue : this.value, this.text, gg, iconX, iconY, iconWidth, iconHeight, 0, mouseX, mouseY, delta);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int arrowX = x + this.f_93618_ - this.arrowWidth;
        int arrowY = y;
        this.renderArrow(gg, arrowX, arrowY, this.arrowWidth, this.f_93619_, mouseX, mouseY, this.isRestrictedToSuggestions() && this.m_198029_() ? x : arrowX);
        if (this.isShowHelpTooltips() && this.value != null && this.m_5953_(mouseX, mouseY) && !this.isMouseOverArrow(mouseX, mouseY) && !(tooltip = this.typeWrapper.getHelpTooltip(this.value)).isEmpty()) {
            IOverlayCapableContainer screen = this.getScreen();
            if (this.tooltipConsumer != null) {
                this.tooltipConsumer.renderTooltip(tooltip, mouseX, mouseY);
            } else if (screen instanceof IMultiTooltipScreen) {
                IMultiTooltipScreen ts = (IMultiTooltipScreen)((Object)screen);
                ts.addTooltip(Tooltip.of(this.area, Point.of(mouseX, mouseY), tooltip));
            } else {
                gg.m_280666_(this.font, tooltip, mouseX, mouseY);
            }
        }
    }

    protected void renderCaret(GuiGraphics gg, int x, int y, int w, int h) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bb = tessellator.m_85915_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bb.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_5752_();
        bb.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_5752_();
        bb.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_5752_();
        bb.m_252986_(m, (float)x, (float)y, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableColorLogicOp();
    }

    public boolean isMouseOverArrow(int mouseX, int mouseY) {
        int arrowX = this.m_252754_() + this.f_93618_ - this.arrowWidth;
        int arrowY = this.m_252907_();
        return mouseX >= arrowX && mouseX < arrowX + this.arrowWidth && mouseY >= arrowY && mouseY < arrowY + this.f_93619_;
    }

    public boolean isMouseOverIcon(int mouseX, int mouseY) {
        int iconHeight = this.getIconHeight();
        int iconY = this.shouldDrawBackground ? this.m_252907_() + this.f_93619_ / 2 - iconHeight / 2 : this.m_252907_();
        return this.hasIcon() && mouseX >= this.m_252754_() && mouseX < this.m_252754_() + this.getIconWidth() && mouseY >= iconY && mouseY < iconY + iconHeight;
    }

    protected void renderArrow(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, int backgroundX) {
        int arrowBackground;
        boolean hovered = mouseX >= backgroundX && mouseX < x + w && mouseY >= y && mouseY < y + h;
        int n = arrowBackground = hovered ? -2140904348 : -2145115100;
        if (backgroundX == mouseX || hovered) {
            gg.m_280509_(backgroundX, y, x + w, y + h, arrowBackground);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.canShowDropDown() ? 1.0f : 0.7f));
        SimpleConfigIcons.ComboBox.DROP_DOWN_ARROW.renderCentered(gg, x, y + (h - 10) / 2, 10, 10, this.isDropDownShown() ? 1 : 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderSelection(GuiGraphics gg, int sX, int sY, int eX, int eY) {
        int x;
        int swap;
        if (sX < eX) {
            swap = sX;
            sX = eX;
            eX = swap;
        }
        if (sY < eY) {
            swap = sY;
            sY = eY;
            eY = swap;
        }
        if (eX > (x = this.m_252754_()) + this.f_93618_) {
            eX = x + this.f_93618_;
        }
        if (sX > x + this.f_93618_) {
            sX = x + this.f_93618_;
        }
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.XOR);
        gg.m_280509_(sX, sY, eX, eY, -16777088);
        RenderSystem.disableColorLogicOp();
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    protected int getMaxLength() {
        return this.maxLength;
    }

    public int getCaret() {
        return this.caretPos;
    }

    protected boolean shouldDrawBackground() {
        return this.shouldDrawBackground;
    }

    public void setShouldDrawBackground(boolean shouldDrawBackground) {
        this.shouldDrawBackground = shouldDrawBackground;
    }

    public void setTextColor(int color) {
        this.enabledColor = color;
    }

    public void setDisabledTextColour(int color) {
        this.disabledColor = color;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    protected void onFocusedChanged(boolean focused) {
        if (focused) {
            if (this.isRestrictedToSuggestions()) {
                this.setText("");
                if (this.isAutoDropDown()) {
                    this.setDropDownShown(true);
                }
            } else if (this.pendingDropDownShownChange && this.dropDownShown) {
                this.setDropDownShown(true);
            }
        } else {
            if (this.isRestrictedToSuggestions()) {
                if (this.value != null) {
                    this.setText(this.typeWrapper.getName(this.value));
                } else {
                    this.setText("");
                }
            }
            this.setDropDownShown(false, true);
        }
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected boolean isEditable() {
        return this.isEnabled();
    }

    public boolean canShowDropDown() {
        return this.canShowDropDown && this.isEnabled();
    }

    public void setCanShowDropDown(boolean canShowDropDown) {
        this.canShowDropDown = canShowDropDown;
        if (!canShowDropDown && this.isDropDownShown()) {
            this.setDropDownShown(false);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public int getInnerWidth() {
        int w;
        int n = w = this.shouldDrawBackground() ? this.f_93618_ - 8 : this.f_93618_;
        if (this.hasIcon()) {
            w += 4 - this.getIconWidth();
        }
        return w - this.arrowWidth;
    }

    public void setAnchorPos(int pos) {
        int i = this.text.length();
        this.anchorPos = Mth.m_14045_((int)pos, (int)0, (int)i);
        if (this.font != null) {
            if (this.hScroll > i) {
                this.hScroll = i;
            }
            int j = this.getInnerWidth();
            String s = this.font.m_92834_(this.text.substring(this.hScroll), j);
            int k = s.length() + this.hScroll;
            if (this.anchorPos == this.hScroll) {
                this.hScroll -= this.font.m_92837_(this.text, j, true).length();
            }
            if (this.anchorPos > k) {
                String rev = new StringBuilder(this.text.substring(0, this.anchorPos)).reverse().toString();
                this.hScroll = this.anchorPos - this.font.m_92834_(rev, j).length();
            } else if (this.anchorPos <= this.hScroll) {
                this.hScroll = this.anchorPos;
            }
            this.hScroll = Mth.m_14045_((int)this.hScroll, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    @Deprecated
    public int getTextXFor(int pos) {
        return pos > this.text.length() ? this.m_252754_() : this.m_252754_() + this.font.m_92895_(this.text.substring(0, pos));
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public Optional<Component> getError() {
        return Optional.ofNullable(this.parseError);
    }

    protected void m_168797_(NarrationElementOutput out) {
        out.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.getValue()}));
    }
}

