/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.ui.gui.widget.combobox.IComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractComboBoxModel<T>
implements IComboBoxModel<T> {
    protected static Pattern TOKEN_SPLITTER = Pattern.compile("[\\s_]++|(?<=[a-z])(?=[A-Z])");

    protected static List<String> tokenMatches(String target, String query) {
        query = query.trim();
        target = target.trim();
        if (query.length() > target.length()) {
            return Collections.emptyList();
        }
        String[] q = TOKEN_SPLITTER.split(query);
        String[] t = TOKEN_SPLITTER.split(target);
        if (t.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        int r = -1;
        block0: for (String qq : q) {
            String rem;
            qq = qq.toLowerCase();
            if (++r < t.length) {
                rem = t[r];
            } else {
                return Collections.emptyList();
            }
            while (!qq.isEmpty()) {
                int j;
                int m = Math.min(qq.length(), rem.length());
                for (j = 0; j < m && qq.charAt(j) == Character.toLowerCase(rem.charAt(j)); ++j) {
                }
                if (j == 0) {
                    if (++r < t.length) {
                        rem = t[r];
                        continue;
                    }
                    return Collections.emptyList();
                }
                result.add(rem.substring(0, j));
                qq = qq.substring(j);
                if (qq.isEmpty()) continue block0;
                if (++r < t.length) {
                    rem = t[r];
                    continue;
                }
                return Collections.emptyList();
            }
        }
        return result;
    }

    @Override
    public Pair<List<T>, List<Component>> pickAndDecorateSuggestions(TypeWrapper<T> typeWrapper, String query, List<T> suggestions) {
        if (query.isEmpty()) {
            return Pair.of(suggestions, suggestions.stream().map(typeWrapper::getDisplayName).collect(Collectors.toList()));
        }
        if (suggestions.isEmpty()) {
            return Pair.of(suggestions, new ArrayList());
        }
        LinkedHashSet set = new LinkedHashSet();
        ArrayList names = new ArrayList();
        suggestions.stream().map(e -> {
            String n = typeWrapper.getName(e);
            return Triple.of((Object)e, (Object)n, AbstractComboBoxModel.tokenMatches(n, query));
        }).filter(t -> !((List)t.getRight()).isEmpty()).sorted(Comparator.comparingInt(t -> ((List)t.getRight()).stream().mapToInt(String::length).reduce(0, (a, b) -> a * b)).thenComparingInt(t -> ((String)t.getMiddle()).length())).forEachOrdered(t -> {
            Object value = t.getLeft();
            if (set.add(value)) {
                String name;
                String n = name = (String)t.getMiddle();
                String[] sp = TOKEN_SPLITTER.split(name);
                List matches = (List)t.getRight();
                int i = 0;
                int o = 0;
                MutableComponent stc = Component.m_237113_((String)"");
                for (String frag : sp) {
                    String tar;
                    int j;
                    if (i >= matches.size()) break;
                    int s = n.indexOf(frag);
                    if (s > 0) {
                        stc = stc.m_7220_(this.getNonMatch(typeWrapper, value, name, o, n.substring(0, s)));
                        o += s;
                        n = n.substring(s);
                    }
                    if ((j = frag.indexOf(tar = (String)matches.get(i))) == -1) {
                        stc = stc.m_7220_(this.getNonMatch(typeWrapper, value, name, o, frag));
                    } else {
                        stc = stc.m_7220_(this.getNonMatch(typeWrapper, value, name, o, frag.substring(0, j))).m_7220_(this.getMatch(typeWrapper, value, name, o, frag, o + j, tar)).m_7220_(this.getNonMatch(typeWrapper, value, name, o + j + tar.length(), frag.substring(j + tar.length())));
                        ++i;
                    }
                    o += frag.length();
                    n = n.substring(frag.length());
                }
                stc = stc.m_7220_(this.getNonMatch(typeWrapper, value, name, o, n));
                names.add(stc);
            }
        });
        suggestions.stream().filter(e -> !set.contains(e)).map(e -> Pair.of((Object)e, (Object)typeWrapper.getName(e))).filter(p -> ((String)p.getRight()).contains(query)).sorted(Comparator.comparingInt(p -> ((String)p.getRight()).length()).thenComparingInt(p -> ((String)p.getRight()).indexOf(query)).thenComparing(Pair::getRight)).forEachOrdered(p -> {
            Object value = p.getKey();
            if (set.add(value)) {
                String name = (String)p.getRight();
                int i = name.indexOf(query);
                names.add(this.getNonMatch(typeWrapper, value, name, 0, name.substring(0, i)).m_6881_().m_7220_(this.getMatch(typeWrapper, value, name, 0, name, i, query)).m_7220_(this.getNonMatch(typeWrapper, value, name, i + query.length(), name.substring(i + query.length()))));
            }
        });
        return Pair.of(new ArrayList(set), names);
    }

    protected Style getMatchStyle() {
        return Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.BLUE});
    }

    protected Component getMatch(TypeWrapper<T> typeWrapper, T item, String name, int fragmentPos, String fragment, int matchPos, String match) {
        return Component.m_237113_((String)match).m_6270_(this.getMatchStyle());
    }

    protected Component getNonMatch(TypeWrapper<T> typeWrapper, T item, String name, int fragmentPos, String fragment) {
        Component title = typeWrapper.getDisplayName(item);
        if (!title.getString().equals(name)) {
            return Component.m_237113_((String)fragment);
        }
        return SimpleConfigTextUtil.subText(title, fragmentPos, fragmentPos + fragment.length());
    }
}

