/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ui.icon.Icon;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleImageButton
extends ImageButton {
    private boolean toggle;
    protected Icon icon;
    @Nullable
    protected Icon tintedIcon = null;
    protected int tint = 0;
    protected int hoverOverlayColor = 0x42FFFFFF;
    protected int borderColor = -2039584;
    protected Consumer<Boolean> onChange;

    public static ToggleImageButton of(boolean value, int size, Icon icon) {
        return ToggleImageButton.of(value, size, icon, null);
    }

    public static ToggleImageButton of(boolean value, int size, Icon icon, @Nullable Consumer<Boolean> listener) {
        return new ToggleImageButton(value, 0, 0, size, size, icon, listener);
    }

    public ToggleImageButton(boolean value, int x, int y, int width, int height, Icon icon, @Nullable Consumer<Boolean> onChange) {
        super(x, y, width, height, icon.getU(), icon.getV(), icon.h, icon.getTexture(), b -> {});
        this.toggle = value;
        this.icon = icon;
        this.onChange = onChange;
    }

    public boolean getValue() {
        return this.isToggle();
    }

    public void setValue(boolean value) {
        this.setToggle(value);
        if (this.onChange != null) {
            this.onChange.accept(this.isToggle());
        }
    }

    public Consumer<Boolean> getListener() {
        return this.onChange;
    }

    public void setListener(Consumer<Boolean> listener) {
        this.onChange = listener;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (button == 0) {
                this.setValue(!this.isToggle());
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)1.0f));
                return true;
            }
            if (button == 1) {
                this.setValue(Screen.m_96638_());
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)1.0f));
                return true;
            }
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 32 || keyCode == 335) {
            this.setValue(!this.isToggle());
            return true;
        }
        return false;
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        Icon icon = this.tintedIcon == null ? this.icon : this.tintedIcon;
        int x = this.m_252754_();
        int y = this.m_252907_();
        icon.renderStretch(gg, x, y, this.f_93618_, this.f_93619_, this.isToggle() ? 1 : 0);
        if (this.m_5953_(mouseX, mouseY)) {
            gg.m_280509_(x, y, x + this.f_93618_, y + this.f_93619_, this.hoverOverlayColor);
        }
        if (this.m_93696_()) {
            gg.m_280509_(x, y, x + this.f_93618_, y + 1, this.borderColor);
            gg.m_280509_(x, y + 1, x + 1, y + this.f_93619_ - 1, this.borderColor);
            gg.m_280509_(x + this.f_93618_ - 1, y + 1, x + this.f_93618_, y + this.f_93619_ - 1, this.borderColor);
            gg.m_280509_(x, y + this.f_93619_ - 1, x + this.f_93618_, y + this.f_93619_, this.borderColor);
        }
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.tintedIcon = this.tint == 0 ? null : icon.withTint(this.tint);
    }

    public int getTint() {
        return this.tint;
    }

    public void setTint(int tint) {
        this.tint = tint;
        this.tintedIcon = tint == 0 ? null : this.icon.withTint(tint);
    }

    public int getHoverOverlayColor() {
        return this.hoverOverlayColor;
    }

    public void setHoverOverlayColor(int hoverOverlayColor) {
        this.hoverOverlayColor = hoverOverlayColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }
}

