/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

public class ToggleAnimator {
    protected float progress;
    protected float target;
    protected float lastProgress;
    protected long lastChange = 0L;
    protected long length;
    protected float min = 0.0f;
    protected float max = 1.0f;

    public ToggleAnimator() {
        this(250L);
    }

    public ToggleAnimator(long length) {
        this(0.0f, length);
    }

    public ToggleAnimator(float progress, long length) {
        this.lastProgress = this.progress = progress;
        this.target = this.progress;
        this.length = length;
    }

    public void toggle() {
        this.setTarget((double)this.target <= 0.5);
    }

    public void resetTarget() {
        this.resetTarget(true);
    }

    public void resetTarget(boolean onOff) {
        this.target = onOff ? 1.0f : 0.0f;
        this.lastProgress = 1.0f - this.target;
        this.lastChange = System.currentTimeMillis();
    }

    public void resetTarget(float target) {
        this.target = target;
        this.lastProgress = 0.0f;
        this.lastChange = System.currentTimeMillis();
    }

    public void stopAndSet(float target) {
        this.target = target;
        this.lastProgress = 1.0f;
        this.lastChange = System.currentTimeMillis() - this.length;
    }

    public void stopAndSet(boolean target) {
        this.stopAndSet(target ? 1.0f : 0.0f);
    }

    public void setEaseOutTarget(boolean onOff) {
        this.setEaseOutTarget(onOff ? 1.0f : 0.0f);
    }

    public void setEaseOutTarget(float target) {
        this.lastProgress = this.getEaseOut();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public void setEaseInTarget(boolean onOff) {
        this.setEaseInTarget(onOff ? 1.0f : 0.0f);
    }

    public void setEaseInTarget(float target) {
        this.lastProgress = this.getEaseIn();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public void setEaseInOutTarget(boolean onOff) {
        this.setEaseInOutTarget(onOff ? 1.0f : 0.0f);
    }

    public void setEaseInOutTarget(float target) {
        this.lastProgress = this.getEaseInOut();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public boolean isInProgress() {
        return (float)(System.currentTimeMillis() - this.lastChange) < (float)this.length * Math.abs(this.target - this.lastProgress);
    }

    public float getProgress() {
        float len;
        long time = System.currentTimeMillis();
        if ((float)(time - this.lastChange) < (len = (float)this.length * Math.abs(this.target - this.lastProgress))) {
            float t = (float)(time - this.lastChange) / len;
            this.progress = this.lastProgress * (1.0f - t) + this.target * t;
            return this.progress;
        }
        this.progress = this.target;
        return this.progress;
    }

    public float getEaseOut() {
        float t = this.getProgress();
        return this.mapRange(this.target < t ? t * t : 2.0f * t - t * t);
    }

    public float getEaseIn() {
        float t = this.getProgress();
        return this.mapRange(this.target < t ? 2.0f * t - t * t : t * t);
    }

    public float getEaseInOut() {
        float t = this.getProgress();
        return this.mapRange((double)t <= 0.5 ? 2.0f * t * t : -1.0f + (4.0f - 2.0f * t) * t);
    }

    public float mapRange(float in) {
        return this.min + in * (this.max - this.min);
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public float getTarget() {
        return this.target;
    }

    public void setTarget(boolean onOff) {
        this.setTarget(onOff ? 1.0f : 0.0f);
    }

    public void setTarget(float target) {
        this.lastProgress = this.getProgress();
        this.target = target;
        this.lastChange = System.currentTimeMillis();
    }

    public float getRangeMin() {
        return this.min;
    }

    public float getRangeMax() {
        return this.max;
    }

    public void setOutputRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }
}

