/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.OverlayInjector;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TintedButton
extends Button {
    protected int tintColor = 0;
    protected Rectangle area = new Rectangle();
    @Nullable
    protected Rectangle overlayArea = null;
    protected Rectangle contentArea = new Rectangle();
    protected ButtonOverlay overlay = new ButtonOverlay(this);

    public static TintedButton of(Component title, Button.OnPress pressedAction) {
        return TintedButton.of(80, 20, title, pressedAction);
    }

    public static TintedButton of(Component title, int tint, Button.OnPress pressedAction) {
        return TintedButton.of(80, 20, title, tint, pressedAction);
    }

    public static TintedButton of(int width, int height, Component title, Button.OnPress pressedAction) {
        return TintedButton.of(width, height, title, 0, pressedAction);
    }

    public static TintedButton of(int width, int height, Component title, int tint, Button.OnPress pressedAction) {
        TintedButton button = new TintedButton(0, 0, width, height, title, pressedAction);
        button.setTintColor(tint);
        return button;
    }

    public TintedButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
        super(new Button.Builder(title, pressedAction).m_252987_(x, y, width, height));
    }

    public TintedButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction, Button.CreateNarration createNarration) {
        super(x, y, width, height, title, pressedAction, createNarration);
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.area.setBounds(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
        super.m_88315_(gg, mouseX, mouseY, delta);
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int level = this.getTextureLevel();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_93617_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        SimpleConfigIcons.Backgrounds.BUTTON_BACKGROUND.renderStretch(gg, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, level);
        this.renderTint(gg, this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_ / 2 * 2, this.m_252907_() + this.f_93619_);
        int fgColor = this.getFGColor();
        Component message = this.m_6035_();
        int contentWidth = font.m_92852_((FormattedText)message);
        this.contentArea.setBounds(this.area.x + 4, this.area.y, this.area.width - 8, this.area.height);
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        if (contentWidth < this.f_93618_ - 8) {
            mStack.m_85837_((double)(this.f_93618_ - 8 - contentWidth) / 2.0, 0.0, 0.0);
        }
        if (contentWidth > this.f_93618_ - 8) {
            ScissorsHandler.INSTANCE.withScissor(this.contentArea, () -> gg.m_280430_(font, message, this.m_252754_() + 4, this.m_252907_() + (this.f_93619_ - 8) / 2, fgColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
            if (this.m_5953_(mouseX, mouseY) && !this.overlay.isRendering()) {
                Screen screen = mc.f_91080_;
                if (this.overlayArea == null) {
                    this.overlayArea = new Rectangle();
                    OverlayInjector.injectVisualOverlay(this.overlayArea, this.overlay, 10);
                }
                this.overlayArea.setBounds(this.m_252754_(), this.m_252907_(), contentWidth + 8, this.f_93619_ + 1);
                if (screen != null && this.overlayArea.getMaxX() > screen.f_96543_) {
                    this.overlayArea.x = Math.max(4, screen.f_96543_ - 4 - this.overlayArea.getWidth());
                }
            }
        } else {
            if (this.overlayArea != null) {
                this.overlayArea.setBounds(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_ + 1);
            }
            gg.m_280430_(font, message, this.m_252754_() + 4, this.m_252907_() + (this.f_93619_ - 8) / 2, fgColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
        mStack.m_85849_();
        if (this.m_198029_()) {
            this.renderToolTip(gg, mouseX, mouseY);
        }
    }

    protected int getTextureLevel() {
        return !this.f_93623_ ? 0 : (this.m_198029_() ? 2 : 1);
    }

    protected void renderTint(@NotNull GuiGraphics gg, int x, int y, int xm, int ym) {
        if (this.tintColor != 0) {
            gg.m_280509_(x, y, xm, ym, this.getEffectiveTintColor());
        }
    }

    protected int getEffectiveTintColor() {
        return this.f_93623_ ? this.tintColor : this.tintColor & 0xFFFFFF | (this.tintColor >> 24 & 0xFF) / 4 << 24;
    }

    public List<Component> getTooltipContents() {
        return Collections.emptyList();
    }

    public void renderToolTip(@NotNull GuiGraphics gg, int mouseX, int mouseY) {
        List<Component> ls = this.getTooltipContents();
        if (!ls.isEmpty()) {
            int tooltipY;
            int tooltipX;
            Screen screen = Minecraft.m_91087_().f_91080_;
            boolean hovered = this.m_5953_(mouseX, mouseY);
            int n = tooltipX = hovered ? mouseX : this.m_252754_() + this.f_93618_ / 2;
            int n2 = hovered ? mouseY : (tooltipY = this.m_252907_() < 64 ? this.m_252907_() + this.f_93619_ : this.m_252907_());
            if (screen instanceof IMultiTooltipScreen) {
                IMultiTooltipScreen ts = (IMultiTooltipScreen)screen;
                ts.addTooltip(Tooltip.of(Rectangle.of(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_), Point.of(tooltipX, tooltipY), ls).asKeyboardTooltip(!hovered));
            } else if (screen != null) {
                gg.m_280666_(Minecraft.m_91087_().f_91062_, ls, tooltipX, tooltipY);
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int color) {
        this.tintColor = color;
    }

    public static class ButtonOverlay
    implements IOverlayCapableContainer.IOverlayRenderer {
        protected final TintedButton button;
        protected final ToggleAnimator animator = new ToggleAnimator(140L);
        protected final Rectangle area = new Rectangle();
        protected boolean rendering;
        protected int lastWidth = -1;

        public ButtonOverlay(TintedButton button) {
            this.button = button;
        }

        @Override
        public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
            if (!this.button.m_5953_(mouseX, mouseY)) {
                this.button.overlayArea = null;
                this.animator.stopAndSet(0.0f);
                return false;
            }
            if (this.animator.getTarget() == 0.0f) {
                this.animator.resetTarget();
                this.animator.setOutputRange(this.button.f_93618_, area.width);
            }
            if (this.lastWidth != area.width) {
                this.animator.setOutputRange(this.animator.getEaseOut(), area.width);
                this.animator.resetTarget();
                this.lastWidth = area.width;
            }
            this.rendering = true;
            int x = this.button.m_252754_();
            int y = this.button.m_252907_();
            int w = this.button.f_93618_;
            int h = this.button.f_93619_;
            int ww = (int)this.animator.getEaseOut();
            this.button.m_264152_(area.x, area.y);
            this.button.m_93674_(ww);
            this.button.setHeight(area.height);
            this.area.setBounds(area.x, area.y, ww, area.height);
            ScissorsHandler.INSTANCE.withSingleScissor(this.area, () -> this.button.m_88315_(gg, mouseX, mouseY, delta));
            this.button.m_88315_(gg, mouseX, mouseY, delta);
            this.button.m_264152_(x, y);
            this.button.m_93674_(w);
            this.button.setHeight(h);
            this.rendering = false;
            return true;
        }

        public boolean isRendering() {
            return this.rendering;
        }
    }
}

