/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.TextFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class TextFieldWidgetEx
extends AbstractWidget {
    protected final Font font;
    protected String value = "";
    protected long lastClick;
    protected long lastInteraction = 0L;
    protected boolean draggingText;
    protected int maxLength = 32;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    protected int hScroll;
    protected int caretPos;
    protected int anchorPos;
    protected int lastClickWordPos = -1;
    private int borderColor = 0xFFFFFF;
    private int textColor = -2039584;
    private int textColorUneditable = -9408400;
    @Nullable
    private Function<String, Optional<Component>> hintProvider;
    protected Consumer<String> responder;
    protected Predicate<String> filter = Objects::nonNull;
    protected TextFormatter formatter = TextFormatter.DEFAULT;
    private static final Pattern WORD_BREAK_RIGHT_PATTERN = Pattern.compile("(?<=\\p{Alnum})(?=\\P{Alnum})|(?<=\\p{Alnum})(?=\\p{Lu}[\\p{Ll}\\d])|(?<=[\\p{Ll}\\d])(?=\\p{Lu})|(?<=[^\\p{Alnum}\\s_])(?=[\\p{Alnum}\\s_])");
    private static final Pattern WORD_BREAK_LEFT_PATTERN = Pattern.compile("(?<=\\p{Alnum})(?=\\P{Alnum})|(?<=[\\p{Ll}\\d]\\p{Lu})(?=\\p{Lu})|(?<=\\p{Lu})(?=[\\p{Ll}\\d])|(?<=[^\\p{Alnum}\\s_])(?=[\\p{Alnum}\\s_])");

    public static TextFieldWidgetEx of(String text) {
        TextFieldWidgetEx tf = new TextFieldWidgetEx(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, (Component)Component.m_237119_());
        tf.setValue(text);
        return tf;
    }

    public TextFieldWidgetEx(Font font, int x, int y, int w, int h, Component title) {
        this(font, x, y, w, h, null, title);
    }

    public TextFieldWidgetEx(Font font, int x, int y, int w, int h, @Nullable TextFieldWidgetEx copy, Component title) {
        super(x, y, w, h, title);
        this.font = font;
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public void m_93674_(int width) {
        boolean change = width != this.f_93618_;
        super.m_93674_(width);
        if (change) {
            this.scrollToFitCaret();
        }
    }

    public void tick() {
    }

    @NotNull
    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void setValue(String value) {
        if (this.filter.test(value)) {
            this.value = value.length() > this.maxLength ? value.substring(0, this.maxLength) : value;
            this.moveCaretToStart();
            this.setAnchorPos(this.caretPos);
            this.onValueChange(value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public MutableComponent getDisplayedText() {
        return this.formatter.formatText(this.value);
    }

    public boolean hasSelection() {
        return this.anchorPos != this.caretPos;
    }

    public String getHighlighted() {
        return this.caretPos < this.anchorPos ? this.value.substring(this.caretPos, this.anchorPos) : this.value.substring(this.anchorPos, this.caretPos);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public void insertText(String inserted) {
        String result;
        String txt;
        int length;
        if (this.formatter != null) {
            inserted = this.formatter.stripInsertText(inserted);
        }
        int start = Math.min(this.caretPos, this.anchorPos);
        int end = Math.max(this.caretPos, this.anchorPos);
        int allowed = this.maxLength - this.value.length() - (start - end);
        if (allowed < (length = (txt = SharedConstants.m_136190_((String)inserted)).length())) {
            txt = txt.substring(0, allowed);
            length = allowed;
        }
        if (this.filter.test(result = new StringBuilder(this.value).replace(start, end, txt).toString())) {
            this.value = result;
            this.setCaretPosition(start + length);
            this.setAnchorPos(this.caretPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int words) {
        if (this.hasSelection()) {
            this.insertText("");
        } else if (Screen.m_96637_()) {
            this.deleteWords(words);
        } else {
            this.deleteFromCaret(words);
        }
    }

    public void deleteWords(int words) {
        if (!this.value.isEmpty()) {
            if (this.hasSelection()) {
                this.insertText("");
            } else {
                this.deleteFromCaret(this.getWordPosFromCaret(words) - this.caretPos);
            }
        }
    }

    public void deleteFromCaret(int chars) {
        if (!this.value.isEmpty()) {
            if (this.hasSelection()) {
                this.insertText("");
            } else {
                int stop;
                int i = this.expandLigaturesFromCaret(chars);
                int start = Math.min(i, this.caretPos);
                if (start != (stop = Math.max(i, this.caretPos))) {
                    String s;
                    String text = this.getValue();
                    if (this.formatter != null && chars == -1 && stop - start == 1 && stop < text.length()) {
                        String context = new StringBuilder(text).delete(start, stop + 1).toString();
                        String closingPair = this.formatter.closingPair(text.charAt(start), context, start);
                        if (closingPair != null && text.substring(stop).startsWith(closingPair)) {
                            stop += closingPair.length();
                        }
                    }
                    if (this.filter.test(s = new StringBuilder(text).delete(start, stop).toString())) {
                        this.value = s;
                        this.moveCaretWithAnchor(start);
                    }
                }
            }
        }
    }

    public int getWordPosFromCaret(int numWords) {
        return this.getWordPosFromPos(numWords, this.getCaret());
    }

    public int getWordPosFromPos(int wordStep, int pos) {
        boolean reverse;
        if (wordStep == 0) {
            return pos;
        }
        String text = this.getValue();
        int length = text.length();
        boolean bl = reverse = wordStep < 0;
        if (reverse) {
            text = new StringBuilder(text).reverse().toString();
            wordStep = -wordStep;
            pos = length - pos;
        }
        Matcher m = (reverse ? WORD_BREAK_LEFT_PATTERN : WORD_BREAK_RIGHT_PATTERN).matcher(text);
        int r = -1;
        while (wordStep > 0 && m.find()) {
            if (m.end() <= pos) continue;
            --wordStep;
            r = m.end();
        }
        if (wordStep > 0) {
            r = length;
        }
        if (reverse) {
            r = length - r;
        }
        return r;
    }

    public void moveCaretBy(int relative) {
        this.moveCaret(this.expandLigaturesFromCaret(relative));
    }

    private int expandLigaturesFromCaret(int relativePos) {
        return Util.m_137479_((String)this.value, (int)this.caretPos, (int)relativePos);
    }

    public void moveCaret(int pos) {
        this.setCaretPosition(pos);
        if (!Screen.m_96638_()) {
            this.setAnchorPos(this.caretPos);
        }
        this.onValueChange(this.value);
    }

    public void moveCaretWithAnchor(int pos) {
        this.moveCaret(pos);
        this.setAnchorPos(pos);
    }

    public void setCaretPosition(int pos) {
        this.caretPos = Mth.m_14045_((int)pos, (int)0, (int)this.value.length());
        this.scrollToFitCaret();
    }

    public void moveCaretToStart() {
        this.moveCaret(0);
    }

    public void moveCaretToEnd() {
        this.moveCaret(this.value.length());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.lastInteraction = System.currentTimeMillis();
        if (Screen.m_96634_((int)keyCode)) {
            this.moveCaretToEnd();
            this.setAnchorPos(0);
            return true;
        }
        KeyboardHandler kl = Minecraft.m_91087_().f_91068_;
        if (Screen.m_96632_((int)keyCode)) {
            kl.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable()) {
                this.insertText(kl.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            kl.m_90911_(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable()) {
                    this.deleteText(-1);
                }
                return true;
            }
            case 261: {
                if (this.isEditable()) {
                    this.deleteText(1);
                }
                return true;
            }
            case 262: {
                if (this.hasSelection() && !Screen.m_96638_()) {
                    this.moveCaretWithAnchor(Math.max(this.anchorPos, this.caretPos));
                } else if (Screen.m_96637_()) {
                    this.moveCaret(this.getWordPosFromCaret(1));
                } else {
                    this.moveCaretBy(1);
                }
                return true;
            }
            case 263: {
                if (this.hasSelection() && !Screen.m_96638_()) {
                    this.moveCaretWithAnchor(Math.min(this.anchorPos, this.caretPos));
                } else if (Screen.m_96637_()) {
                    this.moveCaret(this.getWordPosFromCaret(-1));
                } else {
                    this.moveCaretBy(-1);
                }
                return true;
            }
            case 268: {
                this.moveCaretToStart();
                return true;
            }
            case 269: {
                this.moveCaretToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            if (this.isEditable()) {
                int caret;
                String closingPair = null;
                if (this.formatter != null) {
                    String text;
                    caret = this.getCaret();
                    if (caret < (text = this.getValue()).length() && text.charAt(caret) == codePoint && this.formatter.shouldSkipClosingPair(codePoint, text, caret)) {
                        this.moveCaretWithAnchor(caret + 1);
                        return true;
                    }
                    closingPair = this.formatter.closingPair(codePoint, text, caret);
                }
                this.insertText(Character.toString(codePoint));
                if (closingPair != null && !closingPair.isEmpty()) {
                    caret = this.getCaret();
                    this.insertText(closingPair);
                    this.moveCaretWithAnchor(caret);
                }
            }
            return true;
        }
        return false;
    }

    public void m_93692_(boolean focused) {
        if (this.canLoseFocus || focused) {
            super.m_93692_(focused);
            if (focused) {
                this.lastInteraction = System.currentTimeMillis();
            }
        }
    }

    public boolean m_93696_() {
        return super.m_93696_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.draggingText = false;
        if (this.isVisible()) {
            boolean hovered = this.m_5953_(mouseX, mouseY);
            if (this.isCanLoseFocus()) {
                this.m_93692_(hovered);
            }
            if (this.m_93696_() && hovered && button == 0) {
                this.lastClickWordPos = -1;
                this.draggingText = true;
                double relX = mouseX - (double)this.m_252754_();
                if (this.isBordered()) {
                    relX -= 4.0;
                }
                int clickedPos = this.getClickedCaretPos(SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll), relX) + this.hScroll;
                this.lastInteraction = System.currentTimeMillis();
                if (this.lastInteraction - this.lastClick < 250L) {
                    int left = this.getWordPosFromPos(-1, clickedPos);
                    int right = this.getWordPosFromPos(1, clickedPos);
                    if (this.anchorPos == left && this.caretPos == right) {
                        this.moveCaretToEnd();
                        this.setAnchorPos(0);
                        this.draggingText = false;
                    } else {
                        this.moveCaret(right);
                        this.setAnchorPos(left);
                        this.lastClickWordPos = clickedPos;
                    }
                } else {
                    this.moveCaret(clickedPos);
                    this.setAnchorPos(this.caretPos);
                }
                this.lastClick = this.lastInteraction;
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isVisible() && this.m_93696_() && button == 0 && this.draggingText) {
            this.lastInteraction = System.currentTimeMillis();
            double relX = mouseX - (double)this.m_252754_();
            if (this.isBordered()) {
                relX -= 4.0;
            }
            int prevAnchor = this.anchorPos;
            int draggedPos = this.getClickedCaretPos(SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll), relX) + this.hScroll;
            if (this.lastClickWordPos != -1) {
                int left = this.getWordPosFromPos(-1, this.lastClickWordPos);
                int right = this.getWordPosFromPos(1, this.lastClickWordPos);
                if (draggedPos < left) {
                    this.moveCaret(this.getWordPosFromPos(-1, draggedPos));
                    this.setAnchorPos(right);
                } else if (draggedPos > right) {
                    this.moveCaret(this.getWordPosFromPos(1, draggedPos));
                    this.setAnchorPos(left);
                } else {
                    boolean r = draggedPos > (left + right) / 2;
                    this.moveCaret(r ? right : left);
                    this.setAnchorPos(r ? left : right);
                }
            } else {
                this.moveCaret(draggedPos);
                this.setAnchorPos(prevAnchor);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected int getClickedCaretPos(MutableComponent line, double relX) {
        int right;
        int lineLength = line.getString().length();
        int floor = this.font.m_92854_((FormattedText)line, (int)relX).getString().length();
        if (floor >= lineLength) {
            return lineLength;
        }
        int left = this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)line, 0, floor));
        return relX < (double)(left + (right = this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)line, 0, floor + 1)))) * 0.5 ? floor : floor + 1;
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            Component hint;
            int caretX;
            int textY;
            boolean bordered = this.isBordered();
            if (bordered) {
                int borderColor = this.m_198029_() ? 0xFF000000 | this.borderColor & 0xFFFFFF : 0xA0000000 | this.borderColor & 0xFFFFFF;
                gg.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, borderColor);
                gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
            }
            int color = this.isEditable() ? this.textColor : this.textColorUneditable;
            int relCaret = this.caretPos - this.hScroll;
            int relAnchor = this.anchorPos - this.hScroll;
            int innerWidth = this.getInnerWidth();
            MutableComponent displayedText = SimpleConfigTextUtil.subText((Component)this.getDisplayedText(), this.hScroll);
            String shown = this.font.m_92854_((FormattedText)displayedText, innerWidth).getString();
            int fitLength = shown.length();
            displayedText = SimpleConfigTextUtil.subText((Component)displayedText, 0, fitLength);
            boolean fitCaret = relCaret >= 0 && relCaret <= fitLength;
            boolean showCaret = this.m_93696_() && fitCaret && (System.currentTimeMillis() - this.lastInteraction) % 1000L < 500L;
            int textX = bordered ? this.m_252754_() + 4 : this.m_252754_();
            int n = textY = bordered ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int n2 = fitCaret ? textX + this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)displayedText, 0, relCaret)) - 1 : (caretX = relCaret > 0 ? textX + innerWidth - 1 : textX);
            if (!shown.isEmpty()) {
                gg.m_280430_(this.font, (Component)displayedText, textX, textY, color);
            }
            Component component = hint = this.hintProvider != null ? (Component)this.hintProvider.apply(this.value).orElse(null) : null;
            if (relCaret == shown.length() && hint != null) {
                gg.m_280430_(this.font, hint, caretX, textY, -8355712);
            }
            if (showCaret) {
                this.renderCaret(gg, caretX, textY - 2, 1, 12);
            }
            if (relAnchor != relCaret && this.m_93696_()) {
                if (relAnchor > fitLength) {
                    relAnchor = fitLength;
                }
                if (relAnchor < 0) {
                    relAnchor = 0;
                }
                int aX = textX + this.font.m_92852_((FormattedText)SimpleConfigTextUtil.subText((Component)displayedText, 0, relAnchor)) - 1;
                this.renderSelection(gg, caretX, textY - 3, aX, textY + 2 + 9);
            }
        }
    }

    protected void renderCaret(GuiGraphics gg, int x, int y, int w, int h) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bb = tessellator.m_85915_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bb.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_5752_();
        bb.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_5752_();
        bb.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_5752_();
        bb.m_252986_(m, (float)x, (float)y, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableColorLogicOp();
    }

    protected void renderSelection(GuiGraphics gg, int sX, int sY, int eX, int eY) {
        int swap;
        if (sX < eX) {
            swap = sX;
            sX = eX;
            eX = swap;
        }
        if (sY < eY) {
            swap = sY;
            sY = eY;
            eY = swap;
        }
        if (eX > this.m_252754_() + this.f_93618_) {
            eX = this.m_252754_() + this.f_93618_;
        }
        if (sX > this.m_252754_() + this.f_93618_) {
            sX = this.m_252754_() + this.f_93618_;
        }
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.XOR);
        gg.m_280509_(sX, sY, eX, eY, -16777088);
        RenderSystem.disableColorLogicOp();
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCaret() {
        return this.caretPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUneditable(int color) {
        this.textColorUneditable = color;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.f_93618_ - 8 : this.f_93618_;
    }

    public int getMaxHScroll() {
        String text = this.value;
        String reversed = new StringBuilder(text).reverse().toString();
        return text.length() - this.font.m_92834_(reversed, this.getInnerWidth()).length();
    }

    public void scrollToFit(int pos) {
        int maxHScroll = this.getMaxHScroll();
        if (this.font != null) {
            if (this.hScroll > maxHScroll) {
                this.hScroll = maxHScroll;
            }
            int w = this.getInnerWidth();
            String shown = this.font.m_92834_(this.value.substring(this.hScroll), w);
            int lastShown = shown.length() + this.hScroll;
            if (pos > lastShown) {
                this.hScroll += pos - lastShown + 1;
            } else if (pos <= this.hScroll) {
                this.hScroll = pos - 1;
            }
            this.hScroll = Mth.m_14045_((int)this.hScroll, (int)0, (int)maxHScroll);
        }
    }

    public void scrollToFitCaret() {
        this.scrollToFit(this.caretPos);
    }

    public void setAnchorPos(int pos) {
        int len = this.value.length();
        this.anchorPos = Mth.m_14045_((int)pos, (int)0, (int)len);
    }

    public boolean isCanLoseFocus() {
        return this.canLoseFocus;
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    public void setPlainHint(@Nullable String hint) {
        this.setHint((Component)(hint != null ? Component.m_237113_((String)hint) : null));
    }

    public void setPlainHint(@Nullable Function<String, Optional<String>> hintProvider) {
        this.setHint(hintProvider != null ? s -> ((Optional)hintProvider.apply((String)s)).map(Component::m_237113_) : null);
    }

    public void setHint(@Nullable Component hint) {
        this.setHint(hint != null ? s -> Optional.of(hint) : null);
    }

    public void setHint(@Nullable Function<String, Optional<Component>> hintProvider) {
        this.hintProvider = hintProvider;
    }

    public void setEmptyHint(String hint) {
        this.setEmptyHint((Component)Component.m_237113_((String)hint));
    }

    public void setEmptyHint(Component hint) {
        this.setHint((String s) -> s.isEmpty() ? Optional.of(hint) : Optional.empty());
    }

    public int getScreenX(int pos) {
        return pos > this.value.length() ? this.m_252754_() : this.m_252754_() + this.font.m_92895_(this.value.substring(0, pos));
    }

    protected void m_168797_(NarrationElementOutput out) {
        out.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.getValue()}));
    }
}

