/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class SelectorButton<T>
extends MultiFunctionIconButton {
    private Consumer<T> action;
    private List<T> values;
    private int selectedIndex = 0;
    private Function<T, Component> formatter;
    @Nullable
    private Function<T, Icon> iconProvider;

    public static <T extends Enum<?>> SelectorButton<T> of(Class<T> enumClass, Function<T, Component> formatter, Consumer<T> action) {
        return SelectorButton.of(enumClass, formatter, null, action);
    }

    public static <T extends Enum<?>> SelectorButton<T> of(Class<T> enumClass, Function<T, Component> formatter, @Nullable Function<T, Icon> iconProvider, Consumer<T> action) {
        return SelectorButton.of(Arrays.asList((Enum[])enumClass.getEnumConstants()), formatter, iconProvider, action);
    }

    public static <T> SelectorButton<T> of(Collection<T> values, Function<T, Component> formatter, Consumer<T> action) {
        return SelectorButton.of(values, formatter, null, action);
    }

    public static <T> SelectorButton<T> of(Collection<T> values, Function<T, Component> formatter, @Nullable Function<T, Icon> iconProvider, Consumer<T> action) {
        return new SelectorButton<T>(new ArrayList<T>(values), formatter, iconProvider, action);
    }

    public SelectorButton(List<T> values, Function<T, Component> formatter, @Nullable Function<T, Icon> iconProvider, Consumer<T> action) {
        super(0, 0, 80, 80, Icon.EMPTY, MultiFunctionImageButton.ButtonAction.of(() -> {}));
        this.action = action;
        if (values.isEmpty()) {
            throw new IllegalArgumentException("List of selectable values cannot be empty");
        }
        this.values = values;
        this.formatter = formatter;
        this.iconProvider = iconProvider;
        this.actions.clear();
        this.on(MultiFunctionImageButton.Modifier.NONE, MultiFunctionImageButton.ButtonAction.of(this::selectNext, this::selectPrev));
        this.on(MultiFunctionImageButton.Modifier.SHIFT, MultiFunctionImageButton.ButtonAction.of(this::selectPrev, this::selectNext));
    }

    public void selectPrev() {
        this.selectNext(false);
    }

    public void selectNext() {
        this.selectNext(true);
    }

    public void selectNext(boolean forwards) {
        int size = this.values.size();
        this.selectedIndex = (this.selectedIndex + size + (forwards ? 1 : -1)) % size;
        this.action.accept(this.getValue());
    }

    @Override
    public Icon getDefaultIcon() {
        return this.iconProvider != null ? this.iconProvider.apply(this.getValue()) : Icon.EMPTY;
    }

    @Override
    public Component getTitle() {
        return this.formatter.apply(this.getValue());
    }

    public T getValue() {
        return this.values.get(this.selectedIndex);
    }

    public void setValue(T value) {
        int i = this.values.indexOf(value);
        if (i < 0) {
            throw new IllegalArgumentException("Set value is not selectable");
        }
        this.selectedIndex = i;
        this.action.accept(this.getValue());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int idx) {
        if (idx < 0 || idx >= this.values.size()) {
            throw new IndexOutOfBoundsException("Selected index is out of bounds");
        }
        this.selectedIndex = idx;
        this.action.accept(this.getValue());
    }

    public List<T> getSelectableValues() {
        return this.values;
    }

    public void setSelectableValues(List<T> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("List of selectable values cannot be empty");
        }
        this.values = values;
        if (this.selectedIndex >= values.size()) {
            this.selectedIndex = 0;
        }
    }

    public Consumer<T> getAction() {
        return this.action;
    }

    public void setAction(Consumer<T> action) {
        this.action = action;
    }

    public Function<T, Component> getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Function<T, Component> formatter) {
        this.formatter = formatter;
    }

    @Nullable
    public Function<T, Icon> getIconProvider() {
        return this.iconProvider;
    }

    public void setIconProvider(@Nullable Function<T, Icon> iconProvider) {
        this.iconProvider = iconProvider;
    }

    public static class BooleanButton
    extends SelectorButton<Boolean> {
        private static final List<Boolean> VALUES = Arrays.asList(false, true);

        public static BooleanButton of(BooleanConsumer action) {
            return new BooleanButton(b -> Component.m_237115_((String)("simpleconfig.format.bool.yes_no." + b.toString())), null, action);
        }

        public static BooleanButton of(Icon trueIcon, Icon falseIcon, BooleanConsumer action) {
            return new BooleanButton(b -> Component.m_237115_((String)("simpleconfig.format.bool.yes_no." + b.toString())), b -> b != false ? trueIcon : falseIcon, action);
        }

        public static BooleanButton of(ChatFormatting trueStyle, ChatFormatting falseStyle, Icon trueIcon, Icon falseIcon, BooleanConsumer action) {
            return BooleanButton.of(Style.f_131099_.m_131157_(trueStyle), Style.f_131099_.m_131157_(falseStyle), trueIcon, falseIcon, action);
        }

        public static BooleanButton of(Style trueStyle, Style falseStyle, Icon trueIcon, Icon falseIcon, BooleanConsumer action) {
            return BooleanButton.of((Boolean b) -> Component.m_237113_((String)SimpleConfigTextUtil.stripFormattingCodes(I18n.m_118938_((String)("simpleconfig.format.bool.yes_no." + b.toString()), (Object[])new Object[0]))).m_130948_(b != false ? trueStyle : falseStyle), trueIcon, falseIcon, action);
        }

        public static BooleanButton of(Function<Boolean, Component> formatter, Icon trueIcon, Icon falseIcon, BooleanConsumer action) {
            return new BooleanButton(formatter, b -> b != false ? trueIcon : falseIcon, action);
        }

        public BooleanButton(Function<Boolean, Component> formatter, @Nullable Function<Boolean, Icon> iconProvider, BooleanConsumer action) {
            super(VALUES, formatter, iconProvider, b -> action.accept(b.booleanValue()));
        }

        public boolean getToggle() {
            return (Boolean)this.getValue();
        }

        public void setToggle(boolean toggle) {
            this.setValue(toggle);
        }
    }
}

