/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.google.common.collect.Lists;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.ToggleImageButton;
import endorh.simpleconfig.ui.gui.widget.combobox.ComboBoxWidget;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.PatternTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.StringTypeWrapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchBarWidget
extends AbstractContainerEventHandlerEx
implements IOverlayCapableContainer.IOverlayRenderer,
NarratableEntry {
    protected static Component[] CASE_SENSITIVE_TOOLTIP = new Component[]{Component.m_237115_((String)"simpleconfig.ui.search.case_sensitive"), Component.m_237115_((String)"key.modifier.alt").m_130946_(" + C").m_130940_(ChatFormatting.GRAY)};
    protected static Component[] REGEX_TOOLTIP = new Component[]{Component.m_237115_((String)"simpleconfig.ui.search.regex"), Component.m_237115_((String)"key.modifier.alt").m_130946_(" + R").m_130940_(ChatFormatting.GRAY)};
    protected static Component[] FILTER_TOOLTIP = new Component[]{Component.m_237115_((String)"simpleconfig.ui.search.filter"), Component.m_237115_((String)"key.modifier.alt").m_130946_(" + F").m_130940_(ChatFormatting.GRAY)};
    public int x;
    public int y;
    public int w;
    public int h;
    protected IDialogCapableScreen screen;
    protected ISearchHandler handler;
    protected ComboBoxWidget<String> comboBox;
    protected ComboBoxWidget<Pattern> regexComboBox;
    protected MultiFunctionImageButton up;
    protected MultiFunctionImageButton down;
    protected MultiFunctionImageButton close;
    protected MultiFunctionImageButton open;
    protected List<ToggleImageButton> optionButtons;
    protected ToggleImageButton regexButton;
    protected ToggleImageButton caseButton;
    protected ToggleImageButton filterButton;
    protected List<GuiEventListener> expandedListeners;
    protected List<GuiEventListener> regexListeners;
    protected List<GuiEventListener> closedListeners;
    protected GuiEventListener focused;
    protected boolean overMatch = false;
    protected int currentMatch = 0;
    protected int totalMatches = 0;
    protected boolean caseSensitive = ClientConfig.advanced.search.search_case_sensitive;
    protected boolean regex = ClientConfig.advanced.search.search_regex;
    protected boolean filter = ClientConfig.advanced.search.search_filter;
    protected boolean closeOnClickOutside = false;
    protected boolean expanded = false;
    protected Rectangle overlay = new Rectangle();
    private static final Pattern NO_MATCH = Pattern.compile("$^");

    public SearchBarWidget(ISearchHandler handler, int x, int y, int w, IDialogCapableScreen screen) {
        this(handler, x, y, w, 24, screen);
    }

    public SearchBarWidget(ISearchHandler handler, int x, int y, int w, int h, IDialogCapableScreen screen) {
        this.handler = handler;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.screen = screen;
        this.comboBox = new ComboBoxWidget<String>(new StringTypeWrapper(), () -> screen, x + 36, y + 1, w - 108, 18);
        this.regexComboBox = new ComboBoxWidget<Pattern>(new PatternTypeWrapper(), () -> screen, x + 36, y + 1, w - 108, 18);
        this.comboBox.setMaxLength(99999);
        this.regexComboBox.setMaxLength(99999);
        this.comboBox.setValueListener(s -> this.makeQuery());
        this.regexComboBox.setValueListener(s -> this.makeQuery());
        this.comboBox.setAutoDropDown(false);
        this.regexComboBox.setAutoDropDown(false);
        this.comboBox.setSuggestions(ClientConfig.advanced.search.search_history);
        this.regexComboBox.setSuggestions(ClientConfig.advanced.search.regex_search_history);
        this.up = new MultiFunctionImageButton(x + w - 68, y, 18, 18, SimpleConfigIcons.Buttons.UP, MultiFunctionImageButton.ButtonAction.of(b -> this.next(b == 1))).on(MultiFunctionImageButton.Modifier.SHIFT, MultiFunctionImageButton.ButtonAction.of(b -> this.next(b != 1)).icon(SimpleConfigIcons.Buttons.DOWN));
        this.down = new MultiFunctionImageButton(x + w - 44, y, 18, 18, SimpleConfigIcons.Buttons.DOWN, MultiFunctionImageButton.ButtonAction.of(b -> this.next(b != 1))).on(MultiFunctionImageButton.Modifier.SHIFT, MultiFunctionImageButton.ButtonAction.of(b -> this.next(b == 1)).icon(SimpleConfigIcons.Buttons.UP));
        this.close = new MultiFunctionImageButton(x + w - 20, y, 20, 20, SimpleConfigIcons.Buttons.SEARCH_CLOSE, MultiFunctionImageButton.ButtonAction.of(this::close));
        this.open = new MultiFunctionImageButton(x + 2, y, 20, 20, SimpleConfigIcons.Buttons.SEARCH, MultiFunctionImageButton.ButtonAction.of(this::open));
        this.caseButton = ToggleImageButton.of(this.caseSensitive, 18, SimpleConfigIcons.SearchBar.SEARCH_CASE_SENSITIVE, b -> this.updateModifiers());
        this.regexButton = ToggleImageButton.of(this.regex, 18, SimpleConfigIcons.SearchBar.SEARCH_REGEX, b -> this.updateModifiers());
        this.filterButton = ToggleImageButton.of(this.filter, 18, SimpleConfigIcons.SearchBar.SEARCH_FILTER, b -> this.updateModifiers());
        this.optionButtons = Lists.newArrayList((Object[])new ToggleImageButton[]{this.caseButton, this.regexButton, this.filterButton});
        this.expandedListeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.caseButton, this.regexButton, this.filterButton, this.comboBox, this.up, this.down, this.close});
        this.regexListeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.caseButton, this.regexButton, this.filterButton, this.regexComboBox, this.up, this.down, this.close});
        this.closedListeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.open});
    }

    protected void addOptionButton(ToggleImageButton button) {
        this.addOptionButton(this.optionButtons.size(), button);
    }

    protected void addOptionButton(int pos, ToggleImageButton button) {
        this.optionButtons.add(pos, button);
        this.expandedListeners.add(pos, (GuiEventListener)button);
        this.regexListeners.add(pos, (GuiEventListener)button);
    }

    protected void removeButton(ToggleImageButton button) {
        this.optionButtons.remove((Object)button);
        this.expandedListeners.remove((Object)button);
        this.regexListeners.remove((Object)button);
    }

    protected void next(boolean forward) {
        int nextMatch = this.currentMatch + (forward ? 1 : -1);
        if (nextMatch < 0 || nextMatch >= this.totalMatches) {
            if (this.overMatch) {
                this.overMatch = false;
                nextMatch = forward ? 0 : this.totalMatches - 1;
            } else {
                this.overMatch = true;
            }
        } else {
            this.overMatch = false;
        }
        if (!this.overMatch) {
            this.currentMatch = nextMatch;
            this.handler.selectMatch(this.currentMatch);
        }
        this.m_7522_((GuiEventListener)this.getComboBox());
        this.commitHistory();
    }

    protected void commitHistory() {
        if (this.regex) {
            Pattern value = this.regexComboBox.getValue();
            if (value != null && !value.pattern().isEmpty()) {
                LinkedList<Pattern> sh = new LinkedList<Pattern>(ClientConfig.advanced.search.regex_search_history);
                if (sh.indexOf(value) == 0) {
                    return;
                }
                sh.remove(value);
                sh.add(0, value);
                int size = ClientConfig.advanced.search.regex_search_history_size;
                Pair newHistory = Pair.of((Object)size, new ArrayList(sh.subList(0, Math.min(sh.size(), size))));
                ConfigEntryHolder c = SimpleConfigMod.CLIENT_CONFIG.getChild("advanced.search");
                String REGEX_SEARCH_HISTORY = "regex_search_history";
                if (c.hasGUI()) {
                    Pair newGUIHistory = Pair.of((Object)((Integer)newHistory.getLeft()), ((List)newHistory.getRight()).stream().map(Pattern::pattern).collect(Collectors.toList()));
                    c.setGUI(REGEX_SEARCH_HISTORY, newGUIHistory);
                    ClientConfig.advanced.search.regex_search_history = (List)newHistory.getValue();
                } else {
                    c.set(REGEX_SEARCH_HISTORY, newHistory);
                }
                this.regexComboBox.setSuggestions((List)newHistory.getValue());
            }
        } else {
            String value = this.comboBox.getValue();
            if (value != null && !value.isEmpty()) {
                LinkedList<String> sh = new LinkedList<String>(ClientConfig.advanced.search.search_history);
                if (sh.indexOf(value) == 0) {
                    return;
                }
                sh.remove(value);
                sh.add(0, value);
                int size = ClientConfig.advanced.search.search_history_size;
                Pair newHistory = Pair.of((Object)size, new ArrayList(sh.subList(0, Math.min(sh.size(), size))));
                String SEARCH_HISTORY = "search_history";
                ConfigEntryHolder c = SimpleConfigMod.CLIENT_CONFIG.getChild("advanced.search");
                if (c.hasGUI()) {
                    c.setGUI(SEARCH_HISTORY, newHistory);
                    ClientConfig.advanced.search.search_history = (List)newHistory.getValue();
                } else {
                    c.set(SEARCH_HISTORY, newHistory);
                }
                this.comboBox.setSuggestions((List)newHistory.getValue());
            }
        }
    }

    protected void updateModifiers() {
        if (this.regexButton.getValue() != this.regex) {
            if (this.regex) {
                this.comboBox.setText(this.regexComboBox.getText());
            } else {
                this.regexComboBox.setText(this.comboBox.getText());
            }
            this.comboBox.setDropDownShown(false);
            this.regexComboBox.setDropDownShown(false);
        }
        this.caseSensitive = this.caseButton.getValue();
        this.regex = this.regexButton.getValue();
        this.filter = this.filterButton.getValue();
        ConfigEntryHolder g = SimpleConfigMod.CLIENT_CONFIG.getChild("advanced.search");
        String SEARCH_FILTER = "search_filter";
        String SEARCH_CASE_SENSITIVE = "search_case_sensitive";
        String SEARCH_REGEX = "search_regex";
        if (g.hasGUI()) {
            g.setGUI(SEARCH_FILTER, this.filter);
            g.setGUI(SEARCH_CASE_SENSITIVE, this.caseSensitive);
            g.setGUI(SEARCH_REGEX, this.regex);
        } else {
            g.set(SEARCH_FILTER, this.filter);
            g.set(SEARCH_CASE_SENSITIVE, this.caseSensitive);
            g.set(SEARCH_REGEX, this.regex);
        }
        this.makeQuery();
        this.m_7522_((GuiEventListener)this.getComboBox());
        if (!this.getComboBox().m_93696_()) {
            this.getComboBox().m_93692_(true);
        }
        if (this.getOtherComboBox().m_93696_()) {
            this.getOtherComboBox().m_93692_(true);
        }
    }

    protected ComboBoxWidget<?> getComboBox() {
        return this.regex ? this.regexComboBox : this.comboBox;
    }

    protected ComboBoxWidget<?> getOtherComboBox() {
        return this.regex ? this.comboBox : this.regexComboBox;
    }

    @NotNull
    protected Pattern getQuery() {
        if (this.regex) {
            Pattern value = this.regexComboBox.getValue();
            return value != null ? (this.caseSensitive ? value : Pattern.compile(value.pattern(), 2)) : NO_MATCH;
        }
        String value = this.comboBox.getValue();
        return value != null ? Pattern.compile(Pattern.quote(value), this.caseSensitive ? 0 : 2) : NO_MATCH;
    }

    protected void makeQuery() {
        Pair<Integer, Integer> p = this.handler.query(this.getQuery());
        if (p != null) {
            this.totalMatches = (Integer)p.getRight();
            this.currentMatch = Math.max(0, (Integer)p.getLeft());
        }
    }

    public void close() {
        this.handler.dismissQuery();
        this.comboBox.setDropDownShown(false);
        this.regexComboBox.setDropDownShown(false);
        this.expanded = false;
    }

    public void open() {
        this.expanded = true;
        ComboBoxWidget<?> comboBox = this.getComboBox();
        this.m_7522_((GuiEventListener)comboBox);
        if (!comboBox.m_93696_()) {
            comboBox.m_93692_(true);
        }
        comboBox.selectAll();
        this.handler.selectMatch(this.currentMatch);
        this.screen.addOverlay(this.overlay, this, 50);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.w) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.h);
    }

    public Optional<Component[]> getTooltip(double mouseX, double mouseY) {
        if (this.isExpanded()) {
            if (this.caseButton.m_5953_(mouseX, mouseY)) {
                return Optional.of(CASE_SENSITIVE_TOOLTIP);
            }
            if (this.regexButton.m_5953_(mouseX, mouseY)) {
                return Optional.of(REGEX_TOOLTIP);
            }
            if (this.filterButton.m_5953_(mouseX, mouseY)) {
                return Optional.of(FILTER_TOOLTIP);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
        this.m_6375_(mouseX, mouseY, button);
        return true;
    }

    @Override
    public void overlayMouseClickedOutside(Rectangle area, double mouseX, double mouseY, int button) {
        if (this.closeOnClickOutside && this.isExpanded() && !this.isFilter() && !this.m_5953_(mouseX, mouseY)) {
            this.close();
        }
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        if (!this.expanded) {
            return false;
        }
        this.drawBackground(gg, mouseX, mouseY, delta);
        ComboBoxWidget<?> comboBox = this.getComboBox();
        if (this.m_93696_()) {
            this.m_7522_((GuiEventListener)comboBox);
        }
        if (this.m_93696_() && !comboBox.m_93696_() && !this.isFilter()) {
            comboBox.m_93692_(true);
        }
        this.positionExpanded(gg, mouseX, mouseY, delta);
        this.renderExpanded(gg, mouseX, mouseY, delta);
        Optional<Component[]> tt = this.getTooltip(mouseX, mouseY);
        tt.ifPresent(t -> this.screen.addTooltip(Tooltip.of(Point.of(mouseX, mouseY), t)));
        return true;
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        ComboBoxWidget<?> comboBox = this.getComboBox();
        this.overlay.setBounds(this.x, this.y, this.w, comboBox.isDropDownShown() ? this.h + comboBox.getDropDownHeight() : this.h);
        if (!this.expanded) {
            this.positionNotExpanded(gg, mouseX, mouseY, delta);
            this.renderNotExpanded(gg, mouseX, mouseY, delta);
        }
    }

    protected void positionExpanded(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int textY = this.y + 8;
        Font font = Minecraft.m_91087_().f_91062_;
        String text = String.format("%s / %s", this.totalMatches > 0 ? this.currentMatch + 1 : 0, this.totalMatches);
        int textW = font.m_92895_(text);
        int textX = this.x + this.w - 42 - textW;
        this.up.m_252865_(this.x + this.w - 38);
        this.up.m_253211_(this.y + 3);
        this.down.m_252865_(this.x + this.w - 20);
        this.down.m_253211_(this.y + 3);
        this.close.m_252865_(this.x + 2);
        this.close.m_253211_(this.y + 2);
        int bx = this.x + 24;
        for (ToggleImageButton b : this.optionButtons) {
            b.m_252865_(bx);
            bx += b.m_5711_() + 2;
            b.m_253211_(this.y + 12 - b.m_93694_() / 2);
        }
        int comboWidth = this.w - bx - 42 - (this.filter ? 0 : Math.max(42, textW));
        this.comboBox.m_93674_(comboWidth);
        this.regexComboBox.m_93674_(comboWidth);
        this.comboBox.m_252865_(bx + 2);
        this.comboBox.m_253211_(this.y + 3);
        this.regexComboBox.m_252865_(bx + 2);
        this.regexComboBox.m_253211_(this.y + 3);
        if (!this.filter) {
            gg.m_280488_(font, text, textX, textY, this.overMatch ? -190 : -2039584);
        }
    }

    protected void positionNotExpanded(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.open.m_252865_(this.x + 2);
        this.open.m_253211_(this.y + 2);
    }

    protected void renderExpanded(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.regex) {
            this.regexComboBox.m_88315_(gg, mouseX, mouseY, delta);
        } else {
            this.comboBox.m_88315_(gg, mouseX, mouseY, delta);
        }
        for (ToggleImageButton b : this.optionButtons) {
            b.m_88315_(gg, mouseX, mouseY, delta);
        }
        this.up.m_88315_(gg, mouseX, mouseY, delta);
        this.down.m_88315_(gg, mouseX, mouseY, delta);
        this.close.m_88315_(gg, mouseX, mouseY, delta);
    }

    protected void renderNotExpanded(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.open.m_88315_(gg, mouseX, mouseY, delta);
    }

    protected void drawBackground(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        gg.m_280509_(this.x, this.y, this.x + this.w, this.y + this.h, -13355980);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (Screen.m_96639_()) {
            switch (Character.toLowerCase(codePoint)) {
                case 'c': {
                    this.caseButton.setValue(!this.caseButton.getValue());
                    return true;
                }
                case 'r': {
                    this.regexButton.setValue(!this.regexButton.getValue());
                    return true;
                }
                case 'f': {
                    this.filterButton.setValue(!this.filterButton.getValue());
                    return true;
                }
            }
        }
        return super.m_5534_(codePoint, modifiers);
    }

    @Override
    public boolean overlayEscape() {
        ComboBoxWidget<?> comboBox = this.getComboBox();
        if (comboBox.isDropDownShown()) {
            comboBox.setDropDownShown(false);
            return true;
        }
        if (this.isExpanded()) {
            this.close();
            this.handler.focusResults();
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        ComboBoxWidget<?> comboBox = this.getComboBox();
        if (comboBox.isDropDownShown() && comboBox.getShownSuggestions().size() == 0) {
            comboBox.setDropDownShown(false);
        }
        if (!comboBox.isDropDownShown()) {
            switch (keyCode) {
                case 256: {
                    if (!this.expanded) break;
                    this.close();
                    this.handler.focusResults();
                    return true;
                }
                case 257: {
                    if (this.isFilter() || Screen.m_96637_()) {
                        this.getComboBox().m_93692_(false);
                        this.handler.focusResults();
                    } else {
                        this.next(!Screen.m_96638_());
                    }
                    return true;
                }
                case 264: {
                    this.next(true);
                    return true;
                }
                case 265: {
                    this.next(false);
                    return true;
                }
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public boolean isEmpty() {
        return this.getComboBox().getText().isEmpty();
    }

    public void m_93692_(boolean focus) {
        if (focus) {
            this.m_7522_((GuiEventListener)this.getComboBox());
        } else {
            this.m_7522_(null);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.isExpanded() ? (this.regex ? this.regexListeners : this.expandedListeners) : this.closedListeners;
    }

    @Override
    @Nullable
    public ComponentPath m_264435_() {
        return super.m_264435_();
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
        if (!this.isExpanded()) {
            return super.m_264064_(e);
        }
        return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)this.getComboBox().m_264064_(e));
    }

    public void refresh() {
        if (this.isExpanded()) {
            this.makeQuery();
        } else {
            this.handler.dismissQuery();
        }
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput out) {
    }

    public static interface ISearchHandler {
        public Pair<Integer, Integer> query(Pattern var1);

        public void dismissQuery();

        public void selectMatch(int var1);

        public void focusResults();
    }
}

