/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.api.ScrollingHandler;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollingContainerWidget
extends ScrollingHandler
implements ContainerEventHandlerEx,
IPositionableRenderable.IRectanglePositionableRenderable {
    public final Rectangle area;
    protected final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    protected GuiEventListener listener;
    protected Pair<Integer, GuiEventListener> dragged;
    protected boolean dragging;

    public ScrollingContainerWidget(int x, int y, int w, int h) {
        this(new Rectangle(x, y, w, h));
    }

    public ScrollingContainerWidget(Rectangle area) {
        this.area = area;
        this.init();
    }

    public void init() {
    }

    @Override
    public Rectangle getBounds() {
        return this.area;
    }

    @Override
    public Rectangle getArea() {
        return this.getBounds();
    }

    public void updateScroll() {
        double prev = this.scrollAmount;
        int maxScroll = this.getMaxScroll();
        this.updatePosition(0.0f);
        this.scrollAmount = Mth.m_14008_((double)this.scrollAmount, (double)0.0, (double)maxScroll);
    }

    public void scrollBy(double amount, boolean animated) {
        int maxScroll = this.getMaxScroll();
        if (amount < 0.0 && this.scrollTarget > (double)maxScroll) {
            this.scrollTo((double)maxScroll + amount, animated);
        }
        if (amount > 0.0 && this.scrollTarget < 0.0) {
            this.scrollTo(amount, animated);
        } else {
            this.scrollTo(this.scrollTarget + amount, animated);
        }
    }

    public void position() {
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.updateScroll();
        this.position();
        ScissorsHandler.INSTANCE.pushScissor(this.area);
        this.renderInner(gg, this.area.x, (int)Math.round((double)this.area.y - this.scrollAmount), this.area.width - 8, this.area.height, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.popScissor();
        this.renderScrollBar();
    }

    public abstract void renderInner(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    public abstract int getInnerHeight();

    @Override
    public final int getMaxScrollHeight() {
        return this.getInnerHeight();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (ContainerEventHandlerEx.super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        this.scrollBy(delta * -24.0, Math.abs(delta) >= 1.0);
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (super.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.listener;
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        this.listener = listener;
    }

    public void m_93692_(boolean focused) {
        GuiEventListener listener;
        ContainerEventHandlerEx.super.m_93692_(focused);
        if (focused && (listener = this.m_7222_()) instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)listener;
            int target = widget.m_252907_() + widget.m_93694_() / 2 - this.area.y;
            this.scrollTo(target, true);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }
}

