/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.GuiEventListenerEx;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ResetButton
extends MultiFunctionImageButton
implements GuiEventListenerEx,
IOverlayCapableContainer.IOverlayRenderer {
    protected static List<Component> resetTooltip = Arrays.asList(Component.m_237115_((String)"simpleconfig.ui.reset"), Component.m_237115_((String)"simpleconfig.ui.restore.alt"), Component.m_237115_((String)"simpleconfig.ui.hotkey.ctrl"));
    protected static List<Component> resetTooltipGroup = Arrays.asList(Component.m_237115_((String)"simpleconfig.ui.reset.group"), Component.m_237115_((String)"simpleconfig.ui.restore.alt"), Component.m_237115_((String)"simpleconfig.ui.hotkey.ctrl"));
    protected static List<Component> restoreTooltip = Arrays.asList(Component.m_237115_((String)"simpleconfig.ui.restore"));
    protected static List<Component> restoreTooltipGroup = Arrays.asList(Component.m_237115_((String)"simpleconfig.ui.restore.group"));
    protected AbstractConfigField<?> entry;
    protected boolean shift = false;
    protected boolean alt = false;
    protected boolean isGroup = false;
    protected boolean isActive = false;
    protected boolean confirming = false;
    protected boolean dragging = false;
    protected int dragOffset = 0;
    protected double dragAnchor = 0.0;
    protected Rectangle overlay = new Rectangle();

    public ResetButton(AbstractConfigField<?> entry) {
        super(0, 0, 20, 20, SimpleConfigIcons.Buttons.RESET, MultiFunctionImageButton.ButtonAction.of(b -> {}), GameNarrator.f_93310_);
        this.entry = entry;
        this.defaultActivePredicate = this::shouldBeActive;
    }

    protected boolean shouldSafeGuard() {
        return this.isRestore() ? (this.isGroup() ? ClientConfig.confirm.group_restore : ClientConfig.confirm.restore) : (this.isGroup() ? ClientConfig.confirm.group_reset : ClientConfig.confirm.reset);
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        if (this.dragging) {
            if (Minecraft.m_91087_().f_91062_.m_92718_()) {
                this.overlay.setBounds(x - 4, y - 4, 2 * this.f_93618_ + 48, this.f_93619_ + 8);
            } else {
                this.overlay.setBounds(x - this.f_93618_ - 44, y - 4, 2 * this.f_93618_ + 48, this.f_93619_ + 8);
            }
        } else if (this.confirming) {
            this.overlay.setBounds(x - 4, y - 4, this.f_93618_ + 8, this.f_93619_ + 8);
        } else {
            this.overlay.setBounds(x, y, this.f_93618_, this.f_93619_);
        }
        this.overlay.setBounds(ScissorsHandler.INSTANCE.getScissorsAreas().stream().reduce(this.overlay, Rectangle::intersection));
        if (this.overlay.isEmpty()) {
            this.overlay.setBounds(0, 0, 0, 0);
        }
        super.m_88315_(gg, mouseX, mouseY, delta);
        if (this.m_93696_() && !this.f_93623_ && this.entry != null) {
            this.entry.m_93692_(false);
            this.m_93692_(false);
        }
    }

    protected boolean isRestore() {
        return this.alt;
    }

    protected boolean isGroup() {
        return this.isGroup;
    }

    protected boolean computeIsGroup() {
        if (!this.entry.isGroup()) {
            return false;
        }
        AbstractConfigField<?> abstractConfigField = this.entry;
        if (!(abstractConfigField instanceof IEntryHolder)) {
            return true;
        }
        IEntryHolder entryHolder = (IEntryHolder)((Object)abstractConfigField);
        boolean restore = this.isRestore();
        return this.shift || (restore ? entryHolder.getSingleRestorableEntry() : entryHolder.getSingleResettableEntry()) == null || (restore ? this.entry.canRestoreGroup() : this.entry.canResetGroup()) && !(!restore ? this.entry.isResettable() : this.entry.isRestorable());
    }

    protected Icon getIcon() {
        return this.isRestore() ? (this.isGroup() ? SimpleConfigIcons.Buttons.RESTORE_GROUP : SimpleConfigIcons.Buttons.RESTORE) : (this.isGroup() ? SimpleConfigIcons.Buttons.RESET_GROUP : SimpleConfigIcons.Buttons.RESET);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_) {
            if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
                return false;
            }
            return this.activate(Screen.m_96637_() ? 2 : (Screen.m_96638_() ? 1 : 0));
        }
        return false;
    }

    public boolean activate() {
        return this.activate(0);
    }

    public boolean activate(int button) {
        if (!this.shouldSafeGuard() || this.confirming) {
            this.confirming = false;
            if (this.onPress((Button)this, button)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            if (button != 0 && this.onPress((Button)this, 0)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return false;
        }
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        this.confirming = true;
        this.dragging = false;
        this.getScreen().addOverlay(this.overlay, this, 20);
        return true;
    }

    protected boolean shouldBeActive() {
        return this.isActive;
    }

    protected boolean computeActive() {
        if (this.entry == null) {
            return false;
        }
        if (this.entry.isSubEntry()) {
            return false;
        }
        return this.isGroup() ? (this.isRestore() ? this.entry.canRestoreGroup() : this.entry.canResetGroup()) : (this.isRestore() ? this.entry.isRestorable() : this.entry.isResettable());
    }

    public void tick() {
        if (!(this.confirming || this.dragging || this.getScreen().hasDialogs())) {
            this.shift = Screen.m_96638_();
            this.alt = Screen.m_96639_();
            this.defaultIcon = this.getIcon();
        }
        this.isGroup = this.computeIsGroup();
        this.isActive = this.computeActive();
    }

    protected boolean reset(AbstractConfigField<?> entry, int button) {
        this.tick();
        if (button == 0) {
            IEntryHolder entryHolder;
            AbstractConfigField<?> singleEntry;
            if (entry instanceof IEntryHolder && (singleEntry = (entryHolder = (IEntryHolder)((Object)entry)).getSingleResettableEntry()) != null && this.isGroup()) {
                if (this.isRestore() && entry.isRestorable()) {
                    entryHolder.restoreSingleEntry(singleEntry);
                    return true;
                }
                if (!this.isRestore() && entry.isResettable()) {
                    entryHolder.resetSingleEntry(singleEntry);
                    return true;
                }
                return false;
            }
            if (this.isRestore() && this.isGroup() ? entry.canRestoreGroup() : entry.isRestorable()) {
                entry.restoreValue();
                return true;
            }
            if (!this.isRestore() && this.isGroup() ? entry.canResetGroup() : entry.isResettable()) {
                entry.resetValue();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean onPress(Button widget, int button) {
        if (this.entry != null) {
            boolean result = this.reset(this.entry, button);
            if (result) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.tick();
        if (this.m_5953_(mouseX, mouseY)) {
            if (!this.shouldSafeGuard()) {
                return this.onPress((Button)this, button);
            }
            if (this.dragging) {
                return true;
            }
            if (button == 0) {
                this.dragging = true;
                this.confirming = false;
                this.dragOffset = 0;
                this.dragAnchor = mouseX - (double)this.m_252754_();
                this.getScreen().addOverlay(this.overlay, this, 20);
            }
            return true;
        }
        return false;
    }

    protected AbstractConfigScreen getScreen() {
        return this.entry != null ? this.entry.getScreen() : null;
    }

    @Override
    public boolean overlayMouseDragged(Rectangle area, double mouseX, double mouseY, int button, double dragX, double dragY) {
        return IOverlayCapableContainer.IOverlayRenderer.super.overlayMouseDragged(area, mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.dragging) {
            return false;
        }
        this.dragOffset = (int)Math.round(mouseX - (double)this.m_252754_() - this.dragAnchor);
        this.dragOffset = Minecraft.m_91087_().f_91062_.m_92718_() ? Mth.m_14045_((int)this.dragOffset, (int)0, (int)(40 + this.f_93618_)) : Mth.m_14045_((int)this.dragOffset, (int)(-40 - this.f_93618_), (int)0);
        return true;
    }

    @Override
    public void endDrag(double mouseX, double mouseY, int button) {
        this.dragging = false;
        if (Math.abs(this.dragOffset) >= 40 + this.f_93618_) {
            this.onPress((Button)this, button);
        }
        this.dragOffset = 0;
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        if (!this.dragging && !this.confirming) {
            return false;
        }
        this.getScreen().removeTooltips(area);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        gg.m_280509_(area.x, area.y, area.getMaxX(), area.getMaxY(), -2130755006);
        gg.m_280509_(area.x + 2, area.y + 2, area.getMaxX() - 2, area.getMaxY() - 2, -39836);
        int x = this.m_252754_();
        int y = this.m_252907_();
        if (this.dragging) {
            this.defaultIcon.renderStretch(gg, x, y, this.f_93618_, this.f_93619_, 0);
            if (Minecraft.m_91087_().f_91062_.m_92718_()) {
                SimpleConfigIcons.Buttons.CONFIRM_DRAG_RIGHT.renderStretch(gg, x + this.f_93618_, y, 40, 20);
                this.defaultIcon.renderStretch(gg, x + this.f_93618_ + 40, y, this.f_93618_, this.f_93619_, 0);
                if (Math.abs(this.dragOffset) >= this.f_93618_ + 40) {
                    gg.m_280509_(x + this.f_93618_, y, x + 2 * this.f_93618_ + 40, y + this.f_93619_, 1694450242);
                }
            } else {
                SimpleConfigIcons.Buttons.CONFIRM_DRAG_LEFT.renderStretch(gg, x - 40, y, 40, 20);
                this.defaultIcon.renderStretch(gg, x - this.f_93618_ - 40, y, this.f_93618_, this.f_93619_, 0);
                if (Math.abs(this.dragOffset) >= this.f_93618_ + 40) {
                    gg.m_280509_(x - 40, y, x + this.f_93618_, y + this.f_93619_, 1694450242);
                }
            }
        }
        this.defaultIcon.renderStretch(gg, x + this.dragOffset, y, this.f_93618_, this.f_93619_, 2);
        if (this.confirming) {
            gg.m_280509_(x + this.dragOffset, y, x + this.f_93618_, y + this.f_93619_, 1694450242);
        }
        return true;
    }

    @Override
    public boolean overlayEscape() {
        if (this.confirming) {
            this.confirming = false;
            return true;
        }
        return IOverlayCapableContainer.IOverlayRenderer.super.overlayEscape();
    }

    @Override
    public void m_93692_(boolean focused) {
        this.confirming = false;
        super.m_93692_(focused);
    }

    @Override
    public List<Component> getTooltipContents() {
        if (this.isGroup()) {
            return this.isRestore() ? restoreTooltipGroup : resetTooltipGroup;
        }
        return this.isRestore() ? restoreTooltip : resetTooltip;
    }

    public Optional<List<Component>> getTooltip(int mouseX, int mouseY) {
        return this.m_5953_(mouseX, mouseY) ? Optional.of(this.getTooltipContents()) : Optional.empty();
    }
}

