/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import net.minecraft.util.Mth;

public class RectangleAnimator {
    protected ToggleAnimator animator;
    protected Rectangle target = new Rectangle();
    protected Rectangle origin = new Rectangle();
    protected Rectangle current = new Rectangle();
    protected float lastUpdate = -1.0f;

    public RectangleAnimator() {
        this(250L);
    }

    public RectangleAnimator(long length) {
        this.animator = new ToggleAnimator(length);
    }

    public void reset(Rectangle origin, Rectangle target) {
        this.target = target.copy();
        this.origin = origin.copy();
        this.animator.resetTarget();
    }

    public void setTarget(Rectangle target) {
        this.reset(this.getCurrent(), target);
    }

    public void setEaseInTarget(Rectangle target) {
        this.reset(this.getCurrentEaseIn(), target);
    }

    public void setEaseOutTarget(Rectangle target) {
        this.reset(this.getCurrentEaseOut(), target);
    }

    public void setEaseInOutTarget(Rectangle target) {
        this.reset(this.getCurrentEaseInOut(), target);
    }

    protected void updateCurrent(float progress) {
        if (this.lastUpdate != progress) {
            int l = (int)Mth.m_14179_((float)progress, (float)this.origin.x, (float)this.target.x);
            int t = (int)Mth.m_14179_((float)progress, (float)this.origin.y, (float)this.target.y);
            int w = (int)Mth.m_14179_((float)progress, (float)this.origin.getMaxX(), (float)this.target.getMaxX()) - l;
            int h = (int)Mth.m_14179_((float)progress, (float)this.origin.getMaxY(), (float)this.target.getMaxY()) - t;
            this.current.setBounds(l, t, w, h);
            this.lastUpdate = progress;
        }
    }

    public Rectangle getCurrent() {
        this.updateCurrent(this.animator.progress);
        return this.current;
    }

    public Rectangle getCurrentEaseIn() {
        this.updateCurrent(this.animator.getEaseIn());
        return this.current;
    }

    public Rectangle getCurrentEaseOut() {
        this.updateCurrent(this.animator.getEaseOut());
        return this.current;
    }

    public Rectangle getCurrentEaseInOut() {
        this.updateCurrent(this.animator.getEaseInOut());
        return this.current;
    }

    public boolean isInProgress() {
        return this.animator.isInProgress();
    }

    public float getProgress() {
        return this.animator.getProgress();
    }

    public Rectangle getTarget() {
        return this.target;
    }

    public Rectangle getOrigin() {
        return this.origin;
    }

    public Rectangle setOrigin(Rectangle origin) {
        this.origin = origin.copy();
        return origin;
    }
}

