/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.ErrorDialog;
import endorh.simpleconfig.ui.gui.InfoDialog;
import endorh.simpleconfig.ui.gui.ProgressDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import endorh.simpleconfig.ui.gui.widget.combobox.ComboBoxWidget;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresetPickerWidget
extends AbstractContainerEventHandler
implements IPositionableRenderable.IRectanglePositionableRenderable,
NarratableEntry {
    protected List<GuiEventListener> listeners;
    protected long lastUpdate = 0L;
    protected long updateCooldown = 1000L;
    @Nullable
    protected CompletableFuture<Void> lastFuture = null;
    private final Rectangle area = new Rectangle();
    protected AbstractConfigScreen screen;
    protected MultiFunctionImageButton loadButton;
    protected MultiFunctionImageButton saveButton;
    protected Map<SimpleConfig.Type, Map<String, Preset>> knownLocalPresets = Maps.newHashMap();
    protected Map<SimpleConfig.Type, Map<String, Preset>> knownRemotePresets = Maps.newHashMap();
    protected Map<SimpleConfig.Type, Map<String, Preset>> knownResourcePresets = Maps.newHashMap();
    protected Style selectedCountStyle = Style.f_131099_.m_131157_(ChatFormatting.DARK_AQUA);
    protected Style nameStyle = Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE);
    protected ComboBoxWidget<Preset> selector;
    private boolean active;
    public static boolean userSkipOverwriteDialog = false;
    public static boolean userSkipConfirmDeleteDialog = false;
    private static final Pattern NAME_PATTERN = Pattern.compile("^[^/\\n\\r\\t\u0000\\f`?*\\\\<>|\":]+$");

    public PresetPickerWidget(AbstractConfigScreen screen, int x, int y, int w) {
        this.screen = screen;
        this.area.setBounds(x, y, w, 18);
        for (SimpleConfig.Type type : SimpleConfig.Type.values()) {
            this.knownLocalPresets.put(type, Maps.newHashMap());
            this.knownRemotePresets.put(type, Maps.newHashMap());
            this.knownResourcePresets.put(type, Maps.newHashMap());
        }
        this.loadButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.LOAD, MultiFunctionImageButton.ButtonAction.of(() -> {
            Preset value = this.selector.getValue();
            if (value != null) {
                this.load(value);
            }
        }).active(() -> this.getHandler() != null && this.isKnownPreset(this.selector.getText(), screen.getEditedType().getType()) && screen.isEditable()).tooltip(() -> {
            Preset value = this.selector.getValue();
            if (value == null) {
                return Lists.newArrayList();
            }
            return Lists.newArrayList((Object[])new Component[]{Component.m_237110_((String)("simpleconfig.preset.load." + value.getLocation().getAlias()), (Object[])new Object[]{Component.m_237115_((String)("simpleconfig.preset." + value.getType().getAlias()))})});
        }), (Component)Component.m_237115_((String)"simpleconfig.preset.load.label"));
        this.saveButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.SAVE, MultiFunctionImageButton.ButtonAction.of(() -> this.save(this.selector.getText(), false)).tooltip(() -> this.getSaveTooltip(false, false)).active(() -> this.getHandler() != null && this.isValidName(this.selector.getText()) && screen.isEditable()), (Component)Component.m_237115_((String)"simpleconfig.preset.save.label")).on(MultiFunctionImageButton.Modifier.SHIFT, MultiFunctionImageButton.ButtonAction.of(() -> this.save(this.selector.getText(), true)).icon(SimpleConfigIcons.Buttons.SAVE_REMOTE).active(() -> this.getHandler() != null && this.isValidName(this.selector.getText()) && this.getHandler().canSaveRemote() && screen.isEditable()).tooltip(() -> this.getSaveTooltip(false, true))).on(MultiFunctionImageButton.Modifier.ALT, MultiFunctionImageButton.ButtonAction.of(() -> this.delete(this.selector.getValue())).icon(SimpleConfigIcons.Buttons.DELETE).active(() -> this.getHandler() != null && this.selector.getValue() != null && (!this.selector.getValue().isRemote() || this.getHandler().canSaveRemote()) && screen.isEditable()).tooltip(() -> {
            Preset preset = this.selector.getValue();
            return this.getSaveTooltip(true, preset != null && preset.isRemote());
        }));
        this.selector = new ComboBoxWidget<Preset>(new Preset.TypeWrapper(this), () -> screen, x, y, w - 48, 24, (Component)Component.m_237115_((String)"simpleconfig.preset.picker.label"));
        this.selector.setHint((Component)Component.m_237115_((String)"simpleconfig.preset.picker.hint"));
        SimpleComboBoxModel provider = new SimpleComboBoxModel(() -> this.getKnownPresets(screen.getEditedType().getType()));
        provider.setPlaceholder((Component)Component.m_237115_((String)"simpleconfig.ui.no_presets_found"));
        this.selector.setSuggestionProvider(provider);
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.selector, this.loadButton, this.saveButton});
    }

    public boolean m_142518_() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    protected List<Component> getSaveTooltip(boolean delete, boolean remote) {
        ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getHandler();
        if (handler == null || !this.isValidName(this.selector.getText())) {
            return Lists.newArrayList();
        }
        SimpleConfig.Type type = this.screen.getEditedType().getType();
        ArrayList tt = Lists.newArrayList((Object[])new Component[]{Component.m_237110_((String)String.format("simpleconfig.preset.%s.%s", delete ? "delete" : "save", remote ? "remote" : "local"), (Object[])new Object[]{Component.m_237115_((String)("simpleconfig.preset." + type.getAlias()))})});
        if (!delete && !remote && handler.canSaveRemote()) {
            tt.add(Component.m_237115_((String)"simpleconfig.preset.save.remote.shift"));
        }
        if (!delete && this.selector.getValue() != null) {
            tt.add(Component.m_237115_((String)"simpleconfig.preset.delete.alt"));
        }
        return tt;
    }

    public List<Preset> getKnownPresets() {
        return Stream.of(this.knownLocalPresets, this.knownRemotePresets, this.knownResourcePresets).flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).collect(Collectors.toList());
    }

    @Override
    public Rectangle getArea() {
        return this.area;
    }

    protected void position() {
        if (this.screen.m_7222_() != this) {
            this.listeners.forEach(l -> l.m_93692_(false));
        }
        this.selector.m_252865_(this.area.x + 1);
        this.selector.m_253211_(this.area.y + 2);
        this.selector.setHeight(this.area.height - 2);
        this.selector.m_93674_(this.area.width - 42);
        this.loadButton.m_252865_(this.area.getMaxX() - 40);
        this.loadButton.m_253211_(this.area.y);
        this.saveButton.m_252865_(this.area.getMaxX() - 20);
        this.saveButton.m_253211_(this.area.y);
    }

    protected ConfigScreenBuilder.IConfigSnapshotHandler getHandler() {
        return this.screen.getSnapshotHandler();
    }

    protected void update() {
        this.knownLocalPresets.values().forEach(Map::clear);
        for (Preset preset : this.getHandler().getLocalPresets()) {
            this.knownLocalPresets.get((Object)preset.getType()).put(preset.getName(), preset);
        }
        this.knownResourcePresets.values().forEach(Map::clear);
        for (Preset preset : this.getHandler().getResourcePresets()) {
            this.knownResourcePresets.get((Object)preset.getType()).put(preset.getName(), preset);
        }
        this.refreshSelector();
        if (this.lastFuture == null) {
            this.lastFuture = this.getHandler().getRemotePresets().thenAccept(presets -> {
                this.knownRemotePresets.values().forEach(Map::clear);
                for (Preset p : presets) {
                    this.knownRemotePresets.get((Object)p.getType()).put(p.getName(), p);
                }
                this.lastFuture = null;
                this.refreshSelector();
            });
        }
    }

    protected void refreshSelector() {
        Preset value = this.selector.getValue();
        String text = this.selector.getText();
        if (value != null && !this.isKnownPreset(value)) {
            this.selector.setText(this.selector.getText());
        }
        if (value == null && this.isKnownPreset(text)) {
            this.selector.setText("");
            this.selector.setText(text);
        }
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        long time = System.currentTimeMillis();
        if ((this.selector.m_93696_() || this.lastUpdate == 0L) && time - this.lastUpdate > this.updateCooldown) {
            this.lastUpdate = time;
            this.update();
        }
        this.position();
        this.selector.f_93623_ = this.getHandler() != null && this.screen.isEditable();
        this.selector.m_88315_(gg, mouseX, mouseY, delta);
        this.loadButton.m_88315_(gg, mouseX, mouseY, delta);
        this.saveButton.m_88315_(gg, mouseX, mouseY, delta);
    }

    public List<Preset> getKnownPresets(SimpleConfig.Type type) {
        return Stream.of(this.knownLocalPresets.get((Object)type), this.knownRemotePresets.get((Object)type), this.knownResourcePresets.get((Object)type)).flatMap(m -> m.values().stream()).collect(Collectors.toList());
    }

    public Map<String, Preset> getKnownPresets(SimpleConfig.Type type, Preset.Location location) {
        return switch (location) {
            default -> throw new IncompatibleClassChangeError();
            case Preset.Location.LOCAL -> this.knownLocalPresets.get((Object)type);
            case Preset.Location.REMOTE -> this.knownRemotePresets.get((Object)type);
            case Preset.Location.RESOURCE -> this.knownResourcePresets.get((Object)type);
        };
    }

    public boolean isKnownPreset(Preset preset) {
        return this.getKnownPresets(preset.getType(), preset.getLocation()).containsValue(preset);
    }

    public void load(Preset preset) {
        Set selection;
        SimpleConfig.Type type = this.screen.getEditedType().getType();
        ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getHandler();
        Set s = this.screen.getSelectedEntries().stream().map(AbstractConfigField::getRelPath).collect(Collectors.toSet());
        Set set = selection = s.isEmpty() ? null : s;
        if (preset.isRemote()) {
            CompletionStage future = handler.getRemote(preset.getName(), type).thenAccept(config -> this.doLoad((CommentedConfig)config, preset, type, selection));
            this.screen.addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.loading.title"), future, d -> d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.loading.remote.body", this.presetName(preset.getName())))));
        } else {
            handler.getPresetSnapshot(preset).thenAccept(snapshot -> this.doLoad((CommentedConfig)snapshot, preset, type, selection));
        }
    }

    protected void doLoad(CommentedConfig snapshot, Preset preset, SimpleConfig.Type type, @Nullable Set<String> selection) {
        ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getHandler();
        String ll = preset.getLocation().getAlias();
        MutableComponent tt = Component.m_237115_((String)("simpleconfig.preset." + type.getAlias()));
        int matches = this.getMatches(snapshot, selection);
        int total = this.getTotalSize(snapshot);
        this.screen.runAtomicTransparentAction(() -> handler.restore(snapshot, type, selection));
        this.screen.addDialog(InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.load.success.title"), (List)Util.m_137469_(new ArrayList(), b -> {
            b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.load.success." + ll, tt, this.presetName(preset.getName())));
            if (selection != null && matches > 0) {
                b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.load.success.selected", this.selectedCount(matches), this.selectedCount(total)));
            } else if (selection != null) {
                b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.load.success.none", this.selectedCount(total)));
            } else {
                b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.load.success.all", this.selectedCount(total)));
            }
            b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.load.success.undo", new Object[0]));
        })));
    }

    protected int getMatches(CommentedConfig snapshot, Set<String> selection) {
        if (selection == null) {
            return 0;
        }
        return (int)selection.stream().map(p -> p.startsWith(".") ? p.substring(1) : p).filter(arg_0 -> ((CommentedConfig)snapshot).contains(arg_0)).count();
    }

    protected int getTotalSize(CommentedConfig snapshot) {
        int total = 0;
        for (Object obj : snapshot.valueMap().values()) {
            if (obj instanceof CommentedConfig) {
                total += this.getTotalSize((CommentedConfig)obj);
                continue;
            }
            ++total;
        }
        return total;
    }

    public void save(String name, boolean remote) {
        this.save(name, remote, false);
    }

    public void save(String name, boolean remote, boolean overwrite) {
        SimpleConfig.Type type = this.screen.getEditedType().getType();
        ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getHandler();
        Set<String> s = this.screen.getSelectedEntries().stream().map(AbstractConfigField::getRelPath).collect(Collectors.toSet());
        int selected = s.size();
        Set<String> selection = selected > 0 ? s : null;
        CommentedConfig preserved = handler.preserve(type, selection);
        Map<String, Preset> presetMap = this.getKnownPresets(type, remote ? Preset.Location.REMOTE : Preset.Location.LOCAL);
        Map<String, Preset> otherMap = this.getKnownPresets(type, remote ? Preset.Location.LOCAL : Preset.Location.REMOTE);
        Map<String, Preset> resourceMap = this.getKnownPresets(type, Preset.Location.RESOURCE);
        String ll = remote ? "remote" : "local";
        MutableComponent tt = Component.m_237115_((String)("simpleconfig.preset." + type.getAlias()));
        if (!overwrite && !userSkipOverwriteDialog && presetMap.containsKey(name) && presetMap.get(name).getType() == type) {
            this.screen.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.overwrite.title"), arg_0 -> this.lambda$save$26(name, remote, ll, (Component)tt, arg_0)));
        } else if (!overwrite && (otherMap.containsKey(name) || resourceMap.containsKey(name)) && !presetMap.containsKey(name)) {
            boolean resource = !otherMap.containsKey(name);
            String r = resource ? "resource." : "";
            this.screen.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.mistaken.title"), d -> {
                d.withAction(b -> {
                    if (b) {
                        this.save(name, remote, true);
                    }
                });
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.mistaken." + r + ll + ".body", this.presetName(name)));
                d.setConfirmText((Component)Component.m_237115_((String)("simpleconfig.preset.dialog.mistaken.option." + ll + ".create")));
                d.setConfirmButtonTint(remote ? -1438478192 : -1438478270);
                if (!resource) {
                    d.addButton(1, (AbstractWidget)TintedButton.of((Component)Component.m_237115_((String)("simpleconfig.preset.dialog.mistaken.option." + ll + ".overwrite")), remote ? -1438478270 : -1438478192, p -> {
                        this.save(name, !remote, true);
                        d.cancel(false);
                    }));
                }
            }));
        } else if (remote) {
            CompletableFuture<Void> future = handler.saveRemote(name, type, preserved);
            this.screen.addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.saving.title"), future, d -> {
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.saving.remote.body", this.presetName(name)));
                d.setCancellableByUser(false);
                d.setSuccessDialog(this.getSaveSuccessDialog(true, type, name, selected));
            }));
            future.thenAccept(v -> this.update());
        } else {
            Optional<Throwable> result = handler.saveLocal(name, type, preserved);
            if (result.isPresent()) {
                this.screen.addDialog(ErrorDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.saving.error.title"), result.get(), d -> d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.saving.error.local.body", this.presetName(name)))));
            } else {
                this.screen.addDialog(this.getSaveSuccessDialog(false, type, name, selected));
                this.update();
            }
        }
    }

    protected AbstractDialog getSaveSuccessDialog(boolean remote, SimpleConfig.Type type, String name, int selected) {
        String ll = remote ? "remote" : "local";
        MutableComponent tt = Component.m_237115_((String)("simpleconfig.preset." + type.getAlias()));
        return InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.save.success.title"), (List)Util.m_137469_(new ArrayList(), arg_0 -> this.lambda$getSaveSuccessDialog$33(ll, (Component)tt, name, selected, arg_0)));
    }

    public void delete(Preset preset) {
        this.delete(preset, false);
    }

    public void delete(Preset preset, boolean skipConfirm) {
        SimpleConfig.Type type = this.screen.getEditedType().getType();
        ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getHandler();
        String ll = preset.isRemote() ? "remote" : "local";
        MutableComponent tt = Component.m_237115_((String)("simpleconfig.preset." + preset.getType().getAlias()));
        if (!userSkipConfirmDeleteDialog && !skipConfirm) {
            this.screen.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.delete.confirm.title"), arg_0 -> this.lambda$delete$35(preset, ll, (Component)tt, arg_0)));
        } else if (preset.isRemote()) {
            CompletableFuture<Void> future = handler.deleteRemote(preset.getName(), type);
            this.screen.addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.deleting.title"), future, d -> {
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.deleting.remote.body", this.presetName(preset.getName())));
                d.setCancellableByUser(false);
                d.setSuccessDialog(this.getDeleteSuccessDialog(preset));
            }));
            future.thenAccept(v -> this.update());
        } else {
            handler.deleteLocal(preset.getName(), type);
            this.screen.addDialog(this.getDeleteSuccessDialog(preset));
            this.update();
        }
    }

    protected AbstractDialog getDeleteSuccessDialog(Preset preset) {
        String ll = preset.isRemote() ? "remote" : "local";
        MutableComponent tt = Component.m_237115_((String)("simpleconfig.preset." + preset.getType().getAlias()));
        return InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.delete.success.title"), SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.delete.success." + ll, tt, this.presetName(preset.getName())));
    }

    protected MutableComponent selectedCount(int count) {
        return Component.m_237113_((String)String.valueOf(count)).m_130948_(this.selectedCountStyle);
    }

    protected MutableComponent presetName(String name) {
        return Component.m_237113_((String)name).m_130948_(this.nameStyle);
    }

    public boolean isKnownPreset(String name) {
        return Stream.of(this.knownLocalPresets, this.knownRemotePresets, this.knownResourcePresets).flatMap(m -> m.values().stream()).anyMatch(m -> m.containsKey(name));
    }

    public boolean isKnownPreset(String name, SimpleConfig.Type type) {
        return Stream.of(this.knownLocalPresets, this.knownRemotePresets, this.knownResourcePresets).map(m -> (Map)m.get((Object)type)).anyMatch(m -> m.containsKey(name));
    }

    public boolean isValidName(String text) {
        return NAME_PATTERN.matcher(text).matches();
    }

    public void refresh() {
        String text = this.selector.getText();
        this.selector.setValue(null);
        this.selector.setText(text);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput out) {
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    private /* synthetic */ void lambda$delete$35(Preset preset, String ll, Component tt, ConfirmDialog d) {
        d.withCheckBoxes((b, cs) -> {
            if (b) {
                if (cs[0]) {
                    userSkipConfirmDeleteDialog = true;
                }
                this.delete(preset, true);
            }
        }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again_this_session")));
        d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.delete.confirm." + ll, tt, this.presetName(preset.getName())));
        d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.delete.confirm.delete"));
        d.setConfirmButtonTint(-2135088092);
    }

    private /* synthetic */ void lambda$getSaveSuccessDialog$33(String ll, Component tt, String name, int selected, ArrayList b) {
        b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.save.success." + ll, tt, this.presetName(name)));
        if (selected > 0) {
            b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.save.success.selected", this.selectedCount(selected)));
        } else {
            b.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.save.success.all", new Object[0]));
        }
    }

    private /* synthetic */ void lambda$save$26(String name, boolean remote, String ll, Component tt, ConfirmDialog d) {
        d.withCheckBoxes((b, cs) -> {
            if (b) {
                if (cs[0]) {
                    userSkipOverwriteDialog = true;
                }
                this.save(name, remote, true);
            }
        }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again_this_session")));
        d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.preset.dialog.overwrite." + ll, tt, this.presetName(name)));
        d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.preset.dialog.overwrite.confirm"));
        d.setConfirmButtonTint(-1431699286);
    }

    public static class Preset {
        private final String name;
        private final SimpleConfig.Type type;
        private final Location location;

        private Preset(String name, SimpleConfig.Type type, Location location) {
            this.name = name;
            this.type = type;
            this.location = location;
        }

        public static Preset local(String name, SimpleConfig.Type type) {
            return new Preset(name, type, Location.LOCAL);
        }

        public static Preset remote(String name, SimpleConfig.Type type) {
            return new Preset(name, type, Location.REMOTE);
        }

        public static Preset resource(String name, SimpleConfig.Type type) {
            return new Preset(name, type, Location.RESOURCE);
        }

        public String getName() {
            return this.name;
        }

        public SimpleConfig.Type getType() {
            return this.type;
        }

        public boolean isClient() {
            return this.type == SimpleConfig.Type.CLIENT;
        }

        public boolean isCommon() {
            return this.type == SimpleConfig.Type.COMMON;
        }

        public boolean isServer() {
            return this.type == SimpleConfig.Type.SERVER;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean isLocal() {
            return this.location == Location.LOCAL;
        }

        public boolean isRemote() {
            return this.location == Location.REMOTE;
        }

        public boolean isResource() {
            return this.location == Location.RESOURCE;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Preset preset = (Preset)o;
            return this.getType() == preset.getType() && this.getLocation() == preset.getLocation() && this.getName().equals(preset.getName());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getName(), this.getType(), this.getLocation()});
        }

        public static enum Location {
            LOCAL,
            REMOTE,
            RESOURCE;

            private final String alias = this.name().toLowerCase();

            public String getAlias() {
                return this.alias;
            }
        }

        public static class TypeWrapper
        implements endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper<Preset> {
            public final PresetPickerWidget widget;

            public TypeWrapper(PresetPickerWidget widget) {
                this.widget = widget;
            }

            @Override
            public Pair<Optional<Preset>, Optional<Component>> parseElement(@NotNull String text) {
                SimpleConfig.Type type = this.widget.screen.getEditedType().getType();
                for (Location location : Location.values()) {
                    Map<String, Preset> presets = this.widget.getKnownPresets(type, location);
                    if (!presets.containsKey(text)) continue;
                    return Pair.of(Optional.of(presets.get(text)), Optional.empty());
                }
                return Pair.of(Optional.empty(), Optional.of(Component.m_237115_((String)"simpleconfig.config.error.unknown_preset")));
            }

            @Override
            public String getName(@NotNull Preset element) {
                return element.getName();
            }

            @Override
            public Component getDisplayName(@NotNull Preset element) {
                return Component.m_237113_((String)element.getName()).m_130940_(element.isRemote() ? ChatFormatting.AQUA : ChatFormatting.GREEN);
            }

            @Override
            public boolean hasIcon() {
                return true;
            }

            @Override
            public int getIconHeight() {
                return 14;
            }

            @Override
            public Optional<Icon> getIcon(@Nullable Preset element, String text) {
                if (element == null) {
                    return text.isEmpty() ? Optional.empty() : Optional.ofNullable(TypeWrapper.saveIconFor(this.widget.screen.getEditedType().getType()));
                }
                return Optional.ofNullable(TypeWrapper.iconFor(element.getType(), element.getLocation()));
            }

            public static Icon saveIconFor(SimpleConfig.Type type) {
                return switch (type) {
                    default -> throw new IncompatibleClassChangeError();
                    case SimpleConfig.Type.CLIENT -> SimpleConfigIcons.Presets.CLIENT_SAVE;
                    case SimpleConfig.Type.COMMON -> SimpleConfigIcons.Presets.COMMON_SAVE;
                    case SimpleConfig.Type.SERVER -> SimpleConfigIcons.Presets.SERVER_SAVE;
                };
            }

            public static Icon iconFor(SimpleConfig.Type type, Location location) {
                return switch (type) {
                    default -> throw new IncompatibleClassChangeError();
                    case SimpleConfig.Type.CLIENT -> {
                        switch (location) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case LOCAL: {
                                yield SimpleConfigIcons.Presets.CLIENT_LOCAL;
                            }
                            case REMOTE: {
                                yield SimpleConfigIcons.Presets.CLIENT_REMOTE;
                            }
                            case RESOURCE: 
                        }
                        yield SimpleConfigIcons.Presets.CLIENT_RESOURCE;
                    }
                    case SimpleConfig.Type.COMMON -> {
                        switch (location) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case LOCAL: {
                                yield SimpleConfigIcons.Presets.COMMON_LOCAL;
                            }
                            case REMOTE: {
                                yield SimpleConfigIcons.Presets.COMMON_REMOTE;
                            }
                            case RESOURCE: 
                        }
                        yield SimpleConfigIcons.Presets.COMMON_RESOURCE;
                    }
                    case SimpleConfig.Type.SERVER -> {
                        switch (location) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case LOCAL: {
                                yield SimpleConfigIcons.Presets.SERVER_LOCAL;
                            }
                            case REMOTE: {
                                yield SimpleConfigIcons.Presets.SERVER_REMOTE;
                            }
                            case RESOURCE: 
                        }
                        yield SimpleConfigIcons.Presets.SERVER_RESOURCE;
                    }
                };
            }
        }
    }
}

