/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class MultiFunctionImageButton
extends ImageButton {
    protected Icon defaultIcon;
    protected Supplier<Boolean> defaultActivePredicate;
    protected Supplier<List<Component>> defaultTooltip;
    protected Supplier<Optional<SoundInstance>> defaultSound;
    protected TreeSet<Pair<Modifier, ButtonAction>> actions = new TreeSet(Comparator.naturalOrder());
    @NotNull
    protected ButtonAction activeAction;
    @NotNull
    protected ButtonAction defaultAction;
    protected Boolean activeOverride = null;

    public static MultiFunctionImageButton of(@NotNull Icon icon, ButtonAction.ButtonActionBuilder action) {
        return MultiFunctionImageButton.of(GameNarrator.f_93310_, icon, action);
    }

    public static MultiFunctionImageButton of(Component title, @NotNull Icon icon, ButtonAction.ButtonActionBuilder action) {
        return MultiFunctionImageButton.of(title, icon.w, icon.h, icon, action);
    }

    public static MultiFunctionImageButton of(int width, int height, @NotNull Icon icon, ButtonAction.ButtonActionBuilder action) {
        return MultiFunctionImageButton.of(GameNarrator.f_93310_, width, height, icon, action);
    }

    public static MultiFunctionImageButton of(Component title, int width, int height, @NotNull Icon icon, ButtonAction.ButtonActionBuilder action) {
        return new MultiFunctionImageButton(0, 0, width, height, icon, action, title);
    }

    public MultiFunctionImageButton(int x, int y, int width, int height, @NotNull Icon icon, ButtonAction.ButtonActionBuilder action) {
        this(x, y, width, height, icon, action, GameNarrator.f_93310_);
    }

    public MultiFunctionImageButton(int x, int y, int width, int height, @NotNull Icon icon, ButtonAction.ButtonActionBuilder action, Component title) {
        super(x, y, width, height, icon.getU(), icon.getV(), icon.h, icon.getTexture(), icon.tw, icon.th, b -> {}, title);
        ButtonAction defaultAction = action.build();
        this.defaultIcon = icon;
        this.defaultActivePredicate = defaultAction.activePredicate != null ? defaultAction.activePredicate : () -> true;
        this.defaultTooltip = defaultAction.tooltipSupplier != null ? defaultAction.tooltipSupplier : Collections::emptyList;
        this.defaultSound = defaultAction.sound != null ? defaultAction.sound : () -> Optional.of(SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.actions.add((Pair<Modifier, ButtonAction>)Pair.of((Object)Modifier.NONE, (Object)defaultAction));
        this.defaultAction = this.activeAction = defaultAction;
    }

    public boolean click(int button) {
        return this.onClick(this.activeAction, button);
    }

    public boolean click(boolean ctrl, boolean alt, boolean shift, int button) {
        return this.click(MultiFunctionImageButton.modifiers(ctrl, alt, shift), button);
    }

    public boolean click(int modifiers, int button) {
        return this.onClick(this.getActiveAction(modifiers), button);
    }

    protected boolean onClick(ButtonAction action, int button) {
        if ((action.activePredicate != null ? action.activePredicate : this.defaultActivePredicate).get().booleanValue()) {
            action.action.accept(button);
            (action.sound != null ? action.sound : this.defaultSound).get().ifPresent(s -> Minecraft.m_91087_().m_91106_().m_120367_(s));
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateState();
        return this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY) && this.click(button);
    }

    public MultiFunctionImageButton on(Modifier modifier, ButtonAction.ButtonActionBuilder action) {
        ButtonAction a = action.build();
        this.actions.add((Pair<Modifier, ButtonAction>)Pair.of((Object)modifier, (Object)a));
        return this;
    }

    @NotNull
    public ButtonAction getActiveAction() {
        return this.activeAction;
    }

    @NotNull
    public ButtonAction getActiveAction(int modifiers) {
        return this.actions.stream().filter(p -> ((Modifier)p.getLeft()).isActive(modifiers)).map(Pair::getRight).filter(a -> a.activePredicate == null || a.activePredicate.get() != false).findFirst().orElse(this.defaultAction);
    }

    protected void updateState() {
        ButtonAction action = this.activeAction = this.actions.stream().filter(p -> ((Modifier)p.getLeft()).isActive()).map(Pair::getRight).filter(a -> a.activePredicate == null || a.activePredicate.get() != false).findFirst().orElse(this.defaultAction);
        this.f_93623_ = this.activeOverride != null ? this.activeOverride : (action.activePredicate != null ? action.activePredicate : this.defaultActivePredicate).get();
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        Icon icon;
        this.updateState();
        ButtonAction action = this.activeAction;
        int level = this.f_93623_ ? (this.m_198029_() ? 2 : 1) : 0;
        Icon icon2 = icon = action.icon != null ? action.icon.get() : null;
        if (icon == null) {
            icon = this.defaultIcon;
        }
        icon.renderStretch(gg, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, level);
        if (this.m_198029_()) {
            this.renderToolTip(gg, mouseX, mouseY);
        }
    }

    @NotNull
    protected ClientTooltipPositioner m_262860_() {
        return new BelowAboveOrAsideTooltipPositioner((AbstractWidget)this);
    }

    public void renderToolTip(@NotNull GuiGraphics gg, int mouseX, int mouseY) {
        List<Component> ls = this.getTooltipContents();
        if (!ls.isEmpty()) {
            int tooltipY;
            int tooltipX;
            Screen screen = Minecraft.m_91087_().f_91080_;
            boolean hovered = this.m_5953_(mouseX, mouseY);
            int n = tooltipX = hovered ? mouseX : this.m_252754_() + this.f_93618_ / 2;
            int n2 = hovered ? mouseY : (tooltipY = this.m_252907_() < 64 ? this.m_252907_() + this.f_93619_ : this.m_252907_());
            if (screen instanceof IMultiTooltipScreen) {
                IMultiTooltipScreen ts = (IMultiTooltipScreen)screen;
                ts.addTooltip(endorh.simpleconfig.ui.api.Tooltip.of(Rectangle.of(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_), Point.of(tooltipX, tooltipY), ls).asKeyboardTooltip(!hovered));
            } else if (screen != null) {
                gg.m_280666_(Minecraft.m_91087_().f_91062_, ls, tooltipX, tooltipY);
            }
        }
    }

    public List<Component> getTooltipContents() {
        ButtonAction action = this.activeAction;
        return (action.tooltipSupplier != null ? action.tooltipSupplier : this.defaultTooltip).get();
    }

    public void m_257544_(@Nullable Tooltip p_259796_) {
        super.m_257544_(p_259796_);
    }

    public boolean press(boolean ctrl, boolean alt, boolean shift) {
        return this.press(MultiFunctionImageButton.modifiers(ctrl, alt, shift));
    }

    private static int modifiers(boolean ctrl, boolean alt, boolean shift) {
        int modifiers = 0;
        if (ctrl) {
            modifiers |= 2;
        }
        if (alt) {
            modifiers |= 4;
        }
        if (shift) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public boolean press(int modifiers) {
        if (this.f_93623_ && this.f_93624_) {
            ButtonAction action = this.getActiveAction(modifiers);
            return this.onClick(action, -1);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.updateState();
        if (keyCode == 257 || keyCode == 32 || keyCode == 335) {
            return this.press(modifiers);
        }
        return false;
    }

    public void m_93692_(boolean focused) {
        this.updateState();
        super.m_93692_(focused);
    }

    public Boolean getActiveOverride() {
        return this.activeOverride;
    }

    public void setActiveOverride(Boolean activeOverride) {
        this.activeOverride = activeOverride;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public static class ButtonAction
    implements Comparable<ButtonAction> {
        private static int counter;
        private final int stamp = counter++;
        public final int priority;
        @Nullable
        public final Supplier<Icon> icon;
        @Nullable
        public final Supplier<Integer> tint;
        public final Consumer<Integer> action;
        @Nullable
        public final Supplier<Component> titleSupplier;
        @Nullable
        public final Supplier<List<Component>> tooltipSupplier;
        @Nullable
        public final Supplier<Boolean> activePredicate;
        @Nullable
        public final Supplier<Optional<SoundInstance>> sound;

        public ButtonAction(int priority, @Nullable Supplier<Icon> icon, @Nullable Supplier<Integer> tint, Consumer<Integer> action, @Nullable Supplier<Component> titleSupplier, @Nullable Supplier<List<Component>> tooltipSupplier, @Nullable Supplier<Boolean> activePredicate, @Nullable Supplier<Optional<SoundInstance>> sound) {
            this.priority = priority;
            this.icon = icon;
            this.tint = tint;
            this.action = action;
            this.titleSupplier = titleSupplier;
            this.tooltipSupplier = tooltipSupplier;
            this.activePredicate = activePredicate;
            this.sound = sound;
        }

        public static ButtonActionBuilder of(Consumer<Integer> action) {
            return new ButtonActionBuilder(action);
        }

        public static ButtonActionBuilder of(@Nullable Runnable left, @Nullable Runnable right) {
            return ButtonAction.of(left, right, null);
        }

        public static ButtonActionBuilder of(@Nullable Runnable left) {
            return ButtonAction.of(left, null, null);
        }

        public static ButtonActionBuilder of(@Nullable Runnable left, @Nullable Runnable right, @Nullable Runnable middle) {
            return ButtonAction.of((Integer b) -> {
                switch (b) {
                    case 1: {
                        if (right == null) break;
                        right.run();
                        break;
                    }
                    case 2: {
                        if (middle == null) break;
                        middle.run();
                        break;
                    }
                    default: {
                        if (left == null) break;
                        left.run();
                    }
                }
            });
        }

        @Override
        public int compareTo(@NotNull ButtonAction o) {
            int c = Integer.compare(this.priority, o.priority);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.stamp, o.stamp);
        }

        public static class ButtonActionBuilder {
            protected int priority = 0;
            protected final Consumer<Integer> action;
            @Nullable
            protected Supplier<Icon> icon = null;
            @Nullable
            protected Supplier<Integer> tint = null;
            @Nullable
            protected Supplier<Component> titleSupplier = null;
            @Nullable
            protected Supplier<List<Component>> tooltipSupplier = null;
            @Nullable
            protected Supplier<Boolean> activePredicate = null;
            @Nullable
            protected Supplier<Optional<SoundInstance>> sound = null;

            private ButtonActionBuilder(Consumer<Integer> action) {
                this.action = action;
            }

            public ButtonActionBuilder priority(int priority) {
                this.priority = priority;
                return this;
            }

            public ButtonActionBuilder icon(Icon icon) {
                return this.icon(() -> icon);
            }

            public ButtonActionBuilder tint(@Nullable Integer tint) {
                return this.tint(() -> tint);
            }

            public ButtonActionBuilder icon(Supplier<Icon> icon) {
                this.icon = icon;
                return this;
            }

            public ButtonActionBuilder tint(Supplier<Integer> tint) {
                this.tint = tint;
                return this;
            }

            public ButtonActionBuilder title(Supplier<Component> title) {
                this.titleSupplier = title;
                return this;
            }

            public ButtonActionBuilder tooltip(Component tooltip) {
                return this.tooltip(() -> Lists.newArrayList((Object[])new Component[]{tooltip}));
            }

            public ButtonActionBuilder tooltip(List<Component> tooltip) {
                return this.tooltip(() -> tooltip);
            }

            public ButtonActionBuilder tooltip(Supplier<List<Component>> tooltip) {
                this.tooltipSupplier = tooltip;
                return this;
            }

            public ButtonActionBuilder active(Supplier<Boolean> activePredicate) {
                this.activePredicate = activePredicate;
                return this;
            }

            public ButtonActionBuilder sound(Supplier<Optional<SoundInstance>> sound) {
                this.sound = sound;
                return this;
            }

            protected ButtonAction build() {
                return new ButtonAction(this.priority, this.icon, this.tint, this.action, this.titleSupplier, this.tooltipSupplier, this.activePredicate, this.sound);
            }
        }
    }

    public static class Modifier
    implements Comparable<Modifier> {
        public static final Modifier NONE = new Modifier();
        public static final Modifier CTRL = NONE.ctrl();
        public static final Modifier ALT = NONE.alt();
        public static final Modifier SHIFT = NONE.shift();
        private final ModifierBehaviour ctrl;
        private final ModifierBehaviour alt;
        private final ModifierBehaviour shift;

        private Modifier() {
            this(ModifierBehaviour.IGNORE, ModifierBehaviour.IGNORE, ModifierBehaviour.IGNORE);
        }

        private Modifier(ModifierBehaviour ctrl, ModifierBehaviour alt, ModifierBehaviour shift) {
            this.ctrl = ctrl;
            this.alt = alt;
            this.shift = shift;
        }

        public Modifier ctrl() {
            return new Modifier(ModifierBehaviour.REQUIRE, this.alt, this.shift);
        }

        public Modifier alt() {
            return new Modifier(this.ctrl, ModifierBehaviour.REQUIRE, this.shift);
        }

        public Modifier shift() {
            return new Modifier(this.ctrl, this.alt, ModifierBehaviour.REQUIRE);
        }

        public Modifier noCtrl() {
            return new Modifier(ModifierBehaviour.REJECT, this.alt, this.shift);
        }

        public Modifier noAlt() {
            return new Modifier(this.ctrl, ModifierBehaviour.REJECT, this.shift);
        }

        public Modifier noShift() {
            return new Modifier(this.ctrl, this.alt, ModifierBehaviour.REJECT);
        }

        public boolean isActive() {
            return this.isActive(Screen.m_96637_(), Screen.m_96639_(), Screen.m_96638_());
        }

        public boolean isActive(int modifiers) {
            return this.isActive((modifiers & 2) != 0, (modifiers & 4) != 0, (modifiers & 1) != 0);
        }

        public boolean isActive(boolean ctrl, boolean alt, boolean shift) {
            return !(this.ctrl != ModifierBehaviour.IGNORE && ctrl != (this.ctrl == ModifierBehaviour.REQUIRE) || this.alt != ModifierBehaviour.IGNORE && alt != (this.alt == ModifierBehaviour.REQUIRE) || this.shift != ModifierBehaviour.IGNORE && shift != (this.shift == ModifierBehaviour.REQUIRE));
        }

        @Override
        public int compareTo(@NotNull Modifier o) {
            int c = -Integer.compare(this.requireCount(), o.requireCount());
            if (c != 0) {
                return c;
            }
            c = -Integer.compare(this.nonIgnoreCount(), o.nonIgnoreCount());
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.compareHead(), o.compareHead());
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.compareMiddle(), o.compareMiddle());
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.compareTail(), o.compareTail());
        }

        private int compareHead() {
            return this.ctrl == ModifierBehaviour.REQUIRE ? 0 : (this.alt == ModifierBehaviour.REQUIRE ? 1 : (this.shift == ModifierBehaviour.REQUIRE ? 2 : 3));
        }

        private int compareMiddle() {
            return this.ctrl == ModifierBehaviour.REJECT ? 0 : (this.alt == ModifierBehaviour.REJECT ? 1 : (this.shift == ModifierBehaviour.REJECT ? 2 : 3));
        }

        private int compareTail() {
            return this.shift == ModifierBehaviour.IGNORE ? 3 : (this.alt == ModifierBehaviour.IGNORE ? 2 : (this.ctrl == ModifierBehaviour.IGNORE ? 1 : 0));
        }

        private int requireCount() {
            return (int)Stream.of(this.ctrl, this.alt, this.shift).filter(b -> b == ModifierBehaviour.REQUIRE).count();
        }

        private int nonIgnoreCount() {
            return (int)Stream.of(this.ctrl, this.alt, this.shift).filter(b -> b != ModifierBehaviour.IGNORE).count();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Modifier modifier = (Modifier)o;
            return this.ctrl == modifier.ctrl && this.alt == modifier.alt && this.shift == modifier.shift;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.ctrl, this.alt, this.shift});
        }

        private static enum ModifierBehaviour {
            REQUIRE,
            REJECT,
            IGNORE;

        }
    }

    public static class BelowAboveOrAsideTooltipPositioner
    implements ClientTooltipPositioner {
        private final AbstractWidget widget;

        public BelowAboveOrAsideTooltipPositioner(AbstractWidget widget) {
            this.widget = widget;
        }

        @NotNull
        public Vector2ic m_262814_(int sw, int screen, int x, int y, int tw, int th) {
            if (!this.widget.m_5953_((double)(x - 12), (double)(y + 12))) {
                return new Vector2i(this.widget.m_252754_() + this.widget.m_5711_() / 2, this.widget.m_252907_() < 64 ? this.widget.m_252907_() + this.widget.m_93694_() : this.widget.m_252907_());
            }
            return new Vector2i(x - 12, y + 12);
        }
    }
}

