/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.OverlayInjector;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MultiFunctionIconButton
extends TintedButton {
    protected Icon defaultIcon;
    protected Supplier<Boolean> defaultActivePredicate;
    protected Supplier<Component> defaultTitle;
    protected Supplier<List<Component>> defaultTooltip;
    protected Supplier<Optional<SoundInstance>> defaultSound;
    protected TreeSet<Pair<MultiFunctionImageButton.Modifier, MultiFunctionImageButton.ButtonAction>> actions = new TreeSet<Pair>(Comparator.comparing(Pair::getLeft));
    @NotNull
    protected MultiFunctionImageButton.ButtonAction activeAction;
    @NotNull
    protected MultiFunctionImageButton.ButtonAction defaultAction;
    protected Boolean activeOverride = null;
    protected int maxWidth;
    protected int minWidth;
    protected int defaultTint = 0;
    protected boolean suppressHoverPeek = false;

    public static MultiFunctionIconButton of(@NotNull Icon icon, MultiFunctionImageButton.ButtonAction.ButtonActionBuilder builder) {
        return MultiFunctionIconButton.of(icon, icon.w, icon.w, builder);
    }

    public static MultiFunctionIconButton of(@NotNull Icon icon, int minWidth, int maxWidth, MultiFunctionImageButton.ButtonAction.ButtonActionBuilder builder) {
        return new MultiFunctionIconButton(0, 0, minWidth, maxWidth, icon, builder);
    }

    public MultiFunctionIconButton(int x, int y, int minWidth, int maxWidth, @NotNull Icon icon, MultiFunctionImageButton.ButtonAction.ButtonActionBuilder action) {
        super(x, y, minWidth, 20, (Component)Component.m_237119_(), b -> {});
        MultiFunctionImageButton.ButtonAction defaultAction = action.build();
        this.defaultIcon = icon;
        this.defaultActivePredicate = defaultAction.activePredicate != null ? defaultAction.activePredicate : () -> true;
        this.defaultTitle = defaultAction.titleSupplier != null ? defaultAction.titleSupplier : Component::m_237119_;
        this.defaultTooltip = defaultAction.tooltipSupplier != null ? defaultAction.tooltipSupplier : Collections::emptyList;
        this.defaultSound = defaultAction.sound != null ? defaultAction.sound : () -> Optional.of(SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.actions.add((Pair<MultiFunctionImageButton.Modifier, MultiFunctionImageButton.ButtonAction>)Pair.of((Object)MultiFunctionImageButton.Modifier.NONE, (Object)defaultAction));
        this.defaultAction = this.activeAction = defaultAction;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.overlay = new ButtonOverlay(this);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY) && this.click(button);
    }

    public boolean click(int button) {
        return this.onClick(this.activeAction, button);
    }

    public boolean click(boolean ctrl, boolean alt, boolean shift, int button) {
        return this.click(MultiFunctionIconButton.modifiers(ctrl, alt, shift), button);
    }

    public boolean click(int modifiers, int button) {
        return this.onClick(this.getActiveAction(modifiers), button);
    }

    protected boolean onClick(MultiFunctionImageButton.ButtonAction action, int button) {
        if ((action.activePredicate != null ? action.activePredicate : this.defaultActivePredicate).get().booleanValue()) {
            action.action.accept(button);
            (action.sound != null ? action.sound : this.defaultSound).get().ifPresent(s -> Minecraft.m_91087_().m_91106_().m_120367_(s));
            return true;
        }
        return false;
    }

    @NotNull
    public MultiFunctionImageButton.ButtonAction getActiveAction() {
        return this.activeAction;
    }

    @NotNull
    public MultiFunctionImageButton.ButtonAction getActiveAction(int modifiers) {
        return this.actions.stream().filter(p -> ((MultiFunctionImageButton.Modifier)p.getLeft()).isActive(modifiers)).map(Pair::getRight).filter(a -> a.activePredicate == null || a.activePredicate.get() != false).findFirst().orElse(this.defaultAction);
    }

    public MultiFunctionIconButton on(MultiFunctionImageButton.Modifier modifier, MultiFunctionImageButton.ButtonAction.ButtonActionBuilder action) {
        MultiFunctionImageButton.ButtonAction a = action.build();
        this.actions.add((Pair<MultiFunctionImageButton.Modifier, MultiFunctionImageButton.ButtonAction>)Pair.of((Object)modifier, (Object)a));
        return this;
    }

    public Component getTitle() {
        MultiFunctionImageButton.ButtonAction action = this.activeAction;
        return action.titleSupplier != null ? action.titleSupplier.get() : this.defaultTitle.get();
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        Icon icon;
        MultiFunctionImageButton.ButtonAction action = this.activeAction = this.actions.stream().filter(p -> ((MultiFunctionImageButton.Modifier)p.getLeft()).isActive()).map(Pair::getRight).filter(a -> a.activePredicate == null || a.activePredicate.get() != false).findFirst().orElse(this.defaultAction);
        this.f_93623_ = this.activeOverride != null ? this.activeOverride : (action.activePredicate != null ? action.activePredicate : this.defaultActivePredicate).get();
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Component title = this.getTitle();
        Icon icon2 = icon = action.icon != null ? action.icon.get() : null;
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        int textWidth = font.m_92852_((FormattedText)title);
        int iconWidth = icon != Icon.EMPTY ? 20 : 4;
        int contentWidth = textWidth + iconWidth + 4;
        if (this.minWidth != -1 && this.maxWidth != -1) {
            this.f_93618_ = Math.max(this.minWidth, Math.min(this.maxWidth, (contentWidth + 1) / 2 * 2));
        }
        if (action.tint != null) {
            Integer tint = action.tint.get();
            super.setTintColor(tint != null ? tint : 0);
        } else {
            super.setTintColor(this.defaultTint);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_93617_);
        int level = this.getTextureLevel();
        SimpleConfigIcons.Backgrounds.BUTTON_BACKGROUND.renderStretch(gg, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, level);
        this.renderTint(gg, this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
        int color = this.getFGColor();
        this.contentArea.setBounds(this.area.x + 2, this.area.y + 2, this.area.width - 4, this.area.height - 4);
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        if (contentWidth < this.f_93618_) {
            mStack.m_85837_((double)(this.f_93618_ - contentWidth) / 2.0, 0.0, 0.0);
        }
        if (icon != Icon.EMPTY) {
            RenderSystem.setShaderColor((float)0.1f, (float)0.1f, (float)0.1f, (float)0.8f);
            icon.renderCentered(gg, this.m_252754_() + 1, this.m_252907_() + 1, 20, 20);
            float intensity = this.f_93623_ ? 1.0f : 0.3f;
            RenderSystem.setShaderColor((float)intensity, (float)intensity, (float)intensity, (float)1.0f);
            icon.renderCentered(gg, this.m_252754_(), this.m_252907_(), 20, 20);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.f_93618_ > iconWidth) {
            if (contentWidth > this.f_93618_ && !this.suppressHoverPeek) {
                ScissorsHandler.INSTANCE.withScissor(this.contentArea, () -> gg.m_280430_(font, title, this.m_252754_() + iconWidth, this.m_252907_() + (this.f_93619_ - 8) / 2, color | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
                if (this.m_5953_(mouseX, mouseY) && !this.overlay.isRendering()) {
                    Screen screen = mc.f_91080_;
                    if (this.overlayArea == null) {
                        this.overlayArea = new Rectangle();
                        OverlayInjector.injectVisualOverlay(this.overlayArea, this.overlay, 10);
                    }
                    this.overlayArea.setBounds(this.m_252754_(), this.m_252907_(), contentWidth + 4, this.f_93619_ + 1);
                    if (screen != null && this.overlayArea.getMaxX() > screen.f_96543_) {
                        this.overlayArea.x = Math.max(4, screen.f_96543_ - 4 - this.overlayArea.getWidth());
                    }
                }
            } else {
                if (this.overlayArea != null) {
                    this.overlayArea.setBounds(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_ + 1);
                }
                gg.m_280430_(font, title, this.m_252754_() + iconWidth, this.m_252907_() + (this.f_93619_ - 8) / 2, color | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }
        }
        mStack.m_85849_();
        if (this.m_198029_()) {
            this.renderToolTip(gg, mouseX, mouseY);
        }
    }

    public boolean isSuppressHoverPeek() {
        return this.suppressHoverPeek;
    }

    public void setSuppressHoverPeek(boolean suppressHoverPeek) {
        this.suppressHoverPeek = suppressHoverPeek;
        if (suppressHoverPeek) {
            this.overlayArea = null;
        }
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics gg, int mouseX, int mouseY) {
        List<Component> ls = this.getTooltipContents();
        if (!ls.isEmpty()) {
            int tooltipY;
            int tooltipX;
            Screen screen = Minecraft.m_91087_().f_91080_;
            boolean hovered = this.m_5953_(mouseX, mouseY);
            int n = tooltipX = hovered ? mouseX : this.m_252754_() + this.f_93618_ / 2;
            int n2 = hovered ? mouseY : (tooltipY = this.m_252907_() < 64 ? this.m_252907_() + this.f_93619_ : this.m_252907_());
            if (screen instanceof IMultiTooltipScreen) {
                IMultiTooltipScreen ts = (IMultiTooltipScreen)screen;
                ts.addTooltip(Tooltip.of(this.area, Point.of(tooltipX, tooltipY), ls).asKeyboardTooltip(!hovered));
            } else if (screen != null) {
                gg.m_280666_(Minecraft.m_91087_().f_91062_, ls, tooltipX, tooltipY);
            }
        }
    }

    @Override
    public List<Component> getTooltipContents() {
        MultiFunctionImageButton.ButtonAction action = this.activeAction;
        return (action.tooltipSupplier != null ? action.tooltipSupplier : this.defaultTooltip).get();
    }

    public boolean press(boolean ctrl, boolean alt, boolean shift) {
        return this.press(MultiFunctionIconButton.modifiers(ctrl, alt, shift));
    }

    private static int modifiers(boolean ctrl, boolean alt, boolean shift) {
        int modifiers = 0;
        if (ctrl) {
            modifiers |= 2;
        }
        if (alt) {
            modifiers |= 4;
        }
        if (shift) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public boolean press(int modifiers) {
        if (this.f_93623_ && this.f_93624_) {
            MultiFunctionImageButton.ButtonAction action = this.getActiveAction(modifiers);
            return this.onClick(action, -1);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 32 || keyCode == 335) {
            return this.press(modifiers);
        }
        return false;
    }

    public Boolean getActiveOverride() {
        return this.activeOverride;
    }

    public void setActiveOverride(Boolean activeOverride) {
        this.activeOverride = activeOverride;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public void setWidthRange(int min, int max) {
        this.setMinWidth(min);
        this.setMaxWidth(max);
    }

    public void m_93674_(int width) {
        this.setExactWidth(width);
    }

    public void setExactWidth(int width) {
        this.setMinWidth(width);
        this.setMaxWidth(width);
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public void setTintColor(int color) {
        super.setTintColor(color);
        this.defaultTint = color;
    }

    public int m_5711_() {
        Icon icon;
        MultiFunctionImageButton.ButtonAction action = this.actions.stream().filter(p -> ((MultiFunctionImageButton.Modifier)p.getLeft()).isActive()).map(Pair::getRight).findFirst().orElseThrow(() -> new IllegalStateException("Button without default action"));
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Component title = action.titleSupplier != null ? action.titleSupplier.get() : this.defaultTitle.get();
        Icon icon2 = icon = action.icon != null ? action.icon.get() : null;
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        int textWidth = font.m_92852_((FormattedText)title);
        int contentWidth = textWidth + (icon != Icon.EMPTY ? 20 : 4) + 4;
        return Math.max(this.minWidth, Math.min(this.maxWidth, (contentWidth + 1) / 2 * 2));
    }

    public static class ButtonOverlay
    extends TintedButton.ButtonOverlay {
        private final MultiFunctionIconButton button;

        public ButtonOverlay(MultiFunctionIconButton button) {
            super(button);
            this.button = button;
        }

        @Override
        public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
            if (!this.button.m_5953_(mouseX, mouseY) || this.button.overlayArea == null) {
                this.button.overlayArea = null;
                this.animator.stopAndSet(0.0f);
                return false;
            }
            if (this.animator.getTarget() == 0.0f) {
                this.animator.resetTarget();
                this.animator.setOutputRange(this.button.maxWidth, area.width);
            }
            if (this.lastWidth != area.width) {
                this.animator.setOutputRange(this.animator.getEaseOut(), area.width);
                this.animator.resetTarget();
                this.lastWidth = area.width;
            }
            this.rendering = true;
            int x = this.button.m_252754_();
            int y = this.button.m_252907_();
            int minW = this.button.minWidth;
            int maxW = this.button.maxWidth;
            int h = this.button.f_93619_;
            int w = (int)this.animator.getEaseOut();
            this.button.m_264152_(area.x, area.y);
            this.button.m_93674_(w);
            this.button.setHeight(area.height);
            this.button.setExactWidth(w);
            this.area.setBounds(area.x, area.y, w, area.height);
            ScissorsHandler.INSTANCE.withSingleScissor(this.area, () -> this.button.m_88315_(gg, mouseX, mouseY, delta));
            this.button.m_252865_(x);
            this.button.m_253211_(y);
            this.button.minWidth = minW;
            this.button.maxWidth = maxW;
            this.button.f_93619_ = h;
            this.rendering = false;
            return true;
        }
    }
}

