/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettingsBuilder;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.api.ui.icon.KeyBindSettingsIcon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.FocusableOverlayRenderer;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.SelectorButton;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyBindSettingsButton
extends MultiFunctionImageButton {
    @Nullable
    public static ExtendedKeyBindSettings CLIPBOARD = null;
    private long copyTimestamp = 0L;
    private final Supplier<IOverlayCapableContainer> container;
    private ExtendedKeyBindSettings defaultSettings;
    private ExtendedKeyBindSettings settings = this.defaultSettings = ExtendedKeyBindSettings.ingame().build();
    private boolean overlayShown;
    private final KeyBindSettingsIcon icon;
    private final KeyBindSettingsOverlay overlay = new KeyBindSettingsOverlay(this);
    private final RedirectGuiEventListener overlayReference = new RedirectGuiEventListener(null);
    private Rectangle parentRectangle = new Rectangle();
    @Nullable
    private Consumer<ExtendedKeyBindSettings> listener = null;

    public KeyBindSettingsButton(Supplier<IOverlayCapableContainer> container) {
        this(container, 0, 0);
    }

    public KeyBindSettingsButton(Supplier<IOverlayCapableContainer> container, int x, int y) {
        super(x, y, 20, 20, new KeyBindSettingsIcon(), MultiFunctionImageButton.ButtonAction.of(() -> {}));
        this.container = container;
        this.icon = (KeyBindSettingsIcon)this.defaultIcon;
        this.actions.clear();
        this.defaultAction = MultiFunctionImageButton.ButtonAction.of(this::showOverlay, this::copySettings, this::pasteSettings).tooltip(this::getHint).build();
    }

    public void setListener(@Nullable Consumer<ExtendedKeyBindSettings> listener) {
        this.listener = listener;
    }

    protected void setSettings(ExtendedKeyBindSettings settings) {
        this.settings = settings;
        if (this.listener != null) {
            this.listener.accept(settings);
        }
    }

    public void applySettings(ExtendedKeyBindSettings settings) {
        this.setSettings(settings);
        this.overlay.applySettings(settings);
    }

    public void setWarning(boolean warning) {
        this.icon.setWarning(warning);
    }

    public ExtendedKeyBindSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public void setDefaultSettings(ExtendedKeyBindSettings settings) {
        this.defaultSettings = settings;
    }

    public void setParentRectangle(Rectangle parentRectangle) {
        this.parentRectangle = parentRectangle;
    }

    public Rectangle getParentRectangle() {
        return this.parentRectangle;
    }

    public ExtendedKeyBindSettings getSettings() {
        return this.settings;
    }

    public IOverlayCapableContainer getContainer() {
        return this.container.get();
    }

    public RedirectGuiEventListener getOverlayReference() {
        return this.overlayReference;
    }

    public void copySettings() {
        CLIPBOARD = this.getSettings();
        this.copyTimestamp = System.currentTimeMillis();
    }

    public void pasteSettings() {
        this.applySettings(CLIPBOARD == null ? this.defaultSettings : CLIPBOARD);
    }

    public void showOverlay() {
        if (this.overlayShown) {
            this.hideOverlay();
        } else {
            Rectangle area = this.positionOverlay();
            this.getContainer().addOverlay(area, this.overlay, 10);
            this.overlayShown = true;
            this.overlayReference.setTarget(this.overlay);
        }
    }

    public void hideOverlay() {
        this.overlayShown = false;
        this.overlayReference.setTarget(null);
    }

    protected void clickedOutside(int mouseX, int mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            this.hideOverlay();
        }
    }

    protected Rectangle positionOverlay() {
        IOverlayCapableContainer container = this.getContainer();
        Rectangle area = this.overlay.getArea();
        Rectangle parent = this.parentRectangle.isEmpty() ? new Rectangle(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_()) : this.parentRectangle;
        int w = container.getScreenWidth();
        int h = container.getScreenHeight();
        int offset = 2;
        boolean right = parent.getCenterX() > w / 2;
        boolean bottom = parent.getCenterY() > h / 2;
        area.x = right ? parent.getMinX() - area.width - offset : parent.getMaxX() + offset;
        int n = area.y = bottom ? parent.getMaxY() - area.height : parent.getMinY();
        if (area.getMaxX() > w || area.x < 0 || area.y < 0) {
            area.x = right ? parent.getMaxX() - area.width : parent.getMinX();
            area.y = bottom ? parent.getMinY() - area.height - offset : parent.getMaxY() + offset;
        }
        area.x = Mth.m_14045_((int)area.x, (int)2, (int)(w - area.width - 2));
        area.y = Mth.m_14045_((int)area.y, (int)2, (int)(h - area.height - 2));
        return area;
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.overlayShown) {
            this.positionOverlay();
        }
        this.icon.setHighlight(this.m_93696_() || this.m_5953_(mouseX, mouseY) || this.overlayShown);
        if (this.icon.getSettings() != this.settings) {
            this.icon.setSettings(this.settings);
        }
        super.m_88315_(gg, mouseX, mouseY, delta);
    }

    public List<Component> getHint() {
        return this.overlayShown ? Collections.emptyList() : SimpleConfigTextUtil.splitTtc(System.currentTimeMillis() - this.copyTimestamp < 1000L ? "simpleconfig.keybind.settings.copied" : "simpleconfig.keybind.settings:help", new Object[0]);
    }

    public boolean isOverlayShown() {
        return this.overlayShown;
    }

    public KeyBindSettingsOverlay getOverlay() {
        return this.overlay;
    }

    public static class KeyBindSettingsOverlay
    extends FocusableOverlayRenderer {
        private final KeyBindSettingsButton button;
        private final SelectorButton<KeyBindMapping.KeyBindActivation> activationButton;
        private final SelectorButton<KeyBindMapping.KeyBindContext> contextButton;
        private final SelectorButton.BooleanButton allowExtraKeysCheckBox;
        private final SelectorButton.BooleanButton orderSensitiveCheckBox;
        private final SelectorButton.BooleanButton exclusiveCheckBox;
        private final SelectorButton.BooleanButton matchByCharCheckBox;
        private final SelectorButton.BooleanButton preventFurtherCheckBox;

        public KeyBindSettingsOverlay(KeyBindSettingsButton button) {
            this.button = button;
            this.activationButton = SelectorButton.of(KeyBindMapping.KeyBindActivation.class, t -> Component.m_237115_((String)("simpleconfig.keybind.activation." + t.name().toLowerCase())), KeyBindMapping.KeyBindActivation::getIcon, t -> this.update());
            this.contextButton = SelectorButton.of(KeyBindMapping.KeyBindContext.getAllContexts(), KeyBindMapping.KeyBindContext::getDisplayName, KeyBindMapping.KeyBindContext::getIcon, t -> this.update());
            this.allowExtraKeysCheckBox = SelectorButton.BooleanButton.of(ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, SimpleConfigIcons.Hotkeys.EXTRA_KEYS_ALLOW, SimpleConfigIcons.Hotkeys.EXTRA_KEYS_BLOCK, b -> this.update());
            this.orderSensitiveCheckBox = SelectorButton.BooleanButton.of(ChatFormatting.GOLD, ChatFormatting.AQUA, SimpleConfigIcons.Hotkeys.ORDER_SENSITIVE, SimpleConfigIcons.Hotkeys.ORDER_INSENSITIVE, b -> this.update());
            this.exclusiveCheckBox = SelectorButton.BooleanButton.of(ChatFormatting.GOLD, ChatFormatting.AQUA, SimpleConfigIcons.Hotkeys.EXCLUSIVE_YES, SimpleConfigIcons.Hotkeys.EXCLUSIVE_NO, b -> this.update());
            this.matchByCharCheckBox = SelectorButton.BooleanButton.of(ChatFormatting.LIGHT_PURPLE, ChatFormatting.GREEN, SimpleConfigIcons.Hotkeys.MATCH_BY_NAME, SimpleConfigIcons.Hotkeys.MATCH_BY_CODE, b -> this.update());
            this.preventFurtherCheckBox = SelectorButton.BooleanButton.of(ChatFormatting.GREEN, ChatFormatting.GOLD, SimpleConfigIcons.Hotkeys.PREVENT_FURTHER_YES, SimpleConfigIcons.Hotkeys.PREVENT_FURTHER_NO, b -> this.update());
            Stream.of(new SelectorButton[]{this.activationButton, this.contextButton, this.allowExtraKeysCheckBox, this.orderSensitiveCheckBox, this.exclusiveCheckBox, this.matchByCharCheckBox, this.preventFurtherCheckBox}).forEach(this.listeners::add);
        }

        protected void update() {
            this.setSettings(new ExtendedKeyBindSettingsBuilder(this.getSettings()).withActivation(this.activationButton.getValue()).withContext(this.contextButton.getValue()).setAllowExtraKeys(this.allowExtraKeysCheckBox.getToggle()).setOrderSensitive(this.orderSensitiveCheckBox.getToggle()).setExclusive(this.exclusiveCheckBox.getToggle()).setMatchByChar(this.matchByCharCheckBox.getToggle()).setPreventFurther(this.preventFurtherCheckBox.getToggle()).build());
        }

        @Override
        public Rectangle getArea() {
            Rectangle area = super.getArea();
            area.width = 180;
            area.height = 160;
            return area;
        }

        @Override
        public void overlayMouseClickedOutside(Rectangle area, double mouseX, double mouseY, int button) {
            super.overlayMouseClickedOutside(area, mouseX, mouseY, button);
            this.button.clickedOutside((int)mouseX, (int)mouseY);
        }

        @Override
        public boolean overlayEscape() {
            this.button.hideOverlay();
            this.hide();
            return true;
        }

        public ExtendedKeyBindSettings getSettings() {
            return this.button.getSettings();
        }

        public void setSettings(ExtendedKeyBindSettings settings) {
            this.button.setSettings(settings);
        }

        public void applySettings(ExtendedKeyBindSettings settings) {
            this.activationButton.setValue(settings.activation());
            this.contextButton.setValue(settings.context());
            this.allowExtraKeysCheckBox.setToggle(settings.allowExtraKeys());
            this.orderSensitiveCheckBox.setToggle(settings.orderSensitive());
            this.exclusiveCheckBox.setToggle(settings.exclusive());
            this.matchByCharCheckBox.setToggle(settings.matchByChar());
            this.preventFurtherCheckBox.setToggle(settings.preventFurther());
        }

        public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
            Rectangle area = this.getArea();
            AbstractConfigScreen.drawBorderRect(gg, area, 1, -286331154, -299621340);
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            int to = 10 - (9 + 1) / 2;
            int xx = area.x + 4;
            int yy = area.y + 4;
            int bw = 70;
            int bx = area.getMaxX() - bw - 4;
            List<Component> tooltip = null;
            boolean tooltipInXRange = mouseX >= xx + 2 && mouseX < bx - 2;
            gg.m_280430_(font, (Component)this.getLabel("activation"), xx + 2, yy + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("activation");
            }
            this.activationButton.m_264152_(bx, yy);
            this.activationButton.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("context"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("context");
            }
            this.contextButton.m_264152_(bx, yy);
            this.contextButton.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("allow_extra_keys"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("allow_extra_keys");
            }
            this.allowExtraKeysCheckBox.m_264152_(bx, yy);
            this.allowExtraKeysCheckBox.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("order_sensitive"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("order_sensitive");
            }
            this.orderSensitiveCheckBox.m_264152_(bx, yy);
            this.orderSensitiveCheckBox.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("exclusive"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("exclusive");
            }
            this.exclusiveCheckBox.m_264152_(bx, yy);
            this.exclusiveCheckBox.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("match_by_char"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("match_by_char");
            }
            this.matchByCharCheckBox.m_264152_(bx, yy);
            this.matchByCharCheckBox.m_93674_(bw);
            gg.m_280430_(font, (Component)this.getLabel("prevent_further"), xx + 2, (yy += 22) + to, -522133280);
            if (tooltipInXRange && mouseY >= yy + 2 && mouseY < yy + 18) {
                tooltip = this.getTooltip("prevent_further");
            }
            this.preventFurtherCheckBox.m_264152_(bx, yy);
            this.preventFurtherCheckBox.m_93674_(bw);
            ExtendedKeyBindSettings def = this.button.defaultSettings;
            int editedColor = this.getEditedTint();
            int defaultColor = this.getDefaultTint();
            this.activationButton.setTintColor(def.activation() != this.activationButton.getValue() ? editedColor : defaultColor);
            this.contextButton.setTintColor(def.context() != this.contextButton.getValue() ? editedColor : defaultColor);
            this.allowExtraKeysCheckBox.setTintColor(def.allowExtraKeys() != this.allowExtraKeysCheckBox.getToggle() ? editedColor : defaultColor);
            this.orderSensitiveCheckBox.setTintColor(def.orderSensitive() != this.orderSensitiveCheckBox.getToggle() ? editedColor : defaultColor);
            this.exclusiveCheckBox.setTintColor(def.exclusive() != this.exclusiveCheckBox.getToggle() ? editedColor : defaultColor);
            this.matchByCharCheckBox.setTintColor(def.matchByChar() != this.matchByCharCheckBox.getToggle() ? editedColor : defaultColor);
            this.preventFurtherCheckBox.setTintColor(def.preventFurther() != this.preventFurtherCheckBox.getToggle() ? editedColor : defaultColor);
            this.activationButton.m_88315_(gg, mouseX, mouseY, delta);
            this.contextButton.m_88315_(gg, mouseX, mouseY, delta);
            this.allowExtraKeysCheckBox.m_88315_(gg, mouseX, mouseY, delta);
            this.orderSensitiveCheckBox.m_88315_(gg, mouseX, mouseY, delta);
            this.exclusiveCheckBox.m_88315_(gg, mouseX, mouseY, delta);
            this.matchByCharCheckBox.m_88315_(gg, mouseX, mouseY, delta);
            this.preventFurtherCheckBox.m_88315_(gg, mouseX, mouseY, delta);
            if (tooltip != null) {
                this.renderTooltip(tooltip, mouseX, mouseY);
            }
        }

        protected void renderTooltip(List<Component> tooltip, int mouseX, int mouseY) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof IMultiTooltipScreen) {
                IMultiTooltipScreen ts = (IMultiTooltipScreen)screen;
                ts.addTooltip(Tooltip.of(Point.of(mouseX, mouseY), tooltip));
            }
        }

        protected int getEditedTint() {
            return 0x64646424;
        }

        protected int getDefaultTint() {
            return 0x64424242;
        }

        protected MutableComponent getLabel(String translationKey) {
            return Component.m_237115_((String)("simpleconfig.keybind.setting." + translationKey));
        }

        protected List<Component> getTooltip(String translationKey) {
            return SimpleConfigTextUtil.splitTtc("simpleconfig.keybind.setting." + translationKey + ":help", new Object[0]);
        }
    }
}

