/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.api.ui.icon.AnimatedIcon;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.ui.api.IModalInputCapableScreen;
import endorh.simpleconfig.ui.api.IModalInputProcessor;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.KeyBindSettingsButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindDispatcher;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.hotkey.KeyBindMappingImpl;
import endorh.simpleconfig.ui.hotkey.Keys;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyBindButton
extends AbstractContainerEventHandler
implements IPositionableRenderable.IRectanglePositionableRenderable,
IModalInputProcessor,
NarratableEntry {
    private static int ID_GEN;
    private final int id = ID_GEN++;
    private final Supplier<IModalInputCapableScreen> screenSupplier;
    private final Supplier<IOverlayCapableContainer> container;
    private final Rectangle area = new Rectangle(0, 0, 80, 20);
    private final MultiFunctionIconButton button;
    private final KeyBindSettingsButton settingsButton;
    private final MultiFunctionIconButton cancelButton;
    private final RedirectGuiEventListener sideButtonReference;
    private Supplier<List<Component>> tooltipSupplier = null;
    protected final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    private final AnimatedIcon recordingIcon = SimpleConfigIcons.HOTKEY_RECORDING.copy();
    private final IntList keys = new IntArrayList();
    private final Int2ObjectMap<String> chars = new Int2ObjectOpenHashMap();
    private IntList startedKeys;
    private Int2ObjectMap<String> startedChars;
    private KeyBindMapping startedMapping;
    @Nullable
    private ExtendedKeyBindImpl keyBind;
    private boolean reportOverlaps = true;
    private final List<ExtendedKeyBindImpl> overlaps = new ArrayList<ExtendedKeyBindImpl>();
    private int overlapTicks = 0;
    private boolean capturingInput = false;
    private boolean error = false;
    private Style hotKeyStyle = Style.f_131099_;
    private Style conflictStyle = Style.f_131099_.m_131157_(ChatFormatting.GOLD);
    private Style errorStyle = Style.f_131099_.m_131157_(ChatFormatting.RED);
    private Style recordStyle = Style.f_131099_.m_131157_(ChatFormatting.YELLOW);
    private int idleTint;

    public static KeyBindButton of(Supplier<IModalInputCapableScreen> screen, Supplier<IOverlayCapableContainer> container) {
        return KeyBindButton.of(screen, container, null);
    }

    public static KeyBindButton of(Supplier<IModalInputCapableScreen> screen, Supplier<IOverlayCapableContainer> container, @Nullable ExtendedKeyBindImpl keyBind) {
        return new KeyBindButton(screen, container, keyBind);
    }

    public KeyBindButton(Supplier<IModalInputCapableScreen> screenSupplier, Supplier<IOverlayCapableContainer> container, @Nullable ExtendedKeyBindImpl keyBind) {
        this.container = container;
        this.screenSupplier = screenSupplier;
        this.keyBind = keyBind;
        this.button = MultiFunctionIconButton.of(Icon.EMPTY, MultiFunctionImageButton.ButtonAction.of(this::startKeyInput).title(this::getDisplayedText).tooltip(this::getTooltipLines));
        this.idleTint = this.button.defaultTint;
        this.settingsButton = new KeyBindSettingsButton(this::getOverlayContainer);
        this.settingsButton.setParentRectangle(this.getArea());
        this.settingsButton.setListener(s -> this.updateKeyBind());
        this.cancelButton = MultiFunctionIconButton.of(SimpleConfigIcons.Entries.CLOSE_X, MultiFunctionImageButton.ButtonAction.of(this::cancelModalInputProcessing));
        this.cancelButton.setExactWidth(20);
        this.sideButtonReference = new RedirectGuiEventListener((GuiEventListener)this.settingsButton);
        if (keyBind != null) {
            this.setMapping(keyBind.getDefinition());
        }
        this.updateOverlaps();
        Stream.of(new GuiEventListener[]{this.button, this.sideButtonReference, this.settingsButton.getOverlayReference()}).forEach(x$0 -> this.listeners.add((GuiEventListener)x$0));
    }

    public IModalInputCapableScreen getScreen() {
        return this.screenSupplier.get();
    }

    public IOverlayCapableContainer getOverlayContainer() {
        return this.container.get();
    }

    @Nullable
    public ExtendedKeyBind getKeyBind() {
        return this.keyBind;
    }

    public void setKeyBind(@Nullable ExtendedKeyBindImpl keyBind) {
        this.keyBind = keyBind;
        this.updateKeyBind();
        this.updateOverlaps();
    }

    protected void updateKeyBind() {
        if (this.keyBind != null) {
            this.keyBind.setCandidateDefinition(this.getMapping());
        }
    }

    public boolean isReportOverlaps() {
        return this.reportOverlaps;
    }

    public void setReportOverlaps(boolean reportOverlaps) {
        this.reportOverlaps = reportOverlaps;
    }

    public void setTooltip(Supplier<List<Component>> tooltip) {
        this.tooltipSupplier = tooltip;
    }

    public void setTooltip(List<Component> tooltip) {
        this.setTooltip(() -> tooltip);
    }

    @Override
    public Rectangle getArea() {
        return this.area;
    }

    @NotNull
    public List<GuiEventListener> m_6702_() {
        return this.listeners;
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean m_142518_() {
        return this.button.f_93623_;
    }

    @Override
    public void setActive(boolean active) {
        this.button.f_93623_ = active;
        this.settingsButton.f_93623_ = active;
    }

    public boolean m_93696_() {
        return super.m_93696_();
    }

    public void m_93692_(boolean focused) {
        this.m_7522_(focused && !this.listeners.isEmpty() ? this.listeners.get(0) : null);
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent e) {
        return super.m_264064_(e);
    }

    public KeyBindMapping getMapping() {
        ExtendedKeyBindSettings settings = this.getSettings();
        return new KeyBindMappingImpl(this.keys, settings.matchByChar() ? this.chars : null, settings);
    }

    public void setMapping(KeyBindMapping mapping) {
        this.keys.clear();
        IntList keys = mapping.getRequiredKeys();
        this.keys.addAll(keys);
        this.chars.clear();
        Int2ObjectMap<String> chars = mapping.getCharMap();
        if (chars != null) {
            this.chars.putAll(chars);
        }
        this.settingsButton.applySettings(mapping.getSettings());
        this.updateKeyBind();
        this.updateKeys();
        this.updateOverlaps();
    }

    public ExtendedKeyBindSettings getSettings() {
        return this.settingsButton.getSettings();
    }

    public void setSettings(ExtendedKeyBindSettings settings) {
        this.settingsButton.applySettings(settings);
        this.updateKeyBind();
        this.updateOverlaps();
    }

    public ExtendedKeyBindSettings getDefaultSettings() {
        return this.settingsButton.getDefaultSettings();
    }

    public void setDefaultSettings(ExtendedKeyBindSettings settings) {
        this.settingsButton.setDefaultSettings(settings);
    }

    public void updateKeys() {
        ExtendedKeyBindSettings settings = this.settingsButton.getSettings();
        if (settings.matchByChar()) {
            IntListIterator iter = this.keys.listIterator();
            int unmatched = Keys.FIRST_UNASSIGNED_KEY;
            while (iter.hasNext()) {
                int k = (Integer)iter.next();
                if (!this.chars.containsKey(k)) continue;
                String ch = (String)this.chars.remove(k);
                int kk = Keys.getKeyFromChar(ch);
                if (kk == -1) {
                    kk = unmatched--;
                }
                iter.set(kk);
                this.chars.put(kk, (Object)ch);
            }
        } else {
            this.chars.clear();
            IntListIterator intListIterator = this.keys.iterator();
            while (intListIterator.hasNext()) {
                int k = (Integer)intListIterator.next();
                String ch = Keys.getCharFromKey(k);
                if (ch == null) continue;
                this.chars.put(k, (Object)ch);
            }
        }
    }

    public void updateOverlaps() {
        this.overlaps.clear();
        if (this.reportOverlaps) {
            if (this.keyBind != null) {
                this.overlaps.addAll(ExtendedKeyBindDispatcher.INSTANCE.getOverlaps(this.keyBind));
            } else {
                this.overlaps.addAll(ExtendedKeyBindDispatcher.INSTANCE.getOverlaps(this.getMapping()));
            }
        }
    }

    public void tick() {
        if ((++this.overlapTicks + this.id) % 20 == 0) {
            this.updateOverlaps();
        }
    }

    public void startKeyInput() {
        this.capturingInput = true;
        this.getScreen().claimModalInput(this);
        this.sideButtonReference.setTarget((GuiEventListener)this.cancelButton);
        this.startedKeys = new IntArrayList();
        this.startedChars = new Int2ObjectOpenHashMap();
        this.startedMapping = new KeyBindMappingImpl(this.startedKeys, this.startedChars, this.getSettings());
        this.recordingIcon.reset();
        this.button.setDefaultIcon(this.recordingIcon);
        this.button.setTintColor(-2136980926);
    }

    public boolean isCapturingModalInput() {
        return this.capturingInput;
    }

    @Override
    public boolean modalKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.commitInput();
            return false;
        }
        int key = Keys.getKeyFromInput(keyCode, scanCode);
        if (this.startedKeys.contains(key)) {
            return true;
        }
        this.startedKeys.add(key);
        String ch = Keys.getCharFromKey(key);
        if (ch != null) {
            this.startedChars.put(key, (Object)ch);
        }
        return true;
    }

    @Override
    public boolean modalMouseClicked(double mouseX, double mouseY, int button) {
        if (this.cancelButton.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (ClientConfig.advanced.commit_keybind_on_click_outside && !this.m_5953_(mouseX, mouseY)) {
            this.commitInput();
            return false;
        }
        int k = Keys.getKeyFromMouseInput(button);
        if (!this.startedKeys.contains(k)) {
            this.startedKeys.add(k);
        }
        return true;
    }

    @Override
    public boolean modalMouseScrolled(double mouseX, double mouseY, double amount) {
        int k = Keys.getKeyFromScroll(amount);
        int other = Keys.getKeyFromScroll(-amount);
        if (this.startedKeys.contains(other)) {
            this.startedKeys.removeInt(other);
        }
        if (!this.startedKeys.contains(k)) {
            this.startedKeys.add(k);
        }
        return true;
    }

    @Override
    public boolean shouldConsumeModalClicks(double mouseX, double mouseY, int button) {
        return ClientConfig.advanced.commit_keybind_on_click_outside || this.m_5953_(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    protected void commitInput() {
        if (this.startedKeys != null) {
            this.keys.clear();
            this.keys.addAll(this.startedKeys);
            this.chars.clear();
            if (this.startedChars != null) {
                this.chars.putAll(this.startedChars);
            }
            this.updateKeyBind();
            this.updateOverlaps();
        }
    }

    @Override
    public void cancelModalInputProcessing() {
        this.startedKeys = null;
        this.startedChars = null;
        this.startedMapping = null;
        this.capturingInput = false;
        this.sideButtonReference.setTarget((GuiEventListener)this.settingsButton);
        this.button.setDefaultIcon(Icon.EMPTY);
        this.button.setTintColor(this.idleTint);
    }

    protected Style getHotKeyStyle() {
        return this.isError() ? this.errorStyle : (this.hasOverlaps() ? this.conflictStyle : this.hotKeyStyle);
    }

    public Component getDisplayedText() {
        if (this.isCapturingModalInput()) {
            if (this.startedKeys.isEmpty()) {
                return Component.m_237113_((String)">  <").m_130948_(this.recordStyle);
            }
            return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"> ").m_130948_(this.recordStyle)).m_7220_(this.startedMapping.getDisplayName()).m_7220_((Component)Component.m_237113_((String)" <").m_130948_(this.recordStyle));
        }
        KeyBindMapping mapping = this.getMapping();
        return mapping.isUnset() ? Component.m_237115_((String)"key.abbrev.unset").m_130940_(ChatFormatting.GRAY) : mapping.getDisplayName(this.getHotKeyStyle());
    }

    public List<Component> getTooltipLines() {
        List<Component> tooltip = null;
        if (this.tooltipSupplier != null) {
            tooltip = this.tooltipSupplier.get();
        }
        if (this.overlaps.isEmpty() || this.isCapturingModalInput()) {
            return tooltip != null ? tooltip : Collections.emptyList();
        }
        if (tooltip == null) {
            tooltip = new ArrayList<Component>();
        } else {
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        tooltip.add((Component)Component.m_237115_((String)"simpleconfig.keybind.overlaps").m_130940_(ChatFormatting.GOLD));
        this.overlaps.stream().map(o -> {
            MutableComponent title = o.getCandidateName().m_6881_();
            if (o.getModId() != null) {
                title.m_130946_(" ").m_7220_((Component)Component.m_237113_((String)("(" + SimpleConfigImpl.getModNameOrId(o.getModId()) + ")")).m_130940_(ChatFormatting.GRAY));
            }
            return title.m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_(o.getCandidateDefinition().getDisplayName(ChatFormatting.GRAY));
        }).forEach(tooltip::add);
        return tooltip;
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.button.m_264152_(this.area.x, this.area.y);
        this.button.setExactWidth(this.area.width - 22);
        int x = this.area.getMaxX() - 20;
        this.settingsButton.m_264152_(x, this.area.y);
        this.cancelButton.m_264152_(x, this.area.y);
        this.settingsButton.setWarning(!this.overlaps.isEmpty());
        this.button.m_88315_(gg, mouseX, mouseY, delta);
        if (this.isCapturingModalInput()) {
            this.cancelButton.m_88315_(gg, mouseX, mouseY, delta);
        } else {
            this.settingsButton.m_88315_(gg, mouseX, mouseY, delta);
        }
    }

    public int getExtraHeight() {
        if (!this.settingsButton.isOverlayShown()) {
            return 0;
        }
        KeyBindSettingsButton.KeyBindSettingsOverlay overlay2 = this.settingsButton.getOverlay();
        return Math.max(0, overlay2.getArea().getMaxY() - this.area.getMaxY());
    }

    public void setTintColor(int color) {
        this.button.setTintColor(color);
        this.idleTint = color;
    }

    public boolean hasOverlaps() {
        return !this.overlaps.isEmpty();
    }

    public MultiFunctionIconButton getButton() {
        return this.button;
    }

    public KeyBindSettingsButton getSettingsButton() {
        return this.settingsButton;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setHotKeyStyle(Style hotKeyStyle) {
        this.hotKeyStyle = hotKeyStyle;
    }

    public Style getConflictStyle() {
        return this.conflictStyle;
    }

    public void setConflictStyle(Style conflictStyle) {
        this.conflictStyle = conflictStyle;
    }

    public Style getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorStyle(Style errorStyle) {
        this.errorStyle = errorStyle;
    }

    public Style getRecordStyle() {
        return this.recordStyle;
    }

    public void setRecordStyle(Style recordStyle) {
        this.recordStyle = recordStyle;
    }

    public void m_142291_(@NotNull NarrationElementOutput out) {
    }
}

