/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HotKeyActionButton<T>
extends MultiFunctionIconButton {
    private final AbstractConfigField<T> entry;

    public HotKeyActionButton(AbstractConfigField<T> entry) {
        super(0, 0, 20, 20, SimpleConfigIcons.Actions.NONE, MultiFunctionImageButton.ButtonAction.of(b -> {}));
        this.actions.clear();
        this.defaultAction = MultiFunctionImageButton.ButtonAction.of(i -> {
            if (!entry.isEditingHotKeyAction()) {
                entry.getScreen().setEditedConfigHotKey(new ConfigHotKey(), null);
            }
            if (i == -1) {
                i = Screen.m_96638_() ? 1 : 0;
            }
            this.changeAction(i == 0 ? 1 : (i == 1 ? -1 : 0));
        }).tooltip(this::getTypeTooltip).build();
        this.actions.add(Pair.of((Object)MultiFunctionImageButton.Modifier.NONE, (Object)this.defaultAction));
        this.setTintColor(-2145115100);
        this.entry = entry;
    }

    protected List<Component> getTypeTooltip() {
        HotKeyActionType<T, ?> type = this.entry.getHotKeyActionType();
        return Lists.newArrayList((Object[])new Component[]{type == null ? Component.m_237115_((String)"simpleconfig.hotkey.type:help") : type.getDisplayName()});
    }

    protected AbstractConfigScreen getScreen() {
        return this.entry.getScreen();
    }

    @Nullable
    protected <V> V getNext(V current, List<V> values, boolean forward) {
        if (values.isEmpty()) {
            return null;
        }
        int index = values.indexOf(current);
        int size = values.size();
        if (index == -1) {
            return values.get(forward ? 0 : size - 1);
        }
        int next = (size + 1 + index + (forward ? 1 : -1)) % (size + 1);
        return next == size ? null : (V)values.get(next);
    }

    protected void changeAction(int direction) {
        if (direction != 0) {
            HotKeyActionType<T, ?> type = this.entry.getHotKeyActionType();
            List<HotKeyActionType<T, ?>> types = this.entry.getHotKeyActionTypes();
            HotKeyActionType<T, ?> next = this.getNext(type, types, direction > 0);
            this.entry.setHotKeyActionType(next);
        } else {
            this.entry.setHotKeyActionType(null);
        }
    }

    public void tick() {
        HotKeyActionType<T, ?> type = this.entry.getHotKeyActionType();
        this.setDefaultIcon(type != null ? type.getIcon() : SimpleConfigIcons.Actions.NONE);
        this.setTintColor(type != null ? 0 : -2145115100);
    }
}

