/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.ScrollingHandler;
import endorh.simpleconfig.ui.gui.widget.DynamicElementListWidget;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.impl.EasingMethod;
import endorh.simpleconfig.ui.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicNewSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.ListEntry>
extends DynamicEntryListWidget<E> {
    protected double target;
    protected boolean smoothScrolling = true;
    protected long start;
    protected long duration;
    protected long last = 0L;
    protected DynamicEntryListWidget.ListEntry scrollTargetEntry = null;
    protected DynamicEntryListWidget.ListEntry followedEntry = null;
    protected long followEntryStart = 0L;
    protected int userOverScroll;

    protected DynamicNewSmoothScrollingEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    @Override
    public void resize(int width, int height, int top, int bottom) {
        double center = (double)(this.bottom - this.top) / 2.0;
        if (center < 0.0) {
            center = (double)(bottom - top) / 2.0;
        }
        double prevTarget = this.target + center;
        super.resize(width, height, top, bottom);
        this.scrollTo(prevTarget - (double)(this.bottom - this.top) / 2.0, false);
    }

    protected int getActualMaxScrollPosition() {
        return super.getMaxScrollPosition();
    }

    @Override
    protected int getMaxScrollPosition() {
        return Math.max(this.getActualMaxScrollPosition(), this.userOverScroll + this.bottom - this.top - 4);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void setScroll(double scroll) {
        if (!this.smoothScrolling) {
            this.scroll = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxScroll());
        } else {
            this.scroll = ScrollingHandler.clampExtension(scroll, this.getMaxScroll());
            this.target = ScrollingHandler.clampExtension(scroll, this.getMaxScroll());
        }
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.smoothScrolling) {
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.getFocusedItem() != null && this.m_7282_() && this.getFocusedItem().m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.setScroll(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.setScroll(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = Mth.m_14045_((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.setScroll(Mth.m_14008_((double)(this.getScroll() + deltaY * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (DynamicEntryListWidget.ListEntry entry : this.m_6702_()) {
            if (!entry.m_6050_(mouseX, mouseY, delta)) continue;
            return true;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -delta;
            this.scroll = Mth.m_14008_((double)delta, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.scrollBy(16.0 * -delta, Math.abs(delta) >= 1.0);
        return true;
    }

    @Override
    protected void scrollBy(int amount) {
        this.scrollBy(amount, true);
    }

    @Override
    public void scrollTo(double scroll) {
        this.scrollTo(scroll, true);
    }

    @Override
    public void scrollTo(DynamicEntryListWidget.ListEntry entry) {
        entry.expandParents();
        this.scrollTargetEntry = entry;
        this.followedEntry = null;
    }

    public void scrollBy(double value, boolean animated) {
        int maxScroll = this.getMaxScroll();
        if (value < 0.0 && this.target > (double)maxScroll) {
            this.scrollTo((double)maxScroll + value, animated);
        }
        if (value > 0.0 && this.target < 0.0) {
            this.scrollTo(value, animated);
        } else {
            this.scrollTo(this.target + value, animated);
        }
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, 200L);
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = ScrollingHandler.clampExtension(value, this.getMaxScroll());
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = ScrollingHandler.clampExtension(this.target, this.getMaxScroll(), 0.0);
            this.last = System.currentTimeMillis();
        }
        this.scrollTargetEntry = null;
    }

    public boolean isScrollingNow() {
        long t = System.currentTimeMillis();
        return t < this.start + this.duration || t < this.last + 100L;
    }

    @Override
    @Nullable
    public ComponentPath m_264435_() {
        return super.m_264435_();
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
        return super.m_264064_(e);
    }

    protected double entryScroll(DynamicEntryListWidget.ListEntry e) {
        return this.scrollFor(e.getScrollY(), e.getCaptionHeight());
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        long time = System.currentTimeMillis();
        double[] target = new double[]{this.target};
        double prev = this.scroll;
        this.userOverScroll = ClientConfig.advanced.allow_over_scroll ? Math.min(this.getActualMaxScrollPosition(), (int)this.scroll) : 0;
        int maxScroll = this.getMaxScroll();
        this.scroll = ScrollingHandler.handleScrollingPosition(target, this.scroll, Double.POSITIVE_INFINITY, delta, this.start, this.duration);
        if (this.scroll > (double)maxScroll && this.scroll > prev) {
            this.scroll = maxScroll;
        }
        if (this.scroll < 0.0 && prev > this.scroll) {
            this.scroll = 0.0;
        }
        this.target = target[0];
        if (time > this.start + this.duration) {
            if (this.scroll < 0.0 || this.scroll > (double)maxScroll) {
                this.scrollTo(this.scroll < 0.0 ? 0.0 : (double)maxScroll, true);
            } else {
                this.target = Mth.m_14008_((double)this.target, (double)0.0, (double)maxScroll);
            }
        }
        super.m_88315_(gg, mouseX, mouseY, delta);
        if (this.scrollTargetEntry != null) {
            this.followedEntry = this.scrollTargetEntry;
            this.scrollTo(this.entryScroll(this.scrollTargetEntry));
            this.followEntryStart = time;
            this.scrollTargetEntry = null;
        }
    }

    @Override
    protected void renderScrollBar(GuiGraphics gg, Tesselator tessellator, BufferBuilder buffer, int maxScroll, int sbMinX, int sbMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(gg, tessellator, buffer, maxScroll, sbMinX, sbMaxX);
        } else if (maxScroll > 0) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = Mth.m_14045_((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > (double)this.getMaxScroll() ? (double)((int)this.scroll - this.getMaxScroll()) : 0.0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bc = new Rectangle(sbMinX, minY, sbMaxX - sbMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            int tc = new Rectangle(sbMinX, minY, sbMaxX - sbMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
            Matrix4f matrix = gg.m_280168_().m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix, (float)sbMinX, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMaxX, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMaxX, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMinX, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            tessellator.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix, (float)sbMinX, (float)(minY + height), 0.0f).m_6122_(bc, bc, bc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMaxX, (float)(minY + height), 0.0f).m_6122_(bc, bc, bc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMaxX, (float)minY, 0.0f).m_6122_(bc, bc, bc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMinX, (float)minY, 0.0f).m_6122_(bc, bc, bc, 255).m_5752_();
            tessellator.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix, (float)sbMinX, (float)(minY + height - 1), 0.0f).m_6122_(tc, tc, tc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)(sbMaxX - 1), (float)(minY + height - 1), 0.0f).m_6122_(tc, tc, tc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)(sbMaxX - 1), (float)minY, 0.0f).m_6122_(tc, tc, tc, 255).m_5752_();
            buffer.m_252986_(matrix, (float)sbMinX, (float)minY, 0.0f).m_6122_(tc, tc, tc, 255).m_5752_();
            tessellator.m_85914_();
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * EasingMethod.EasingMethodImpl.CIRC.apply(amount);
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public record ListPath(@NotNull DynamicElementListWidget<?> list, @NotNull ComponentPath child) implements ComponentPath
    {
        public static ComponentPath listPath(@NotNull DynamicElementListWidget<?> list, @NotNull ComponentPath child) {
            return new ListPath(list, child);
        }

        public static ComponentPath pathAsListPath(ComponentPath.Path path) {
            ContainerEventHandler component = path.m_264222_();
            if (!(component instanceof DynamicElementListWidget)) {
                throw new IllegalArgumentException("Path component is not a DynamicElementListWidget");
            }
            return ListPath.listPath((DynamicElementListWidget)component, path.f_263808_());
        }

        @NotNull
        public GuiEventListener m_264222_() {
            return this.list;
        }

        public void m_264432_(boolean focused) {
            this.list.m_93692_(focused);
            this.child.m_264432_(focused);
            if (focused) {
                this.list.ensureFocusedVisible();
            }
        }
    }
}

