/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicEntryListWidget<E extends ListEntry>
extends AbstractContainerEventHandler
implements Renderable,
ContainerEventHandlerEx,
NarratableEntry {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected int yDrag = -2;
    protected boolean selectionVisible = false;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    @Nullable
    protected INavigableTarget selectedTarget = null;
    @Nullable
    protected INavigableTarget smallestLastTarget = null;
    protected ResourceLocation backgroundLocation;
    protected Pair<Integer, GuiEventListener> dragged = null;
    protected int extraScroll;
    protected int forcedScrollMargin = 12;
    protected int preferredScrollMargin = 60;
    protected Rectangle area = new Rectangle();
    protected ISeekableComponent focusedMatch = null;
    protected List<ISeekableComponent> matchingEntries = null;

    public DynamicEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.area.setBounds(this.left, top, this.right - this.left, bottom - top);
        this.backgroundLocation = backgroundLocation;
    }

    public void resize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.area.setBounds(this.left, top, this.right - this.left, bottom - top);
    }

    @Deprecated
    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }

    protected void setRenderHeader(boolean render, int headerHeight) {
        this.renderSelection = render;
        this.headerHeight = headerHeight;
        if (!render) {
            this.headerHeight = 0;
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public int getFieldWidth() {
        return 150;
    }

    public int getKeyFieldWidth() {
        return 120;
    }

    public E getFocusedItem() {
        return (E)((ListEntry)this.m_7222_());
    }

    @Nullable
    public E getSelectedEntry() {
        INavigableTarget target;
        for (target = this.getSelectedTarget(); !(target instanceof ListEntry) && target != null; target = target.getNavigableParent()) {
        }
        return (E)((ListEntry)target);
    }

    @Nullable
    public INavigableTarget getSelectedTarget() {
        INavigableTarget target;
        List<INavigableTarget> targets = this.getNavigableTargets(true, false);
        if (this.selectedTarget == null) {
            return null;
        }
        if (targets.contains(this.selectedTarget)) {
            return this.selectedTarget;
        }
        for (target = this.selectedTarget; target != null && (!targets.contains(target) || target.isNavigableSubTarget()); target = target.getNavigableParent()) {
        }
        return target;
    }

    @Nullable
    public INavigableTarget getSelectedSubTarget() {
        INavigableTarget target;
        List<INavigableTarget> targets = this.getNavigableTargets(true, false);
        if (this.selectedTarget == null) {
            return null;
        }
        if (targets.contains(this.selectedTarget)) {
            return this.selectedTarget;
        }
        for (target = this.selectedTarget.getNavigableParent(); target != null && !targets.contains(target); target = target.getNavigableParent()) {
        }
        if (target != null) {
            List<INavigableTarget> subTargets = target.getNavigableSubTargets();
            return this.selectedTarget.isNavigableSubTarget() && subTargets.contains(this.selectedTarget) ? this.selectedTarget : (subTargets.isEmpty() ? target : null);
        }
        return null;
    }

    public final List<E> getEntries() {
        return this.entries;
    }

    @NotNull
    public final List<E> m_6702_() {
        return Collections.unmodifiableList(this.entries);
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((ListEntry)this.m_6702_().get(index));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.m_6702_().size();
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = Mth.m_14107_((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((ListEntry)item).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)(mouseX < (double)this.getScrollBarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (ListEntry)this.m_6702_().get(itemIndex) : null);
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.area.setBounds(left, this.top, this.right - left, this.bottom - this.top);
    }

    public void setRightPos(int right) {
        this.right = right;
        this.area.setBounds(this.left, this.top, right - this.left, this.bottom - this.top);
    }

    public Rectangle getArea() {
        return this.area;
    }

    protected int getMaxScrollPosition() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.headerHeight;
        for (ListEntry entry : this.entries) {
            if (!entry.isShown()) continue;
            i += entry.getItemHeight();
            if (entry.getExtraScrollHeight() < 0) continue;
            list.add(i + entry.getExtraScrollHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) + Math.min(this.bottom - this.top, this.extraScroll);
    }

    public int getExtraScroll() {
        return this.extraScroll;
    }

    public void setExtraScroll(int extraScroll) {
        this.extraScroll = Math.max(0, extraScroll);
    }

    protected void clickedHeader(int mouseX, int mouseY) {
    }

    protected void renderHeader(GuiGraphics matrices, int rowLeft, int startY, Tesselator tessellator) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(GuiGraphics gg, int mouseX, int mouseY) {
    }

    protected void renderBackBackground(GuiGraphics gg, BufferBuilder buffer, Tesselator tessellator) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.backgroundLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = gg.m_280168_().m_85850_().m_252922_();
        int scroll = (int)this.getScroll();
        float div = 32.0f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, (float)this.bottom, 0.0f).m_7421_(0.0f, (float)(this.bottom + scroll) / div).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.width, (float)this.bottom, 0.0f).m_7421_((float)this.width / div, (float)(this.bottom + scroll) / div).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.width, (float)this.top, 0.0f).m_7421_((float)this.width / div, (float)(this.top + scroll) / div).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)this.top, 0.0f).m_7421_(0.0f, (float)(this.top + scroll) / div).m_6122_(32, 32, 32, 255).m_5752_();
        tessellator.m_85914_();
    }

    public void tick() {
        this.entries.forEach(ListEntry::tick);
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollBarPosition = this.getScrollBarPosition();
        int scrollBarEnd = scrollBarPosition + 6;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bb = tessellator.m_85915_();
        this.renderBackBackground(gg, bb, tessellator);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(gg, rowLeft, startY, tessellator);
        }
        ScissorsHandler.INSTANCE.pushScissor(new Rectangle(0, this.top, this.width, this.bottom - this.top));
        this.renderList(gg, rowLeft, startY, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.popScissor();
        RenderSystem.disableDepthTest();
        this.renderBarBackground(gg, 0, this.top, 255, 255);
        this.renderBarBackground(gg, this.bottom, this.height, 255, 255);
        this.renderScrollBar(gg, tessellator, bb, this.getMaxScroll(), scrollBarPosition, scrollBarEnd);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderTexture((int)0, (int)0);
        Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_252986_(m, 0.0f, (float)(this.top + 4), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bb.m_252986_(m, (float)this.width, (float)(this.top + 4), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bb.m_252986_(m, (float)this.width, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bb.m_252986_(m, 0.0f, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        tessellator.m_85914_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_252986_(m, 0.0f, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bb.m_252986_(m, (float)this.width, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bb.m_252986_(m, (float)this.width, (float)(this.bottom - 4), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        bb.m_252986_(m, 0.0f, (float)(this.bottom - 4), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        this.renderDecorations(gg, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void renderScrollBar(GuiGraphics gg, Tesselator tessellator, BufferBuilder bb, int maxScroll, int sbMinX, int sbMaxX) {
        if (maxScroll > 0) {
            int sbHeight = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            sbHeight = Mth.m_14045_((int)sbHeight, (int)32, (int)(this.bottom - this.top - 8));
            int sbMinY = (int)this.getScroll() * (this.bottom - this.top - sbHeight) / maxScroll + this.top;
            if (sbMinY < this.top) {
                sbMinY = this.top;
            }
            int alpha = 190;
            Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bb.m_252986_(m, (float)sbMinX, (float)this.bottom, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMaxX, (float)this.bottom, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMaxX, (float)this.top, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMinX, (float)this.top, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, alpha).m_5752_();
            tessellator.m_85914_();
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bb.m_252986_(m, (float)sbMinX, (float)(sbMinY + sbHeight), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMaxX, (float)(sbMinY + sbHeight), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMaxX, (float)sbMinY, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, alpha).m_5752_();
            bb.m_252986_(m, (float)sbMinX, (float)sbMinY, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, alpha).m_5752_();
            tessellator.m_85914_();
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bb.m_5483_((double)sbMinX, (double)(sbMinY + sbHeight - 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, alpha).m_5752_();
            bb.m_5483_((double)(sbMaxX - 1), (double)(sbMinY + sbHeight - 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, alpha).m_5752_();
            bb.m_5483_((double)(sbMaxX - 1), (double)sbMinY, 0.0).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, alpha).m_5752_();
            bb.m_5483_((double)sbMinX, (double)sbMinY, 0.0).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, alpha).m_5752_();
            tessellator.m_85914_();
        }
    }

    public void scrollTo(double scroll) {
        this.setScroll(scroll);
    }

    public double scrollFor(double y, double height) {
        double relY = y - this.scroll;
        double margin = Mth.m_14008_((double)(((double)(this.bottom - this.top) - height) / 2.0), (double)this.forcedScrollMargin, (double)this.preferredScrollMargin);
        if (relY < margin) {
            return Math.max(0.0, y - margin);
        }
        if (relY + height > (double)(this.bottom - this.top) - margin) {
            return Math.max(0.0, Math.min(y - margin, y - ((double)(this.bottom - this.top) - height - margin)));
        }
        return this.scroll;
    }

    public void scrollTo(ListEntry entry) {
        entry.expandParents();
        this.setScroll(entry.getScrollY());
    }

    public void ensureFocusedVisible() {
        int focusedTop = this.getFocusedScroll();
        int height = this.getFocusedHeight();
        int up = focusedTop - 12 - (int)this.getScroll();
        if (up < 0) {
            this.scrollBy(up);
        } else {
            int down = this.bottom - this.top - focusedTop - height - 12 + (int)this.getScroll();
            if (down < 0) {
                this.scrollBy(-down);
            }
        }
    }

    protected void scrollBy(int amount) {
        this.setScroll(this.getScroll() + (double)amount);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void setScroll(double scroll) {
        this.scroll = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollBarPosition() && mouseX < (double)(this.getScrollBarPosition() + 6);
    }

    protected int getScrollBarPosition() {
        return this.width / 2 + 124;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        E item = this.getItemAtPosition(mouseX, mouseY);
        if (item != null) {
            if (item.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)item);
                this.m_7897_(true);
                this.updateSelectedTarget();
                return true;
            }
        } else if (button == 0) {
            this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    protected void updateSelectedTarget() {
        INavigableTarget target = null;
        DynamicEntryListWidget nest = this;
        while (nest.m_7222_() instanceof ContainerEventHandler) {
            if (!((nest = (ContainerEventHandler)nest.m_7222_()) instanceof INavigableTarget)) continue;
            target = (INavigableTarget)((Object)nest);
        }
        GuiEventListener listener = nest.m_7222_();
        if (listener instanceof INavigableTarget) {
            target = (INavigableTarget)listener;
        }
        if (target != null) {
            this.setSelectedTarget(target);
        }
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.getFocusedItem() != null) {
            this.getFocusedItem().m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (ContainerEventHandlerEx.super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.setScroll(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.setScroll(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = Mth.m_14045_((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.setScroll(this.getScroll() + deltaY * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (ListEntry entry : this.entries) {
            if (!entry.m_6050_(mouseX, mouseY, delta)) continue;
            return true;
        }
        this.setScroll(this.getScroll() - delta * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96639_() && this.handleNavigationKey(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    protected boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        INavigableTarget target = this.getSelectedTarget();
        INavigableTarget subTarget = this.getSelectedSubTarget();
        if (subTarget != null && subTarget.handleNavigationKey(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (target != null && target.handleNavigationKey(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 264: {
                this.navigateEntries(1);
                return true;
            }
            case 265: {
                this.navigateEntries(-1);
                return true;
            }
            case 263: {
                INavigableTarget parent;
                if (subTarget instanceof IExpandable && ((IExpandable)((Object)subTarget)).isExpanded()) {
                    ((IExpandable)((Object)subTarget)).setExpanded(false, Screen.m_96638_());
                    this.playFeedbackTap(0.4f);
                    return true;
                }
                if (this.navigateSubEntries(-1)) {
                    return true;
                }
                if (target instanceof IExpandable && ((IExpandable)((Object)target)).isExpanded()) {
                    ((IExpandable)((Object)target)).setExpanded(false, Screen.m_96638_());
                    this.playFeedbackTap(0.4f);
                    return true;
                }
                if (subTarget == null) break;
                for (parent = subTarget.getNavigableParent(); parent != null && !(parent instanceof IExpandable); parent = parent.getNavigableParent()) {
                }
                if (parent == null) break;
                parent.navigate();
                this.playFeedbackTap(0.4f);
                return true;
            }
            case 262: {
                if (subTarget instanceof IExpandable && !((IExpandable)((Object)subTarget)).isExpanded()) {
                    ((IExpandable)((Object)subTarget)).setExpanded(true, Screen.m_96638_());
                    this.playFeedbackTap(0.4f);
                    return true;
                }
                if (this.navigateSubEntries(1)) {
                    return true;
                }
                if (!(target instanceof IExpandable) || ((IExpandable)((Object)target)).isExpanded()) break;
                ((IExpandable)((Object)target)).setExpanded(true, Screen.m_96638_());
                this.playFeedbackTap(0.4f);
                return true;
            }
        }
        return false;
    }

    private void playFeedbackTap(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)volume));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    protected void renderList(GuiGraphics gg, int startX, int startY, int mouseX, int mouseY, float delta) {
        int itemCount = this.getItemCount();
        int yy = startY + this.headerHeight;
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            if (!((ListEntry)item).isShown()) continue;
            int itemHeight = ((ListEntry)item).getItemHeight();
            int itemWidth = this.getItemWidth();
            int x = this.getRowLeft();
            this.renderItem(gg, item, renderIndex, x, yy, itemWidth, itemHeight, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && item.m_5953_((double)mouseX, (double)mouseY), delta);
            yy += ((ListEntry)item).getItemHeight();
        }
        if (yy == startY + this.headerHeight) {
            this.renderEmptyPlaceHolder(gg, mouseX, mouseY, delta);
        }
    }

    protected MutableComponent getEmptyPlaceHolder() {
        return Component.m_237115_((String)"simpleconfig.ui.no_entries");
    }

    protected void renderEmptyPlaceHolder(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        MutableComponent text = this.getEmptyPlaceHolder();
        Font font = Minecraft.m_91087_().f_91062_;
        gg.m_280653_(font, (Component)text, (this.left + this.right) / 2, (this.top + this.bottom) / 2, -257908576);
    }

    protected void renderItem(GuiGraphics matrices, E item, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        ((ListEntry)item).render(matrices, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    protected int getRowLeft() {
        return (this.left + this.right) / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int y = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            if (!((ListEntry)this.entries.get(i)).isShown()) continue;
            y += ((ListEntry)this.entries.get(i)).getItemHeight();
        }
        return y;
    }

    public int getFocusedScroll() {
        int y = this.headerHeight;
        List<E> entries2 = this.entries;
        E focused = this.getFocusedItem();
        int index = entries2.indexOf(focused);
        if (index < 0) {
            return y;
        }
        for (ListEntry entry : entries2.subList(0, index)) {
            y += entry.getItemHeight();
        }
        if (focused instanceof IExpandable) {
            y += ((IExpandable)focused).getFocusedScroll();
        }
        return y;
    }

    public int getFocusedHeight() {
        E focused = this.getFocusedItem();
        if (focused instanceof IExpandable) {
            return ((IExpandable)focused).getFocusedHeight();
        }
        if (focused != null) {
            return ((ListEntry)focused).getItemHeight();
        }
        return 24;
    }

    public boolean m_93696_() {
        return false;
    }

    protected void renderBarBackground(GuiGraphics gg, int y1, int y2, int alpha1, int alpha2) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.backgroundLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f matrix = gg.m_280168_().m_85850_().m_252922_();
        float div = 32.0f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, (float)y2, 0.0f).m_7421_(0.0f, (float)y2 / div).m_6122_(64, 64, 64, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)this.width, (float)y2, 0.0f).m_7421_((float)this.width / div, (float)y2 / div).m_6122_(64, 64, 64, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)this.width, (float)y1, 0.0f).m_7421_((float)this.width / div, (float)y1 / div).m_6122_(64, 64, 64, alpha1).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)y1, 0.0f).m_7421_(0.0f, (float)y1 / div).m_6122_(64, 64, 64, alpha1).m_5752_();
        tessellator.m_85914_();
    }

    protected E remove(int int_1) {
        ListEntry itemListWidget$Item_1 = (ListEntry)this.entries.get(int_1);
        return (E)(this.removeEntry((ListEntry)this.entries.get(int_1)) ? itemListWidget$Item_1 : null);
    }

    protected boolean removeEntry(E entry) {
        return this.entries.remove(entry);
    }

    public void m_93692_(boolean focused) {
        if (focused) {
            this.updateSelectedTarget();
        }
        super.m_93692_(focused);
    }

    public void setSelectedTarget(@Nullable INavigableTarget target) {
        if (this.smallestLastTarget == null) {
            this.smallestLastTarget = this.selectedTarget;
        } else if (this.selectedTarget != null) {
            Rectangle selectedArea = this.selectedTarget.getNavigableArea();
            Rectangle smallestArea = this.smallestLastTarget.getNavigableArea();
            if (selectedArea.width < smallestArea.width || selectedArea.horizontalIntersection(smallestArea) <= 0) {
                this.smallestLastTarget = this.selectedTarget;
            }
        }
        if (target != null) {
            INavigableTarget parent;
            for (parent = target; parent != null && parent.isNavigableSubTarget(); parent = parent.getNavigableParent()) {
            }
            if (parent != null && parent.getNavigableSubTargets().contains(target)) {
                parent.setLastSelectedNavigableSubTarget(target);
            }
        }
        this.selectedTarget = target;
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    public Pair<Integer, Integer> search(Pattern query) {
        if (this.focusedMatch != null) {
            this.focusedMatch.setFocusedMatch(false);
        }
        this.matchingEntries = this.entries.stream().flatMap(e -> e.search(query).stream()).collect(Collectors.toList());
        if (this.focusedMatch != null && !this.matchingEntries.contains(this.focusedMatch)) {
            this.focusedMatch = null;
        }
        if (this.focusedMatch == null) {
            this.changeFocusedMatch(0);
        } else {
            this.focusedMatch.setFocusedMatch(true);
        }
        return Pair.of((Object)(this.focusedMatch != null ? this.matchingEntries.indexOf(this.focusedMatch) : -1), (Object)this.matchingEntries.size());
    }

    public void changeFocusedMatch(int index) {
        if (this.matchingEntries == null || this.matchingEntries.isEmpty()) {
            this.focusedMatch = null;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_DOUBLE_TAP, (float)1.0f));
            return;
        }
        this.matchingEntries.forEach(e -> e.setFocusedMatch(false));
        this.focusedMatch = this.matchingEntries.get(index);
        this.focusedMatch.setFocusedMatch(true);
        if (this.focusedMatch instanceof INavigableTarget) {
            this.setSelectedTarget((INavigableTarget)((Object)this.focusedMatch));
        }
        this.playFeedbackTap(0.4f);
    }

    public List<INavigableTarget> getNavigableTargets(boolean onlyVisible, boolean subTargets) {
        return this.entries.stream().filter(INavigableTarget::isNavigable).flatMap(subTargets ? e -> Stream.of(Stream.of(e), e.getNavigableSubTargets().stream(), e.getNavigableDescendantsAndSubDescendants(onlyVisible).stream()).flatMap(Function.identity()) : e -> Stream.concat(Stream.of(e), e.getNavigableDescendants(onlyVisible).stream())).collect(Collectors.toList());
    }

    public void navigateEntries(int step) {
        int target;
        int i;
        if (step == 0) {
            return;
        }
        List<INavigableTarget> targets = this.getNavigableTargets(true, false);
        INavigableTarget selected = this.getSelectedTarget();
        INavigableTarget subTarget = this.getSelectedSubTarget();
        int n = i = selected != null ? targets.indexOf(selected) : -1;
        if (i == -1) {
            int n2 = i = step > 0 ? -1 : targets.size();
        }
        if ((target = Mth.m_14045_((int)(i + step), (int)0, (int)(targets.size() - 1))) != i) {
            INavigableTarget parent = targets.get(target);
            INavigableTarget t = parent;
            List<INavigableTarget> subTargets = t.getNavigableSubTargets();
            if (!subTargets.isEmpty()) {
                INavigableTarget last = t.getLastSelectedNavigableSubTarget();
                t = subTarget != null ? subTarget.selectClosestTarget(subTargets, last != null ? last : this.smallestLastTarget) : subTargets.get(0);
                parent.setLastSelectedNavigableSubTarget(t);
            }
            t.navigate();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)0.3f));
        }
    }

    public boolean navigateSubEntries(int step) {
        int target;
        int i;
        if (step == 0) {
            return false;
        }
        INavigableTarget selected = this.getSelectedTarget();
        INavigableTarget subTarget = this.getSelectedSubTarget();
        if (selected == null) {
            return false;
        }
        List<INavigableTarget> subTargets = selected.getNavigableSubTargets();
        if (subTargets.isEmpty()) {
            return false;
        }
        int n = i = subTarget != null ? subTargets.indexOf(subTarget) : -1;
        if (i == -1) {
            int n2 = i = step > 0 ? -1 : subTargets.size();
        }
        if ((target = Mth.m_14045_((int)(i + step), (int)0, (int)(subTargets.size() - 1))) != i) {
            INavigableTarget t = subTargets.get(target);
            selected.setLastSelectedNavigableSubTarget(t);
            t.navigate();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)0.3f));
            return true;
        }
        return false;
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput out) {
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int index) {
            return (ListEntry)this.items.get(index);
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int index, E entry) {
            ListEntry item = (ListEntry)this.items.set(index, entry);
            ((ListEntry)entry).setEntryList(DynamicEntryListWidget.this);
            return item;
        }

        @Override
        public void add(int index, E entry) {
            this.items.add(index, entry);
            ((ListEntry)entry).setEntryList(DynamicEntryListWidget.this);
        }

        @Override
        public E remove(int int_1) {
            return (ListEntry)this.items.remove(int_1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ListEntry
    implements ISeekableComponent,
    INavigableTarget {
        @Nullable
        private DynamicEntryListWidget<?> entryList = null;

        public boolean isShown() {
            return true;
        }

        public void tick() {
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public DynamicEntryListWidget<?> getEntryList() {
            if (this.entryList == null) {
                throw new IllegalStateException("Tried to get parent of orphan config entry of type " + this.getClass().getSimpleName() + "\nThis entry hasn't been properly initialized");
            }
            return this.entryList;
        }

        public void setEntryList(@Nullable DynamicEntryListWidget<?> parent) {
            this.entryList = parent;
        }

        protected abstract void expandParents();

        protected abstract void claimFocus();

        public abstract int getItemHeight();

        public int getCaptionHeight() {
            return 20;
        }

        public int getExtraScrollHeight() {
            return -1;
        }

        public abstract int getScrollY();
    }
}

