/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Color;
import endorh.simpleconfig.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorPickerWidget
extends AbstractWidget {
    protected int colorBg = -14408668;
    protected int colorBorder = -10197916;
    protected int colorBorderHover = -6250336;
    protected int historySize = 20;
    protected int unit = 12;
    protected int margin = 4;
    protected Color value;
    @Nullable
    protected Consumer<Color> onChange;
    protected Color initial;
    protected boolean allowAlpha = false;
    protected int paletteRows;
    protected int shownHistorySize;
    protected float lastSaturation;
    protected float lastHue;
    protected Color historyMemory;
    protected int historyPreview;
    protected List<Color> history;
    protected BrightnessSaturationControl brightnessSaturation = new BrightnessSaturationControl();
    protected HueBar hueBar = new HueBar();
    protected TransparencyBar transparencyBar = new TransparencyBar();
    protected HistoryBar historyBar = new HistoryBar();
    protected Palette palette = new Palette();
    protected List<SubWidget> subWidgets = Lists.newArrayList((Object[])new SubWidget[]{this.hueBar, this.brightnessSaturation, this.transparencyBar, this.historyBar, this.palette});
    protected SubWidget lastClicked;
    protected boolean isDragging = false;

    public ColorPickerWidget(Color initial, int x, int y, @Nullable Consumer<Color> onChange) {
        this(initial, x, y, 142, 84, onChange);
    }

    public ColorPickerWidget(Color initial, int x, int y, int width, int height, @Nullable Consumer<Color> onChange) {
        super(x, y, width, height, GameNarrator.f_93310_);
        this.initial = initial;
        this.value = initial;
        this.onChange = onChange;
        this.lastHue = initial.getHue();
        this.lastSaturation = initial.getSaturation();
        this.history = new ArrayList<Color>();
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color value) {
        this.setValue(value, false);
    }

    public void setValue(Color value, boolean suppressUpdate) {
        this.value = value;
        this.lastHue = value.getHue();
        this.lastSaturation = value.getSaturation();
        if (!suppressUpdate) {
            this.onChange();
        }
    }

    protected void updateValue(Color value) {
        this.value = value;
        this.onChange();
    }

    public Color getInitial() {
        return this.initial;
    }

    public void setInitial(Color initial) {
        this.initial = initial;
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.palette.x = this.m_252754_() + this.f_93618_ - 2 * (this.unit + this.margin) - this.margin - 1;
        this.palette.y = this.m_252907_() + this.margin;
        this.palette.w = 2 * (this.unit + this.margin);
        this.palette.h = this.f_93619_ - 2 * this.margin;
        if (this.allowAlpha) {
            this.transparencyBar.x = this.palette.x - this.unit - this.margin;
            this.transparencyBar.y = this.palette.y;
            this.transparencyBar.w = this.unit;
            this.transparencyBar.h = this.palette.h - this.unit - this.margin;
            this.hueBar.x = this.transparencyBar.x - this.unit - this.margin;
            this.hueBar.y = this.palette.y;
            this.hueBar.w = this.unit;
            this.hueBar.h = this.transparencyBar.h;
        } else {
            this.hueBar.x = this.palette.x - this.unit - this.margin;
            this.hueBar.y = this.palette.y;
            this.hueBar.w = this.unit;
            this.hueBar.h = this.palette.h - this.unit - this.margin;
        }
        this.brightnessSaturation.x = this.m_252754_() + this.margin;
        this.brightnessSaturation.y = this.palette.y;
        this.brightnessSaturation.w = this.hueBar.x - this.margin - this.brightnessSaturation.x;
        this.brightnessSaturation.h = this.hueBar.h;
        this.historyBar.x = this.m_252754_() + this.margin;
        this.historyBar.y = this.m_252907_() + this.f_93619_ - this.unit - this.margin;
        this.historyBar.w = this.palette.x - this.margin - this.historyBar.x;
        this.historyBar.h = this.unit;
        this.drawBox(gg, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        for (SubWidget subWidget : this.subWidgets) {
            subWidget.render(gg, mouseX, mouseY);
        }
    }

    protected void drawBox(GuiGraphics gg, int x, int y, int w, int h) {
        gg.m_280509_(x, y, x + w, y + h, this.colorBorder);
        gg.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, this.colorBg);
    }

    protected boolean drawBox(GuiGraphics gg, int x, int y, int w, int h, int mX, int mY) {
        boolean hovered = mX >= x && mX < x + w && mY >= y && mY < y + h;
        gg.m_280509_(x, y, x + w, y + h, hovered ? this.colorBorderHover : this.colorBorder);
        gg.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, this.colorBg);
        return hovered;
    }

    protected List<Color> getHistory() {
        ArrayList<Color> colors2 = new ArrayList<Color>(this.history);
        while (colors2.size() < this.historySize) {
            colors2.add(0, this.initial);
        }
        return colors2;
    }

    protected List<Color> getShownHistory() {
        return this.getHistory().subList(this.historySize - this.shownHistorySize, this.historySize);
    }

    private void addToHistory(Color value) {
        while (this.history.size() >= this.historySize) {
            this.history.remove(0);
        }
        this.history.add(value);
    }

    protected void addToHistory() {
        Color value = this.value;
        if (this.historyMemory != null) {
            if (this.historyPreview >= 0 && this.historyPreview < this.history.size()) {
                Color preview = this.getHistory().get(this.historyPreview);
                this.history.remove(this.historyPreview);
                while (this.history.size() >= this.historySize - 1) {
                    this.history.remove(0);
                }
                this.history.add(this.historyMemory);
                this.history.add(preview);
            } else {
                this.addToHistory(this.historyMemory);
                if (this.historyPreview != -3 && this.historyPreview != -2) {
                    this.addToHistory(value);
                }
            }
            this.historyMemory = null;
        } else {
            this.addToHistory(value);
        }
    }

    public void allowAlpha(boolean alpha) {
        this.allowAlpha = alpha;
        if (alpha && !this.subWidgets.contains(this.transparencyBar)) {
            this.subWidgets.add(this.transparencyBar);
        }
        if (!alpha) {
            this.updateValue(Color.ofOpaque(this.value.getColor()));
            this.subWidgets.remove(this.transparencyBar);
        }
    }

    protected void onChange() {
        if (this.onChange != null) {
            this.onChange.accept(this.value);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.m_252754_() || mouseX >= (double)(this.m_252754_() + this.f_93618_) || mouseY < (double)this.m_252907_() || mouseY >= (double)(this.m_252907_() + this.f_93619_)) {
            return false;
        }
        for (SubWidget subWidget : this.subWidgets) {
            if (!subWidget.isMouseOver((int)Math.round(mouseX), (int)Math.round(mouseY)) || !subWidget.onClick(mouseX, mouseY, button)) continue;
            this.lastClicked = subWidget;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.lastClicked != null) {
            this.lastClicked.onDrag(mouseX, mouseY, dragX, dragY);
        }
    }

    public boolean m_93696_() {
        return false;
    }

    public void m_93692_(boolean pFocused) {
    }

    protected void m_168797_(NarrationElementOutput out) {
    }

    public class BrightnessSaturationControl
    extends SubWidget {
        @Override
        public void render(GuiGraphics gg, int mX, int mY) {
            ColorPickerWidget.this.drawBox(gg, this.x - 1, this.y - 1, this.w + 2, this.h + 2, mX, mY);
            PoseStack mStack = gg.m_280168_();
            mStack.m_85836_();
            mStack.m_85837_((double)this.x, (double)this.y, 0.0);
            mStack.m_85836_();
            mStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            gg.m_280024_(-this.h, 0, 0, this.w, -1, Color.ofHSB(ColorPickerWidget.this.lastHue, 1.0f, 1.0f).getOpaque());
            mStack.m_85849_();
            gg.m_280024_(0, 0, this.w, this.h, 0, -16777216);
            int cX = (int)(ColorPickerWidget.this.lastSaturation * (float)(this.w - 1)) - 5;
            int cY = (int)((1.0f - ColorPickerWidget.this.value.getBrightness()) * (float)(this.h - 1)) - 5;
            SimpleConfigIcons.ColorPicker.POINTER.renderCentered(gg, cX, cY, 11, 11, this.isMouseOver(mX, mY) ? 1 : 0);
            mStack.m_85849_();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ColorPickerWidget.this.addToHistory();
                if (ColorPickerWidget.this.lastHue != 1.0f || ColorPickerWidget.this.value.getHue() != 0.0f) {
                    ColorPickerWidget.this.lastHue = ColorPickerWidget.this.value.getHue();
                }
                this.dragBrightnessSaturation(mouseX, mouseY);
                return true;
            }
            return false;
        }

        @Override
        public void onDrag(double mX, double mY, double dragX, double dragY) {
            this.dragBrightnessSaturation(mX, mY);
        }

        protected void dragBrightnessSaturation(double mouseX, double mouseY) {
            float s = ColorPickerWidget.this.lastSaturation = Mth.m_14036_((float)((float)((mouseX - (double)this.x) / (double)(this.w - 1))), (float)0.0f, (float)1.0f);
            float b = 1.0f - Mth.m_14036_((float)((float)((mouseY - (double)this.y) / (double)(this.h - 1))), (float)0.0f, (float)1.0f);
            ColorPickerWidget.this.updateValue(Color.ofHSBA(ColorPickerWidget.this.lastHue, s, b, ColorPickerWidget.this.value.getAlpha()));
        }
    }

    public class HueBar
    extends SubWidget {
        @Override
        public void render(GuiGraphics gg, int mX, int mY) {
            ColorPickerWidget.this.drawBox(gg, this.x - 1, this.y - 1, this.w + 2, this.h + 2, mX, mY);
            PoseStack mStack = gg.m_280168_();
            mStack.m_85836_();
            mStack.m_85837_((double)this.x, (double)this.y, 0.0);
            if (this.w > this.h) {
                mStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                mStack.m_85837_((double)(-this.h), 0.0, 0.0);
                this.w += this.h;
                this.h = this.w - this.h;
                this.w -= this.h;
            }
            gg.m_280024_(0, 0, this.w, this.h / 6, -65536, -256);
            gg.m_280024_(0, this.h / 6, this.w, 2 * this.h / 6, -256, -16711936);
            gg.m_280024_(0, 2 * this.h / 6, this.w, 3 * this.h / 6, -16711936, -16711681);
            gg.m_280024_(0, 3 * this.h / 6, this.w, 4 * this.h / 6, -16711681, -16776961);
            gg.m_280024_(0, 4 * this.h / 6, this.w, 5 * this.h / 6, -16776961, -65281);
            gg.m_280024_(0, 5 * this.h / 6, this.w, this.h, -65281, -65536);
            int level = this.isMouseOver(mX, mY) ? 1 : 0;
            int aY = (int)(ColorPickerWidget.this.lastHue * (float)(this.h - 1)) - 3;
            SimpleConfigIcons.ColorPicker.ARROW_RIGHT.renderCentered(gg, -1, aY, 5, 7, level);
            SimpleConfigIcons.ColorPicker.ARROW_LEFT.renderCentered(gg, this.w - 4, aY, 5, 7, level);
            mStack.m_85849_();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ColorPickerWidget.this.addToHistory();
                this.dragHue(mouseX, mouseY);
                return true;
            }
            return false;
        }

        @Override
        public void onDrag(double mX, double mY, double dragX, double dragY) {
            this.dragHue(mX, mY);
        }

        protected void dragHue(double mouseX, double mouseY) {
            float h = ColorPickerWidget.this.lastHue = Mth.m_14036_((float)((float)((mouseY - (double)this.y) / (double)(this.h - 1))), (float)0.0f, (float)1.0f);
            ColorPickerWidget.this.updateValue(Color.ofHSBA(h, ColorPickerWidget.this.value.getSaturation(), ColorPickerWidget.this.value.getBrightness(), ColorPickerWidget.this.value.getAlpha()));
        }
    }

    public class TransparencyBar
    extends SubWidget {
        @Override
        public void render(GuiGraphics gg, int mX, int mY) {
            ColorPickerWidget.this.drawBox(gg, this.x - 1, this.y - 1, this.w + 2, this.h + 2, mX, mY);
            SimpleConfigIcons.ColorPicker.CHESS_BOARD.renderFill(gg, this.x, this.y, this.w, this.h);
            PoseStack mStack = gg.m_280168_();
            mStack.m_85836_();
            mStack.m_85837_((double)this.x, (double)this.y, 0.0);
            if (this.w > this.h) {
                mStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                mStack.m_85837_(0.0, (double)(-this.w), 0.0);
                this.w += this.h;
                this.h = this.w - this.h;
                this.w -= this.h;
            }
            gg.m_280024_(0, 0, this.w, this.h, ColorPickerWidget.this.value.getOpaque(), ColorPickerWidget.this.value.getColor() & 0xFFFFFF);
            int level = this.isMouseOver(mX, mY) ? 1 : 0;
            int aY = (int)((float)(255 - ColorPickerWidget.this.value.getAlpha()) / 255.0f * (float)(this.h - 1)) - 3;
            SimpleConfigIcons.ColorPicker.ARROW_RIGHT.renderCentered(gg, -1, aY, 5, 7, level);
            SimpleConfigIcons.ColorPicker.ARROW_LEFT.renderCentered(gg, this.w - 4, aY, 5, 7, level);
            mStack.m_85849_();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ColorPickerWidget.this.addToHistory();
                this.dragTransparency(mouseX, mouseY);
                return true;
            }
            return false;
        }

        @Override
        public void onDrag(double mX, double mY, double dragX, double dragY) {
            this.dragTransparency(mX, mY);
        }

        protected void dragTransparency(double mouseX, double mouseY) {
            float a = 1.0f - Mth.m_14036_((float)((float)((mouseY - (double)this.y) / (double)(this.h - 1))), (float)0.0f, (float)1.0f);
            ColorPickerWidget.this.updateValue(Color.ofTransparent(ColorPickerWidget.this.value.getColor() & 0xFFFFFF | Math.round(a * 255.0f) << 24));
        }
    }

    public class HistoryBar
    extends SubWidget {
        @Override
        public void render(GuiGraphics gg, int mX, int mY) {
            boolean hovered = ColorPickerWidget.this.drawBox(gg, this.x - 1, this.y - 1, this.w + 2, this.h + 2, mX, mY);
            SimpleConfigIcons.ColorPicker.CHESS_BOARD.renderFill(gg, this.x, this.y, this.w, this.h);
            PoseStack mStack = gg.m_280168_();
            mStack.m_85836_();
            mStack.m_85837_((double)this.x, (double)this.y, 0.0);
            if (this.w < this.h) {
                mStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                mStack.m_85837_(0.0, (double)this.w, 0.0);
            }
            ColorPickerWidget.this.shownHistorySize = Math.min(ColorPickerWidget.this.historySize, Math.max(0, this.w / this.h - 2));
            int n = ColorPickerWidget.this.shownHistorySize + 2;
            List<Color> history = ColorPickerWidget.this.getShownHistory();
            Function<Color, Integer> toInt = ColorPickerWidget.this.allowAlpha ? Color::getColor : Color::getOpaque;
            for (int i = 0; i < ColorPickerWidget.this.shownHistorySize; ++i) {
                gg.m_280509_(i * this.w / n, 0, (i + 1) * this.w / n, this.h, toInt.apply(history.get(i)).intValue());
            }
            gg.m_280509_((n - 2) * this.w / n, 0, (n - 1) * this.w / n, this.h, toInt.apply(ColorPickerWidget.this.historyMemory != null ? ColorPickerWidget.this.historyMemory : ColorPickerWidget.this.value).intValue());
            gg.m_280509_((n - 1) * this.w / n, 0, this.w, this.h, toInt.apply(ColorPickerWidget.this.initial).intValue());
            gg.m_280509_((n - 2) * this.w / n, 0, (n - 2) * this.w / n + 1, this.h, hovered ? ColorPickerWidget.this.colorBorderHover : ColorPickerWidget.this.colorBorder);
            gg.m_280509_((n - 1) * this.w / n, 0, (n - 1) * this.w / n + 1, this.h, hovered ? ColorPickerWidget.this.colorBorderHover : ColorPickerWidget.this.colorBorder);
            mStack.m_85849_();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                int index = this.hoveredHistoryIndex((int)Math.round(mouseX), (int)Math.round(mouseY));
                if (index == -3) {
                    if (ColorPickerWidget.this.historyMemory == null) {
                        ColorPickerWidget.this.historyMemory = ColorPickerWidget.this.value;
                    }
                    ColorPickerWidget.this.historyPreview = -3;
                    ColorPickerWidget.this.setValue(ColorPickerWidget.this.initial);
                    return true;
                }
                if (index == -2 && ColorPickerWidget.this.historyMemory != null) {
                    ColorPickerWidget.this.historyPreview = -2;
                    ColorPickerWidget.this.setValue(ColorPickerWidget.this.historyMemory);
                } else if (index >= 0 && index < ColorPickerWidget.this.shownHistorySize) {
                    ColorPickerWidget.this.historyPreview = ColorPickerWidget.this.historySize - ColorPickerWidget.this.shownHistorySize + index;
                    if (ColorPickerWidget.this.historyMemory == null) {
                        ColorPickerWidget.this.historyMemory = ColorPickerWidget.this.value;
                    }
                    ColorPickerWidget.this.setValue(ColorPickerWidget.this.getShownHistory().get(index));
                    return true;
                }
            }
            return false;
        }

        protected int hoveredHistoryIndex(int mouseX, int mouseY) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return -1;
            }
            int rX = mouseX - this.x;
            int n = ColorPickerWidget.this.shownHistorySize + 2;
            for (int i = 0; i < ColorPickerWidget.this.shownHistorySize; ++i) {
                if (rX < i * this.w / n || rX >= (i + 1) * this.w / n) continue;
                return i;
            }
            if (rX >= (n - 2) * this.w / n && rX < (n - 1) * this.w / n) {
                return -2;
            }
            if (rX >= (n - 1) * this.w / n && rX < n * this.w / n) {
                return -3;
            }
            return -1;
        }
    }

    public class Palette
    extends SubWidget {
        @Override
        public void render(GuiGraphics gg, int mX, int mY) {
            gg.m_280509_(this.x, this.y, this.x + 1, this.y + this.h, ColorPickerWidget.this.colorBorder);
            Map<Integer, java.awt.Color> saved_colors = ClientConfig.advanced.color_picker_saved_colors;
            ColorPickerWidget.this.paletteRows = (this.h + ColorPickerWidget.this.margin) / (ColorPickerWidget.this.unit + ColorPickerWidget.this.margin);
            for (int i = 0; i < ColorPickerWidget.this.paletteRows; ++i) {
                int rY = this.y + i * (ColorPickerWidget.this.unit + ColorPickerWidget.this.margin);
                this.drawPaletteEntry(saved_colors.get(2 * i), gg, this.x + ColorPickerWidget.this.margin + 1, rY, mX, mY);
                this.drawPaletteEntry(saved_colors.get(2 * i + 1), gg, this.x + 2 * ColorPickerWidget.this.margin + ColorPickerWidget.this.unit + 1, rY, mX, mY);
            }
        }

        protected void drawPaletteEntry(java.awt.Color color, GuiGraphics gg, int x, int y, int mX, int mY) {
            ColorPickerWidget.this.drawBox(gg, x - 1, y - 1, ColorPickerWidget.this.unit + 2, ColorPickerWidget.this.unit + 2, mX, mY);
            if (color == null) {
                SimpleConfigIcons.ColorPicker.DIAGONAL_TEXTURE.renderFill(gg, x, y, ColorPickerWidget.this.unit, ColorPickerWidget.this.unit);
            } else {
                SimpleConfigIcons.ColorPicker.CHESS_BOARD.renderFill(gg, x, y, ColorPickerWidget.this.unit, ColorPickerWidget.this.unit);
                gg.m_280509_(x, y, x + ColorPickerWidget.this.unit, y + ColorPickerWidget.this.unit, color.getRGB());
            }
        }

        @Override
        public boolean onClick(double mouseX, double mouseY, int button) {
            int index = this.hoveredPaletteEntry((int)Math.round(mouseX), (int)Math.round(mouseY));
            if (index >= 0) {
                if (button == 0) {
                    Color c = this.getColorFromPalette(index);
                    if (c != null) {
                        ColorPickerWidget.this.addToHistory();
                        ColorPickerWidget.this.setValue(c);
                    }
                    return true;
                }
                if (button == 1) {
                    this.saveColorToPalette(index, ColorPickerWidget.this.value);
                    return true;
                }
                if (button == 2) {
                    this.saveColorToPalette(index, null);
                    return true;
                }
            }
            return false;
        }

        protected int hoveredPaletteEntry(int mouseX, int mouseY) {
            int rX = mouseX - this.x - ColorPickerWidget.this.margin - 1;
            if (rX < 0 || rX % (ColorPickerWidget.this.unit + ColorPickerWidget.this.margin) > ColorPickerWidget.this.unit) {
                return -1;
            }
            int j = rX < ColorPickerWidget.this.unit + ColorPickerWidget.this.margin ? 0 : 1;
            int rY = mouseY - this.y;
            if (rY % (ColorPickerWidget.this.unit + ColorPickerWidget.this.margin) > ColorPickerWidget.this.unit) {
                return -1;
            }
            int i = rY / (ColorPickerWidget.this.unit + ColorPickerWidget.this.margin);
            return 2 * i + j;
        }

        protected Color getColorFromPalette(int index) {
            java.awt.Color c = ClientConfig.advanced.color_picker_saved_colors.get(index);
            return c != null ? Color.ofTransparent(c.getRGB()) : null;
        }

        protected void saveColorToPalette(int index, Color color) {
            if (color == null) {
                ClientConfig.advanced.color_picker_saved_colors.remove(index);
            } else {
                java.awt.Color c = new java.awt.Color(ColorPickerWidget.this.allowAlpha ? color.getColor() : color.getOpaque(), true);
                ClientConfig.advanced.color_picker_saved_colors.put(index, c);
            }
            SimpleConfigMod.CLIENT_CONFIG.set("advanced.color_picker_saved_colors", ClientConfig.advanced.color_picker_saved_colors);
        }
    }

    public static abstract class SubWidget {
        public int x = 0;
        public int y = 0;
        public int w = 0;
        public int h = 0;

        public boolean isMouseOver(int mouseX, int mouseY) {
            return this.x <= mouseX && mouseX < this.x + this.w && this.y <= mouseY && mouseY < this.y + this.h;
        }

        public abstract void render(GuiGraphics var1, int var2, int var3);

        public boolean onClick(double mouseX, double mouseY, int button) {
            return false;
        }

        public void onDrag(double mX, double mY, double dragX, double dragY) {
        }
    }
}

