/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TripleListEntry<L, M, R, LE extends AbstractConfigField<L>, ME extends AbstractConfigField<M>, RE extends AbstractConfigField<R>>
extends TooltipListEntry<Triple<L, M, R>>
implements IChildListEntry,
IEntryHolder {
    private final LE leftEntry;
    private final ME middleEntry;
    private final RE rightEntry;
    @Nullable
    protected Icon leftIcon;
    @Nullable
    protected Icon rightIcon;
    protected float leftWeight = 0.333f;
    protected float rightWeight = 0.333f;
    protected List<GuiEventListener> listeners;
    protected List<AbstractConfigField<?>> heldEntries;
    protected List<ISeekableComponent> seekableChildren;

    public TripleListEntry(Component fieldName, Triple<L, M, R> value, LE leftEntry, ME middleEntry, RE rightEntry) {
        super(fieldName);
        this.leftEntry = leftEntry;
        this.middleEntry = middleEntry;
        this.rightEntry = rightEntry;
        ((AbstractConfigField)leftEntry).setChildSubEntry(true);
        ((AbstractConfigField)middleEntry).setChildSubEntry(true);
        ((AbstractConfigField)rightEntry).setChildSubEntry(true);
        ((AbstractConfigField)leftEntry).setParentEntry(this);
        ((AbstractConfigField)middleEntry).setParentEntry(this);
        ((AbstractConfigField)rightEntry).setParentEntry(this);
        ((AbstractConfigField)leftEntry).setName("left");
        ((AbstractConfigField)middleEntry).setName("middle");
        ((AbstractConfigField)rightEntry).setName("right");
        this.setValue(value);
        this.setDisplayedValue(value);
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{leftEntry, middleEntry, rightEntry, this.sideButtonReference});
        this.heldEntries = Lists.newArrayList((Object[])new AbstractConfigField[]{leftEntry, middleEntry, rightEntry});
        this.seekableChildren = Lists.newArrayList((Object[])new ISeekableComponent[]{leftEntry, middleEntry, rightEntry});
    }

    @Override
    public Triple<L, M, R> getDisplayedValue() {
        Object left = ((AbstractConfigField)this.leftEntry).getDisplayedValue();
        Object middle = ((AbstractConfigField)this.middleEntry).getDisplayedValue();
        Object right = ((AbstractConfigField)this.rightEntry).getDisplayedValue();
        return left == null && middle == null && right == null ? null : Triple.of(left, middle, right);
    }

    @Override
    public void setDisplayedValue(Triple<L, M, R> value) {
        ((AbstractConfigField)this.leftEntry).setDisplayedValue((Object)(value == null ? null : value.getLeft()));
        ((AbstractConfigField)this.middleEntry).setDisplayedValue((Object)(value == null ? null : value.getMiddle()));
        ((AbstractConfigField)this.rightEntry).setDisplayedValue((Object)(value == null ? null : value.getRight()));
    }

    @Override
    public boolean areEqual(Triple<L, M, R> value, Triple<L, M, R> other) {
        if (value == null || other == null) {
            return value == other;
        }
        return ((AbstractConfigField)this.leftEntry).areEqual((Object)value.getLeft(), (Object)other.getLeft()) && ((AbstractConfigField)this.middleEntry).areEqual((Object)value.getMiddle(), (Object)other.getMiddle()) && ((AbstractConfigField)this.rightEntry).areEqual((Object)value.getRight(), (Object)other.getRight());
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        ((AbstractConfigField)this.leftEntry).updateFocused(isFocused && this.m_7222_() == this.leftEntry);
        ((AbstractConfigField)this.middleEntry).updateFocused(isFocused && this.m_7222_() == this.middleEntry);
        ((AbstractConfigField)this.rightEntry).updateFocused(isFocused && this.m_7222_() == this.rightEntry);
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public List<EntryError> getEntryErrors() {
        List<EntryError> errors = super.getEntryErrors();
        errors.addAll(IEntryHolder.super.getErrors());
        return errors;
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        int leftIconWidth = this.leftIcon != null ? this.leftIcon.w : 4;
        int rightIconWidth = this.rightIcon != null ? this.rightIcon.w : 4;
        int entriesWidth = w - leftIconWidth - rightIconWidth;
        int leftWidth = (int)((float)entriesWidth * this.leftWeight);
        int rightWidth = (int)((float)entriesWidth * Math.min(this.rightWeight, 1.0f - this.leftWeight));
        int middleWidth = (int)((float)entriesWidth * Math.max(0.0f, 1.0f - this.leftWeight - this.rightWeight));
        if (this.leftIcon != null) {
            this.leftIcon.renderCentered(gg, x + leftWidth, y, this.leftIcon.w, h);
        }
        if (this.rightIcon != null) {
            this.rightIcon.renderCentered(gg, x + leftWidth, y, this.rightIcon.w, h);
        }
        ((IChildListEntry)this.leftEntry).renderChild(gg, x, y, leftWidth, h, mouseX, mouseY, delta);
        ((IChildListEntry)this.middleEntry).renderChild(gg, x + leftWidth + leftIconWidth, y, middleWidth, h, mouseX, mouseY, delta);
        ((IChildListEntry)this.rightEntry).renderChild(gg, x + leftWidth + leftIconWidth + middleWidth + rightIconWidth, y, rightWidth, h, mouseX, mouseY, delta);
    }

    @Override
    public int getExtraScrollHeight() {
        return Math.max(((DynamicEntryListWidget.ListEntry)this.leftEntry).getExtraScrollHeight(), Math.max(((DynamicEntryListWidget.ListEntry)this.middleEntry).getExtraScrollHeight(), ((DynamicEntryListWidget.ListEntry)this.rightEntry).getExtraScrollHeight()));
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        ArrayList<INavigableTarget> targets = new ArrayList<INavigableTarget>();
        List<INavigableTarget> leftTargets = this.leftEntry.getNavigableSubTargets();
        if (!leftTargets.isEmpty()) {
            targets.addAll(leftTargets);
        } else {
            targets.add((INavigableTarget)this.leftEntry);
        }
        List<INavigableTarget> middleTargets = this.middleEntry.getNavigableSubTargets();
        if (!middleTargets.isEmpty()) {
            targets.addAll(middleTargets);
        } else {
            targets.add((INavigableTarget)this.middleEntry);
        }
        List<INavigableTarget> rightTargets = this.rightEntry.getNavigableSubTargets();
        if (!rightTargets.isEmpty()) {
            targets.addAll(rightTargets);
        } else {
            targets.add((INavigableTarget)this.rightEntry);
        }
        return targets;
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        return this.seekableChildren;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.listeners;
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    public LE getLeftEntry() {
        return this.leftEntry;
    }

    public ME getMiddleEntry() {
        return this.middleEntry;
    }

    public RE getRightEntry() {
        return this.rightEntry;
    }

    @Nullable
    public Icon getLeftIcon() {
        return this.leftIcon;
    }

    public void setLeftIcon(@Nullable Icon leftIcon) {
        this.leftIcon = leftIcon;
    }

    @Nullable
    public Icon getRightIcon() {
        return this.rightIcon;
    }

    public void setRightIcon(@Nullable Icon rightIcon) {
        this.rightIcon = rightIcon;
    }

    public float getLeftWeight() {
        return this.leftWeight;
    }

    public void setLeftWeight(float leftWeight) {
        this.leftWeight = leftWeight;
    }

    public float getRightWeight() {
        return this.rightWeight;
    }

    public void setRightWeight(float rightWeight) {
        this.rightWeight = rightWeight;
    }
}

