/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.SearchBarWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    @Nullable
    private Supplier<Optional<Component[]>> tooltipSupplier;
    protected String matchedTooltipText = null;
    protected EntryTag helpEntryFlag = new EntryTag(-200, null, SimpleConfigIcons.Entries.HELP, () -> this.getTooltip().map(Arrays::asList).orElse(Collections.emptyList()), null);
    protected EntryTag matchedHelpEntryFlag = new EntryTag(-200, null, SimpleConfigIcons.Entries.HELP_SEARCH_MATCH, () -> this.getTooltip().map(Arrays::asList).orElse(Collections.emptyList()), null);
    protected EntryTag errorEntryFlag = new EntryTag(-1000, null, SimpleConfigIcons.Entries.ERROR, () -> this.getErrors().stream().map(e -> e.getError().m_6881_().m_130940_(ChatFormatting.RED)).collect(Collectors.toList()), b -> {
        AbstractConfigField<?> entry;
        List<EntryError> errors = this.getErrors();
        if (!errors.isEmpty() && (entry = errors.get(0).getEntry()) != null) {
            entry.navigate();
        }
    });
    protected MultiFunctionImageButton matchedHelpButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Entries.HELP_SEARCH_MATCH, MultiFunctionImageButton.ButtonAction.of(() -> {}).active(() -> false).sound(Optional::empty).tooltip(() -> this.getTooltip().map(Arrays::asList).orElse(Collections.emptyList())).icon(() -> this.isFocusedMatch() ? SimpleConfigIcons.Entries.HELP_SEARCH_FOCUSED_MATCH : SimpleConfigIcons.Entries.HELP_SEARCH_MATCH));
    @Nullable
    private Component[] lastTooltip = null;
    protected static final Pattern NEW_LINE = Pattern.compile("\\R");

    protected TooltipListEntry(Component fieldName) {
        super(fieldName);
    }

    @Override
    public void tick() {
        super.tick();
        this.lastTooltip = this.tooltipSupplier != null ? (Component[])this.tooltipSupplier.get().map(this::decorateTooltip).orElse(null) : null;
        NavigableSet<EntryTag> tags = this.getEntryTags();
        if (this.lastTooltip != null) {
            boolean matches = this.matchesTooltipSearch();
            boolean matchedAdded = tags.contains(this.matchedHelpEntryFlag);
            if (matches && !matchedAdded) {
                tags.remove(this.helpEntryFlag);
                tags.add(this.matchedHelpEntryFlag);
            } else if (!matches) {
                if (matchedAdded) {
                    tags.remove(this.matchedHelpEntryFlag);
                }
                tags.add(this.helpEntryFlag);
            }
        } else {
            tags.remove(this.helpEntryFlag);
            tags.remove(this.matchedHelpEntryFlag);
        }
        if (this.getErrors().isEmpty()) {
            tags.remove(this.errorEntryFlag);
        } else {
            tags.add(this.errorEntryFlag);
        }
    }

    protected boolean shouldUseHelpButton() {
        return true;
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Optional<Component[]> tooltip;
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.getScreen().isShowingHelp() && this.getEntryList().getSelectedEntry() == this) {
            this.getTooltip().ifPresent(t -> this.addTooltip(Tooltip.of(Point.of(this.rowArea.x - 12, this.rowArea.getMaxY() + 12), t)));
        } else if (this.getEntryList().m_5953_(mouseX, mouseY) && this.shouldProvideTooltip(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.addTooltip(Tooltip.of(Point.of(mouseX, mouseY), this.postProcessTooltip(tooltip.get())));
        }
    }

    protected boolean shouldProvideTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        return !this.getScreen().m_7282_() && (this.isMouseOverFlags(mouseX, mouseY) || !this.shouldUseHelpButton()) && this.isMouseOverRow(mouseX, mouseY);
    }

    protected FormattedCharSequence[] postProcessTooltip(Component[] tooltip) {
        return (FormattedCharSequence[])Arrays.stream(tooltip).flatMap(c -> Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)c, (int)((float)this.getScreen().f_96543_ * ClientConfig.advanced.tooltip_max_width)).stream()).toArray(FormattedCharSequence[]::new);
    }

    public Optional<Component[]> getTooltip() {
        return Optional.ofNullable(this.lastTooltip);
    }

    protected Optional<Component[]> updateTooltip() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get().map(this::decorateTooltip);
        }
        return Optional.empty();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.flagsRectangle.contains(mouseX, mouseY)) {
            NavigableSet<EntryTag> entryTags = this.getEntryTags();
            int index = ((int)mouseX - this.flagsRectangle.x) / 14;
            if (index >= 0 && index < entryTags.size()) {
                Iterator<EntryTag> iterator = entryTags.iterator();
                EntryTag flag = null;
                for (int i = 0; i <= index; ++i) {
                    flag = iterator.next();
                }
                flag.onClick(button);
            }
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.flagsRectangle.contains(mouseX, mouseY)) {
            int index = (mouseX - this.flagsRectangle.x) / 14;
            NavigableSet<EntryTag> entryFlags = this.getEntryTags();
            if (index >= 0 && index < entryFlags.size()) {
                Iterator<EntryTag> iterator = entryFlags.iterator();
                EntryTag flag = null;
                for (int i = 0; i <= index; ++i) {
                    flag = iterator.next();
                }
                List<Component> tooltip = flag.getTooltip();
                return Optional.of((Component[])tooltip.toArray(Component[]::new));
            }
        }
        return this.getTooltip();
    }

    @Nullable
    public Supplier<Optional<Component[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    protected boolean matchesSearch() {
        return super.matchesSearch() || this.matchesTooltipSearch();
    }

    protected boolean matchesTooltipSearch() {
        return this.matchedTooltipText != null && !this.matchedTooltipText.isEmpty();
    }

    protected Component[] decorateTooltip(Component[] tooltip) {
        String tooltipText;
        int i;
        if (this.matchedTooltipText != null && !this.matchedTooltipText.isEmpty() && (i = (tooltipText = Arrays.stream(tooltip).map(x$0 -> AbstractConfigField.getUnformattedString(x$0)).collect(Collectors.joining("\n"))).indexOf(this.matchedTooltipText)) != -1) {
            int j = i + this.matchedTooltipText.length();
            ArrayList tt = Lists.newArrayList();
            Style style = Style.f_131099_.m_131157_(this.isFocusedMatch() ? ChatFormatting.GOLD : ChatFormatting.YELLOW).m_131157_(ChatFormatting.UNDERLINE);
            for (Component line : tooltip) {
                int b;
                int l = TooltipListEntry.getUnformattedString(line).length();
                int a = Mth.m_14045_((int)i, (int)0, (int)l);
                MutableComponent ln = a != (b = Mth.m_14045_((int)j, (int)0, (int)l)) ? SimpleConfigTextUtil.applyStyle(line, style, a, b) : line.m_6881_();
                tt.add(ln);
                i -= l + 1;
                j -= l + 1;
            }
            return tt.toArray(new Component[0]);
        }
        return tooltip;
    }

    @Override
    protected boolean searchSelf(Pattern query) {
        String tooltipText;
        SearchBarWidget searchBar = this.getScreen().getSearchBar();
        boolean matches = false;
        this.matchedTooltipText = null;
        if (searchBar instanceof SimpleConfigScreen.TooltipSearchBarWidget && ((SimpleConfigScreen.TooltipSearchBarWidget)searchBar).isSearchTooltips() && !(tooltipText = this.seekableTooltipString()).isEmpty()) {
            Matcher m = query.matcher(tooltipText);
            while (m.find()) {
                if (m.group().isEmpty()) continue;
                matches = true;
                this.matchedTooltipText = m.group();
                break;
            }
        }
        return super.searchSelf(query) || matches;
    }

    protected String seekableTooltipString() {
        if (this.isChildSubEntry()) {
            return "";
        }
        return this.getTooltip().map(t -> Arrays.stream(t).map(x$0 -> AbstractConfigField.getUnformattedString(x$0)).collect(Collectors.joining("\n"))).orElse("");
    }
}

