/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextListEntry
extends TooltipListEntry<Void> {
    protected Font font;
    protected int color;
    protected Supplier<Component> textSupplier;
    protected Component savedText;
    protected int savedWidth;
    protected int savedX;
    protected int savedY;
    private List<FormattedCharSequence> wrappedLines;

    @ApiStatus.Internal
    public TextListEntry(Component fieldName, Supplier<Component> textSupplier, int color) {
        super(fieldName);
        this.font = Minecraft.m_91087_().f_91062_;
        this.savedWidth = -1;
        this.savedX = -1;
        this.savedY = -1;
        this.textSupplier = textSupplier;
        this.savedText = this.getText();
        this.color = color;
        this.wrappedLines = Collections.emptyList();
    }

    @Override
    @Nullable
    public ResetButton getResetButton() {
        return null;
    }

    @Override
    public List<HotKeyActionType<Void, ?>> getHotKeyActionTypes() {
        return Collections.emptyList();
    }

    @Override
    protected boolean shouldUseHelpButton() {
        return false;
    }

    @Override
    protected void renderTitle(GuiGraphics gg, Component title, float textX, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Component text = this.getText();
        if (this.savedWidth != entryWidth || this.savedX != x || this.savedY != y || !Objects.equals(text, this.savedText)) {
            this.savedText = text;
            this.wrappedLines = this.font.m_92923_((FormattedText)text, entryWidth);
            this.savedWidth = entryWidth;
            this.savedX = x;
            this.savedY = y;
        }
        int yy = y + 4;
        int lineHeight = this.getLineHeightWithMargin();
        for (FormattedCharSequence string : this.wrappedLines) {
            gg.m_280648_(this.font, string, x, yy, this.color);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            yy += lineHeight;
        }
        Style style = this.getTextAt(mouseX, mouseY);
        AbstractConfigScreen configScreen = this.getScreen();
        if (style != null) {
            gg.m_280304_(this.font, style, mouseX, mouseY);
        }
    }

    public int getLineHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public int getLineHeightWithMargin() {
        return this.getLineHeight() + 3;
    }

    @Override
    public int getItemHeight() {
        int lh = this.getLineHeightWithMargin();
        if (this.savedWidth == -1) {
            return lh;
        }
        int lineCount = this.wrappedLines.size();
        return lineCount == 0 ? 0 : 15 + lineCount * lh;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Style style = this.getTextAt(mouseX, mouseY);
            AbstractConfigScreen configScreen = this.getScreen();
            if (configScreen.m_5561_(style)) {
                return true;
            }
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public int getFieldHeight() {
        return this.getItemHeight() - 3;
    }

    @Nullable
    private Style getTextAt(double x, double y) {
        int lineCount = this.wrappedLines.size();
        if (lineCount > 0) {
            int line;
            int textX = Mth.m_14107_((double)(x - (double)this.savedX));
            int textY = Mth.m_14107_((double)(y - 4.0 - (double)this.savedY));
            int lineHeight = this.getLineHeightWithMargin();
            if (textX >= 0 && textY >= 0 && textX <= this.savedWidth && textY < lineHeight * lineCount + lineCount && (line = textY / lineHeight) < this.wrappedLines.size()) {
                FormattedCharSequence orderedText = this.wrappedLines.get(line);
                return this.font.m_92865_().m_92338_(orderedText, textX);
            }
        }
        return null;
    }

    public Component getText() {
        Component text = this.textSupplier.get();
        if (this.matchedText == null || this.matchedText.isEmpty()) {
            return text;
        }
        String str = text.getString();
        int index = str.indexOf(this.matchedText);
        if (index == -1) {
            return text;
        }
        return SimpleConfigTextUtil.applyStyle((Component)text.m_6881_(), this.isFocusedMatch() ? ChatFormatting.GOLD : ChatFormatting.YELLOW, index, index + this.matchedText.length());
    }

    @Override
    protected List<EntryError> computeErrors() {
        return Collections.emptyList();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public int getCaptionHeight() {
        return this.getItemHeight() - 4;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return Collections.emptyList();
    }

    @Override
    public String seekableText() {
        return TextListEntry.getUnformattedString(this.getText());
    }

    @Override
    public boolean isNavigable() {
        return false;
    }
}

