/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.TextFieldWidgetEx;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class TextFieldListEntry<V>
extends TooltipListEntry<V>
implements IChildListEntry {
    protected TextFieldWidgetEx textFieldWidget;
    protected List<GuiEventListener> widgets;
    protected List<GuiEventListener> childWidgets;
    protected boolean expandable;
    private boolean expanded = false;
    protected Rectangle labelArea = new Rectangle();
    protected ToggleAnimator expandAnimator = new ToggleAnimator(250L);
    protected int maxLength;
    protected int minLength;
    private int frame = 0;
    protected TextFormatter textFormatter = TextFormatter.DEFAULT;

    @ApiStatus.Internal
    protected TextFieldListEntry(Component fieldName, V original, boolean canExpand) {
        super(fieldName);
        this.expandable = canExpand;
        this.textFieldWidget = new TextFieldWidgetEx(Minecraft.m_91087_().f_91062_, 0, 0, 150, 18, GameNarrator.f_93310_);
        this.textFieldWidget.setMaxLength(999999);
        this.textFieldWidget.setFormatter(TextFormatter.cached(this.textFormatter));
        this.setOriginal(original);
        this.setValue(original);
        this.setDisplayedValue(original);
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.textFieldWidget, this.sideButtonReference});
        this.childWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.textFieldWidget});
    }

    @Override
    public void setSubEntry(boolean isSubEntry) {
        super.setSubEntry(isSubEntry);
    }

    @Override
    public V getDisplayedValue() {
        return this.fromString(this.textFieldWidget.getValue());
    }

    @Override
    public void setDisplayedValue(V v) {
        this.textFieldWidget.setValue(this.toString(v));
    }

    public String getText() {
        return this.textFieldWidget.getValue();
    }

    @Nullable
    protected abstract V fromString(String var1);

    protected String toString(@Nullable V v) {
        return v != null ? String.valueOf(v) : "";
    }

    @Override
    public void updateFocused(boolean isFocused) {
        boolean prev = this.m_93696_();
        super.updateFocused(isFocused);
        if (!isFocused && prev) {
            this.textFieldWidget.setAnchorPos(this.textFieldWidget.getCaret());
            this.textFieldWidget.m_93692_(false);
        }
    }

    @Override
    protected void acquireFocus() {
        super.acquireFocus();
        this.textFieldWidget.moveCaretToEnd();
        this.textFieldWidget.setAnchorPos(0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.frame++ % 10 == 0) {
            this.textFieldWidget.tick();
        }
        this.textFieldWidget.setBorderColor(this.hasError() ? 0xFF8080 : 0xFFFFFF);
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        this.labelArea.setBounds(x - 15, y, entryWidth, 24);
        if (this.isExpandable()) {
            SimpleConfigIcons.Entries.TEXT_EXPAND.renderCentered(gg, x - 15, y + 5, 9, 9, (this.isExpanded() ? 1 : 0) + (this.isMouseOverLabel(mouseX, mouseY) && !this.textFieldWidget.m_5953_(mouseX, mouseY) && !this.sideButtonReference.m_5953_(mouseX, mouseY) ? 2 : 0));
        }
    }

    @Override
    protected boolean isFieldFullWidth() {
        return this.isExpanded();
    }

    @Override
    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        float p = this.expandAnimator.getEaseOut();
        int expandedX = Minecraft.m_91087_().f_91062_.m_92718_() ? fieldX : x + 14;
        this.renderChild(gg, (int)Mth.m_14179_((float)p, (float)fieldX, (float)expandedX), this.isHeadless() ? fieldY : (int)Mth.m_14179_((float)p, (float)fieldY, (float)(y + 24)), (int)Mth.m_14179_((float)p, (float)fieldWidth, (float)(this.isHeadless() ? (float)(entryWidth - 16 - this.resetButton.m_5711_()) : (float)(entryWidth - 14))), fieldHeight, mouseX, mouseY, delta);
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.textFieldWidget.setEditable(this.shouldRenderEditable());
        this.textFieldWidget.m_252865_(x + 1);
        this.textFieldWidget.m_253211_(y + 1);
        this.textFieldWidget.m_93674_(w - 2);
        this.textFieldWidget.setHeight(h - 2);
        this.textFieldWidget.m_88315_(gg, mouseX, mouseY, delta);
    }

    protected boolean isMouseOverLabel(double mouseX, double mouseY) {
        return this.labelArea.contains(mouseX, mouseY);
    }

    @Override
    public int getItemHeight() {
        return 24 + (this.isHeadless() ? 0 : (this.isSubEntry() ? (this.expanded ? 24 : 0) : (int)(this.expandAnimator.getEaseOut() * 24.0f)));
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.textFieldWidget.m_5953_(mouseX, mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    public void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            expanded = false;
        }
        if (this.expanded != expanded) {
            this.expandAnimator.setEaseOutTarget(expanded);
            this.expanded = expanded;
            if (this.isEditable()) {
                this.m_7522_((GuiEventListener)this.textFieldWidget);
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isExpandable() {
        return this.expandable && !this.isChildSubEntry();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (super.onMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isExpandable() && button == 0 && this.isMouseOverLabel(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            this.m_7222_().m_93692_(false);
            this.textFieldWidget.m_93692_(true);
            this.m_7522_((GuiEventListener)this.textFieldWidget);
            TextFieldListEntry.playFeedbackTap(1.0f);
            return true;
        }
        return false;
    }

    @Override
    public Optional<Component> getErrorMessage() {
        Optional<Component> opt = super.getErrorMessage();
        if (opt.isPresent()) {
            return opt;
        }
        if (this.getText().length() < this.minLength) {
            return Optional.of(this.minLength == 1 ? Component.m_237115_((String)"simpleconfig.config.error.string.empty") : Component.m_237110_((String)"simpleconfig.config.error.string.min_length", (Object[])new Object[]{this.minLength}));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childWidgets : this.widgets;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.textFieldWidget.setMaxLength(maxLength);
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setTextFormatter(TextFormatter textFormatter) {
        this.textFormatter = textFormatter;
        this.textFieldWidget.setFormatter(TextFormatter.cached(textFormatter));
    }

    public TextFormatter getTextFormatter() {
        return this.textFormatter;
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        if (this.isExpandable() && Screen.m_96639_()) {
            if (keyCode == 262 && !this.isExpanded()) {
                this.setExpanded(true);
                TextFieldListEntry.playFeedbackTap(1.0f);
                return true;
            }
            if (keyCode == 263 && this.isExpanded()) {
                this.setExpanded(false);
                TextFieldListEntry.playFeedbackTap(1.0f);
                return true;
            }
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public String seekableValueText() {
        return this.getText();
    }
}

