/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.TextFieldWidgetEx;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class SliderListEntry<V extends Comparable<V>>
extends TooltipListEntry<V>
implements IChildListEntry {
    protected V sliderValue;
    protected SliderWidget sliderWidget;
    protected boolean showText = false;
    protected TextFieldListEntry<V> textFieldEntry = null;
    protected V min;
    protected V max;
    protected V sliderMin;
    protected V sliderMax;
    @Nullable
    protected RangedEntryBuilder.InvertibleDouble2DoubleFunction sliderMap = null;
    protected Function<V, Component> textGetter;
    protected List<GuiEventListener> widgets;
    protected List<GuiEventListener> textWidgets;
    protected List<GuiEventListener> childWidgets;
    protected List<GuiEventListener> textChildWidgets;

    public SliderListEntry(Component fieldName, V min, V max, V value, Function<V, Component> textGetter) {
        super(fieldName);
        this.min = min;
        this.max = max;
        this.sliderMin = min;
        this.sliderMax = max;
        this.setOriginal(value);
        this.setValue(value);
        this.sliderValue = value;
        this.textGetter = textGetter;
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.sideButtonReference});
        this.textWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.sideButtonReference});
        this.childWidgets = Lists.newArrayList();
        this.textChildWidgets = Lists.newArrayList();
    }

    protected void initWidgets(SliderWidget widget, @Nullable TextFieldListEntry<V> textFieldEntry) {
        if (this.sliderWidget != null) {
            throw new IllegalStateException("initWidgets called twice");
        }
        this.sliderWidget = widget;
        this.sliderWidget.setHeight(20);
        this.sliderWidget.setValue((Comparable)this.getValue());
        this.sliderWidget.m_93666_(this.textGetter.apply(this.getDisplayedValue()));
        this.widgets.add(0, (GuiEventListener)this.sliderWidget);
        this.childWidgets.add(0, (GuiEventListener)this.sliderWidget);
        this.textFieldEntry = textFieldEntry;
        if (textFieldEntry != null) {
            textFieldEntry.setChildSubEntry(true);
            textFieldEntry.setParentEntry(this);
        }
        this.textWidgets.add(0, (GuiEventListener)textFieldEntry);
        this.textChildWidgets.add(0, (GuiEventListener)textFieldEntry);
    }

    public boolean canUseTextField() {
        return this.isEditable();
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<V, ?> type) {
        super.setHotKeyActionType(type);
        if (type != null && type != HotKeyActionTypes.ASSIGN.cast()) {
            this.setTextFieldShown(true, true);
        }
    }

    @Override
    public Object getHotKeyActionValue() {
        if (this.isTextFieldEnforced()) {
            return this.textFieldEntry.getDisplayedValue();
        }
        return super.getHotKeyActionValue();
    }

    protected boolean isTextFieldEnforced() {
        if (!this.isEditingHotKeyAction()) {
            return false;
        }
        HotKeyActionType type = this.getHotKeyActionType();
        return type != null && type != HotKeyActionTypes.ASSIGN;
    }

    public V getMin() {
        return this.min;
    }

    public void setMin(V min) {
        this.min = min;
        if (min.compareTo(this.sliderMin) > 0) {
            this.sliderMin = min;
        }
    }

    public V getMax() {
        return this.max;
    }

    public void setMax(V max) {
        this.max = max;
        if (max.compareTo(this.sliderMax) < 0) {
            this.sliderMax = max;
        }
    }

    public V getSliderMin() {
        return this.sliderMin;
    }

    public void setSliderMin(V sliderMin) {
        Object v = this.getDisplayedValue();
        this.sliderMin = this.min.compareTo(sliderMin) > 0 ? this.min : sliderMin;
        this.setDisplayedValue((V)v);
    }

    public V getSliderMax() {
        return this.sliderMax;
    }

    public void setSliderMax(V sliderMax) {
        Object v = this.getDisplayedValue();
        this.sliderMax = this.max.compareTo(sliderMax) < 0 ? this.max : sliderMax;
        this.setDisplayedValue((V)v);
    }

    @Nullable
    public RangedEntryBuilder.InvertibleDouble2DoubleFunction getSliderMap() {
        return this.sliderMap;
    }

    public void setSliderMap(@Nullable RangedEntryBuilder.InvertibleDouble2DoubleFunction sliderMap) {
        double v = this.sliderWidget.getSliderValue();
        this.sliderMap = sliderMap;
        this.sliderWidget.setSliderValue(v);
    }

    public Function<V, Component> getTextGetter() {
        return this.textGetter;
    }

    public void setTextGetter(Function<V, Component> textGetter) {
        this.textGetter = textGetter;
        this.sliderWidget.m_93666_(this.textGetter.apply((Comparable)this.getValue()));
    }

    @Override
    public V getDisplayedValue() {
        return this.sliderValue;
    }

    @Override
    public void setDisplayedValue(V value) {
        this.sliderValue = value;
        this.sliderWidget.setValue(value);
        this.sliderWidget.m_5695_();
        if (this.showText && !this.areEqual((Comparable)this.textFieldEntry.getDisplayedValue(), value)) {
            this.textFieldEntry.setDisplayedValue(value);
        }
    }

    @Override
    public Optional<Component> getErrorMessage() {
        Optional<Component> error;
        if (this.isTextFieldShown() && (error = this.textFieldEntry.getErrorMessage()).isPresent()) {
            return error;
        }
        return super.getErrorMessage();
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isTextFieldShown() ? (this.isChildSubEntry() ? this.textChildWidgets : this.textWidgets) : (this.isChildSubEntry() ? this.childWidgets : this.widgets);
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 262: {
                if (this.isTextFieldShown() || this.isChildSubEntry()) break;
                this.setTextFieldShown(true, true);
                return true;
            }
            case 263: {
                if (!this.isTextFieldShown()) break;
                this.setTextFieldShown(false, true);
                return true;
            }
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.canUseTextField() && !this.isTextFieldEnforced()) {
            SimpleConfigIcons.Entries.SLIDER_EDIT.renderCentered(gg, x - 15, y + 5, 9, 9, (this.isTextFieldShown() ? 1 : 0) + (this.entryArea.contains(mouseX, mouseY) && !this.sliderWidget.m_5953_(mouseX, mouseY) && !this.sideButtonReference.m_5953_(mouseX, mouseY) ? 2 : 0));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTextFieldShown()) {
            this.textFieldEntry.tick();
        }
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        if (!(!this.showText || this.isTextFieldEnforced() || this.canUseTextField() && this.m_7222_() == this.textFieldEntry)) {
            this.setTextFieldShown(false, false);
        }
        if (this.isTextFieldShown()) {
            Comparable value;
            this.textFieldEntry.updateFocused(this.m_93696_() && this.m_7222_() == this.textFieldEntry);
            this.textFieldEntry.setEditable(this.shouldRenderEditable());
            this.textFieldEntry.renderChild(gg, x, y, w, h, mouseX, mouseY, delta);
            if ((this.textFieldEntry.getErrorMessage().isEmpty() || this.isTextFieldEnforced()) && (value = (Comparable)this.textFieldEntry.getDisplayedValue()) != null) {
                this.setDisplayedValue((V)value);
            }
        } else {
            this.sliderWidget.f_93623_ = this.shouldRenderEditable();
            this.sliderWidget.m_252865_(x);
            this.sliderWidget.m_253211_(y);
            this.sliderWidget.m_93674_(w);
            this.sliderWidget.setHeight(h);
            this.sliderWidget.m_88315_(gg, mouseX, mouseY, delta);
        }
    }

    public boolean isTextFieldShown() {
        return this.showText;
    }

    public void setTextFieldShown(boolean show, boolean focus) {
        if (!this.canUseTextField()) {
            show = false;
        }
        if (this.isTextFieldEnforced()) {
            show = true;
        }
        this.showText = show;
        if (focus) {
            this.sideButtonReference.m_93692_(false);
        }
        if (show) {
            this.textFieldEntry.setDisplayedValue(this.getDisplayedValue());
            if (focus) {
                this.m_7522_((GuiEventListener)this.textFieldEntry);
                this.sliderWidget.m_93692_(false);
                TextFieldWidgetEx textFieldWidget = this.textFieldEntry.textFieldWidget;
                this.textFieldEntry.m_7522_((GuiEventListener)textFieldWidget);
                textFieldWidget.m_93692_(true);
                textFieldWidget.moveCaretToEnd();
                textFieldWidget.setAnchorPos(0);
            }
        } else if (focus) {
            this.m_7522_((GuiEventListener)this.sliderWidget);
            this.sliderWidget.m_93692_(true);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.showText && this.sliderWidget.m_5953_(mouseX, mouseY) && !this.m_93696_()) {
            this.preserveState();
            this.m_93692_(true);
        }
        if (super.onMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && !Screen.m_96639_() && this.canUseTextField() && this.entryArea.grow(32, 0, 0, 0).contains(mouseX, mouseY)) {
            this.setTextFieldShown(!this.isTextFieldShown(), true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(this.canUseTextField() ? SimpleConfigMod.UI_TAP : SimpleConfigMod.UI_DOUBLE_TAP), (float)1.0f));
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        GuiEventListener listener = this.m_7222_();
        if ((listener == this.sliderWidget || listener == this.textFieldEntry) && this.canUseTextField() && codePoint == ' ') {
            boolean state = Screen.m_96637_() || !Screen.m_96638_() && !this.isTextFieldShown();
            boolean change = state != this.isTextFieldShown();
            this.setTextFieldShown(state, true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(change ? SimpleConfigMod.UI_TAP : SimpleConfigMod.UI_DOUBLE_TAP), (float)1.0f));
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener listener = this.m_7222_();
        if (Screen.m_96639_()) {
            return true;
        }
        if ((listener == this.sliderWidget || listener == this.textFieldEntry) && this.canUseTextField() && keyCode == 257) {
            boolean state = Screen.m_96637_() || !Screen.m_96638_() && !this.isTextFieldShown();
            boolean change = state != this.isTextFieldShown();
            this.setTextFieldShown(state, true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(change ? SimpleConfigMod.UI_TAP : SimpleConfigMod.UI_DOUBLE_TAP), (float)1.0f));
            return true;
        }
        return super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.sliderWidget.m_5953_(mouseX, mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.sliderWidget.m_93692_(false);
        }
    }

    public abstract class SliderWidget
    extends AbstractSliderButton {
        boolean clamped;

        protected SliderWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.clamped = false;
        }

        protected void m_5695_() {
            this.m_93666_(SliderListEntry.this.textGetter.apply(SliderListEntry.this.getDisplayedValue()));
        }

        protected void m_5697_() {
            this.clamped = this.f_93577_ < 0.0 || this.f_93577_ > 1.0;
            SliderListEntry.this.sliderValue = this.getValue();
        }

        public double getStep(boolean left) {
            float step;
            float f = step = left ? -2.0f : 2.0f;
            if (Screen.m_96638_()) {
                step *= 0.25f;
            }
            if (Screen.m_96637_()) {
                step *= 4.0f;
            }
            return step / (float)(this.f_93618_ - 8);
        }

        public double applyStep(double step) {
            return Mth.m_14008_((double)(this.f_93577_ + step), (double)0.0, (double)1.0);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (SliderListEntry.this.isEditable()) {
                boolean left;
                boolean bl = left = keyCode == 263;
                if (left || keyCode == 262) {
                    double v;
                    double step = this.getStep(left);
                    this.f_93577_ = v = this.applyStep(step);
                    SliderListEntry.this.setDisplayedValue(this.getValue());
                    this.f_93577_ = v;
                    return true;
                }
            }
            return false;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return SliderListEntry.this.isEditable() && super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        protected void renderBg(@NotNull GuiGraphics gg, @NotNull Minecraft mc, int mouseX, int mouseY) {
            if (this.clamped) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            int bw = this.clamped ? 4 : 8;
            int vOffset = (this.m_198029_() ? 3 : 2) * 20;
            gg.m_280027_(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - bw)), this.m_252907_(), bw, 20, 20, 4, 200, 20, 0, vOffset);
        }

        public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            RenderSystem.setShader(GameRenderer::m_172817_);
            if (this.clamped) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.5f, (float)this.f_93625_);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            gg.m_280398_(f_263683_, this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, this.f_93618_ / 2, this.f_93619_, 256, 256);
            gg.m_280398_(f_263683_, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), 0, (float)(200 - this.f_93618_ / 2), 0.0f, this.f_93618_ / 2, this.f_93619_, 256, 256);
            this.renderBg(gg, mc, mouseX, mouseY);
            int color = this.getFGColor();
            Component message = this.m_6035_();
            if (font.m_92852_((FormattedText)message) > this.f_93618_ - 8 && !this.m_198029_()) {
                message = font.m_92854_((FormattedText)message, this.f_93618_ - 8);
            }
            FormattedCharSequence seq = (FormattedCharSequence)font.m_92923_((FormattedText)message, Integer.MAX_VALUE).get(0);
            int textWidth = font.m_92724_(seq);
            int textX = Mth.m_14045_((int)(this.m_252754_() + (this.f_93618_ - textWidth) / 2), (int)4, (int)(SliderListEntry.this.getScreen().f_96543_ - 4 - textWidth));
            gg.m_280648_(font, seq, textX, this.m_252907_() + (this.f_93619_ - 8) / 2, color | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            if (this.clamped) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        protected double getSliderValue() {
            return SliderListEntry.this.sliderMap != null ? (Double)SliderListEntry.this.sliderMap.apply(this.f_93577_) : this.f_93577_;
        }

        protected void setSliderValue(double value) {
            if (SliderListEntry.this.sliderMap != null) {
                value = SliderListEntry.this.sliderMap.inverse(value);
            }
            this.clamped = value < 0.0 || value > 1.0;
            this.f_93577_ = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }

        public abstract V getValue();

        public abstract void setValue(V var1);
    }
}

