/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.entries.IntegerListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SelectionListEntry<T>
extends TooltipListEntry<T>
implements IChildListEntry {
    protected final ImmutableList<T> values;
    protected int displayedIndex;
    protected final MultiFunctionIconButton buttonWidget;
    protected final IntegerListEntry intEntry;
    protected final RedirectGuiEventListener widgetReference;
    protected final Function<T, Component> nameProvider;
    protected final List<GuiEventListener> widgets;
    protected final List<GuiEventListener> childWidgets;
    protected SelectionButtonOverlay<T> overlay;
    protected double accumulatedScroll;
    protected long lastScrollTime = 0L;

    @ApiStatus.Internal
    public SelectionListEntry(Component fieldName, List<T> valuesList, T value, Function<T, Component> nameProvider) {
        super(fieldName);
        this.values = valuesList != null ? ImmutableList.copyOf(valuesList) : ImmutableList.of(value);
        this.displayedIndex = this.values.indexOf(value);
        if (this.displayedIndex == -1) {
            this.displayedIndex = 0;
        }
        this.setOriginal(value);
        this.setValue(value);
        this.nameProvider = nameProvider == null ? t -> Component.m_237115_((String)(t instanceof Translatable ? ((Translatable)t).getKey() : t.toString())) : nameProvider;
        this.buttonWidget = MultiFunctionIconButton.of(Icon.EMPTY, MultiFunctionImageButton.ButtonAction.of(b -> {
            if (b != 2 && !this.m_93696_()) {
                this.preserveState();
                this.m_93692_(true);
            }
            int s = this.values.size();
            if (b < 0) {
                b = 0;
            }
            if (b <= 1) {
                int step = b == 0 ^ Screen.m_96638_() ? 1 : -1;
                this.displayedIndex = (this.displayedIndex + step + s) % s;
            }
        }).title(() -> this.nameProvider.apply(this.getDisplayedValue())).active(this::shouldRenderEditable));
        this.intEntry = new IntegerListEntry((Component)Component.m_237119_(), 1);
        this.intEntry.setSubEntry(true);
        this.intEntry.setParentEntry(this);
        this.widgetReference = new RedirectGuiEventListener((GuiEventListener)this.buttonWidget);
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.widgetReference, this.sideButtonReference});
        this.childWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.widgetReference});
    }

    @Override
    public T getDisplayedValue() {
        return (T)this.values.get(this.displayedIndex);
    }

    @Override
    public void setDisplayedValue(T value) {
        int index = this.values.indexOf(value);
        if (0 <= index && index < this.values.size()) {
            this.displayedIndex = index;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isEditingHotKeyAction()) {
            this.intEntry.tick();
        }
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        HotKeyActionType type;
        if (this.isEditingHotKeyAction() && (type = this.getHotKeyActionType()) == HotKeyActionTypes.ENUM_ADD) {
            this.intEntry.shouldRenderEditable();
            this.intEntry.renderChild(gg, x, y, w, h, mouseX, mouseY, delta);
            return;
        }
        this.buttonWidget.m_252865_(x);
        this.buttonWidget.m_253211_(y);
        this.buttonWidget.setExactWidth(w);
        this.buttonWidget.setHeight(h);
        this.buttonWidget.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.buttonWidget.m_5953_(mouseX, mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.buttonWidget.m_93692_(false);
        }
        this.intEntry.updateFocused(isFocused && this.isEditingHotKeyAction() && this.getHotKeyActionType() == HotKeyActionTypes.ENUM_ADD);
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childWidgets : this.widgets;
    }

    @Override
    public String seekableValueText() {
        return SelectionListEntry.getUnformattedString(this.nameProvider.apply(this.getValue()));
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if ((button == 2 || button == 0 && Screen.m_96639_()) && this.buttonWidget.m_5953_(mouseX, mouseY) && this.isEditable()) {
            this.preserveState();
            this.m_93692_(true);
            this.m_7897_(true);
            this.setDragged((Pair<Integer, GuiEventListener>)Pair.of((Object)2, (Object)this));
            this.buttonWidget.setSuppressHoverPeek(true);
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null) {
                return false;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int width = this.values.stream().mapToInt(v -> font.m_92852_((FormattedText)this.nameProvider.apply(v)) + 8).max().orElse(60);
            width = Math.max(this.buttonWidget.m_5711_(), Math.min(width, 300));
            int x = this.buttonWidget.m_252754_() + width > screen.f_96543_ ? screen.f_96543_ - width : this.buttonWidget.m_252754_();
            Rectangle area = new Rectangle(x, this.buttonWidget.m_252907_() - this.buttonWidget.m_93694_() * (this.values.size() - 1), width, this.buttonWidget.m_93694_() * (this.values.size() * 2 - 1));
            if (this.overlay != null) {
                this.overlay.cancel();
            }
            this.overlay = new SelectionButtonOverlay(this);
            this.overlay.startAnimation();
            this.getScreen().addOverlay(area, this.overlay);
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (ClientConfig.advanced.cycle_with_scroll && this.isEditable() && this.buttonWidget.m_5953_(mouseX, mouseY)) {
            int i = this.values.indexOf(this.getDisplayedValue());
            delta /= ((Double)Minecraft.m_91087_().f_91066_.m_232122_().m_231551_()).doubleValue();
            if (Math.abs(delta = this.accumulateScroll(delta)) >= 1.0) {
                this.preserveState();
                int step = delta > 0.0 ? -((int)delta) : (int)(-delta);
                this.accumulatedScroll += (double)step;
                int ic = Mth.m_14045_((int)(i += step), (int)0, (int)(this.values.size() - 1));
                this.setDisplayedValue(this.values.get(ic));
                SelectionListEntry.playFeedbackTap(i != ic ? 0.1f : 0.5f);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected double accumulateScroll(double delta) {
        long time = System.currentTimeMillis();
        if (time - this.lastScrollTime > 250L) {
            this.accumulatedScroll = 0.0;
        }
        this.lastScrollTime = time;
        this.accumulatedScroll += delta;
        return this.accumulatedScroll;
    }

    @Override
    public void endDrag(double mouseX, double mouseY, int button) {
        Pair<Integer, GuiEventListener> dragged = this.getDragged();
        if (dragged != null && dragged.getRight() == this && (Integer)dragged.getLeft() == 2) {
            if (this.overlay != null) {
                this.overlay.commit();
            }
            this.m_7897_(false);
            this.setDragged(null);
            this.buttonWidget.setSuppressHoverPeek(false);
        } else {
            super.endDrag(mouseX, mouseY, button);
        }
    }

    public static class SelectionButtonOverlay<T>
    implements IOverlayCapableContainer.IOverlayRenderer {
        private final SelectionListEntry<T> entry;
        private int startY = -1;
        private int startIndex;
        private T lastSelected;
        private boolean cancelled = false;
        private ToggleAnimator animator = new ToggleAnimator(150L);

        public SelectionButtonOverlay(SelectionListEntry<T> entry) {
            this.entry = entry;
            this.lastSelected = entry.getDisplayedValue();
            this.startIndex = entry.values.indexOf(this.lastSelected);
            if (this.startIndex == -1) {
                this.startIndex = 0;
            }
        }

        public void startAnimation() {
            this.animator.resetTarget();
        }

        @Override
        public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
            if (this.cancelled) {
                return false;
            }
            if (this.startY == -1) {
                this.startY = mouseY;
            }
            MultiFunctionIconButton button = this.entry.buttonWidget;
            ImmutableList values = this.entry.values;
            int bh = button.m_93694_();
            if (this.animator.isInProgress()) {
                float p = this.animator.getEaseOut();
                Rectangle rect = new Rectangle(button.m_252754_(), button.m_252907_() + mouseY - this.startY - Math.round((float)(this.startIndex * bh) * p), area.width, Math.round(Mth.m_14179_((float)p, (float)bh, (float)(bh * values.size()))));
                this.renderOverlayShadow(gg, area, mouseX, mouseY, delta, rect);
                ScissorsHandler.INSTANCE.withSingleScissor(rect, () -> this.doRenderOverlay(gg, area, mouseX, mouseY, delta));
            } else {
                this.renderOverlayShadow(gg, area, mouseX, mouseY, delta, null);
                this.doRenderOverlay(gg, area, mouseX, mouseY, delta);
            }
            return true;
        }

        public void renderOverlayShadow(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta, @Nullable Rectangle overlayArea) {
            if (overlayArea == null) {
                MultiFunctionIconButton button = this.entry.buttonWidget;
                ImmutableList values = this.entry.values;
                int bh = button.m_93694_();
                int y = button.m_252907_() + mouseY - this.startY - this.startIndex * bh;
                y = Mth.m_14045_((int)y, (int)(button.m_252907_() - (values.size() - 1) * bh), (int)button.m_252907_());
                overlayArea = new Rectangle(button.m_252754_(), y, area.width, bh * values.size());
            }
            Rectangle r = overlayArea;
            ScissorsHandler.INSTANCE.withoutScissors(() -> {
                for (int i = 4; i > 0; --i) {
                    gg.m_280509_(r.x - i, r.y - i, r.getMaxX() + i, r.getMaxY() + i, (int)((float)(4 - i + 1) / 4.0f * 0.8f * 255.0f) << 24 | 0x161616);
                }
            });
        }

        public void doRenderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
            MultiFunctionIconButton button = this.entry.buttonWidget;
            ImmutableList values = this.entry.values;
            int bh = button.m_93694_();
            int y = button.m_252907_() + mouseY - this.startY - this.startIndex * bh;
            y = Mth.m_14045_((int)y, (int)(button.m_252907_() - (values.size() - 1) * bh), (int)button.m_252907_());
            int index = Mth.m_14045_((int)((button.m_252907_() - y + bh / 2) / bh), (int)0, (int)values.size());
            T prev = this.entry.getDisplayedValue();
            this.lastSelected = values.get(index);
            boolean prevFocused = button.m_93696_();
            for (Object value : values) {
                button.m_93692_(value == this.lastSelected);
                button.m_264152_(area.x, y);
                button.m_93674_(area.width);
                this.entry.setDisplayedValue(value);
                button.m_88315_(gg, -1, -1, delta);
                y += bh;
            }
            button.m_93692_(prevFocused);
            this.entry.setDisplayedValue(prev);
        }

        public T getSelected() {
            return this.lastSelected;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void commit() {
            if (this.entry.isEditable()) {
                this.entry.preserveState();
                this.entry.setDisplayedValue(this.lastSelected);
            }
            this.cancel();
        }
    }

    public static interface Translatable {
        @NotNull
        public String getKey();
    }
}

