/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.range.Range;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.ToggleImageButton;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeListEntry<V extends Comparable<V>, R extends Range<V, R>, E extends AbstractConfigField<V>>
extends TooltipListEntry<R>
implements IChildListEntry,
IEntryHolder {
    private final E minEntry;
    private final E maxEntry;
    protected Icon middleIcon;
    protected Icon comparisonIcon = SimpleConfigIcons.Entries.LESS_EQUAL;
    protected ToggleImageButton minExclusivenessButton;
    protected ToggleImageButton maxExclusivenessButton;
    protected List<GuiEventListener> listeners;
    protected List<AbstractConfigField<?>> heldEntries;
    protected List<ISeekableComponent> seekableChildren;

    public RangeListEntry(Component fieldName, R value, E minEntry, E maxEntry) {
        super(fieldName);
        this.minEntry = minEntry;
        this.maxEntry = maxEntry;
        this.minExclusivenessButton = ToggleImageButton.of(value.isExclusiveMin(), 18, this.comparisonIcon);
        this.maxExclusivenessButton = ToggleImageButton.of(value.isExclusiveMax(), 18, this.comparisonIcon);
        this.minExclusivenessButton.setHoverOverlayColor(1115717760);
        this.maxExclusivenessButton.setHoverOverlayColor(1115717760);
        ((AbstractConfigField)minEntry).setChildSubEntry(true);
        ((AbstractConfigField)maxEntry).setChildSubEntry(true);
        ((AbstractConfigField)minEntry).setParentEntry(this);
        ((AbstractConfigField)maxEntry).setParentEntry(this);
        ((AbstractConfigField)minEntry).setName("min");
        ((AbstractConfigField)maxEntry).setName("max");
        this.setValue(value);
        this.setDisplayedValue(value);
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{minEntry, this.minExclusivenessButton, this.maxExclusivenessButton, maxEntry, this.sideButtonReference});
        this.heldEntries = Lists.newArrayList((Object[])new AbstractConfigField[]{minEntry, maxEntry});
        this.seekableChildren = Lists.newArrayList((Object[])new ISeekableComponent[]{minEntry, maxEntry});
    }

    @Override
    public R getDisplayedValue() {
        Comparable left = (Comparable)((AbstractConfigField)this.minEntry).getDisplayedValue();
        Comparable right = (Comparable)((AbstractConfigField)this.maxEntry).getDisplayedValue();
        return left == null && right == null ? null : (R)((Range)this.getValue()).create(left, right, this.minExclusivenessButton.getValue(), this.maxExclusivenessButton.getValue());
    }

    @Override
    public void setDisplayedValue(R value) {
        ((AbstractConfigField)this.minEntry).setDisplayedValue(value != null ? (Object)value.getMin() : null);
        ((AbstractConfigField)this.maxEntry).setDisplayedValue(value != null ? (Object)value.getMax() : null);
        this.minExclusivenessButton.setToggle(value != null && value.isExclusiveMin());
        this.maxExclusivenessButton.setToggle(value != null && value.isExclusiveMax());
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        ((AbstractConfigField)this.minEntry).updateFocused(isFocused && this.m_7222_() == this.minEntry);
        ((AbstractConfigField)this.maxEntry).updateFocused(isFocused && this.m_7222_() == this.maxEntry);
        boolean focus1 = isFocused && this.m_7222_() == this.minExclusivenessButton;
        this.minExclusivenessButton.m_93692_(focus1);
        boolean focus = isFocused && this.m_7222_() == this.maxExclusivenessButton;
        this.maxExclusivenessButton.m_93692_(focus);
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public List<EntryError> getEntryErrors() {
        List<EntryError> errors = super.getEntryErrors();
        errors.addAll(IEntryHolder.super.getErrors());
        return errors;
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        int iconWidth = this.middleIcon != null ? this.middleIcon.w : 0;
        int buttonWidth = this.minExclusivenessButton.m_5711_();
        int centerWidth = buttonWidth * 2 + 4 + iconWidth;
        int leftWidth = (int)((double)(w - centerWidth) * 0.5);
        int rightWidth = w - centerWidth - leftWidth;
        this.minExclusivenessButton.m_252865_(x + leftWidth + 2);
        this.minExclusivenessButton.m_253211_(y + 1);
        this.maxExclusivenessButton.m_252865_(x + leftWidth + buttonWidth + 2 + iconWidth);
        this.maxExclusivenessButton.m_253211_(y + 1);
        if (this.middleIcon != null) {
            this.middleIcon.renderCentered(gg, x + leftWidth, y, this.middleIcon.w, h);
        }
        ((IChildListEntry)this.minEntry).renderChild(gg, x, y, leftWidth, h, mouseX, mouseY, delta);
        this.minExclusivenessButton.m_88315_(gg, mouseX, mouseY, delta);
        if (this.middleIcon != null) {
            this.middleIcon.renderCentered(gg, x + leftWidth + buttonWidth + 2, y, iconWidth, 20, 0);
        }
        this.maxExclusivenessButton.m_88315_(gg, mouseX, mouseY, delta);
        ((IChildListEntry)this.maxEntry).renderChild(gg, x + leftWidth + centerWidth, y, rightWidth, h, mouseX, mouseY, delta);
    }

    @Override
    public int getExtraScrollHeight() {
        return Math.max(((DynamicEntryListWidget.ListEntry)this.minEntry).getExtraScrollHeight(), ((DynamicEntryListWidget.ListEntry)this.maxEntry).getExtraScrollHeight());
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        ArrayList<INavigableTarget> targets = new ArrayList<INavigableTarget>();
        List<INavigableTarget> minTargets = this.minEntry.getNavigableSubTargets();
        if (!minTargets.isEmpty()) {
            targets.addAll(minTargets);
        } else {
            targets.add((INavigableTarget)this.minEntry);
        }
        List<INavigableTarget> maxTargets = this.maxEntry.getNavigableSubTargets();
        if (!maxTargets.isEmpty()) {
            targets.addAll(maxTargets);
        } else {
            targets.add((INavigableTarget)this.maxEntry);
        }
        return targets;
    }

    public boolean m_5534_(char chr, int modifiers) {
        ToggleImageButton button;
        GuiEventListener f = this.m_7222_();
        ToggleImageButton toggleImageButton = f == this.minEntry || f == this.minExclusivenessButton ? this.minExclusivenessButton : (button = f == this.maxEntry || f == this.maxExclusivenessButton ? this.maxExclusivenessButton : null);
        if (button != null && button.f_93623_) {
            switch (chr) {
                case '<': {
                    button.setToggle(true);
                    return true;
                }
                case '=': {
                    button.setToggle(false);
                    return true;
                }
            }
        }
        return super.m_5534_(chr, modifiers);
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        return this.seekableChildren;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.listeners;
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    public E getMinEntry() {
        return this.minEntry;
    }

    public E getMaxEntry() {
        return this.maxEntry;
    }

    public boolean isMinExclusivenessEditable() {
        return this.minExclusivenessButton.f_93623_;
    }

    public boolean isMaxExclusivenessEditable() {
        return this.maxExclusivenessButton.f_93623_;
    }

    public void setMinExclusivenessEditable(boolean editable) {
        this.minExclusivenessButton.f_93623_ = editable;
        this.minExclusivenessButton.setTint(editable ? -257901057 : 0);
    }

    public void setMaxExclusivenessEditable(boolean editable) {
        this.maxExclusivenessButton.f_93623_ = editable;
        this.maxExclusivenessButton.setTint(editable ? -257901057 : 0);
    }

    public ToggleImageButton getMinExclusivenessButton() {
        return this.minExclusivenessButton;
    }

    public ToggleImageButton getMaxExclusivenessButton() {
        return this.maxExclusivenessButton;
    }

    public void setComparisonIcon(@NotNull Icon icon) {
        this.comparisonIcon = icon;
        this.minExclusivenessButton.setIcon(icon);
        this.maxExclusivenessButton.setIcon(icon);
    }

    public void setMiddleIcon(@Nullable Icon icon) {
        this.middleIcon = icon;
    }
}

