/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairListEntry<L, R, LE extends AbstractConfigField<L>, RE extends AbstractConfigField<R>>
extends TooltipListEntry<Pair<L, R>>
implements IChildListEntry,
IEntryHolder {
    private final LE leftEntry;
    private final RE rightEntry;
    @Nullable
    protected Icon middleIcon = null;
    protected float splitPos = 0.5f;
    protected List<GuiEventListener> listeners;
    protected List<AbstractConfigField<?>> heldEntries;
    protected List<ISeekableComponent> seekableChildren;

    public PairListEntry(Component fieldName, Pair<L, R> value, LE leftEntry, RE rightEntry) {
        super(fieldName);
        this.leftEntry = leftEntry;
        this.rightEntry = rightEntry;
        ((AbstractConfigField)leftEntry).setChildSubEntry(true);
        ((AbstractConfigField)rightEntry).setChildSubEntry(true);
        ((AbstractConfigField)leftEntry).setParentEntry(this);
        ((AbstractConfigField)rightEntry).setParentEntry(this);
        ((AbstractConfigField)leftEntry).setName("left");
        ((AbstractConfigField)rightEntry).setName("right");
        this.setValue(value);
        this.setDisplayedValue(value);
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{leftEntry, rightEntry, this.sideButtonReference});
        this.heldEntries = Lists.newArrayList((Object[])new AbstractConfigField[]{leftEntry, rightEntry});
        this.seekableChildren = Lists.newArrayList((Object[])new ISeekableComponent[]{leftEntry, rightEntry});
    }

    @Override
    public Pair<L, R> getDisplayedValue() {
        Object left = ((AbstractConfigField)this.leftEntry).getDisplayedValue();
        Object right = ((AbstractConfigField)this.rightEntry).getDisplayedValue();
        return left == null && right == null ? null : Pair.of(left, right);
    }

    @Override
    public void setDisplayedValue(Pair<L, R> value) {
        ((AbstractConfigField)this.leftEntry).setDisplayedValue((Object)(value == null ? null : value.getLeft()));
        ((AbstractConfigField)this.rightEntry).setDisplayedValue((Object)(value == null ? null : value.getRight()));
    }

    @Override
    public boolean areEqual(Pair<L, R> value, Pair<L, R> other) {
        if (value == null || other == null) {
            return value == other;
        }
        return ((AbstractConfigField)this.leftEntry).areEqual((Object)value.getLeft(), (Object)other.getLeft()) && ((AbstractConfigField)this.rightEntry).areEqual((Object)value.getRight(), (Object)other.getRight());
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        ((AbstractConfigField)this.leftEntry).updateFocused(isFocused && this.m_7222_() == this.leftEntry);
        ((AbstractConfigField)this.rightEntry).updateFocused(isFocused && this.m_7222_() == this.rightEntry);
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public List<EntryError> getEntryErrors() {
        List<EntryError> errors = super.getEntryErrors();
        errors.addAll(IEntryHolder.super.getErrors());
        return errors;
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        int iconWidth = this.middleIcon != null ? this.middleIcon.w : 4;
        int leftWidth = (int)((float)(w - iconWidth) * this.splitPos);
        if (this.middleIcon != null) {
            this.middleIcon.renderCentered(gg, x + leftWidth, y, this.middleIcon.w, h);
        }
        ((IChildListEntry)this.leftEntry).renderChild(gg, x, y, leftWidth, h, mouseX, mouseY, delta);
        ((IChildListEntry)this.rightEntry).renderChild(gg, x + leftWidth + iconWidth, y, w - iconWidth - leftWidth, h, mouseX, mouseY, delta);
    }

    @Override
    public int getExtraScrollHeight() {
        return Math.max(((DynamicEntryListWidget.ListEntry)this.leftEntry).getExtraScrollHeight(), ((DynamicEntryListWidget.ListEntry)this.rightEntry).getExtraScrollHeight());
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        ArrayList<INavigableTarget> targets = new ArrayList<INavigableTarget>();
        List<INavigableTarget> leftTargets = this.leftEntry.getNavigableSubTargets();
        if (!leftTargets.isEmpty()) {
            targets.addAll(leftTargets);
        } else {
            targets.add((INavigableTarget)this.leftEntry);
        }
        List<INavigableTarget> rightTargets = this.rightEntry.getNavigableSubTargets();
        if (!rightTargets.isEmpty()) {
            targets.addAll(rightTargets);
        } else {
            targets.add((INavigableTarget)this.rightEntry);
        }
        return targets;
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        return this.seekableChildren;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.listeners;
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    public LE getLeftEntry() {
        return this.leftEntry;
    }

    public RE getRightEntry() {
        return this.rightEntry;
    }

    @Nullable
    public Icon getMiddleIcon() {
        return this.middleIcon;
    }

    public void setMiddleIcon(@Nullable Icon middleIcon) {
        this.middleIcon = middleIcon;
    }

    public float getSplitPos() {
        return this.splitPos;
    }

    public void setSplitPos(float splitPos) {
        this.splitPos = splitPos;
    }
}

