/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.AbstractListListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class NestedListListEntry<T, Inner extends AbstractConfigListEntry<T>>
extends AbstractListListEntry<T, NestedListCell<T, Inner>, NestedListListEntry<T, Inner>>
implements IEntryHolder {
    protected boolean ignoreOrder;

    public NestedListListEntry(Component fieldName, List<T> value, Function<NestedListListEntry<T, Inner>, Inner> createInner, boolean ignoreOrder) {
        super(fieldName, value, l -> new NestedListCell(l, (AbstractConfigListEntry)createInner.apply((NestedListListEntry)l)));
        this.ignoreOrder = ignoreOrder;
    }

    @Override
    public boolean areEqual(List<T> value, List<T> other) {
        Object dummy;
        if (value == null || other == null) {
            return value == other;
        }
        if (value.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (value.size() != other.size()) {
            return false;
        }
        Object Inner = dummy = !this.cells.isEmpty() ? ((NestedListCell)this.cells.get((int)0)).nestedEntry : ((NestedListCell)this.createCellWithValue(value.get((int)0))).nestedEntry;
        if (this.ignoreOrder) {
            ArrayList<T> o = new ArrayList<T>(other);
            block0: for (T t : value) {
                Iterator iter = o.iterator();
                while (iter.hasNext()) {
                    Object e = iter.next();
                    if (!((AbstractConfigField)dummy).areEqual(t, e)) continue;
                    iter.remove();
                    continue block0;
                }
                return false;
            }
        } else {
            Iterator<T> iter = other.iterator();
            for (T t : value) {
                if (((AbstractConfigField)dummy).areEqual(t, iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    @ApiStatus.Internal
    public List<Inner> getEntries() {
        return this.cells.stream().map(c -> c.nestedEntry).collect(Collectors.toList());
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.cells.stream().map(c -> c.nestedEntry).collect(Collectors.toList());
    }

    @Override
    public String providePath(AbstractConfigField<?> child) {
        String prefix = this.getCatPath() + ".";
        int i = 0;
        for (NestedListCell cell : this.cells) {
            if (cell.nestedEntry == child) {
                return prefix + i;
            }
            ++i;
        }
        return prefix + "?";
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        String[] split = DOT.split(path, 2);
        if ("?".equals(split[0])) {
            return null;
        }
        try {
            int i = Integer.parseInt(split[0]);
            if (i >= 0 && i < this.cells.size()) {
                Object nestedEntry = ((NestedListCell)this.cells.get((int)i)).nestedEntry;
                if (nestedEntry instanceof IEntryHolder && split.length == 2) {
                    return ((IEntryHolder)nestedEntry).getEntry(split[1]);
                }
                return nestedEntry;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean preserveState() {
        return false;
    }

    @Override
    public void m_7522_(GuiEventListener listener) {
        if (this.m_6702_().contains(listener)) {
            super.m_7522_(listener);
        } else {
            for (NestedListCell cell : this.cells) {
                if (cell.nestedEntry != listener) continue;
                super.m_7522_((GuiEventListener)cell);
                cell.m_7522_(listener);
                break;
            }
        }
    }

    public static class NestedListCell<T, Inner extends AbstractConfigListEntry<T>>
    extends AbstractListListEntry.AbstractListCell<T, NestedListCell<T, Inner>, NestedListListEntry<T, Inner>> {
        protected final Inner nestedEntry;
        protected final boolean isExpandable;

        public NestedListCell(NestedListListEntry<T, Inner> listEntry, Inner nestedEntry) {
            super(listEntry);
            this.nestedEntry = nestedEntry;
            this.isExpandable = nestedEntry instanceof IExpandable;
            ((AbstractConfigField)nestedEntry).setSubEntry(true);
            if (!(nestedEntry instanceof IExpandable)) {
                ((AbstractConfigListEntry)nestedEntry).setHeadless(true);
            }
            ((AbstractConfigField)nestedEntry).setParentEntry(listEntry);
            ((AbstractConfigField)nestedEntry).setNavigableParent(this);
        }

        @Override
        public void tick() {
            ((AbstractConfigField)this.nestedEntry).tick();
            super.tick();
        }

        @Override
        public T getValue() {
            return ((AbstractConfigField)this.nestedEntry).getDisplayedValue();
        }

        @Override
        protected List<EntryError> computeErrors() {
            List<EntryError> errors = super.computeErrors();
            errors.addAll(((AbstractConfigField)this.nestedEntry).getEntryErrors().stream().filter(e -> !errors.contains(e)).toList());
            return errors;
        }

        @Override
        public Optional<Component> getErrorMessage() {
            return Optional.empty();
        }

        @Override
        public int getCellHeight() {
            return ((AbstractConfigField)this.nestedEntry).getItemHeight();
        }

        @Override
        public Rectangle getSelectionArea() {
            return ((AbstractConfigListEntry)this.nestedEntry).getSelectionArea();
        }

        @Override
        public boolean drawsLine(int mouseX, int mouseY) {
            if (!this.isExpandable) {
                return false;
            }
            if (this.nestedEntry instanceof IExpandable) {
                return ((IExpandable)this.nestedEntry).isExpanded() && mouseY > 18;
            }
            return false;
        }

        @Override
        public void renderCell(GuiGraphics gg, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            super.renderCell(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
            ((AbstractConfigField)this.nestedEntry).render(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        public void renderLabel(GuiGraphics gg, Component label, int textX, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            super.renderLabel(gg, label, textX, index, x, y, cellWidth, ((DynamicEntryListWidget.ListEntry)this.nestedEntry).getCaptionHeight(), mouseX, mouseY, isSelected, delta);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.nestedEntry);
        }

        @Override
        public boolean isRequiresRestart() {
            return ((AbstractConfigField)this.nestedEntry).isRequiresRestart();
        }

        @Override
        public void updateSelected(boolean isSelected) {
            super.updateSelected(isSelected);
            ((AbstractConfigListEntry)this.nestedEntry).updateFocused(isSelected);
        }

        @Override
        protected boolean computeIsEdited() {
            return super.computeIsEdited() || ((AbstractConfigField)this.nestedEntry).isEdited();
        }

        public Inner getNestedEntry() {
            return this.nestedEntry;
        }

        @Override
        public void doSetValue(T value) {
            ((AbstractConfigField)this.nestedEntry).setDisplayedValue(value);
            ((AbstractConfigField)this.nestedEntry).setValue(value);
        }

        @Override
        public void setOriginal(T value) {
            ((AbstractConfigField)this.nestedEntry).setOriginal(value);
        }

        @Override
        public boolean areEqual(T left, T right) {
            return ((AbstractConfigField)this.nestedEntry).areEqual(left, right);
        }

        @Override
        protected String seekableText() {
            return "";
        }

        @Override
        protected List<ISeekableComponent> seekableComponents() {
            return Lists.newArrayList((Object[])new ISeekableComponent[]{this.nestedEntry});
        }

        @Override
        public List<INavigableTarget> getNavigableSubTargets() {
            ArrayList subTargets = this.nestedEntry.getNavigableSubTargets();
            return subTargets.isEmpty() ? Lists.newArrayList((Object[])new INavigableTarget[]{this.nestedEntry}) : subTargets;
        }

        @Override
        @Nullable
        public INavigableTarget getNavigableParent() {
            return this.getListEntry();
        }

        @Override
        public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
            if (!onlyVisible) {
                return Stream.concat(Stream.of(this.nestedEntry), this.nestedEntry.getNavigableChildren(false).stream()).collect(Collectors.toList());
            }
            return this.nestedEntry.getNavigableChildren(true);
        }

        @Override
        public void navigate() {
            ((AbstractConfigField)this.nestedEntry).navigate();
        }

        @Override
        public Rectangle getRowArea() {
            return ((AbstractConfigListEntry)this.nestedEntry).getRowArea();
        }
    }
}

