/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.LongListEntry;
import endorh.simpleconfig.ui.gui.entries.SliderListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LongSliderEntry
extends SliderListEntry<Long> {
    public LongSliderEntry(Component fieldName, long min, long max, long value) {
        super(fieldName, min, max, value, v -> Component.m_237110_((String)"simpleconfig.format.slider", (Object[])new Object[]{String.format("%d", v)}));
        LongListEntry textEntry = new LongListEntry((Component)Component.m_237119_(), value);
        textEntry.setMinimum(min);
        textEntry.setMaximum(max);
        textEntry.setChildSubEntry(true);
        Stream.of(HotKeyActionTypes.LONG_ADD, HotKeyActionTypes.LONG_ADD_CYCLE, HotKeyActionTypes.LONG_MUL, HotKeyActionTypes.LONG_DIV).forEach(this.hotKeyActionTypes::add);
        this.initWidgets(new SliderWidget(0, 0, 100, 24), textEntry);
    }

    private static boolean isFloating(HotKeyActionType<Long, ?> type) {
        return type == HotKeyActionTypes.LONG_MUL || type == HotKeyActionTypes.LONG_DIV;
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<Long, ?> type) {
        boolean prevFloating = LongSliderEntry.isFloating(this.getHotKeyActionType());
        Double prev = prevFloating ? this.getDisplayedDouble() : Double.valueOf(((Long)this.getDisplayedValue()).longValue());
        super.setHotKeyActionType(type);
        boolean floating = LongSliderEntry.isFloating(type);
        if (floating) {
            this.setDisplayedDouble(prev);
        }
        if (floating != prevFloating) {
            this.textFieldEntry.setTextFormatter(TextFormatter.numeric(!floating));
            if (!floating) {
                Double d = this.getDisplayedDouble();
                this.setDisplayedValue((long)(d != null ? d : (double)((Long)this.getValue()).longValue()));
            }
        }
    }

    @Override
    public void setHotKeyActionValue(Object value) {
        HotKeyActionType type = this.getHotKeyActionType();
        if (LongSliderEntry.isFloating(type)) {
            this.setDisplayedDouble(value);
        } else {
            super.setHotKeyActionValue(value);
        }
    }

    @Override
    public Object getHotKeyActionValue() {
        return LongSliderEntry.isFloating(this.getHotKeyActionType()) ? this.getDisplayedDouble() : super.getHotKeyActionValue();
    }

    private Double getDisplayedDouble() {
        try {
            return Double.parseDouble(this.textFieldEntry.textFieldWidget.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setDisplayedDouble(Object d) {
        this.textFieldEntry.textFieldWidget.setValue(d != null ? String.valueOf(d) : "");
    }

    public class SliderWidget
    extends SliderListEntry.SliderWidget {
        public SliderWidget(int x, int y, int width, int height) {
            super(LongSliderEntry.this, x, y, width, height);
        }

        @Override
        public double getStep(boolean left) {
            this.setValue(this.getValue());
            return super.getStep(left);
        }

        @Override
        public double applyStep(double step) {
            long prev;
            RangedEntryBuilder.InvertibleDouble2DoubleFunction map = LongSliderEntry.this.sliderMap;
            if (map == null) {
                return super.applyStep(Math.copySign(Math.max(Math.abs(step), 1.001 / (double)((Long)LongSliderEntry.this.sliderMax - (Long)LongSliderEntry.this.sliderMin)), step));
            }
            double v = this.f_93577_ + step;
            if (v <= 0.0) {
                return 0.0;
            }
            if (v >= 1.0) {
                return 1.0;
            }
            long vv = prev = this.toLong(this.getSliderValue());
            while (vv == prev) {
                if ((v += step) <= 0.0) {
                    return 0.0;
                }
                if (v >= 1.0) {
                    return 1.0;
                }
                vv = this.toLong(map.applyAsDouble(v));
            }
            double r = Mth.m_14008_((double)map.inverse(this.toDouble(vv)), (double)0.0, (double)1.0);
            return this.toLong(map.applyAsDouble(r)) == vv ? r : v;
        }

        public long toLong(double v) {
            return Math.round((double)((Long)LongSliderEntry.this.sliderMin).longValue() + (double)((Long)LongSliderEntry.this.sliderMax - (Long)LongSliderEntry.this.sliderMin) * v);
        }

        public double toDouble(long v) {
            return (double)(v - (Long)LongSliderEntry.this.sliderMin) / (double)((Long)LongSliderEntry.this.sliderMax - (Long)LongSliderEntry.this.sliderMin);
        }

        public Long getValue() {
            return this.toLong(this.getSliderValue());
        }

        public void setValue(Long v) {
            this.setSliderValue((double)(v - (Long)LongSliderEntry.this.sliderMin) / (double)((Long)LongSliderEntry.this.sliderMax - (Long)LongSliderEntry.this.sliderMin));
        }
    }
}

