/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LongListEntry
extends TextFieldListEntry<Long>
implements IRangedEntry<Long> {
    private long minimum = Long.MIN_VALUE;
    private long maximum = Long.MAX_VALUE;

    @ApiStatus.Internal
    public LongListEntry(Component fieldName, Long value) {
        super(fieldName, value, false);
        this.setTextFormatter(TextFormatter.numeric(true));
        Stream.of(HotKeyActionTypes.LONG_ADD, HotKeyActionTypes.LONG_ADD_CYCLE, HotKeyActionTypes.LONG_MUL, HotKeyActionTypes.LONG_DIV).forEach(this.hotKeyActionTypes::add);
    }

    @Override
    public void setMinimum(Long minimum) {
        this.minimum = minimum != null ? minimum : Long.MIN_VALUE;
    }

    @Override
    public void setMaximum(Long maximum) {
        this.maximum = maximum != null ? maximum : Long.MAX_VALUE;
    }

    @Override
    @Nullable
    protected Long fromString(String s) {
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isFloating(HotKeyActionType<Long, ?> type) {
        return type == HotKeyActionTypes.LONG_MUL || type == HotKeyActionTypes.LONG_DIV;
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<Long, ?> type) {
        boolean prevFloating = LongListEntry.isFloating(this.getHotKeyActionType());
        super.setHotKeyActionType(type);
        boolean floating = LongListEntry.isFloating(type);
        if (floating != prevFloating) {
            this.setTextFormatter(TextFormatter.numeric(!floating));
            if (!floating) {
                Double d = this.getDisplayedDouble();
                this.setDisplayedValue((long)(d != null ? d : (double)((Long)this.getValue()).longValue()));
            }
        }
    }

    @Override
    public void setHotKeyActionValue(Object value) {
        HotKeyActionType type = this.getHotKeyActionType();
        if (LongListEntry.isFloating(type)) {
            this.textFieldWidget.setValue(String.valueOf(value));
        } else {
            super.setHotKeyActionValue(value);
        }
    }

    @Override
    public Object getHotKeyActionValue() {
        return LongListEntry.isFloating(this.getHotKeyActionType()) ? this.getDisplayedDouble() : super.getHotKeyActionValue();
    }

    private Double getDisplayedDouble() {
        try {
            return Double.parseDouble(this.textFieldWidget.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        try {
            long i = Long.parseLong(this.getText());
            if (i > this.maximum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_integer", (Object[])new Object[]{this.getText()}));
        }
        return super.getErrorMessage();
    }
}

