/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.KeyBindButton;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindListEntry
extends TooltipListEntry<KeyBindMapping>
implements IChildListEntry {
    protected final KeyBindButton hotKeyButton;
    protected final List<GuiEventListener> widgets;
    protected final List<GuiEventListener> childWidgets;

    @ApiStatus.Internal
    public KeyBindListEntry(Component fieldName, KeyBindMapping value, @Nullable ExtendedKeyBindImpl keyBind) {
        super(fieldName);
        this.setOriginal(value.copy());
        this.setValue(value.copy());
        this.hotKeyButton = KeyBindButton.of(this::getScreen, this::getScreen, keyBind);
        this.hotKeyButton.setMapping(value);
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.hotKeyButton, this.sideButtonReference});
        this.childWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.hotKeyButton});
    }

    @Override
    public void tick() {
        super.tick();
        this.hotKeyButton.tick();
    }

    @Override
    public int getExtraScrollHeight() {
        return this.hotKeyButton.getExtraHeight();
    }

    @Override
    public void resetValue() {
        super.resetValue();
        AbstractConfigScreen screen = this.getScreen();
        if (screen.getModalInputProcessor() == this.hotKeyButton) {
            screen.cancelModalInput();
        }
    }

    public ExtendedKeyBindSettings getDefaultSettings() {
        return this.hotKeyButton.getDefaultSettings();
    }

    public void setDefaultSettings(ExtendedKeyBindSettings settings) {
        this.hotKeyButton.setDefaultSettings(settings);
    }

    public boolean isReportOverlaps() {
        return this.hotKeyButton.isReportOverlaps();
    }

    public void setReportOverlaps(boolean reportOverlaps) {
        this.hotKeyButton.setReportOverlaps(reportOverlaps);
    }

    @Override
    public KeyBindMapping getDisplayedValue() {
        return this.hotKeyButton.getMapping();
    }

    @Override
    public void setDisplayedValue(KeyBindMapping value) {
        this.hotKeyButton.setMapping(value);
    }

    @Override
    public KeyBindMapping getDefaultValue() {
        KeyBindMapping v = (KeyBindMapping)super.getDefaultValue();
        return v == null ? null : v.copy();
    }

    private Component getLocalizedName() {
        return this.getDisplayedValue().getDisplayName();
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.hotKeyButton.setActive(this.shouldRenderEditable());
        this.hotKeyButton.setPosition(x, y, w);
        this.hotKeyButton.setHeight(h);
        this.hotKeyButton.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.hotKeyButton.m_93692_(false);
        }
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childWidgets : this.widgets;
    }
}

