/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.IntegerListEntry;
import endorh.simpleconfig.ui.gui.entries.SliderListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IntegerSliderEntry
extends SliderListEntry<Integer> {
    public IntegerSliderEntry(Component fieldName, int min, int max, int value) {
        super(fieldName, min, max, value, v -> Component.m_237110_((String)"simpleconfig.format.slider", (Object[])new Object[]{String.format("%d", v)}));
        IntegerListEntry textEntry = new IntegerListEntry((Component)Component.m_237119_(), value);
        textEntry.setMinimum(min);
        textEntry.setMaximum(max);
        textEntry.setChildSubEntry(true);
        this.textFieldEntry = textEntry;
        Stream.of(HotKeyActionTypes.INT_ADD, HotKeyActionTypes.INT_ADD_CYCLE, HotKeyActionTypes.INT_MUL, HotKeyActionTypes.INT_DIV).forEach(this.hotKeyActionTypes::add);
        this.initWidgets(new SliderWidget(0, 0, 100, 24), textEntry);
    }

    private static boolean isFloating(HotKeyActionType<Integer, ?> type) {
        return type == HotKeyActionTypes.INT_MUL || type == HotKeyActionTypes.INT_DIV;
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<Integer, ?> type) {
        boolean prevFloating = IntegerSliderEntry.isFloating(this.getHotKeyActionType());
        Float prev = prevFloating ? this.getDisplayedFloat() : Float.valueOf(((Integer)this.getDisplayedValue()).intValue());
        super.setHotKeyActionType(type);
        boolean floating = IntegerSliderEntry.isFloating(type);
        if (floating) {
            this.setDisplayedFloat(prev);
        }
        if (floating != prevFloating) {
            this.textFieldEntry.setTextFormatter(TextFormatter.numeric(!floating));
            if (!floating) {
                Float f = this.getDisplayedFloat();
                this.setDisplayedValue((int)(f != null ? f.floatValue() : (float)((Integer)this.getValue()).intValue()));
            }
        }
    }

    @Override
    public void setHotKeyActionValue(Object value) {
        HotKeyActionType type = this.getHotKeyActionType();
        if (IntegerSliderEntry.isFloating(type)) {
            this.setDisplayedFloat(value);
        } else {
            super.setHotKeyActionValue(value);
        }
    }

    @Override
    public Object getHotKeyActionValue() {
        return IntegerSliderEntry.isFloating(this.getHotKeyActionType()) ? this.getDisplayedFloat() : super.getHotKeyActionValue();
    }

    private Float getDisplayedFloat() {
        try {
            return Float.valueOf(Float.parseFloat(this.textFieldEntry.textFieldWidget.getValue()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setDisplayedFloat(Object d) {
        this.textFieldEntry.textFieldWidget.setValue(d != null ? String.valueOf(d) : "");
    }

    public class SliderWidget
    extends SliderListEntry.SliderWidget {
        public SliderWidget(int x, int y, int width, int height) {
            super(IntegerSliderEntry.this, x, y, width, height);
        }

        @Override
        public double getStep(boolean left) {
            this.setValue(this.getValue());
            return super.getStep(left);
        }

        @Override
        public double applyStep(double step) {
            int prev;
            RangedEntryBuilder.InvertibleDouble2DoubleFunction map = IntegerSliderEntry.this.sliderMap;
            if (map == null) {
                return super.applyStep(Math.copySign(Math.max(Math.abs(step), 1.001 / (double)((Integer)IntegerSliderEntry.this.sliderMax - (Integer)IntegerSliderEntry.this.sliderMin)), step));
            }
            double v = this.f_93577_ + step;
            if (v <= 0.0) {
                return 0.0;
            }
            if (v >= 1.0) {
                return 1.0;
            }
            int vv = prev = this.toInt(this.getSliderValue());
            while (vv == prev) {
                if ((v += step) <= 0.0) {
                    return 0.0;
                }
                if (v >= 1.0) {
                    return 1.0;
                }
                vv = this.toInt(map.applyAsDouble(v));
            }
            double r = Mth.m_14008_((double)map.inverse(this.toDouble(vv)), (double)0.0, (double)1.0);
            return this.toInt(map.applyAsDouble(r)) == vv ? r : v;
        }

        public int toInt(double v) {
            return (int)Math.round((double)((Integer)IntegerSliderEntry.this.sliderMin).intValue() + (double)((Integer)IntegerSliderEntry.this.sliderMax - (Integer)IntegerSliderEntry.this.sliderMin) * v);
        }

        public double toDouble(int v) {
            return (double)(v - (Integer)IntegerSliderEntry.this.sliderMin) / (double)((Integer)IntegerSliderEntry.this.sliderMax - (Integer)IntegerSliderEntry.this.sliderMin);
        }

        public Integer getValue() {
            return this.toInt(this.getSliderValue());
        }

        public void setValue(Integer v) {
            this.setSliderValue(this.toDouble(v));
        }
    }
}

