/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.AbstractTextFieldListListEntry;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class IntegerListListEntry
extends AbstractTextFieldListListEntry<Integer, IntegerListCell, IntegerListListEntry>
implements IRangedEntry<Integer> {
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;

    @ApiStatus.Internal
    public IntegerListListEntry(Component fieldName, List<Integer> value) {
        super(fieldName, value, IntegerListCell::new);
    }

    @Override
    public void setMinimum(Integer minimum) {
        this.minimum = minimum != null ? minimum : Integer.MIN_VALUE;
    }

    @Override
    public void setMaximum(Integer maximum) {
        this.maximum = maximum != null ? maximum : Integer.MAX_VALUE;
    }

    public static class IntegerListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Integer, IntegerListCell, IntegerListListEntry> {
        public IntegerListCell(IntegerListListEntry listListEntry) {
            super(listListEntry);
            this.widget.setFormatter(TextFormatter.numeric(true));
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45);
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.widget.getValue());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public void doSetValue(Integer value) {
            this.widget.setValue(String.valueOf(value));
        }

        @Override
        public Optional<Component> getErrorMessage() {
            try {
                int i = Integer.parseInt(this.widget.getValue());
                IntegerListListEntry listEntry = (IntegerListListEntry)this.getListEntry();
                if (i > listEntry.maximum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{listEntry.maximum}));
                }
                if (i < listEntry.minimum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{listEntry.minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_integer", (Object[])new Object[]{this.widget.getValue()}));
            }
            return Optional.empty();
        }
    }
}

