/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class IntegerListEntry
extends TextFieldListEntry<Integer>
implements IRangedEntry<Integer> {
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;

    @ApiStatus.Internal
    public IntegerListEntry(Component fieldName, Integer value) {
        super(fieldName, value, false);
        this.setTextFormatter(TextFormatter.numeric(true));
        Stream.of(HotKeyActionTypes.INT_ADD, HotKeyActionTypes.INT_ADD_CYCLE, HotKeyActionTypes.INT_MUL, HotKeyActionTypes.INT_DIV).forEach(this.hotKeyActionTypes::add);
    }

    @Override
    public void setMinimum(Integer minimum) {
        this.minimum = minimum != null ? minimum : Integer.MIN_VALUE;
    }

    @Override
    public void setMaximum(Integer maximum) {
        this.maximum = maximum != null ? maximum : Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public Integer fromString(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isFloating(HotKeyActionType<Integer, ?> type) {
        return type == HotKeyActionTypes.INT_MUL || type == HotKeyActionTypes.INT_DIV;
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<Integer, ?> type) {
        boolean prevFloating = IntegerListEntry.isFloating(this.getHotKeyActionType());
        super.setHotKeyActionType(type);
        boolean floating = IntegerListEntry.isFloating(type);
        if (floating != prevFloating) {
            this.setTextFormatter(TextFormatter.numeric(!floating));
            if (!floating) {
                Float f = this.getDisplayedFloat();
                this.setDisplayedValue((int)(f != null ? f.floatValue() : (float)((Integer)this.getValue()).intValue()));
            }
        }
    }

    @Override
    public void setHotKeyActionValue(Object value) {
        HotKeyActionType type = this.getHotKeyActionType();
        if (IntegerListEntry.isFloating(type)) {
            this.textFieldWidget.setValue(String.valueOf(value));
        } else {
            super.setHotKeyActionValue(value);
        }
    }

    @Override
    public Object getHotKeyActionValue() {
        return IntegerListEntry.isFloating(this.getHotKeyActionType()) ? this.getDisplayedFloat() : super.getHotKeyActionValue();
    }

    private Float getDisplayedFloat() {
        try {
            return Float.valueOf(Float.parseFloat(this.textFieldWidget.getValue()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        try {
            int i = Integer.parseInt(this.getText());
            if (i > this.maximum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_integer", (Object[])new Object[]{this.getText()}));
        }
        return super.getErrorMessage();
    }
}

