/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.ui.gui.entries.FloatListEntry;
import endorh.simpleconfig.ui.gui.entries.SliderListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FloatSliderEntry
extends SliderListEntry<Float> {
    public FloatSliderEntry(Component fieldName, float min, float max, float value) {
        super(fieldName, Float.valueOf(min), Float.valueOf(max), Float.valueOf(value), v -> Component.m_237110_((String)"simpleconfig.format.slider", (Object[])new Object[]{String.format("%5.2f", v)}));
        FloatListEntry textEntry = new FloatListEntry((Component)Component.m_237119_(), Float.valueOf(value));
        textEntry.setMinimum(Float.valueOf(min));
        textEntry.setMaximum(Float.valueOf(max));
        textEntry.setChildSubEntry(true);
        Stream.of(HotKeyActionTypes.FLOAT_ADD, HotKeyActionTypes.FLOAT_ADD_CYCLE, HotKeyActionTypes.FLOAT_MULTIPLY, HotKeyActionTypes.FLOAT_DIVIDE).forEach(this.hotKeyActionTypes::add);
        this.initWidgets(new SliderWidget(0, 0, 100, 24), textEntry);
    }

    public class SliderWidget
    extends SliderListEntry.SliderWidget {
        public SliderWidget(int x, int y, int width, int height) {
            super(FloatSliderEntry.this, x, y, width, height);
        }

        public Float getValue() {
            return Float.valueOf(((Float)FloatSliderEntry.this.sliderMin).floatValue() + (float)((double)(((Float)FloatSliderEntry.this.sliderMax).floatValue() - ((Float)FloatSliderEntry.this.sliderMin).floatValue()) * this.getSliderValue()));
        }

        public void setValue(Float v) {
            this.setSliderValue((v.floatValue() - ((Float)FloatSliderEntry.this.sliderMin).floatValue()) / (((Float)FloatSliderEntry.this.sliderMax).floatValue() - ((Float)FloatSliderEntry.this.sliderMin).floatValue()));
        }
    }
}

