/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.AbstractTextFieldListListEntry;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FloatListListEntry
extends AbstractTextFieldListListEntry<Float, FloatListCell, FloatListListEntry>
implements IRangedEntry<Float> {
    private float minimum = Float.NEGATIVE_INFINITY;
    private float maximum = Float.POSITIVE_INFINITY;

    @ApiStatus.Internal
    public FloatListListEntry(Component fieldName, List<Float> value) {
        super(fieldName, value, FloatListCell::new);
    }

    @Override
    public void setMinimum(Float minimum) {
        this.minimum = minimum != null ? minimum.floatValue() : Float.NEGATIVE_INFINITY;
    }

    @Override
    public void setMaximum(Float maximum) {
        this.maximum = maximum != null ? maximum.floatValue() : Float.POSITIVE_INFINITY;
    }

    public static class FloatListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Float, FloatListCell, FloatListListEntry> {
        public FloatListCell(FloatListListEntry listListEntry) {
            super(listListEntry);
            this.widget.setFormatter(TextFormatter.numeric(false));
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Float getValue() {
            try {
                return Float.valueOf(this.widget.getValue());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }

        @Override
        public void doSetValue(Float value) {
            this.widget.setValue(String.valueOf(value));
        }

        @Override
        public Optional<Component> getErrorMessage() {
            try {
                float i = Float.parseFloat(this.widget.getValue());
                FloatListListEntry listEntry = (FloatListListEntry)this.getListEntry();
                if (i > listEntry.maximum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{Float.valueOf(listEntry.maximum)}));
                }
                if (i < listEntry.minimum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{Float.valueOf(listEntry.minimum)}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_float", (Object[])new Object[]{this.widget.getValue()}));
            }
            return Optional.empty();
        }
    }
}

