/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class FloatListEntry
extends TextFieldListEntry<Float>
implements IRangedEntry<Float> {
    private float minimum = Float.NEGATIVE_INFINITY;
    private float maximum = Float.POSITIVE_INFINITY;

    @ApiStatus.Internal
    public FloatListEntry(Component fieldName, Float value) {
        super(fieldName, value, false);
        this.setTextFormatter(TextFormatter.numeric(false));
        Stream.of(HotKeyActionTypes.FLOAT_ADD, HotKeyActionTypes.FLOAT_ADD_CYCLE, HotKeyActionTypes.FLOAT_MULTIPLY, HotKeyActionTypes.FLOAT_DIVIDE).forEach(this.hotKeyActionTypes::add);
    }

    @Override
    public void setMinimum(Float minimum) {
        this.minimum = minimum != null ? minimum.floatValue() : Float.NEGATIVE_INFINITY;
    }

    @Override
    public void setMaximum(Float maximum) {
        this.maximum = maximum != null ? maximum.floatValue() : Float.POSITIVE_INFINITY;
    }

    @Override
    @Nullable
    public Float fromString(String s) {
        try {
            return Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        try {
            float i = Float.parseFloat(this.getText());
            if (i > this.maximum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{Float.valueOf(this.maximum)}));
            }
            if (i < this.minimum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{Float.valueOf(this.minimum)}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_float", (Object[])new Object[]{this.getText()}));
        }
        return super.getErrorMessage();
    }
}

