/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.entries.SelectionListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EnumListEntry<E extends Enum<?>>
extends SelectionListEntry<E> {
    public static final Function<Enum<?>, Component> DEFAULT_NAME_PROVIDER = t -> Component.m_237115_((String)(t instanceof SelectionListEntry.Translatable ? ((SelectionListEntry.Translatable)((Object)t)).getKey() : t.toString()));
    @Nullable
    protected Function<E, List<Component>> enumTooltipProvider;
    @Nullable
    protected Set<E> allowedValues;

    @ApiStatus.Internal
    public EnumListEntry(Component fieldName, Class<E> clazz, E value, Function<E, Component> enumNameProvider, @Nullable Function<E, List<Component>> enumTooltipProvider, @Nullable Set<E> allowedValues) {
        super(fieldName, Arrays.stream((Enum[])clazz.getEnumConstants()).filter(e -> allowedValues == null || allowedValues.contains(e)).collect(Collectors.toList()), value, enumNameProvider);
        this.enumTooltipProvider = enumTooltipProvider;
        this.allowedValues = allowedValues;
        this.hotKeyActionTypes.add(HotKeyActionTypes.ENUM_ADD.cast());
    }

    @Override
    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        super.renderField(gg, fieldX, fieldY, fieldWidth, fieldHeight, x, y, entryWidth, entryHeight, index, mouseX, mouseY, delta);
        if (this.enumTooltipProvider != null && !this.getEntryList().m_7282_() && this.fieldArea.contains(mouseX, mouseY)) {
            List<Component> tooltip = this.enumTooltipProvider.apply((Enum)this.getDisplayedValue());
            FormattedCharSequence[] tt = this.postProcessTooltip((Component[])tooltip.toArray(Component[]::new));
            if (!tooltip.isEmpty()) {
                this.addTooltip(Tooltip.of(this.fieldArea, Point.of(mouseX, mouseY), tt));
            }
        }
    }

    @Override
    public List<EntryError> getHotKeyActionErrors(HotKeyActionType<E, ?> type) {
        List<EntryError> errors = super.getHotKeyActionErrors(type);
        if (type == HotKeyActionTypes.ENUM_ADD) {
            errors.addAll(this.intEntry.getErrors());
        }
        errors.addAll(this.intEntry.getEntryErrors());
        return errors;
    }

    @Override
    public void setHotKeyActionType(HotKeyActionType<E, ?> type) {
        super.setHotKeyActionType(type);
        this.widgetReference.setTarget((GuiEventListener)(type == HotKeyActionTypes.ENUM_ADD ? this.intEntry : this.buttonWidget));
    }

    @Override
    public Object getHotKeyActionValue() {
        if (this.getHotKeyActionType() == HotKeyActionTypes.ENUM_ADD) {
            return this.intEntry.getDisplayedValue();
        }
        return super.getHotKeyActionValue();
    }

    @Override
    public void setHotKeyActionValue(Object value) {
        if (this.getHotKeyActionType() == HotKeyActionTypes.ENUM_ADD && value instanceof Number) {
            this.intEntry.setDisplayedValue(((Number)value).intValue());
        }
        super.setHotKeyActionValue(value);
    }
}

