/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.AbstractListListEntry;
import endorh.simpleconfig.ui.gui.entries.BaseListEntry;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntryPairListListEntry<K, V, KE extends AbstractConfigListEntry<K>, E extends AbstractConfigListEntry<V>>
extends AbstractListListEntry<Pair<K, V>, EntryPairCell<K, V, KE, E>, EntryPairListListEntry<K, V, KE, E>>
implements IEntryHolder {
    protected boolean ignoreOrder;
    protected boolean selectKey;

    public EntryPairListListEntry(Component fieldName, List<Pair<K, V>> value, Function<EntryPairListListEntry<K, V, KE, E>, Pair<KE, E>> cellFactory, boolean ignoreOrder) {
        super(fieldName, value, l -> {
            Pair pair = (Pair)cellFactory.apply((EntryPairListListEntry)l);
            return new EntryPairCell(l, (AbstractConfigListEntry)pair.getKey(), (AbstractConfigListEntry)pair.getValue());
        });
        this.ignoreOrder = ignoreOrder;
    }

    @Override
    public boolean preserveState() {
        return false;
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        for (EntryPairCell cell : this.cells) {
            cell.updateSelected(isFocused && this.m_7222_() == cell && this.expanded);
        }
    }

    @Override
    protected boolean isFieldFullWidth() {
        return true;
    }

    @Override
    public boolean areEqual(List<Pair<K, V>> value, List<Pair<K, V>> other) {
        EntryPairCell dummy;
        if (value.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (value.size() != other.size()) {
            return false;
        }
        EntryPairCell entryPairCell = dummy = !this.cells.isEmpty() ? (EntryPairCell)this.cells.get(0) : (EntryPairCell)this.createCellWithValue(value.get(0));
        if (this.ignoreOrder) {
            Map vMap = value.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
            Map oMap = other.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
            if (vMap.size() != oMap.size()) {
                return false;
            }
            for (Object key : vMap.keySet()) {
                if (((AbstractConfigField)dummy.valueEntry).areEqual(vMap.get(key), oMap.get(key))) continue;
                return false;
            }
        } else {
            Iterator<Pair<K, V>> iter = other.iterator();
            for (Pair<K, V> t : value) {
                if (dummy.areEqual(t, iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    @ApiStatus.Internal
    public List<Pair<K, E>> getEntries() {
        return this.cells.stream().map(c -> Pair.of(((AbstractConfigField)c.keyEntry).getDisplayedValue(), c.valueEntry)).collect(Collectors.toList());
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.cells.stream().flatMap(c -> Stream.of(c.keyEntry, c.valueEntry)).collect(Collectors.toList());
    }

    @Override
    public String providePath(AbstractConfigField<?> child) {
        String prefix = this.getCatPath() + ".";
        int i = 0;
        for (EntryPairCell cell : this.cells) {
            if (cell.keyEntry == child) {
                return prefix + "key." + i;
            }
            if (cell.valueEntry == child) {
                return prefix + "val." + i;
            }
            ++i;
        }
        return prefix + "?";
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        String[] split = DOT.split(path, 3);
        boolean isKey = "key".equals(split[0]);
        if (!isKey && !"val".equals(split[0]) || split.length < 2) {
            return null;
        }
        try {
            int i = Integer.parseInt(split[1]);
            if (i >= 0 && i < this.cells.size()) {
                Object entry;
                EntryPairCell cell = (EntryPairCell)this.cells.get(i);
                Object object = entry = isKey ? cell.keyEntry : cell.valueEntry;
                if (entry instanceof IEntryHolder && split.length == 3) {
                    return ((IEntryHolder)entry).getEntry(split[2]);
                }
                return entry;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void m_7522_(GuiEventListener listener) {
        if (this.m_6702_().contains(listener)) {
            super.m_7522_(listener);
        } else {
            for (EntryPairCell cell : this.cells) {
                if (cell.keyEntry != listener && cell.valueEntry != listener) continue;
                super.m_7522_((GuiEventListener)cell);
                cell.m_7522_(listener);
                break;
            }
        }
    }

    public static class EntryPairCell<K, V, KE extends AbstractConfigListEntry<K>, E extends AbstractConfigListEntry<V>>
    extends AbstractListListEntry.AbstractListCell<Pair<K, V>, EntryPairCell<K, V, KE, E>, EntryPairListListEntry<K, V, KE, E>> {
        protected final KE keyEntry;
        protected final E valueEntry;
        protected final List<GuiEventListener> widgets;
        protected int keyOffset = 0;
        protected final boolean isExpandable;
        protected int noFilter = 0;
        protected int errorFilter = 1692418626;
        protected int keyOverlayColor = 0;

        public EntryPairCell(EntryPairListListEntry<K, V, KE, E> listEntry, KE keyEntry, E valueEntry) {
            super(listEntry);
            this.keyEntry = keyEntry;
            this.valueEntry = valueEntry;
            if (listEntry.areCaptionControlsEnabled()) {
                this.keyOffset = 24;
            }
            ((AbstractConfigField)keyEntry).setChildSubEntry(true);
            ((AbstractConfigField)keyEntry).setSubEntry(true);
            ((AbstractConfigField)valueEntry).setSubEntry(true);
            ((AbstractConfigField)keyEntry).setParentEntry(listEntry);
            ((AbstractConfigField)valueEntry).setParentEntry(listEntry);
            ((AbstractConfigField)keyEntry).setNavigableParent(this);
            ((AbstractConfigField)valueEntry).setNavigableParent(this);
            this.isExpandable = valueEntry instanceof BaseListEntry;
            this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{keyEntry, valueEntry});
        }

        @Override
        public void tick() {
            ((AbstractConfigField)this.keyEntry).tick();
            ((AbstractConfigField)this.valueEntry).tick();
            super.tick();
        }

        @Override
        public Pair<K, V> getValue() {
            return Pair.of(((AbstractConfigField)this.keyEntry).getDisplayedValue(), ((AbstractConfigField)this.valueEntry).getDisplayedValue());
        }

        @Override
        public Rectangle getSelectionArea() {
            return ((AbstractConfigListEntry)this.valueEntry).getSelectionArea();
        }

        @Override
        public int getCellHeight() {
            return ((AbstractConfigField)this.valueEntry).getItemHeight();
        }

        @Override
        public void updateSelected(boolean isSelected) {
            super.updateSelected(isSelected);
            ((AbstractConfigListEntry)this.keyEntry).updateFocused(isSelected && this.m_7222_() == this.keyEntry);
            ((AbstractConfigListEntry)this.valueEntry).updateFocused(isSelected && this.m_7222_() == this.valueEntry);
            if (isSelected) {
                ((EntryPairListListEntry)this.getListEntry()).selectKey = this.m_7222_() == this.keyEntry;
            }
        }

        @Override
        protected List<EntryError> computeErrors() {
            List<EntryError> errors = super.computeErrors();
            errors.addAll(Stream.concat(((AbstractConfigField)this.keyEntry).getEntryErrors().stream(), ((AbstractConfigField)this.valueEntry).getEntryErrors().stream()).filter(e -> !errors.contains(e)).toList());
            return errors;
        }

        @Override
        public Optional<Component> getErrorMessage() {
            return Optional.empty();
        }

        @Override
        public void doSetValue(Pair<K, V> value) {
            ((AbstractConfigField)this.keyEntry).setDisplayedValue((Object)value.getKey());
            ((AbstractConfigField)this.keyEntry).setValue((Object)value.getKey());
            ((AbstractConfigField)this.valueEntry).setDisplayedValue((Object)value.getValue());
            ((AbstractConfigField)this.valueEntry).setValue((Object)value.getValue());
        }

        @Override
        public void setOriginal(Pair<K, V> value) {
            ((AbstractConfigField)this.keyEntry).setOriginal((Object)value.getKey());
            ((AbstractConfigField)this.valueEntry).setOriginal((Object)value.getValue());
        }

        @Override
        public boolean areEqual(Pair<K, V> left, Pair<K, V> right) {
            return ((AbstractConfigField)this.keyEntry).areEqual((Object)left.getKey(), (Object)right.getKey()) && ((AbstractConfigField)this.valueEntry).areEqual((Object)left.getValue(), (Object)right.getValue());
        }

        @Override
        public void renderCell(GuiGraphics gg, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.renderCell(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isHovered, delta);
            this.keyOverlayColor = this.hasError() ? this.errorFilter : this.noFilter;
            Font fr = Minecraft.m_91087_().f_91062_;
            int keyX = fr.m_92718_() ? x + cellWidth - 150 - this.keyOffset : x + this.keyOffset;
            ((AbstractConfigField)this.valueEntry).render(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isHovered, delta);
            EntryPairListListEntry listEntry = (EntryPairListListEntry)this.getListEntry();
            ((IChildListEntry)this.keyEntry).renderChild(gg, keyX, y, listEntry.getKeyFieldWidth(), 20, mouseX, mouseY, delta);
            gg.m_280509_(keyX, y, keyX + listEntry.getKeyFieldWidth(), y + 20, this.keyOverlayColor);
        }

        @Override
        public void renderLabel(GuiGraphics gg, Component label, int textX, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        }

        @Override
        public Component getLabel() {
            return Component.m_237119_();
        }

        @Override
        public boolean drawsLine(int mouseX, int mouseY) {
            return this.isExpandable && ((BaseListEntry)this.valueEntry).expanded && mouseY > 18;
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        @Override
        protected List<ISeekableComponent> seekableComponents() {
            return Lists.newArrayList((Object[])new ISeekableComponent[]{this.keyEntry, this.valueEntry});
        }

        @Override
        protected String seekableText() {
            return "";
        }

        @Override
        public List<INavigableTarget> getNavigableSubTargets() {
            AbstractConfigField[] arr;
            ArrayList<INavigableTarget> subTargets = new ArrayList<INavigableTarget>();
            for (AbstractConfigField entry : arr = new AbstractConfigField[]{this.isExpandable ? this.valueEntry : this.keyEntry, this.isExpandable ? this.keyEntry : this.valueEntry}) {
                List<INavigableTarget> entryTargets = entry.getNavigableSubTargets();
                if (entryTargets.isEmpty()) {
                    subTargets.add(entry);
                    continue;
                }
                subTargets.addAll(entryTargets);
            }
            return subTargets;
        }

        @Override
        public void navigate() {
            if (((EntryPairListListEntry)this.getListEntry()).selectKey) {
                ((AbstractConfigField)this.keyEntry).navigate();
            } else {
                ((AbstractConfigField)this.valueEntry).navigate();
            }
        }

        @Override
        public Rectangle getRowArea() {
            return ((AbstractConfigListEntry)this.valueEntry).getRowArea();
        }

        @Override
        @Nullable
        public INavigableTarget getNavigableParent() {
            return this.getListEntry();
        }

        @Override
        public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
            if (!onlyVisible) {
                return Stream.concat(Stream.of(this.keyEntry, this.valueEntry), this.valueEntry.getNavigableChildren(false).stream()).collect(Collectors.toList());
            }
            return this.valueEntry.getNavigableChildren(true);
        }

        @Override
        @Nullable
        public ComponentPath handleTabNavigation(FocusNavigationEvent.TabNavigation e) {
            return super.handleTabNavigation(e);
        }

        public void m_93692_(boolean pFocused) {
            super.m_93692_(pFocused);
        }

        public boolean m_93696_() {
            return super.m_93696_();
        }
    }
}

