/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntryButtonListEntry<V, Entry extends AbstractConfigListEntry<V>>
extends TooltipListEntry<V>
implements IChildListEntry,
IEntryHolder {
    public final Entry entry;
    protected final Button button;
    protected final Supplier<Component> buttonLabelSupplier;
    protected final List<AbstractConfigField<?>> heldEntries;
    protected List<GuiEventListener> listeners;
    protected List<GuiEventListener> childListeners;

    public EntryButtonListEntry(Component fieldName, Entry entry, Consumer<V> action, Supplier<Component> buttonLabelSupplier) {
        super(fieldName);
        this.entry = entry;
        this.setValue(((AbstractConfigField)entry).getValue());
        this.setOriginal(((AbstractConfigField)entry).getOriginal());
        this.setDisplayedValue((V)((AbstractConfigField)entry).getDisplayedValue());
        ((AbstractConfigField)entry).setChildSubEntry(true);
        ((AbstractConfigField)entry).setParentEntry(this);
        ((AbstractConfigField)entry).setName("entry");
        this.buttonLabelSupplier = buttonLabelSupplier;
        this.button = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.ACCEPT, MultiFunctionImageButton.ButtonAction.of(() -> action.accept(this.getValue())).active(() -> this.shouldRenderEditable() && this.getErrorMessage().isEmpty()));
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{entry, this.button, this.sideButtonReference});
        this.childListeners = Lists.newArrayList((Object[])new GuiEventListener[]{entry, this.button});
        this.heldEntries = Lists.newArrayList((Object[])new AbstractConfigField[]{entry});
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        ((AbstractConfigListEntry)this.entry).updateFocused(isFocused);
        if (!isFocused) {
            this.button.m_93692_(false);
        }
    }

    @Override
    protected boolean computeIsEdited() {
        return this.getSaveConsumer() != null && super.computeIsEdited();
    }

    @Override
    public boolean isResettable() {
        return super.isResettable();
    }

    @Override
    @Nullable
    public V getDefaultValue() {
        return (V)((AbstractConfigField)this.entry).getDefaultValue();
    }

    @Override
    public V getDisplayedValue() {
        return (V)((AbstractConfigField)this.entry).getDisplayedValue();
    }

    @Override
    public void setDisplayedValue(V value) {
        ((AbstractConfigField)this.entry).setDisplayedValue(value);
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public int getItemHeight() {
        return ((AbstractConfigField)this.entry).getItemHeight();
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 262: {
                if (this.m_7222_() != this.entry) break;
                this.m_7522_((GuiEventListener)this.button);
                this.entry.m_93692_(false);
                this.button.m_93692_(true);
                EntryButtonListEntry.playFeedbackTap(0.4f);
                return true;
            }
            case 263: {
                if (this.m_7222_() != this.button) break;
                this.m_7522_((GuiEventListener)this.entry);
                this.button.m_93692_(false);
                this.entry.m_93692_(true);
                EntryButtonListEntry.playFeedbackTap(0.4f);
                return true;
            }
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        ((AbstractConfigField)this.entry).setEditable(this.isEditable());
        ((AbstractConfigListEntry)this.entry).setPreviewingExternal(this.isPreviewingExternal());
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        ((IChildListEntry)this.entry).renderChild(gg, x, y, w - 22, h, mouseX, mouseY, delta);
        this.button.m_252865_(x + w - 20);
        this.button.m_253211_(y);
        this.button.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public void navigate() {
        super.navigate();
        this.m_7522_((GuiEventListener)this.entry);
    }

    @Override
    public List<HotKeyActionType<V, ?>> getHotKeyActionTypes() {
        return Collections.emptyList();
    }

    @Override
    public String seekableValueText() {
        return ((AbstractConfigField)this.entry).seekableValueText();
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.button.m_5953_((double)mouseX, (double)mouseY)) {
            return Optional.of(new Component[]{this.buttonLabelSupplier.get()});
        }
        if (this.entry instanceof TooltipListEntry && ((TooltipListEntry)this.entry).getTooltip(mouseX, mouseY).isEmpty() && ((TooltipListEntry)this.entry).getTooltip().isPresent()) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childListeners : this.listeners;
    }
}

