/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.ui.gui.entries.DoubleListEntry;
import endorh.simpleconfig.ui.gui.entries.SliderListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoubleSliderEntry
extends SliderListEntry<Double> {
    public DoubleSliderEntry(Component fieldName, double min, double max, double value) {
        super(fieldName, min, max, value, v -> Component.m_237110_((String)"simpleconfig.format.slider", (Object[])new Object[]{String.format("%5.2f", v)}));
        DoubleListEntry textEntry = new DoubleListEntry((Component)Component.m_237119_(), value);
        textEntry.setMinimum(min);
        textEntry.setMaximum(max);
        textEntry.setChildSubEntry(true);
        Stream.of(HotKeyActionTypes.DOUBLE_ADD, HotKeyActionTypes.DOUBLE_ADD_CYCLE, HotKeyActionTypes.DOUBLE_MULTIPLY, HotKeyActionTypes.DOUBLE_DIVIDE).forEach(this.hotKeyActionTypes::add);
        this.initWidgets(new SliderWidget(0, 0, 100, 24), textEntry);
    }

    public class SliderWidget
    extends SliderListEntry.SliderWidget {
        public SliderWidget(int x, int y, int width, int height) {
            super(DoubleSliderEntry.this, x, y, width, height);
        }

        public Double getValue() {
            return (Double)DoubleSliderEntry.this.sliderMin + ((Double)DoubleSliderEntry.this.sliderMax - (Double)DoubleSliderEntry.this.sliderMin) * this.getSliderValue();
        }

        public void setValue(Double v) {
            this.setSliderValue((v - (Double)DoubleSliderEntry.this.sliderMin) / ((Double)DoubleSliderEntry.this.sliderMax - (Double)DoubleSliderEntry.this.sliderMin));
        }
    }
}

