/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.AbstractTextFieldListListEntry;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListListEntry
extends AbstractTextFieldListListEntry<Double, DoubleListCell, DoubleListListEntry>
implements IRangedEntry<Double> {
    private double minimum = Double.NEGATIVE_INFINITY;
    private double maximum = Double.POSITIVE_INFINITY;

    @ApiStatus.Internal
    public DoubleListListEntry(Component fieldName, List<Double> value) {
        super(fieldName, value, DoubleListCell::new);
    }

    @Override
    public void setMinimum(Double minimum) {
        this.minimum = minimum != null ? minimum : Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setMaximum(Double maximum) {
        this.maximum = maximum != null ? maximum : Double.POSITIVE_INFINITY;
    }

    public static class DoubleListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Double, DoubleListCell, DoubleListListEntry> {
        public DoubleListCell(DoubleListListEntry listListEntry) {
            super(listListEntry);
            this.widget.setFormatter(TextFormatter.numeric(false));
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.widget.getValue());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @Override
        public void doSetValue(Double value) {
            this.widget.setValue(String.valueOf(value));
        }

        @Override
        public Optional<Component> getErrorMessage() {
            try {
                double i = Double.parseDouble(this.widget.getValue());
                DoubleListListEntry listEntry = (DoubleListListEntry)this.getListEntry();
                if (i > listEntry.maximum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{listEntry.maximum}));
                }
                if (i < listEntry.minimum) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{listEntry.minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_float", (Object[])new Object[]{this.widget.getValue()}));
            }
            return Optional.empty();
        }
    }
}

