/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.entries.IRangedEntry;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListEntry
extends TextFieldListEntry<Double>
implements IRangedEntry<Double> {
    private double minimum = Double.NEGATIVE_INFINITY;
    private double maximum = Double.POSITIVE_INFINITY;

    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value) {
        super(fieldName, value, false);
        this.setTextFormatter(TextFormatter.numeric(false));
        Stream.of(HotKeyActionTypes.DOUBLE_ADD, HotKeyActionTypes.DOUBLE_ADD_CYCLE, HotKeyActionTypes.DOUBLE_MULTIPLY, HotKeyActionTypes.DOUBLE_DIVIDE).forEach(this.hotKeyActionTypes::add);
    }

    @Override
    public void setMinimum(Double minimum) {
        this.minimum = minimum != null ? minimum : Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setMaximum(Double maximum) {
        this.maximum = maximum != null ? maximum : Double.POSITIVE_INFINITY;
    }

    @Override
    public Double fromString(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        try {
            double i = Double.parseDouble(this.getText());
            if (i > this.maximum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_float", (Object[])new Object[]{this.getText()}));
        }
        return super.getErrorMessage();
    }
}

