/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.combobox.ComboBoxWidget;
import endorh.simpleconfig.ui.gui.widget.combobox.IComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ComboBoxListEntry<T>
extends TooltipListEntry<T>
implements IChildListEntry {
    protected TypeWrapper<T> typeWrapper;
    protected ComboBoxWidget<T> comboBox;
    @NotNull
    protected List<T> suggestions;
    protected boolean suggestionMode = true;
    protected List<GuiEventListener> listeners;
    protected List<GuiEventListener> childListeners;
    protected int maxLength;
    private int frame = 0;

    public ComboBoxListEntry(Component fieldName, T value, TypeWrapper<T> typeWrapper, @Nullable Collection<T> suggestions) {
        super(fieldName);
        this.setOriginal(value);
        this.setValue(value);
        this.typeWrapper = typeWrapper;
        this.suggestions = suggestions != null ? new ArrayList<T>(suggestions) : new ArrayList();
        this.comboBox = new ComboBoxWidget<T>(typeWrapper, this::getScreen, 0, 0, 150, 18);
        this.comboBox.setMaxLength(99999);
        this.comboBox.setSuggestions(this.suggestions);
        this.comboBox.setValue(value);
        this.comboBox.setTooltipRenderer((t, mx, my) -> this.getScreen().addTooltip(Tooltip.of(this.fieldArea, Point.of(mx, my), this.postProcessTooltip((Component[])t.toArray(Component[]::new)))));
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.comboBox, this.sideButtonReference});
        this.childListeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.comboBox});
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.comboBox.setEnabled(this.shouldRenderEditable());
        this.comboBox.setRestrictedToSuggestions(!this.isSuggestionMode());
        this.comboBox.m_252865_(x + 1);
        this.comboBox.m_253211_(y + 1);
        this.comboBox.m_93674_(w - 2);
        this.comboBox.setHeight(h - 2);
        this.comboBox.setDropDownHeight(Math.min(120, this.getEntryList().bottom - this.getEntryList().top - 32));
        this.comboBox.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        boolean prev = this.m_93696_();
        super.updateFocused(isFocused);
        if (!isFocused && prev) {
            this.comboBox.setAnchorPos(this.comboBox.getCaret());
            this.comboBox.m_93692_(false);
        }
    }

    @Override
    protected void acquireFocus() {
        super.acquireFocus();
        this.comboBox.moveCaretToEnd();
        this.comboBox.setAnchorPos(0);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.m_93696_() && button == 1 && this.comboBox.m_5953_(mouseX, mouseY) && !this.comboBox.isMouseOverArrow((int)mouseX, (int)mouseY)) {
            this.preserveState();
            this.m_93692_(true);
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    public void setSuggestions(List<T> suggestions) {
        this.comboBox.setSuggestions(suggestions);
    }

    public void setSuggestionProvider(IComboBoxModel<T> provider) {
        this.comboBox.setSuggestionProvider(provider);
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        return this.comboBox.getError();
    }

    @Override
    public T getDisplayedValue() {
        return this.comboBox.getValue();
    }

    @Override
    public void setDisplayedValue(T value) {
        this.comboBox.setValue(value);
    }

    public boolean isSuggestionMode() {
        return this.suggestionMode;
    }

    public void setSuggestionMode(boolean suggestionMode) {
        this.suggestionMode = suggestionMode;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.frame++ % 10 == 0) {
            this.comboBox.tick();
        }
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.comboBox.m_5953_(mouseX, mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public int getExtraScrollHeight() {
        return this.comboBox.isDropDownShown() ? this.comboBox.getDropDownHeight() : 0;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childListeners : this.listeners;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.comboBox.setMaxLength(maxLength);
    }
}

