/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.mojang.blaze3d.platform.Window;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.api.ui.math.Color;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.entries.TextFieldListEntry;
import endorh.simpleconfig.ui.gui.widget.ColorDisplayWidget;
import endorh.simpleconfig.ui.gui.widget.ColorPickerWidget;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorListEntry
extends TextFieldListEntry<Integer> {
    protected final ColorDisplayWidget colorDisplayWidget;
    protected boolean alpha = true;
    protected ColorPickerWidget colorPicker;
    protected int last;
    protected boolean canShowColorPicker = true;
    protected boolean colorPickerVisible = false;
    protected Rectangle colorPickerRectangle = new Rectangle();
    protected Rectangle reportedColorPickerRectangle = new Rectangle();
    protected List<GuiEventListener> widgetsWithColorPicker;
    protected List<GuiEventListener> childWidgetsWithColorPicker;

    @ApiStatus.Internal
    public ColorListEntry(Component fieldName, int value) {
        super(fieldName, 0, false);
        ColorValue colorValue = this.getColorValue(String.valueOf(value));
        ColorError error = colorValue.getError();
        if (error != null) {
            throw new IllegalArgumentException("Invalid Color: " + error.name());
        }
        this.alpha = false;
        this.colorDisplayWidget = new ColorDisplayWidget(this.textFieldWidget, 0, 0, 20, value);
        this.colorDisplayWidget.onClick = () -> this.setColorPickerVisible(!this.isColorPickerVisible());
        this.colorPicker = new ColorPickerWidget(Color.ofTransparent(value), 48, 24, 142, 84, c -> {
            if (this.isEditable()) {
                this.setDisplayedValue(this.alpha ? c.getColor() : c.getRGB());
                this.last = (Integer)this.getDisplayedValue();
            }
        });
        this.setOriginal(value);
        this.widgets.add(this.colorDisplayWidget);
        this.childWidgets.add(this.colorDisplayWidget);
        this.widgetsWithColorPicker = new LinkedList<GuiEventListener>(this.widgets);
        this.widgetsWithColorPicker.add((GuiEventListener)this.colorPicker);
        this.childWidgetsWithColorPicker = new LinkedList<GuiEventListener>(this.childWidgets);
        this.childWidgetsWithColorPicker.add((GuiEventListener)this.colorPicker);
        this.setTextFormatter(TextFormatter.forColor());
        this.last = value;
    }

    public boolean canShowColorPicker() {
        return this.canShowColorPicker && this.isEditable();
    }

    public void setCanShowColorPicker(boolean canShowColorPicker) {
        this.canShowColorPicker = canShowColorPicker;
        if (!canShowColorPicker) {
            this.setColorPickerVisible(false);
        }
    }

    public void setColorPickerVisible(boolean visible) {
        if (visible && !this.canShowColorPicker()) {
            visible = false;
        }
        this.colorPickerVisible = visible;
        if (visible) {
            if (this.isChildSubEntry()) {
                this.colorPicker.setInitial(this.toColor((Integer)this.getDisplayedValue()));
            }
            this.getScreen().addOverlay(this.reportedColorPickerRectangle, this, -1);
        }
    }

    public Color toColor(int color) {
        return this.alpha ? Color.ofTransparent(color) : Color.ofOpaque(color);
    }

    public boolean isColorPickerVisible() {
        return this.colorPickerVisible;
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        if (this.last != (Integer)this.getDisplayedValue()) {
            this.last = (Integer)this.getDisplayedValue();
            this.colorPicker.setValue(this.toColor((Integer)this.getDisplayedValue()), true);
        }
        if (!this.m_93696_() || !this.canShowColorPicker()) {
            this.setColorPickerVisible(false);
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        Font font = mc.f_91062_;
        this.colorDisplayWidget.m_253211_(y);
        ColorValue value = this.getColorValue(this.getText());
        if (!value.hasError()) {
            this.colorDisplayWidget.setColor(this.alpha ? value.getColor() : 0xFF000000 | value.getColor());
        }
        int offset = this.colorDisplayWidget.m_5711_() + 3;
        super.renderChildEntry(gg, font.m_92718_() ? x : x + offset, y, w - offset, h, mouseX, mouseY, delta);
        this.colorDisplayWidget.m_252865_(x);
        this.colorDisplayWidget.m_88315_(gg, mouseX, mouseY, delta);
        if (this.isColorPickerVisible()) {
            int cpw = this.colorPicker.m_5711_();
            int cph = this.colorPicker.m_93694_();
            int ww = window.m_85445_();
            this.colorPicker.m_253211_(y);
            this.colorPicker.m_252865_(x + w / 2 < ww / 2 ? x + w + 3 : x - cpw - 3);
            if (this.colorPicker.m_252754_() < 4 || this.colorPicker.m_252754_() + cpw > ww - 4) {
                this.colorPicker.m_253211_(y + h + 3);
                this.colorPicker.m_252865_(x + w / 2 < ww / 2 ? x : x + w - cpw);
            }
            this.colorPickerRectangle.setBounds(this.colorPicker.m_252754_(), this.colorPicker.m_252907_(), cpw, cph);
            this.reportedColorPickerRectangle.setBounds(ScissorsHandler.INSTANCE.getScissorsAreas().stream().reduce(this.colorPickerRectangle, Rectangle::intersection));
        }
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        if (area != this.reportedColorPickerRectangle) {
            return super.renderOverlay(gg, area, mouseX, mouseY, delta);
        }
        if (!this.isColorPickerVisible()) {
            return false;
        }
        this.getScreen().removeTooltips(area);
        this.colorPicker.m_88315_(gg, mouseX, mouseY, delta);
        return true;
    }

    @Override
    public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
        if (area != this.reportedColorPickerRectangle) {
            return super.overlayMouseClicked(area, mouseX, mouseY, button);
        }
        return this.colorPicker.m_5953_(mouseX, mouseY) && this.colorPicker.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void overlayMouseClickedOutside(Rectangle area, double mouseX, double mouseY, int button) {
        super.overlayMouseClickedOutside(area, mouseX, mouseY, button);
        if (!this.colorDisplayWidget.m_5953_(mouseX, mouseY)) {
            this.setColorPickerVisible(false);
        }
    }

    @Override
    public boolean isOverlayDragging() {
        return true;
    }

    @Override
    public boolean overlayMouseDragged(Rectangle area, double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.colorPicker.m_7212_(mouseX, mouseY, dragX, dragY);
        return true;
    }

    @Override
    public boolean overlayEscape() {
        if (this.isColorPickerVisible()) {
            this.setColorPickerVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.setColorPickerVisible(false);
        }
    }

    @Override
    protected void acquireFocus() {
        super.acquireFocus();
        this.textFieldWidget.setAnchorPos(1);
    }

    @Override
    public void setOriginal(@Nullable Integer original) {
        super.setOriginal(original);
        if (original != null && this.colorPicker != null) {
            this.colorPicker.setInitial(this.toColor(original));
        }
    }

    @Override
    public int getExtraScrollHeight() {
        return this.isColorPickerVisible() ? this.colorDisplayWidget.m_93694_() + this.colorPickerRectangle.y - this.entryArea.y : -1;
    }

    @Override
    protected Integer fromString(String s) {
        return this.getColorValueColor(s);
    }

    @Override
    protected String toString(Integer value) {
        return this.getHexColorString(value);
    }

    @Override
    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        ColorValue colorValue = this.getColorValue(this.getText());
        ColorError error = colorValue.getError();
        if (error != null) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_color", (Object[])new Object[]{this.getText()}));
        }
        return super.getErrorMessage();
    }

    public void withAlpha() {
        if (!this.alpha) {
            this.alpha = true;
            this.colorPicker.allowAlpha(true);
            this.colorPicker.m_93674_(158);
        }
        Integer original = (Integer)this.getOriginal();
        this.setOriginal(original);
        this.setValue(original);
        this.setDisplayedValue(original);
    }

    public void withoutAlpha() {
        if (this.alpha) {
            this.alpha = false;
            this.colorPicker.allowAlpha(false);
            this.colorPicker.m_93674_(142);
        }
        Integer original = (Integer)this.getOriginal();
        this.setOriginal(original);
        this.setValue(original);
        this.setDisplayedValue(original);
    }

    protected String stripHexStarter(String hex) {
        if (hex.startsWith("#")) {
            return hex.substring(1);
        }
        return hex;
    }

    protected boolean isValidColorString(String str) {
        return !this.getColorValue(str).hasError();
    }

    protected int getColorValueColor(String str) {
        return this.getColorValue(str).getColor();
    }

    protected ColorValue getColorValue(String str) {
        try {
            int color;
            if (str.startsWith("#")) {
                String stripHexStarter = this.stripHexStarter(str);
                if (stripHexStarter.length() > 8) {
                    return ColorError.INVALID_COLOR.toValue();
                }
                if (!this.alpha && stripHexStarter.length() > 6) {
                    return ColorError.NO_ALPHA_ALLOWED.toValue();
                }
                color = (int)Long.parseLong(stripHexStarter, 16);
            } else {
                color = (int)Long.parseLong(str);
            }
            int a = color >> 24 & 0xFF;
            if (!this.alpha && a > 0) {
                return ColorError.NO_ALPHA_ALLOWED.toValue();
            }
            return new ColorValue(color);
        }
        catch (NumberFormatException e) {
            return ColorError.INVALID_COLOR.toValue();
        }
    }

    protected String getHexColorString(int color) {
        return "#" + StringUtils.leftPad((String)Integer.toHexString(color), (int)(this.alpha ? 8 : 6), (char)'0');
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        if (this.isChildSubEntry()) {
            return this.isColorPickerVisible() ? this.childWidgetsWithColorPicker : this.childWidgets;
        }
        return this.isColorPickerVisible() ? this.widgetsWithColorPicker : this.widgets;
    }

    protected static class ColorValue {
        private int color = -1;
        @Nullable
        private ColorError error = null;

        public ColorValue(int color) {
            this.color = color;
        }

        public ColorValue(@Nullable ColorError error) {
            this.error = error;
        }

        public int getColor() {
            return this.color;
        }

        @Nullable
        public ColorError getError() {
            return this.error;
        }

        public boolean hasError() {
            return this.getError() != null;
        }
    }

    protected static enum ColorError {
        NO_ALPHA_ALLOWED,
        INVALID_ALPHA,
        INVALID_RED,
        INVALID_GREEN,
        INVALID_BLUE,
        INVALID_COLOR;

        private final ColorValue value = new ColorValue(this);

        public ColorValue toValue() {
            return this.value;
        }
    }
}

