/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CaptionedSubCategoryListEntry<T, CE extends AbstractConfigField<T>>
extends TooltipListEntry<T>
implements IExpandable,
IEntryHolder {
    protected final CaptionWidget<CaptionedSubCategoryListEntry<T, CE>> label;
    protected final List<AbstractConfigField<?>> heldEntries;
    protected final List<AbstractConfigListEntry<?>> entries;
    protected final List<GuiEventListener> children;
    protected final List<GuiEventListener> expandedChildren;
    protected final Rectangle captionEntryArea = new Rectangle();
    @Nullable
    protected CE captionEntry;
    protected boolean expanded;
    protected ToggleAnimator expandAnimator = new ToggleAnimator();

    @ApiStatus.Internal
    public CaptionedSubCategoryListEntry(Component title, List<AbstractConfigListEntry<?>> entries2, @Nullable CE captionEntry) {
        super(title);
        this.entries = Lists.newArrayList(entries2);
        this.heldEntries = Lists.newArrayList(entries2);
        this.captionEntry = captionEntry;
        entries2.forEach(e -> e.setParentEntry(this));
        this.label = new CaptionWidget<CaptionedSubCategoryListEntry>(this);
        if (captionEntry != null) {
            ((AbstractConfigField)captionEntry).setChildSubEntry(true);
            ((AbstractConfigField)captionEntry).setName("$caption");
            ((AbstractConfigField)captionEntry).setParentEntry(this);
            this.setValue(((AbstractConfigField)captionEntry).getValue());
            this.heldEntries.add(0, (AbstractConfigField<?>)captionEntry);
            this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, captionEntry, this.sideButtonReference});
            this.expandedChildren = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, captionEntry, this.sideButtonReference});
            this.expandedChildren.addAll(entries2);
        } else {
            this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.sideButtonReference});
            this.expandedChildren = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.sideButtonReference});
            this.expandedChildren.addAll(entries2);
        }
        this.acceptButton.setDefaultIcon(SimpleConfigIcons.Buttons.MERGE_ACCEPT_GROUP);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded, boolean recursive, boolean animate) {
        if (this.expanded != expanded) {
            if (animate) {
                this.expandAnimator.setLength(Math.min(250L, (long)this.entries.size() * 25L));
                this.expandAnimator.setEaseOutTarget(expanded);
            } else {
                this.expandAnimator.stopAndSet(expanded);
            }
        }
        this.expanded = expanded;
        if (recursive) {
            this.entries.stream().filter(e -> e instanceof IExpandable).forEach(e -> ((IExpandable)((Object)e)).setExpanded(expanded, true));
        }
    }

    @Override
    public T getDisplayedValue() {
        return this.captionEntry != null ? (T)((AbstractConfigField)this.captionEntry).getDisplayedValue() : null;
    }

    @Override
    public void setDisplayedValue(T value) {
        if (this.captionEntry != null) {
            ((AbstractConfigField)this.captionEntry).setDisplayedValue(value);
        }
    }

    @Override
    public boolean isShown() {
        return super.isShown() || this.entries.stream().anyMatch(AbstractConfigListEntry::isShown);
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    @Override
    public Rectangle getNavigableArea() {
        return this.label.area;
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        return this.captionEntry != null ? Lists.newArrayList((Object[])new INavigableTarget[]{this, this.captionEntry}) : super.getNavigableSubTargets();
    }

    @Override
    public void resetValue() {
        this.getScreen().runAtomicTransparentAction(this, () -> this.entries.forEach(AbstractConfigField::resetValue));
    }

    @Override
    public void restoreValue() {
        this.getScreen().runAtomicTransparentAction(this, () -> this.entries.forEach(AbstractConfigField::restoreValue));
    }

    @Override
    protected List<EntryError> computeErrors() {
        List<EntryError> errors = super.computeErrors();
        errors.addAll(IEntryHolder.super.getErrors());
        return errors;
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.isHeldEntryHovered(mouseX, mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.label.m_93692_(this.m_93696_() && this.m_7222_() == this.label);
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SimpleConfigIcons.Entries.EXPAND.renderCentered(gg, x - 15, y + 5, 9, 9, (this.label.area.contains(mouseX, mouseY) ? 2 : 0) + (this.isExpanded() ? 1 : 0));
        boolean animating = this.expandAnimator.isInProgress();
        if (this.isExpanded() || animating) {
            if (animating) {
                DynamicEntryListWidget<?> parent = this.getEntryList();
                ScissorsHandler.INSTANCE.pushScissor(new Rectangle(parent.left, this.entryArea.y, parent.right - parent.left, this.getItemHeight()));
            }
            int yy = y + 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                if (!entry.isShown()) continue;
                entry.render(gg, -1, x + 14, yy, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered && this.m_7222_() == entry, delta);
                yy += entry.getItemHeight();
            }
            if (animating) {
                ScissorsHandler.INSTANCE.popScissor();
            }
        }
        this.label.render(gg, mouseX, mouseY, delta);
    }

    @Override
    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        super.renderField(gg, fieldX, fieldY, fieldWidth, fieldHeight, x, y, entryWidth, entryHeight, index, mouseX, mouseY, delta);
        this.label.area.setBounds(x - 24, y, this.captionEntry != null ? entryWidth - fieldWidth - 5 : entryWidth - 2, 20);
        if (this.captionEntry != null) {
            ((IChildListEntry)this.captionEntry).renderChild(gg, fieldX, fieldY, fieldWidth, fieldHeight, mouseX, mouseY, delta);
            this.captionEntryArea.setBounds(fieldX, fieldY, fieldWidth, fieldHeight);
        } else {
            this.captionEntryArea.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelectable() && this.isShown() && this.entries.stream().filter(e -> e.isSelectable() && e.isShown()).allMatch(AbstractConfigField::isSelected) && this.entries.stream().filter(e -> e.isSelectable() && e.isShown()).anyMatch(e -> true);
    }

    @Override
    public void setSelected(boolean isSelected) {
        if (!this.isSelectable()) {
            return;
        }
        this.entries.stream().filter(e -> e.isSelectable() && e.isShown()).forEach(e -> e.setSelected(isSelected));
    }

    @Override
    protected void doExpandParents(AbstractConfigField<?> entry) {
        boolean expanded = this.isExpanded();
        super.doExpandParents(entry);
        if (entry == this.captionEntry) {
            this.setExpanded(expanded);
        }
    }

    @Override
    public boolean isSelectable() {
        return super.isSelectable() && this.entries.stream().anyMatch(AbstractConfigField::isSelectable);
    }

    public boolean isHeldEntryHovered(int mouseX, int mouseY) {
        return this.captionEntry != null && this.captionEntryArea.contains(mouseX, mouseY);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (this.captionEntry != null) {
            boolean captionEntrySelected = isFocused && this.m_7222_() == this.captionEntry;
            boolean prevSelected = ((AbstractConfigField)this.captionEntry).m_93696_();
            ((AbstractConfigField)this.captionEntry).updateFocused(captionEntrySelected);
            if (!prevSelected && captionEntrySelected) {
                this.getScreen().getHistory().preserveState((AbstractConfigField<?>)this.captionEntry);
            }
        }
        for (AbstractConfigListEntry<?> entry : this.entries) {
            entry.updateFocused(this.isExpanded() && isFocused && this.m_7222_() == entry);
        }
    }

    @Override
    public boolean isEditable() {
        if (this.isEditingHotKeyAction()) {
            return this.getScreen().isEditable();
        }
        return super.isEditable();
    }

    @Override
    protected boolean computeIsEdited() {
        return super.computeIsEdited() || !this.isIgnoreEdits() && !this.isSubEntry() && this.isEditable() && this.entries.stream().anyMatch(AbstractConfigField::isEdited);
    }

    @Override
    public boolean areEqual(T value, T other) {
        return this.captionEntry != null ? ((AbstractConfigField)this.captionEntry).areEqual(value, other) : super.areEqual(value, other);
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getSingleResettableEntry() {
        return super.isResettable() ? (AbstractConfigField<?>)this.captionEntry : null;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getSingleRestorableEntry() {
        return super.isRestorable() ? (AbstractConfigField<?>)this.captionEntry : null;
    }

    @Override
    public void resetSingleEntry(AbstractConfigField<?> entry) {
        super.resetValue();
    }

    @Override
    public void restoreSingleEntry(AbstractConfigField<?> entry) {
        super.restoreValue();
    }

    @Override
    public boolean isResettable() {
        if (!this.isEditable() || this.isSubEntry()) {
            return false;
        }
        return this.captionEntry != null && ((AbstractConfigField)this.captionEntry).isResettable();
    }

    @Override
    public boolean isRestorable() {
        if (!this.isEditable() || this.isSubEntry()) {
            return false;
        }
        return this.captionEntry != null && ((AbstractConfigField)this.captionEntry).isRestorable();
    }

    @Override
    public boolean canResetGroup() {
        return this.entries.stream().anyMatch(e -> e.isResettable() || e.canResetGroup());
    }

    @Override
    public boolean canRestoreGroup() {
        return this.entries.stream().anyMatch(e -> e.isRestorable() || e.canRestoreGroup());
    }

    @Override
    public int getExtraScrollHeight() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        if (this.captionEntry != null) {
            list.add(i + ((DynamicEntryListWidget.ListEntry)this.captionEntry).getExtraScrollHeight());
        }
        if (this.isExpanded()) {
            for (AbstractConfigListEntry<?> entry : this.entries) {
                i += entry.getItemHeight();
                if (entry.getExtraScrollHeight() < 0) continue;
                list.add(i + entry.getExtraScrollHeight());
            }
            list.add(i);
        }
        return list.stream().max(Integer::compare).orElse(0) - i;
    }

    @Override
    public Rectangle getSelectionArea() {
        DynamicEntryListWidget<?> parent = this.getEntryList();
        return new Rectangle(parent.left, this.entryArea.y, parent.right - parent.left, 20);
    }

    @Override
    public int getItemHeight() {
        if (this.isExpanded() || this.expandAnimator.isInProgress()) {
            int i = 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                if (!entry.isShown()) continue;
                i += entry.getItemHeight();
            }
            return Math.round(this.expandAnimator.getEaseOut() * (float)(i - 24)) + 24;
        }
        return 24;
    }

    @Override
    public void tick() {
        super.tick();
        this.entries.forEach(AbstractConfigField::tick);
    }

    @Override
    public void save() {
        super.save();
        this.entries.forEach(AbstractConfigField::save);
    }

    @Override
    protected int getPreviewCaptionOffset() {
        return this.captionEntry != null ? super.getPreviewCaptionOffset() : 0;
    }

    @Override
    public void setHeadless(boolean headless) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isExpanded() ? this.expandedChildren : this.children;
    }

    @Override
    public int getFocusedScroll() {
        GuiEventListener listener = this.m_7222_();
        if (!this.entries.contains(listener)) {
            return 0;
        }
        int y = 24;
        int index = this.entries.indexOf(listener);
        if (index >= 0) {
            for (AbstractConfigListEntry<?> entry : this.entries.subList(0, index)) {
                y += entry.getItemHeight();
            }
        }
        if (listener instanceof IExpandable) {
            y += ((IExpandable)listener).getFocusedScroll();
        }
        return y;
    }

    @Override
    public int getFocusedHeight() {
        GuiEventListener listener = this.m_7222_();
        if (listener instanceof IExpandable) {
            return ((IExpandable)listener).getFocusedHeight();
        }
        if (listener instanceof AbstractConfigListEntry) {
            return ((AbstractConfigListEntry)listener).getItemHeight();
        }
        return 20;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        String[] split;
        if (path.startsWith("$caption") && "$caption".equals((split = DOT.split(path, 2))[0])) {
            if (this.captionEntry instanceof IEntryHolder && split.length == 2) {
                return ((IEntryHolder)this.captionEntry).getEntry(split[1]);
            }
            return this.captionEntry;
        }
        return IEntryHolder.super.getEntry(path);
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        List<ISeekableComponent> children = this.entries.stream().map(e -> e).collect(Collectors.toList());
        if (this.captionEntry != null) {
            children.add(0, (ISeekableComponent)this.captionEntry);
        }
        return children;
    }

    @Override
    public String seekableValueText() {
        return "";
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() == this.label && keyCode == 263 && this.isExpanded()) {
            this.setExpanded(false, Screen.m_96638_());
            CaptionedSubCategoryListEntry.playFeedbackTap(0.4f);
            return true;
        }
        if (keyCode == 262 && !this.isExpanded()) {
            this.setExpanded(true, Screen.m_96638_());
            CaptionedSubCategoryListEntry.playFeedbackTap(0.4f);
            return true;
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Nullable
    public AbstractConfigField<?> getCaptionEntry() {
        return this.captionEntry;
    }

    @Override
    public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
        return onlyVisible ? (this.isExpanded() ? this.entries.stream().filter(AbstractConfigField::isNavigable).collect(Collectors.toList()) : Collections.emptyList()) : Lists.newArrayList(this.entries);
    }

    public static class CaptionWidget<E extends AbstractConfigField<?>>
    implements GuiEventListener {
        protected final Rectangle area = new Rectangle();
        protected boolean focused = false;
        protected E expandable;
        protected int focusedColor = -2132746016;

        protected CaptionWidget(E expandable) {
            this.expandable = expandable;
        }

        protected E getParent() {
            return this.expandable;
        }

        public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
            if (this.focused && !((AbstractConfigField)this.expandable).isPreviewingExternal()) {
                CaptionedSubCategoryListEntry.drawBorder(gg, this.area.x + 4, this.area.y, this.area.width, this.area.height, 1, this.focusedColor);
            }
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.area.contains(mouseX, mouseY);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.area.contains(mouseX, mouseY)) {
                E parent = this.getParent();
                boolean recurse = Screen.m_96638_();
                ((IExpandable)parent).setExpanded(!((IExpandable)parent).isExpanded(), recurse);
                DynamicEntryListWidget<?> list = ((AbstractConfigField)parent).getEntryList();
                if (!recurse && list instanceof SimpleConfigScreen.ListWidget) {
                    ((SimpleConfigScreen.ListWidget)list).startDragAction(new SimpleConfigScreen.ListWidget.EntryDragAction.ExpandedDragAction(((IExpandable)parent).isExpanded()));
                }
                CaptionedSubCategoryListEntry.playFeedbackClick(1.0f);
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            IExpandable parent = (IExpandable)this.getParent();
            switch (keyCode) {
                case 262: {
                    if (parent.isExpanded()) break;
                    parent.setExpanded(true, Screen.m_96638_());
                    CaptionedSubCategoryListEntry.playFeedbackTap(0.4f);
                    return true;
                }
                case 263: {
                    if (!parent.isExpanded()) break;
                    parent.setExpanded(false, Screen.m_96638_());
                    CaptionedSubCategoryListEntry.playFeedbackTap(0.4f);
                    return true;
                }
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent e) {
            return this.m_93696_() ? null : ComponentPath.m_264401_((GuiEventListener)this);
        }

        @Nullable
        public ComponentPath m_264435_() {
            return super.m_264435_();
        }
    }
}

