/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.AbstractListListEntry;
import endorh.simpleconfig.ui.gui.entries.BaseListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CaptionedListListEntry<V, E extends AbstractListListEntry<V, ?, E>, C, CE extends AbstractConfigListEntry<C>>
extends TooltipListEntry<Pair<C, List<V>>>
implements IExpandable,
IEntryHolder {
    protected final BaseListEntry.ListCaptionWidget label;
    private final E listEntry;
    private final CE captionEntry;
    private final List<AbstractConfigField<?>> heldEntries;
    private final List<ISeekableComponent> seekableChildren;
    protected List<GuiEventListener> children;

    public CaptionedListListEntry(Component fieldName, E listEntry, CE captionEntry) {
        super(fieldName);
        this.listEntry = listEntry;
        this.captionEntry = captionEntry;
        ((AbstractConfigField)listEntry).setName("list");
        ((AbstractConfigField)captionEntry).setName("caption");
        ((AbstractConfigField)listEntry).setParentEntry(this);
        ((AbstractConfigField)captionEntry).setParentEntry(this);
        ((AbstractConfigField)captionEntry).setChildSubEntry(true);
        ((AbstractConfigField)listEntry).setSubEntry(true);
        ((BaseListEntry)listEntry).setHeadless(true);
        this.label = new BaseListEntry.ListCaptionWidget((BaseListEntry<?, ?, ?>)listEntry);
        this.heldEntries = Lists.newArrayList((Object[])new AbstractConfigField[]{captionEntry, listEntry});
        this.seekableChildren = Lists.newArrayList((Object[])new ISeekableComponent[]{captionEntry, listEntry});
        this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, captionEntry, this.sideButtonReference, listEntry});
    }

    public E getListEntry() {
        return this.listEntry;
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        ((AbstractConfigField)this.listEntry).render(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        ((IChildListEntry)this.captionEntry).renderChild(gg, fieldX, fieldY, fieldWidth, fieldHeight, mouseX, mouseY, delta);
        this.label.m_93692_(this.m_93696_() && this.m_7222_() == this.label);
        this.label.area.setBounds(x - 24, y, entryWidth - fieldWidth - 5, 20);
        this.label.render(gg, mouseX, mouseY, delta);
        ResetButton resetButton = this.getResetButton();
        if (resetButton != null) {
            resetButton.m_88315_(gg, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void doExpandParents(AbstractConfigField<?> entry) {
        boolean expanded = this.isExpanded();
        super.doExpandParents(entry);
        if (entry == this.captionEntry || this.captionEntry.getNavigableSubTargets().contains(entry)) {
            this.setExpanded(expanded);
        }
    }

    @Override
    public Pair<C, List<V>> getDisplayedValue() {
        return Pair.of(((AbstractConfigField)this.captionEntry).getDisplayedValue(), (Object)((BaseListEntry)this.listEntry).getDisplayedValue());
    }

    @Override
    public void setDisplayedValue(Pair<C, List<V>> value) {
        ((AbstractConfigField)this.captionEntry).setDisplayedValue((Object)value.getKey());
        ((BaseListEntry)this.listEntry).setDisplayedValue((List)value.getValue());
    }

    @Override
    public List<EntryError> getEntryErrors() {
        List<EntryError> errors = super.getEntryErrors();
        errors.addAll(((AbstractConfigField)this.captionEntry).getEntryErrors());
        errors.addAll(((BaseListEntry)this.listEntry).getEntryErrors());
        return errors;
    }

    @Override
    public boolean areEqual(Pair<C, List<V>> value, Pair<C, List<V>> other) {
        if (value == null || other == null) {
            return value == other;
        }
        return ((AbstractConfigField)this.captionEntry).areEqual((Object)value.getLeft(), (Object)other.getLeft()) && ((AbstractConfigField)this.listEntry).areEqual((List)((List)value.getRight()), (List)((List)other.getRight()));
    }

    @Override
    public boolean isResettable() {
        return super.isResettable();
    }

    @Override
    public boolean isRestorable() {
        return super.isRestorable();
    }

    @Override
    public boolean canResetGroup() {
        Pair defValue = (Pair)this.getDefaultValue();
        Pair<C, List<V>> value = this.getDisplayedValue();
        return !((AbstractConfigField)this.listEntry).areEqual(((List)value.getValue()), defValue != null ? (List)defValue.getValue() : null);
    }

    @Override
    public boolean canRestoreGroup() {
        Pair original = (Pair)this.getOriginal();
        Pair<C, List<V>> value = this.getDisplayedValue();
        return !((AbstractConfigField)this.listEntry).areEqual(((List)value.getValue()), original != null ? (List)original.getValue() : null);
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getSingleResettableEntry() {
        Pair defValue = (Pair)this.getDefaultValue();
        if (!((AbstractConfigField)this.captionEntry).areEqual((Object)this.getDisplayedValue().getKey(), (Object)(defValue != null ? defValue.getKey() : null))) {
            return this.captionEntry;
        }
        return null;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getSingleRestorableEntry() {
        Pair original = (Pair)this.getOriginal();
        if (!((AbstractConfigField)this.captionEntry).areEqual((Object)this.getDisplayedValue().getKey(), (Object)(original != null ? original.getKey() : null))) {
            return this.captionEntry;
        }
        return null;
    }

    @Override
    public void resetSingleEntry(AbstractConfigField<?> entry) {
        Pair defValue = (Pair)this.getDefaultValue();
        Pair<C, List<V>> value = this.getDisplayedValue();
        this.setValueTransparently(Pair.of((Object)(defValue != null ? defValue.getLeft() : null), (Object)((List)value.getRight())));
    }

    @Override
    public void restoreSingleEntry(AbstractConfigField<?> entry) {
        Pair original = (Pair)this.getOriginal();
        Pair<C, List<V>> value = this.getDisplayedValue();
        this.setValueTransparently(Pair.of((Object)(original != null ? original.getLeft() : null), (Object)((List)value.getRight())));
    }

    @Override
    public Rectangle getSelectionArea() {
        return ((BaseListEntry)this.listEntry).getSelectionArea();
    }

    @Override
    public int getItemHeight() {
        return ((BaseListEntry)this.listEntry).getItemHeight();
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        ((BaseListEntry)this.listEntry).updateFocused(isFocused && this.m_7222_() == this.listEntry);
        ((AbstractConfigListEntry)this.captionEntry).updateFocused(isFocused && this.m_7222_() == this.captionEntry);
    }

    @Override
    public int getExtraScrollHeight() {
        return ((DynamicEntryListWidget.ListEntry)this.listEntry).getExtraScrollHeight();
    }

    @Override
    public String seekableText() {
        return "";
    }

    @Override
    public String seekableValueText() {
        return "";
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        return this.seekableChildren;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.children;
    }

    @Override
    public boolean isExpanded() {
        return ((BaseListEntry)this.listEntry).isExpanded();
    }

    @Override
    public void setExpanded(boolean expanded, boolean recurse, boolean animate) {
        ((BaseListEntry)this.listEntry).setExpanded(expanded, recurse, animate);
    }

    @Override
    public int getFocusedScroll() {
        return this.m_7222_() == this.listEntry ? ((BaseListEntry)this.listEntry).getFocusedScroll() : 0;
    }

    @Override
    public int getFocusedHeight() {
        return this.m_7222_() == this.listEntry ? ((BaseListEntry)this.listEntry).getFocusedHeight() : this.getCaptionHeight();
    }

    @Override
    protected String seekableTooltipString() {
        return "";
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() == this.label && keyCode == 263 && this.isExpanded()) {
            this.setExpanded(false, Screen.m_96638_());
            CaptionedListListEntry.playFeedbackTap(0.4f);
            return true;
        }
        if (keyCode == 262 && !this.isExpanded()) {
            this.setExpanded(true, Screen.m_96638_());
            CaptionedListListEntry.playFeedbackTap(0.4f);
            return true;
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public Rectangle getNavigableArea() {
        return this.label.area;
    }

    @Override
    public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
        if (!onlyVisible || this.isExpanded()) {
            return ((BaseListEntry)this.listEntry).getNavigableChildren(onlyVisible);
        }
        return super.getNavigableChildren(true);
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        List<INavigableTarget> captionSubTargets = this.captionEntry.getNavigableSubTargets();
        return captionSubTargets.isEmpty() ? Lists.newArrayList((Object[])new INavigableTarget[]{this, this.captionEntry}) : Stream.concat(Stream.of(this), this.captionEntry.getNavigableSubTargets().stream()).collect(Collectors.toList());
    }
}

