/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ButtonListEntry
extends TooltipListEntry<Runnable>
implements IChildListEntry {
    protected final Supplier<Component> buttonLabelSupplier;
    protected final Button button;
    protected List<GuiEventListener> listeners;
    protected List<GuiEventListener> childListeners;

    public ButtonListEntry(Runnable value, Component fieldName, Supplier<Component> buttonLabelSupplier) {
        super(fieldName);
        this.buttonLabelSupplier = buttonLabelSupplier;
        this.setOriginal(value);
        this.setValue(value);
        this.button = new Button.Builder(buttonLabelSupplier.get(), p -> ((Runnable)this.getValue()).run()).m_252987_(0, 0, 150, 20).m_253136_();
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.button});
        this.childListeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.button});
    }

    @Override
    public void setDisplayedValue(Runnable value) {
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.button.m_93666_(this.buttonLabelSupplier.get());
        this.button.f_93623_ = this.shouldRenderEditable();
        this.button.m_252865_(x);
        this.button.m_253211_(y);
        this.button.m_93674_(w);
        this.button.setHeight(h);
        this.button.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.button.m_93692_(false);
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    protected boolean computeIsEdited() {
        return false;
    }

    @Override
    @Nullable
    public ResetButton getResetButton() {
        return null;
    }

    @Override
    public boolean isResettable() {
        return false;
    }

    @Override
    public boolean isRestorable() {
        return false;
    }

    @Override
    public boolean hasExternalDiff() {
        return false;
    }

    @Override
    public boolean hasAcceptedExternalDiff() {
        return false;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childListeners : this.listeners;
    }

    @Override
    public String seekableValueText() {
        return ButtonListEntry.getUnformattedString(this.buttonLabelSupplier.get());
    }
}

